jQuery(function($){
    // 관리자 드로어 버튼 클릭
    $('.point_gift_drawer_btn').on('click', function() {
        openDrawer();
    });
    
    // 닫기 버튼 및 오버레이 클릭
    $('.point_gift_drawer_close, .point_gift_overlay').on('click', function() {
        closeDrawer();
    });
    
    // ESC 키 눌렀을 때 드로어 닫기
    $(document).on('keydown', function(e) {
        if (e.keyCode === 27) { // ESC 키
            closeDrawer();
        }
    });
    
    // 드로어 열기 함수
    function openDrawer() {
        $('.point_gift_drawer').addClass('open');
        $('.point_gift_overlay').addClass('open');
        $('body').css('overflow', 'hidden');
        
        // 모바일에서 드로어 내부 스크롤 활성화
        $('.point_gift_drawer').css('overflow-y', 'auto');
        
        // 포커스를 첫 번째 입력 필드로 이동 (접근성 개선)
        setTimeout(function() {
            $('#use_paging').focus();
        }, 300);
    }
    
    // 포인트 설정 버튼 (상단 메뉴)
    $('.point_gift_settings_btn').on('click', function() {
        openDrawer();
    });
});

// 드로어 닫기 함수 (외부에서 호출 가능하도록 전역 함수로 정의)
function closeDrawer() {
    jQuery('.point_gift_drawer').removeClass('open');
    jQuery('.point_gift_overlay').removeClass('open');
    jQuery('body').css('overflow', '');
} 