<?php
// 비회원 검색 차단 훅 
add_event('before_search_query', function() {
    global $is_member;

    if (!$is_member) {
        echo "<script>
            alert('비회원은 검색을 이용할 수 없습니다.\\n\\n로그인 후 이용해주세요.');
            location.href='".G5_BBS_URL."/login.php';
        </script>";
        exit;
    }
});

// 유튜브
function get_youtu_thumbnail($youtube_url, $size = 'default') {
    if (strpos($youtube_url, '/shorts/') !== false) {
        $video_id = get_shorts_video_id($youtube_url);
    } else {
        $video_id = get_youtu_video_id($youtube_url);
    }

    if (!$video_id) {
        return '';
    }

   switch ($size) {
        case 'medium':
            $thumbnail_url = "https://img.youtube.com/vi/{$video_id}/mqdefault.jpg"; // 중간 크기
            break;
        case 'large':
            $thumbnail_url = "https://img.youtube.com/vi/{$video_id}/maxresdefault.jpg"; // 최대 크기
            break;
        default:
            $thumbnail_url = "https://img.youtube.com/vi/{$video_id}/0.jpg"; // 기본 크기
    }

    return $thumbnail_url;
}

function get_youtu_video_id($url) {
    $video_id = '';
    $pattern = '/(?:youtube\.com\/(?:[^\/\n\s]+\/\S+\/|(?:v|e(?:mbed)?)\/|\S*?[?&]v=)|youtu\.be\/)([a-zA-Z0-9_-]{11})/';

    if (preg_match($pattern, $url, $match)) {
        $video_id = $match[1];
    }

    return $video_id;
}

function get_shorts_video_id($url) {
    $video_id = '';
    $pattern = '/youtube\.com\/shorts\/([^\/\n\s\?]+)/';

    if (preg_match($pattern, $url, $match)) {
        $video_id = $match[1];
    }

    return $video_id;
}