<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$member_skin_url.'/style.css">', 0);
?>
<style>
/* 선택 영역 */
.memo-actions {display: flex;justify-content: right;align-items: center;gap: 15px;margin: 15px 0;padding: 10px;background: #f9f9f9;border-radius: 8px;border: 1px solid #ddd;}
.memo-actions label {font-size: 14px;font-weight: 500;}
.memo-actions .delete-btn {background: #ff4d4f;color: #fff;border: none;padding: 8px 16px;font-size: 14px;border-radius: 5px;cursor: pointer;transition: background 0.3s ease;}
.memo-actions .delete-btn:hover {background: #e60023;}
.win_ul li.filter_btn.active a {color: #ff2d2dff;}
</style>
<!-- 쪽지 목록 시작 { -->
<div id="memo_list" class="new_win">
    <h1 id="win_title">
    	<?php echo $g5['title'] ?>
    	<div class="win_total">전체 <?php echo $kind_title ?>쪽지 <?php echo $total_count ?>통<br></div>
    </h1>
    <div class="new_win_con2">
        <ul class="win_ul">
            <li class="<?php if ($kind == 'recv') {  ?>selected<?php }  ?>"><a href="./memo.php?kind=recv">받은쪽지</a></li>
            <li class="<?php if ($kind == 'send') {  ?>selected<?php }  ?>"><a href="./memo.php?kind=send">보낸쪽지</a></li>
            <li><a href="./memo_form.php">쪽지쓰기</a></li>
            <li class="filter_btn <?php if($status=='unread') echo 'active'; ?>">
                <a href="./memo.php?kind=<?php echo $kind; ?>&status=unread">안읽은 쪽지</a>
            </li>
            <li class="filter_btn <?php if($status=='read') echo 'active'; ?>">
                <a href="./memo.php?kind=<?php echo $kind; ?>&status=read">읽은 쪽지</a>
            </li>
        </ul>
        
        <div class="memo_list">
            <form id="memo_form" method="post" action="<?php echo $member_skin_url;?>/memo_delete_all.php">
            <ul>
            <?php for ($i=0; $i<count($list); $i++): 
                $readed = (substr($list[$i]['me_read_datetime'],0,1) == 0) ? '' : 'read';
                $memo_preview = utf8_strcut(strip_tags($list[$i]['me_memo']), 30, '..');
            ?>
            <li class="<?php echo $readed; ?>">
                <input type="checkbox" name="me_id[]" value="<?php echo $list[$i]['me_id']; ?>">
                <div class="memo_li profile_big_img">
                    <?php echo get_member_profile_img($list[$i]['mb_id']); ?>
                    <?php if (! $readed){ ?><span class="no_read">안 읽은 쪽지</span><?php } ?>
                </div>
                <div class="memo_li memo_name">
                    <?php echo $list[$i]['name']; ?> 
                    <span class="memo_datetime"><i class="fa fa-clock-o" aria-hidden="true"></i> <?php echo $list[$i]['send_datetime']; ?></span>
                    <div class="memo_preview">
                        <a href="<?php echo $list[$i]['view_href']; ?>"><?php echo $memo_preview; ?></a>
                    </div>
                </div>
                <a href="<?php echo $list[$i]['del_href']; ?>" onclick="del(this.href); return false;" class="memo_del">
                    <i class="fa fa-trash-o" aria-hidden="true"></i> <span class="sound_only">삭제</span>
                </a>
            </li>
            <?php endfor; ?>
            </ul>
            <div class="memo-actions">
                <label><input type="checkbox" id="chk_all" onclick="check_all(this)"> 전체선택</label>
                <button type="submit" class="delete-btn">선택 삭제</button>
            </div>
            </form>

            <script>
            document.getElementById('memo_form').addEventListener('submit', function(e){
                const checked = document.querySelectorAll('input[name="me_id[]"]:checked');
                if(checked.length === 0){
                    alert('선택은 하나 이상 하셔야 합니다.');
                    e.preventDefault(); // 제출 중단
                    return;
                }
                if(!confirm('선택한 쪽지를 삭제하시겠습니까?')){
                    e.preventDefault(); // 취소하면 제출 중단
                }
            });

            function check_all(el){
                const checkboxes = document.querySelectorAll('input[name="me_id[]"]');
                checkboxes.forEach(cb => cb.checked = el.checked);
            }
            </script>
        </div>

        <!-- 페이지 -->
        <?php echo $write_pages; ?>

        <p class="win_desc"><i class="fa fa-info-circle" aria-hidden="true"></i> 쪽지 보관일수는 최장 <strong><?php echo $config['cf_memo_del'] ?></strong>일 입니다.</p>

        <div class="win_btn">
            <button type="button" onclick="window.close();" class="btn_close">창닫기</button>
        </div>
    </div>
</div>
<!-- } 쪽지 목록 끝 -->