<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$outlogin_skin_url.'/style.css">', 0);

// 포인트값 단위
function format_compact_number($number) {
    $number = (int) str_replace(',', '', $number);

    if ($number >= 1000000000) {
        return intval($number / 1000000000) . 'B'; 
    } elseif ($number >= 1000000) {
        return intval($number / 1000000) . 'M';
    } elseif ($number >= 10000) {
        return intval($number / 10000) . 'K';
    } else {
        return $number;
    }
}
?>

<!-- 로그인 후 아웃로그인 시작 { -->
<section id="wp_after" class="wp">
    <header id="wp_after_hd">
        <h2>나의 회원정보</h2>
        <span class="profile_img">
            <?php echo get_member_profile_img($member['mb_id']); ?>
        </span>
        <strong><?php echo $nick ?>님 </strong>Lv.<span style="font-family:'S-CoreDream-6Bold', sans-serif !important;color:#b8181a;"><?php echo $member['mb_level']; ?></span>
        <a href="<?php echo G5_BBS_URL ?>/member_confirm.php?url=register_form.php" id="wp_after_info" title="정보수정">정보수정</a>
        <?php if ($is_admin == 'super' || $is_auth) {  ?><a href="<?php echo correct_goto_url(G5_ADMIN_URL); ?>" class="btn_admin btn" title="관리자"><i class="fa fa-cog fa-spin fa-fw"></i><span class="sound_only">관리자</span></a><?php }  ?>
    </header>

    <ul class="user-info-list">
      <li>
        <a href="<?php echo G5_BBS_URL ?>/point.php" id="ol_after_pt" class="item-box">
          <div class="icon-wrap">
            <i class="fa fa-database" aria-hidden="true"></i>
          </div>
          <div class="text-wrap">
            <span class="label">포인트</span>
            <strong><?php echo $point; ?></strong>
          </div>
        </a>
      </li>
      <li>
        <a href="<?php echo G5_BBS_URL ?>/memo.php" id="ol_after_memo" class="item-box">
          <div class="icon-wrap">
              <i class="fa fa-envelope-o <?php echo ($memo_not_read > 0) ? 'blink' : ''; ?>" aria-hidden="true"></i>
          </div>
          <div class="text-wrap">
              <span class="label">쪽지</span>
              <strong><?php echo $memo_not_read; ?></strong>
          </div>
      </a>
      </li>
      <li>
        <a href="<?php echo G5_BBS_URL ?>/scrap.php" id="ol_after_scrap" class="item-box">
          <div class="icon-wrap">
            <i class="fa fa-thumb-tack" aria-hidden="true"></i>
          </div>
          <div class="text-wrap">
            <span class="label">스크랩</span>
            <strong class="scrap"><?php echo $mb_scrap_cnt; ?></strong>
          </div>
        </a>
      </li>
    </ul>    

    <footer>
    	<a href="<?php echo G5_BBS_URL ?>/logout.php" id="wp_after_logout"><i class="fa fa-sign-out" aria-hidden="true"></i> 로그아웃</a>
        <!-- <a href="<--?php echo G5_BBS_URL ?>/logout.php?url=<--?php echo urlencode(G5_URL.'/index.php'); ?>" id="wp_after_logout"><i class="fa fa-sign-out" aria-hidden="true"></i> 로그아웃</a> -->
    </footer>

</section>

<div id="memo_md" class="md">
  <div class="md-content">
    <span class="md_close">&times;</span>
    <iframe id="memo_iframe" src="" frameborder="0" style="width:100%;height:100%;"></iframe>
  </div>
</div>

<script>
  const modalLinks = ['ol_after_memo', 'ol_after_pt', 'ol_after_scrap'];
  const modal = document.getElementById('memo_md');
  const iframe = document.getElementById('memo_iframe');

  modalLinks.forEach(id => {
    const el = document.getElementById(id);
    if(el){
      el.addEventListener('click', function(e){
        e.preventDefault();
        iframe.src = this.href;
        modal.classList.add('show');
      });
    }
  });

  document.querySelector('#memo_md .md_close').addEventListener('click', closeModal);
  modal.addEventListener('click', function(e) {
    if(e.target === modal) closeModal();
  });

  function closeModal() {
    modal.classList.remove('show');
    setTimeout(() => { 
      modal.style.display = 'none'; 
      iframe.src = ''; 
    }, 300); // 끝난 후 display:none
  }

  // display:none 처리를 트리거하기 위해 이벤트리스너
  modal.addEventListener('transitionend', () => {
    if (!modal.classList.contains('show')) {
      modal.style.display = 'none';
    }
  });

  // show 될 때 display:block 
  const observer = new MutationObserver(() => {
    if (modal.classList.contains('show')) {
      modal.style.display = 'block';
    }
  });
  observer.observe(modal, { attributes: true });
</script>
<script>
// 탈퇴의 경우 아래 코드를 연동하시면 됩니다.
function member_leave()
{
    if (confirm("정말 회원에서 탈퇴 하시겠습니까?"))
        location.href = "<?php echo G5_BBS_URL ?>/member_confirm.php?url=member_leave.php";
}
</script>
<!-- } 로그인 후 아웃로그인 끝 -->
