<?php
$sub_menu = '100600';
include_once('./_common.php');

auth_check_menu($auth, $sub_menu, 'r');

$g5['title'] = 'JSON흐름도';
include_once('./admin.head.php');

// g5_json_flowchart 테이블이 없을 경우 생성
if (!sql_query(" DESC g5_json_flowchart ", false)) {
    sql_query(
        " CREATE TABLE IF NOT EXISTS `g5_json_flowchart` (
				`id` int(11) NOT NULL auto_increment,
				`json_input` text NOT NULL,
				`direction` varchar(10) NOT NULL DEFAULT 'LR',
				`created_at` datetime NOT NULL default '0000-00-00 00:00:00',
				`updated_at` datetime NOT NULL default '0000-00-00 00:00:00',
				PRIMARY KEY (`id`)
                ) ",
        false
    );
}

// Insert default data if table is empty
$sql = "select COUNT(*) as count from `g5_json_flowchart`";
$result = sql_query($sql);
$count = sql_fetch_array($result)['count'];
if ($count == 0) {
    $default_json = '{
  "id": "001",
  "position": {
    "x": 20,
    "y": 1,
    "z": 300
  },
  "Encoding": false,
  "items": [
    "Java",
    "C",
	"C++",
	"Python",
	"PHP"
  ]
}';
    $default_json = sql_real_escape_string($default_json);
    $sql = "insert into `g5_json_flowchart` (`json_input`, `direction`, `created_at`) values ('$default_json', 'LR', '".G5_TIME_YMDHIS."')";
    sql_query($sql);
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    $input = json_decode(file_get_contents('php://input'), true);

    if (!isset($input['json_input']) || !isset($input['direction'])) {
        echo json_encode(['status' => 'error', 'message' => 'Missing json_input or direction']);
        exit;
    }

    $json_input = trim($input['json_input']);
    $direction = trim($input['direction']);

    if (empty($json_input) || !in_array($direction, ['LR', 'RL', 'TB', 'TD', 'BT'])) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid input or direction']);
        exit;
    }

    // Validate JSON
    if (json_decode($json_input) === null && json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format']);
        exit;
    }

    $json_input = sql_real_escape_string($json_input);
    $direction = sql_real_escape_string($direction);

    // Update the latest record
    $sql = "SELECT MAX(id) as max_id FROM `g5_json_flowchart`";
    $result = sql_query($sql);
    $max_id = sql_fetch_array($result)['max_id'];

    if ($max_id) {
        $sql = "UPDATE `g5_json_flowchart` SET
                `json_input` = '$json_input',
                `direction` = '$direction',
                `updated_at` = CURRENT_TIMESTAMP
                WHERE `id` = '$max_id'";
    } else {
        $sql = "INSERT INTO `g5_json_flowchart` (`json_input`, `direction`)
                VALUES ('$json_input', '$direction')";
    }

    $result = sql_query($sql);

    if ($result) {
        echo json_encode(['status' => 'success', 'message' => 'Data saved']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . sql_error_info()]);
    }
    exit;
}

// Load latest data
$sql = "SELECT json_input, direction FROM `g5_json_flowchart` ORDER BY id DESC LIMIT 1";
$result = sql_query($sql);
$data = sql_fetch_array($result);
?>

<link rel="stylesheet" href="./json_flowchart.css">
<body class="bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-gray-100 transition">
    <div id="root"></div>
    <script>
        window.initialData = <?php echo json_encode([
            'jsonInput' => $data['json_input'] ?? '{}',
            'direction' => $data['direction'] ?? 'LR'
        ]); ?>;
    </script>
</body>
<script src='https://cdn.tailwindcss.com'></script>
<script type="module" src="./json_flowchart.js"></script>

<?php
include_once('./admin.tail.php');
