function deleteSelectedPopup() {
    const checkedEls = Array.from(document.querySelectorAll('input[name="popup_play_list[]"]:checked'));
    const ids = checkedEls.map(e => e.value.split('**')[0]); // id만 추출

    if(ids.length === 0){
        alert('삭제할 곡을 선택하세요.');
        return;
    }

    if(!confirm(`선택한 ${ids.length}곡을 삭제하시겠습니까?`)) return;

    fetch(g5_bbs_url + "/playlist_delete.php", {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify({ ids: ids })
    })
    .then(res => res.json())
    .then(data => {
        if(data.success){
            alert('선택한 곡이 삭제되었습니다.');
            openPlaylistPopup(); // ✅ 서버 기준으로 다시 렌더링
        } else {
            alert(data.message || '삭제 중 오류가 발생했습니다.');
        }
    })
    .catch(err => {
        console.error(err);
        alert('삭제 중 오류가 발생했습니다. 콘솔을 확인하세요.');
    });
}
