// list_popup.js
function escapeHtml(str){
    if (!str) return '';
    return String(str).replace(/[&<>"']/g, function(m){
        return {'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m];
    });
}

function openPlaylistPopup() {
    const popup = document.getElementById('playlistPopup');
    const listEl = document.getElementById('playlistItems');
    if (!popup || !listEl) return;
    listEl.innerHTML = "<li>불러오는 중...</li>";

    fetch(g5_bbs_url + "/playlist_load.php")
    .then(r => r.json())
    .then(data => {
        if (!data.success) { listEl.innerHTML = "<li>불러오기 실패</li>"; return; }
        if (!data.items || data.items.length === 0) { listEl.innerHTML = "<li>저장된 곡이 없습니다.</li>"; return; }

        listEl.innerHTML = "";
       data.items.forEach((item, index) => {
    const li = document.createElement('li');
    const inputId = `toggle-${item.id}-${index}`; // 이제 index 존재
    li.className = 'playlist-item';
    li.innerHTML = `
        <ul class="pop_list">
            <li class="checkbox-wrapper-34">
                <input type="checkbox" class="tgl tgl-ios" id="${inputId}" name="popup_play_list[]" value="${item.id}**${item.title}">
                <label class="tgl-btn" for="${inputId}"></label>
            </li>
            <li>
                <img src="https://img.youtube.com/vi/${item.id}/default.jpg" style="width:80px;vertical-align:middle;margin-right:10px;">
            </li>
            <li>${escapeHtml(item.title)}</li>
            <li><button type="button" onclick="playPopupYoutube('${item.id}**${item.title}')"> 듣기 &nbsp; ▶</button></li>
            <li><button type="button" onclick="deletePopupItem('${item.id}')"> 삭제 &nbsp; ✕ </button></li>
        </ul>
    `;
    listEl.appendChild(li);
});

    })
    .catch(err => { console.error(err); listEl.innerHTML="<li>에러 발생</li>"; });

    popup.style.display = 'flex';
    setTimeout(()=> popup.style.opacity = '1', 10);
}

function playPopupYoutube(id) {
    if (!id) return;
    openYoutubePopup(id); // id**title 형식도 처리됨
}

//function playSelectedPopup() {
//    const items = Array.from(document.querySelectorAll('input[name="popup_play_list[]"]:checked'))
//                       .map(e => e.value);
//    if (items.length === 0) { alert('선택된 곡이 없습니다.'); return; }
//    openYoutubePopup(items);
//}

function playSelectedPopup(random = false) {
    const items = Array.from(document.querySelectorAll('input[name="popup_play_list[]"]:checked'))
                       .map(e => e.value); // "id**title"

    if (items.length === 0) { 
        alert('선택된 곡이 없습니다.'); 
        return; 
    }

    if (random) {
        // 배열 섞기 (Fisher-Yates shuffle)
        for (let i = items.length - 1; i > 0; i--) {
            const j = Math.floor(Math.random() * (i + 1));
            [items[i], items[j]] = [items[j], items[i]];
        }
    }

    openYoutubePopup(items);
}


function deleteSelectedPopup() {
    const checkedEls = Array.from(document.querySelectorAll('input[name="popup_play_list[]"]:checked'));
    if (checkedEls.length === 0) { alert('삭제할 곡을 선택하세요.'); return; }
    if (!confirm(`선택한 ${checkedEls.length}곡을 삭제하시겠습니까?`)) return;

    const ids = checkedEls.map(e => e.value.split('**')[0]);
    fetch(g5_bbs_url + "/playlist_delete.php", {
        method: 'POST',
        headers: {'Content-Type':'application/json'},
        body: JSON.stringify({ ids: ids })
    })
    .then(r => r.json())
    .then(data => {
        if(data.success){
            alert('삭제 완료');
            checkedEls.forEach(e => e.closest('li').remove());
        } else {
            alert(data.message || '삭제 실패');
        }
    })
    .catch(err => { console.error(err); alert('삭제 오류'); });
}

function deletePopupItem(id) {
    if (!confirm('정말 삭제하시겠습니까?')) return;

    fetch(g5_bbs_url + "/playlist_delete.php", {
        method: "POST",
        headers: {"Content-Type": "application/json"},
        body: JSON.stringify({ ids: [id] })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            alert("삭제되었습니다.");
            openPlaylistPopup(); // 새로 불러오기
        } else {
            alert(data.message || "삭제 실패");
        }
    })
    .catch(err => {
        console.error(err);
        alert("에러 발생");
    });
}

function closePlaylistPopup() {
    const popup = document.getElementById('playlistPopup');
    popup.style.opacity = '0';
    setTimeout(()=> popup.style.display = 'none', 300);
}
