// playlist.js (스킨/js/playlist.js)
function addToPlaylist() {
    // list.skin.php 체크박스는 value="id**title" 형태
    const ids = Array.from(document.querySelectorAll('input[name="play_list[]"]:checked'))
                     .map(e => e.value);
    if (ids.length === 0) { alert('선택된 곡이 없습니다.'); return; }

    fetch('/bbs/playlist_save.php', {
        method: 'POST',
        headers: {'Content-Type':'application/json'},
        body: JSON.stringify({ ids: ids })
    })
    .then(r => r.json())
    .then(data => {
        if (data.success) alert('선택한 곡을 담았습니다!');
        else alert(data.message || '저장 중 오류');
    })
    .catch(err => { console.error(err); alert('통신 오류'); });
}

function playMyPlaylist() {
    fetch('/bbs/playlist_load.php')
    .then(r => r.json())
    .then(data => {
        if (!data.success) { alert(data.message || '오류'); return; }
        // transfer as "id**title" strings so popup/player can use title
        const arr = data.items.map(i => i.id + '**' + i.title);
        if (arr.length === 0) { alert('담은 곡이 없습니다.'); return; }
        openYoutubePopup(arr);
    })
    .catch(err => { console.error(err); alert('불러오기 오류'); });
}
