<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 5;

if ($is_checkbox) $colspan++;
if ($is_good) $colspan++;
if ($is_nogood) $colspan++;

include_once(G5_THEME_PATH . '/lib/youtube.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/samo.css">', 1);
?>
<?php
//유튜브 ID 정규화 함수 — get_youtube_id
if (!function_exists('get_youtube_id')) {
    function get_youtube_id($input) {
        $input = trim((string)$input);
        if ($input === '') return '';

        // 여러 토큰 합쳐진 경우(예: "**"로 합침) 첫 토큰만 사용
        if (strpos($input, '**') !== false) {
            $parts = explode('**', $input);
            $input = trim($parts[0]);
        }

        // 정확히 11자리 아이디만 허용
        if (preg_match('/^[a-zA-Z0-9_-]{11}$/', $input)) {
            return $input;
        }

        // URL 등에서 11자리 아이디 추출 (watch?v=, youtu.be/, embed/, shorts/)
        if (preg_match('~(?:youtube\.com/(?:.*[?&]v=|embed/|shorts/)|youtu\.be/)([a-zA-Z0-9_-]{11})~', $input, $m)) {
            return $m[1];
        }

        // 유효한 ID를 못 찾음
        return '';
    }
}
?>
<!-- Font Awesome 6 Free (CDN) -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">

<!-- 게시판 목록 시작 { -->
<div id="bo_list" style="width:<?php echo $width; ?>">
    <div class="bo_top_title title-sticky" id="stickyTitle">
        <p><a href="<?php echo $list_href ?>"><?php echo $board['bo_subject'] ?></a></p>
        <ul>
            <li><button type="button"onclick="playSelected()">
                    <i class="fa-solid fa-headphones"></i> 선택듣기</button></li>
            <li><button type="button" onclick="addToPlaylist()"><i class="fa-solid fa-plus"></i> 담기</button></li>
            <li>
                <?php if ($is_member) { ?>
                    <button type="button" onclick="playMyPlaylist()"><i class="fa-solid fa-play"></i> 앨범재생</button>
                <?php } else { ?>
                    <button type="button" onclick="alert('로그인 후 이용해주세요');"><i class="fa-solid fa-play"></i> 앨범재생</button>
                <?php } ?>
            </li>
            <li>
                <?php if ($is_member) { ?>
                    <button type="button" onclick="openPlaylistPopup()"><i class="fa-solid fa-list-ul"></i> 앨범보기</button>
                <?php } else { ?>
                    <button type="button" onclick="alert('로그인 후 이용해주세요');"><i class="fa-solid fa-list-ul"></i> 앨범보기</button>
                <?php } ?>
            </li>
        </ul>
    </div>
    <script>
    window.addEventListener('scroll', function () {
        const sticky = document.getElementById('stickyTitle');
        if (window.scrollY > 10) {
            sticky.classList.add('scrolled');
        } else {
            sticky.classList.remove('scrolled');
        }
    });
    </script>
    
    <!-- 게시판 카테고리 시작 { -->
    <?php if ($is_category) { ?>
    <nav id="bo_cate">
        <h2><?php echo $board['bo_subject'] ?> 카테고리</h2>
        <ul id="bo_cate_ul">
            <?php echo $category_option ?>
        </ul>
    </nav>
    <?php } ?>
    <!-- } 게시판 카테고리 끝 -->
    
    <form name="fboardlist" id="fboardlist" action="<?php echo G5_BBS_URL; ?>/board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
    
    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
    <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
    <input type="hidden" name="stx" value="<?php echo $stx ?>">
    <input type="hidden" name="spt" value="<?php echo $spt ?>">
    <input type="hidden" name="sca" value="<?php echo $sca ?>">
    <input type="hidden" name="sst" value="<?php echo $sst ?>">
    <input type="hidden" name="sod" value="<?php echo $sod ?>">
    <input type="hidden" name="page" value="<?php echo $page ?>">
    <input type="hidden" name="sw" value="">

    <!-- 게시판 페이지 정보 및 버튼 시작 { -->
    <div id="bo_btn_top">
        <div id="bo_list_total">
            <span>Total <?php echo number_format($total_count) ?>건</span>
            <?php echo $page ?> 페이지
        </div>

        <nav id="board-menu">
            <button>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-dots">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                    <path d="M5 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0" />
                    <path d="M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0" />
                    <path d="M19 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0" />
                </svg>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-x">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                    <path d="M18 6l-12 12" />
                    <path d="M6 6l12 12" />
                </svg>
            </button>
            <ul>
                <?php if ($admin_href) { ?>
                    <li>
                        <a href="<?php echo $admin_href ?>" title="관리자">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-settings">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z" />
                                <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0" />
                            </svg>
                            관리자
                        </a>
                    </li>
                <?php } ?>
                <?php if ($rss_href) { ?>
                    <li>
                        <a href="<?php echo $rss_href ?>" title="RSS">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-rss">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <path d="M5 19m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0" />
                                <path d="M4 4a16 16 0 0 1 16 16" />
                                <path d="M4 11a9 9 0 0 1 9 9" />
                            </svg>
                            RSS
                        </a>
                    </li>
                <?php } ?>
                <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" title="글쓰기"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-plus">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <path d="M12 5l0 14" />
                                <path d="M5 12l14 0" />
                            </svg>글쓰기</a></li><?php } ?>
                <?php if ($is_admin == 'super' || $is_auth) {  ?>
                    <?php if ($is_checkbox) { ?>
                        <li><button type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-trash">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M4 7l16 0" />
                                    <path d="M10 11l0 6" />
                                    <path d="M14 11l0 6" />
                                    <path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12" />
                                    <path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3" />
                                </svg>선택삭제</button></li>
                        <li><button type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-copy">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M7 7m0 2.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z" />
                                    <path d="M4.012 16.737a2.005 2.005 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1" />
                                </svg>선택복사</button></li>
                        <li><button type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-arrows-move">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M18 9l3 3l-3 3" />
                                    <path d="M15 12h6" />
                                    <path d="M6 9l-3 3l3 3" />
                                    <path d="M3 12h6" />
                                    <path d="M9 18l3 3l3 -3" />
                                    <path d="M12 15v6" />
                                    <path d="M15 6l-3 -3l-3 3" />
                                    <path d="M12 3v6" />
                                </svg>선택이동</button></li>
                    <?php } ?>
                <?php }  ?>
            </ul>
        </nav>     
    </div>
    <!-- } 게시판 페이지 정보 및 버튼 끝 -->
        	
    <div class="list_container">
        <?php if ($is_checkbox) { ?>
            <div class="all_chk chk_box all_box">
            	<input type="checkbox" id="chkall" onclick="if (this.checked) all_checked(true); else all_checked(false);" class="selec_chk">
                <label for="chkall">
                	<span></span>
                	<b class="sound_only">현재 페이지 게시물  전체선택</b>
				</label>
            </div>
        <?php } ?>

        <?php
            for ($i=0; $i<count($list); $i++) {
		?>
            <ul>
                <li>
                    <?php
                        if ($list[$i]['is_notice']) // 공지사항
                            echo '<strong class="notice_icon">공지</strong>';
                        else if ($wr_id == $list[$i]['wr_id'])
                            echo "<span class=\"bo_current\">열람중</span>";
                        else
                            echo $list[$i]['num'];
                    ?>
                </li>
                <li class="thumb_img">
                    <?php if ($is_category && $list[$i]['ca_name']) { ?>
                        <a href="<?php echo $list[$i]['ca_name_href'] ?>" class="bo_cate_link"><?php echo $list[$i]['ca_name'] ?></a>
                    <?php } ?>
                    
                    <?php
                        $youtube_id = get_youtube_id($list[$i]['wr_1'] ?? '');
                        $thumb = $youtube_id ? "https://img.youtube.com/vi/{$youtube_id}/mqdefault.jpg" : '';
                    ?>
                    <?php if ($youtube_id) { ?>
                        <!-- <input type="checkbox" name="play_list[]" value="<?//php echo $youtube_id; ?>" /> -->
                        <img src="<?php echo htmlspecialchars($thumb, ENT_QUOTES); ?>"
                             alt="썸네일"
                             style="width:150px; cursor:pointer;"
                             onclick="openYoutubePopup('<?php echo $youtube_id; ?>')">
                    <?php } ?>
                </li>

                <li>
                    <?php if ($is_checkbox) { ?>
                        <span class="td_chk chk_box">
			            	<input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>" class="selec_chk">
                        	<label for="chk_wr_id_<?php echo $i ?>">
                        		<span></span>
                        		<b class="sound_only"><?php echo $list[$i]['subject'] ?></b>
                        	</label>
                        </span>
                    <?php } ?>
                    <a href="<?php echo $list[$i]['href'] ?>">
                        <?php echo $list[$i]['icon_reply'] ?>
                        <?php if (isset($list[$i]['icon_secret'])) echo rtrim($list[$i]['icon_secret']); ?>
                        <?php echo $list[$i]['subject'] ?>
                    </a>
                    <?php
                        if ($list[$i]['icon_new']) echo "<span class=\"new_icon\">N<span class=\"sound_only\">새글</span></span>";
                        //if (isset($list[$i]['icon_hot'])) echo rtrim($list[$i]['icon_hot']);
                        if (isset($list[$i]['icon_hot']) && $list[$i]['icon_hot']) {
                                echo '<span class="hot-label">HOT</span>';
                            }
                        if (isset($list[$i]['icon_file'])) echo rtrim($list[$i]['icon_file']);
                        if (isset($list[$i]['icon_link'])) echo rtrim($list[$i]['icon_link']);
                    ?>
                    <?php if ($list[$i]['comment_cnt']) { ?><span class="sound_only">댓글</span><span class="cnt_cmt"><?php echo $list[$i]['wr_comment']; ?></span><span class="sound_only">개</span><?php } ?>
                </li>
                <li>
                    <?php if ($youtube_id) { ?>
                        <div class="checkbox-wrapper-35">
                            <!-- <input class="switch" type="checkbox" id="switch<?//php echo $i; ?>" name="play_list[]" value="<?//php echo $youtube_id; ?>" /> -->
                             <input class="switch" type="checkbox" id="switch<?php echo $i; ?>" name="play_list[]" value="<?php echo $youtube_id . '**' . htmlspecialchars($list[$i]['subject'], ENT_QUOTES); ?>" />
                            <label for="switch<?php echo $i; ?>">
                              <!-- <span class="switch-x-text">This is </span> -->
                              <span class="switch-x-toggletext">
                                <span class="switch-x-unchecked"><span class="switch-x-hiddenlabel">Unchecked: </span>&horbar;</span>
                                <span class="switch-x-checked red_chk"><span class="switch-x-hiddenlabel">Checked: </span><i class="fa-solid fa-check"></i></span>
                              </span>
                            </label>
                        </div>
                        <!-- <input type="checkbox" name="play_list[]" value="<?php echo $youtube_id; ?>" /> -->
                    <?php } ?>
                </li>
                <li><?php echo $list[$i]['name'] ?></li>
                <li><?php echo $list[$i]['datetime2'] ?></li>
                <li>H : <?php echo $list[$i]['wr_hit'] ?></li>
            </ul>
        <?php }?>

        <?php if (count($list) == 0) { echo '<div>게시물이 없습니다.</div>'; } ?>
    </div>        



<!-- 내 플레이리스트 팝업 -->
<div id="playlistPopup" class="popup_bg">
    <div class="popup_box">
        <h3>내 플레이리스트</h3>
        <ul id="playlistItems" class="popup_ul"></ul>
        <div class="popup_list">
            <span><button type="button" onclick="playSelectedPopup()">선택 듣기 <i class="fa-solid fa-play"></i></button></span>
            <span><button type="button" onclick="playSelectedPopup(true)">랜덤 듣기 <i class="fa-solid fa-shuffle"></i></button></span>
            <span><button type="button" onclick="deleteSelectedPopup()">선택 삭제 <i class="fa-solid fa-trash"></i></button></span>
            <span><button type="button" onclick="closePlaylistPopup()">닫기 <i class="fa-solid fa-circle-xmark"></i></button></span>
        </div>
    </div>
</div>

	<!-- 페이지 -->
	<?php echo $write_pages; ?>
	<!-- 페이지 -->
        
    </form>

    <!-- 게시판 검색 시작 { -->
    <div class="bo_sch_wrap">
        <fieldset class="bo_sch">
            <h3>검색</h3>
            <form name="fsearch" method="get">
            <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
            <input type="hidden" name="sca" value="<?php echo $sca ?>">
            <input type="hidden" name="sop" value="and">
            <label for="sfl" class="sound_only">검색대상</label>
            <select name="sfl" id="sfl">
                <?php echo get_board_sfl_select_options($sfl); ?>
            </select>
            <label for="stx" class="sound_only">검색어<strong class="sound_only"> 필수</strong></label>
            <div class="sch_bar">
                <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx" class="sch_input" size="25" maxlength="20" placeholder=" 검색어를 입력해주세요">
                <button type="submit" value="검색" class="sch_btn"><i class="fa fa-search" aria-hidden="true"></i><span class="sound_only">검색</span></button>
            </div>
            <button type="button" class="bo_sch_cls" title="닫기"><i class="fa fa-times" aria-hidden="true"></i><span class="sound_only">닫기</span></button>
            </form>
        </fieldset>
        <div class="bo_sch_bg"></div>
    </div>

    <script>
    jQuery(function($){
        // 게시판 검색
        $(".btn_bo_sch").on("click", function() {
            $(".bo_sch_wrap").toggle();
        })
        $('.bo_sch_bg, .bo_sch_cls').click(function(){
            $('.bo_sch_wrap').hide();
        });
    });
    </script>
    <!-- } 게시판 검색 끝 --> 
</div>
    
<script src="<?php echo $board_skin_url;?>/js/choice_h.js"></script>
<script src="<?php echo $board_skin_url;?>/js/playlist.js"></script>
<script src="<?php echo $board_skin_url;?>/js/list_popup.js"></script>
<script src="<?php echo $board_skin_url;?>/js/delete_m.js"></script>

<?php include_once($board_skin_path.'/youtube_popup.php');?>

<script>
    jQuery(function($) {
        $('.category-box button').on('click', function(e) {
            e.preventDefault();
            var box = $(this).closest('.category-box');
            if (box.hasClass('active')) {
                box.removeClass('active');
            } else {
                box.addClass('active');
            }
        });
        if($('#board-menu li').size() < 1) {
            $('#board-menu').remove();
        }
        setTimeout(function() {
            $('#board-menu > button').click();
        }, 600);

        $('#board-menu > button').on('click', function(e) {
            e.preventDefault();
            $(this).parent().toggleClass('active');
        });
    });
</script>

<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = g5_bbs_url+"/board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == "copy")
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = g5_bbs_url+"/move.php";
    f.submit();
}

// 게시판 리스트 관리자 옵션
jQuery(function($){
    $(".btn_more_opt.is_list_btn").on("click", function(e) {
        e.stopPropagation();
        $(".more_opt.is_list_btn").toggle();
    });
    $(document).on("click", function (e) {
        if(!$(e.target).closest('.is_list_btn').length) {
            $(".more_opt.is_list_btn").hide();
        }
    });
});
</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->
