<?php
// /lib/youtube.lib.php
if (!function_exists('get_youtube_id')) {
    function get_youtube_id($input) {
        $input = trim((string)$input);
        if ($input === '') return '';

        // wr_1에 "**"로 여러 값이 합쳐진 경우 첫 토큰만 사용
        if (strpos($input, '**') !== false) {
            $parts = explode('**', $input);
            $input = trim($parts[0]);
        }

        // 아이디만 입력 (정확히 11자)
        if (preg_match('/^[a-zA-Z0-9_-]{11}$/', $input)) {
            return $input;
        }

        // 다양한 URL 형태 지원: watch?v= / youtu.be / embed / shorts
        if (preg_match('~(?:youtube\.com/(?:.*[?&]v=|embed/|shorts/)|youtu\.be/)([a-zA-Z0-9_-]{11})~', $input, $m)) {
            return $m[1];
        }

        return '';
    }
}
