<!-- youtube_popup.php -->
<style>
#youtubePopup { display:none; position:fixed; top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.8);z-index:9999;justify-content:center;align-items:center;opacity:0;transition:opacity .25s;}
#youtubePopup.show{display:flex;opacity:1;}
#youtubePopupContent{position:relative;width:90%;max-width:900px;aspect-ratio:16/9;background:#000;border-radius:10px;overflow:hidden;transform:scale(.9);transition:transform .25s;}
#youtubePopup.show #youtubePopupContent{transform:scale(1);}
#youtubeCloseBtn{position:absolute;top:10px;right:10px;font-size:24px;color:#fff;background:none;border:none;cursor:pointer;}
#youtubeTitle{position:absolute;bottom:10px;left:10px;color:#fff;font-size:16px;text-shadow:0 0 5px #000;padding:6px 10px;background:rgba(0,0,0,0.35);border-radius:6px;}
</style>

<div id="youtubePopup" aria-hidden="true">
  <div id="youtubePopupContent">
    <div id="youtubePlayer" style="width:100%;height:100%;"></div>
    <div id="youtubeTitle"></div>
    <button id="youtubeCloseBtn" aria-label="닫기">✕</button>
  </div>
</div>

<script>
(function(){
  console.log('[youtube_popup] init');
  let playQueue = [];
  let currentIndex = 0;
  let player = null;
  let apiReady = false;
  let playOnReady = false;

  const popup = document.getElementById('youtubePopup');
  const closeBtn = document.getElementById('youtubeCloseBtn');
  const titleEl = document.getElementById('youtubeTitle');

  function updateTitle(){
    if (playQueue[currentIndex] && playQueue[currentIndex].title) {
      titleEl.textContent = playQueue[currentIndex].title;
    } else {
      titleEl.textContent = '';
    }
  }

  window.openYoutubePopup = function(idsOrId){
    if (!idsOrId) return;
    // normalize to array of {id,title}
    if (typeof idsOrId === 'string') idsOrId = [idsOrId];
    playQueue = idsOrId.map(item => {
      if (typeof item === 'string') {
        const parts = item.split('**');
        return { id: parts[0], title: (parts[1]||parts[0]) };
      } else if (item && item.id) {
        return { id: item.id, title: item.title || item.id };
      } else return null;
    }).filter(Boolean);

    currentIndex = 0;
    popup.classList.add('show');
    popup.setAttribute('aria-hidden','false');

    if (apiReady && player) {
      player.loadVideoById(playQueue[currentIndex].id);
      try { player.playVideo(); } catch(e){ console.log(e); }
      updateTitle();
    } else {
      playOnReady = true;
      ensureYouTubeAPI();
    }
  };

  closeBtn.addEventListener('click', function(){ closeYoutubePopup(); });

  window.closeYoutubePopup = function(){
    if (player && typeof player.stopVideo === 'function') {
      try { player.stopVideo(); } catch(e) {}
    }
    playQueue = [];
    playOnReady = false;
    popup.classList.remove('show');
    popup.setAttribute('aria-hidden','true');
  };

  popup.addEventListener('click', function(e){ if (e.target === popup) closeYoutubePopup(); });
  document.addEventListener('keydown', function(e){ if (e.key === 'Escape') closeYoutubePopup(); });

  function ensureYouTubeAPI(){
    if (window.YT && window.YT.Player) { apiReady = true; if (!player) createPlayer(); return; }
    if (document.getElementById('youtube-iframe-api')) return;
    const tag = document.createElement('script'); tag.id='youtube-iframe-api'; tag.src='https://www.youtube.com/iframe_api'; document.head.appendChild(tag);
  }

  window.onYouTubeIframeAPIReady = function(){
    apiReady = true; createPlayer();
  };

  function createPlayer(){
    if (player) return;
    player = new YT.Player('youtubePlayer', {
      height:'100%', width:'100%',
      playerVars: { rel:0, modestbranding:1, playsinline:1 },
      events: {
        onReady: function(){
          if (playOnReady && playQueue.length>0) {
            player.loadVideoById(playQueue[currentIndex].id);
            try { player.playVideo(); } catch(e){}
            updateTitle();
            playOnReady = false;
          }
        },
        onStateChange: function(e){
          if (e.data === YT.PlayerState.ENDED) {
            currentIndex++;
            if (currentIndex < playQueue.length) {
              player.loadVideoById(playQueue[currentIndex].id);
              try { player.playVideo(); } catch(e){}
              updateTitle();
            } else {
              closeYoutubePopup();
            }
          }
        }
      }
    });
  }

  ensureYouTubeAPI();
})();
</script>
