<?php
include_once('./_common.php');
if (!$is_member) {
    echo '로그인 필요';
    exit;
}

function get_youtube_id($input) {
    $input = trim((string)$input);
    if ($input === '') return '';
    if (strpos($input, '**') !== false) {
        $parts = explode('**', $input);
        $input = trim($parts[0]);
    }
    if (preg_match('/^[a-zA-Z0-9_-]{11}$/', $input)) return $input;
    if (preg_match('~(?:youtube\.com/(?:.*[?&]v=|embed/|shorts/)|youtu\.be/)([a-zA-Z0-9_-]{11})~', $input, $m)) return $m[1];
    return '';
}

$playlist_raw = $member['mb_10'] ?? '';
$parts = array_filter(array_map('trim', explode(',', $playlist_raw)));
$clean = [];
foreach ($parts as $p) {
    $g = get_youtube_id($p);
    if ($g) $clean[] = $g;
}
$clean = array_values(array_unique($clean));
$playlist_str = implode(',', $clean);

$sql = "UPDATE {$g5['member_table']} SET mb_10 = '".sql_real_escape_string($playlist_str)."' WHERE mb_id = '".escape_trim($member['mb_id'])."'";
sql_query($sql);

echo "정리 완료. 저장된 곡 수: ".count($clean);
