<?php
include_once('./_common.php');
header('Content-Type: application/json; charset=utf-8');

if (!$is_member) {
    echo json_encode(['success'=>false, 'message'=>'로그인이 필요합니다.']);
    exit;
}

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
$ids = $data['ids'] ?? [];

if (!is_array($ids) || empty($ids)) {
    echo json_encode(['success'=>false, 'message'=>'삭제할 항목이 없습니다.']);
    exit;
}

// 기존 mb_10 값 불러오기
$raw_old = $member['mb_10'] ?? '';
$new = [];

if (trim($raw_old) !== '') {
    $parts = array_filter(array_map('trim', explode(',', $raw_old)));
    foreach ($parts as $p) {
        if ($p === '') continue;
        $tmp = explode('**', $p, 2);
        $id = $tmp[0];
        if (!in_array($id, $ids)) {
            $new[] = $p;
        }
    }
}

$playlist_str = implode(',', $new);

// DB 업데이트
$sql = "UPDATE {$g5['member_table']}
        SET mb_10 = '".sql_real_escape_string($playlist_str)."'
        WHERE mb_id = '".escape_trim($member['mb_id'])."'";
sql_query($sql);

echo json_encode(['success'=>true, 'deleted'=>$ids, 'remain'=>count($new)]);
exit;
