<?php
include_once('./_common.php');
header('Content-Type: application/json; charset=utf-8');

if (!$is_member) {
    echo json_encode(['success'=>false, 'message'=>'로그인이 필요합니다.']);
    exit;
}

$items = [];
$raw = $member['mb_10'] ?? '';
if (trim($raw) !== '') {
    $parts = array_filter(array_map('trim', explode(',', $raw)));
    foreach ($parts as $p) {
        if ($p === '') continue;
        $tmp = explode('**', $p, 2);
        $id = $tmp[0];
        $title = $tmp[1] ?? $id;
        // validate id
        if (preg_match('/^[a-zA-Z0-9_-]{11}$/', $id)) {
            // preserve original title (already escaped on save)
            $items[] = ['id'=>$id, 'title'=>$title];
        }
    }
}

echo json_encode(['success'=>true, 'items'=>$items]);
exit;
