<?php
include_once('./_common.php');
header('Content-Type: application/json; charset=utf-8');

if (!$is_member) {
    echo json_encode(['success'=>false, 'message'=>'로그인이 필요합니다.']);
    exit;
}

function get_youtube_id($input) {
    $input = trim((string)$input);
    if ($input === '') return '';
    if (strpos($input, '**') !== false) {
        $parts = explode('**', $input);
        $input = trim($parts[0]);
    }
    if (preg_match('/^[a-zA-Z0-9_-]{11}$/', $input)) return $input;
    if (preg_match('~(?:youtube\.com/(?:.*[?&]v=|embed/|shorts/)|youtu\.be/)([a-zA-Z0-9_-]{11})~', $input, $m)) return $m[1];
    return '';
}

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
$ids = $data['ids'] ?? [];

if (!is_array($ids) || empty($ids)) {
    echo json_encode(['success'=>false, 'message'=>'곡이 선택되지 않았습니다.']);
    exit;
}

$valid = []; $invalid = [];
foreach ($ids as $rawVal) {
    // rawVal expected "id**title" or "id"
    $parts = explode('**', $rawVal, 2);
    $id = get_youtube_id($parts[0]);
    $title = isset($parts[1]) ? trim($parts[1]) : $parts[0];
    if ($id) {
        // store as id**title (title may include commas)
        $title = str_replace(',', '，', $title); // 콤마 충돌 방지(간단)
        $valid[] = $id . '**' . $title;
    } else {
        $invalid[] = $rawVal;
    }
}
$valid = array_values(array_unique($valid));
if (empty($valid)) {
    echo json_encode(['success'=>false, 'message'=>'유효한 항목이 없습니다.', 'invalid'=>$invalid]);
    exit;
}

// load existing (mb_10) and keep only well-formed "id**title" entries
$old = [];
$raw_old = $member['mb_10'] ?? '';
if ($raw_old !== '') {
    $parts = array_filter(array_map('trim', explode(',', $raw_old)));
    foreach ($parts as $p) {
        if ($p === '') continue;
        // keep only if id valid
        $a = explode('**', $p, 2);
        $gid = get_youtube_id($a[0]);
        if ($gid) {
            $title = $a[1] ?? $a[0];
            $old[$gid] = $gid . '**' . $title;
        }
    }
}

// merge (old + valid), valid overwrites by id
foreach ($valid as $v) {
    $a = explode('**', $v, 2);
    $old[$a[0]] = $v;
}

$merged = array_values($old);

// optional limit
$max = 500;
if (count($merged) > $max) $merged = array_slice($merged, 0, $max);

$playlist_str = implode(',', $merged);

$sql = "UPDATE {$g5['member_table']}
        SET mb_10 = '".sql_real_escape_string($playlist_str)."'
        WHERE mb_id = '".escape_trim($member['mb_id'])."'";
sql_query($sql);

echo json_encode(['success'=>true, 'saved'=>$valid, 'invalid'=>$invalid]);
exit;
