<?php
// G5_LIB_PATH 등 공통 변수 및 라이브러리를 포함합니다.
include_once('./_common.php');
@include_once(G5_LIB_PATH.'/json.lib.php');
include_once(G5_LIB_PATH.'/visit.lib.php');

// HTTP POST 요청이 아닌 경우 접근 차단
if($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die(json_encode(['error' => '올바른 접근 방식이 아닙니다.']));
}

$mode = $_POST['mode'] ?? '';
$response = [];

// 각 모드별 분기
switch ($mode) {

    case 'visit':
        $types   = $_POST['types'] ?? 'hour';
        $fr_date = $_POST['fr_date'] ?? date("Y-m-d");
        $to_date = $_POST['to_date'] ?? date("Y-m-d");

        // 지난 기간 계산
        switch ($types) {
            case 'hour': // 오늘 vs 어제
                $today = date("Y-m-d");
                $yesterday = date("Y-m-d", strtotime("-1 day"));
                break;

            case 'week': // 이번주 vs 지난주
                $fr_date = date("Y-m-d", strtotime('monday this week'));
                $to_date = date("Y-m-d", strtotime('sunday this week'));
                $past_fr_date = date("Y-m-d", strtotime($fr_date." -7 days"));
                $past_to_date = date("Y-m-d", strtotime($to_date." -7 days"));
                break;

            case 'day': // 이번달 vs 전달
                $fr_date = date("Y-m-01");      // 이번달 1일
                $to_date = date("Y-m-t");       // 이번달 말일
                $past_fr_date = date("Y-m-01", strtotime("-1 month"));
                $past_to_date = date("Y-m-t", strtotime("-1 month"));
                break;

            case 'month': // 올해 vs 작년
                $fr_date = date("Y-01-01");     // 올해 1월 1일
                $to_date = date("Y-12-31");     // 올해 12월 31일
                $past_fr_date = date("Y-01-01", strtotime("-1 year"));
                $past_to_date = date("Y-12-31", strtotime("-1 year"));
                break;

            case 'year': // 최근 5년 vs 이전 5년
                $fr_date = date("Y-01-01", strtotime("-4 years"));
                $to_date = date("Y-12-31");
                $past_fr_date = date("Y-01-01", strtotime("-9 years"));
                $past_to_date = date("Y-12-31", strtotime("-5 years"));
                break;
        }

        $arr_to = [];
        $arr_fr = [];

        // 🔹 시간대는 오늘/어제 따로 조회
        if ($types === 'hour') {
            // 오늘
            $sql_today = "SELECT LPAD(SUBSTRING(vi_time,1,2),2,'0') AS kind, COUNT(*) AS cnt
                      FROM {$g5['visit_table']}
                      WHERE vi_date = '{$today}'
                      GROUP BY kind";
            $res = sql_query($sql_today);
            while($row = sql_fetch_array($res)) {
                $arr_to[$row['kind']] = (int)$row['cnt'];
            }

            // 어제
            $sql_yesterday = "SELECT LPAD(SUBSTRING(vi_time,1,2),2,'0') AS kind, COUNT(*) AS cnt
                          FROM {$g5['visit_table']}
                          WHERE vi_date = '{$yesterday}'
                          GROUP BY kind";
            $res = sql_query($sql_yesterday);
            while($row = sql_fetch_array($res)) {
                $arr_fr[$row['kind']] = (int)$row['cnt'];
            }

        } else {
            // 이번 기간
            $sql_now = "
            SELECT ".get_sql_date_part($types)." AS kind, COUNT(*) AS cnt
            FROM {$g5['visit_table']}
            WHERE vi_date BETWEEN '{$fr_date}' AND '{$to_date}'
            GROUP BY kind ORDER BY kind";
            $res = sql_query($sql_now);
            while($row = sql_fetch_array($res)) {
                $arr_to[$row['kind']] = (int)$row['cnt'];
            }

            // 지난 기간
            $sql_past = "
            SELECT ".get_sql_date_part($types)." AS kind, COUNT(*) AS cnt
            FROM {$g5['visit_table']}
            WHERE vi_date BETWEEN '{$past_fr_date}' AND '{$past_to_date}'
            GROUP BY kind ORDER BY kind";
            $res = sql_query($sql_past);
            while($row = sql_fetch_array($res)) {
                $arr_fr[$row['kind']] = (int)$row['cnt'];
            }
        }

        // 보정 (없으면 0)
        $to_ary = ['kind'=>[], 'count'=>[]];
        $fr_ary = ['kind'=>[], 'count'=>[]];

        if ($types === 'hour') {
            for ($i=0; $i<24; $i++) {
                $k = sprintf("%02d", $i);
                $to_ary['kind'][] = $k;
                $to_ary['count'][] = $arr_to[$k] ?? 0;
                $fr_ary['kind'][] = $k;
                $fr_ary['count'][] = $arr_fr[$k] ?? 0;
            }
        } elseif ($types === 'week') {
            $days = ['월','화','수','목','금','토','일'];
            for ($i=0; $i<7; $i++) {
                $to_ary['kind'][] = $days[$i];
                $to_ary['count'][] = $arr_to[$i] ?? 0;
                $fr_ary['kind'][] = $days[$i];
                $fr_ary['count'][] = $arr_fr[$i] ?? 0;
            }
        } elseif ($types === 'day') {
            $period = new DatePeriod(
                new DateTime($fr_date),
                new DateInterval('P1D'),
                (new DateTime($to_date))->modify('+1 day')
            );
            foreach ($period as $dt) {
                $fullKey = $dt->format("Y-m-d"); // DB 조회용 키
                $kind    = $dt->format("m-d");   // ✅ 차트 라벨은 월-일만 표시

                $to_ary['kind'][] = $kind;
                $to_ary['count'][] = $arr_to[$fullKey] ?? 0;

                $prevKey = date("Y-m-d", strtotime($fullKey." -1 month"));
                $fr_ary['kind'][] = $kind;
                $fr_ary['count'][] = $arr_fr[$prevKey] ?? 0;
            }
        } elseif ($types === 'month') {
            $start = new DateTime($fr_date);
            $end   = new DateTime($to_date);
            while ($start <= $end) {
                $fullKey = $start->format("Y-m"); // DB 조회용 키
                $kind    = $start->format("m");   // ✅ 차트 라벨은 월만 표시 (01~12)

                $to_ary['kind'][] = $kind;
                $to_ary['count'][] = $arr_to[$fullKey] ?? 0;
                $fr_ary['kind'][] = $kind;
                $fr_ary['count'][] = $arr_fr[$fullKey] ?? 0;

                $start->modify('+1 month');
            }
        } elseif ($types === 'year') {
            $start = (int)date("Y", strtotime($fr_date));
            $end   = (int)date("Y", strtotime($to_date));
            for ($y=$start; $y<=$end; $y++) {
                $k = (string)$y;
                $to_ary['kind'][] = $k;
                $to_ary['count'][] = $arr_to[$k] ?? 0;
                $fr_ary['kind'][] = $k;
                $fr_ary['count'][] = $arr_fr[$k] ?? 0;
            }
        }

        $response = ['to_data'=>$to_ary, 'fr_data'=>$fr_ary];
        break;

    case 'browser':
        $sql = "SELECT vi_browser, vi_agent FROM {$g5['visit_table']}";
        $result = sql_query($sql);

        $sum_count = 0;
        $hist = [];

        while ($row = sql_fetch_array($result)) {
            $browser = trim((string)$row['vi_browser']);
            if ($browser === '') {
                $browser = get_brow($row['vi_agent']); // 에이전트로 브라우저 판별
            }
            if ($browser === '' || $browser === null) $browser = '기타';

            if (!isset($hist[$browser])) $hist[$browser] = 0;
            $hist[$browser]++;
            $sum_count++;
        }

        // 데이터 없으면 빈 배열 반환
        if ($sum_count === 0) {
            $response = ['data' => ['title' => [], 'rate' => []]];
            break;
        }

        arsort($hist); // 사용량 내림차순

        $titles = [];
        $rates  = [];
        $etc_count = 0;
        $i = 0;

        foreach ($hist as $name => $count) {
            if ($i < 6) {             // 상위 6개
                $titles[] = $name;
                $rates[]  = $count;   // 개수 그대로 (차트에서 퍼센트 필요 시 프론트에서 계산 가능)
            } else {
                $etc_count += $count; // 나머지는 '그 외'
            }
            $i++;
        }

        if ($etc_count > 0) {
            $titles[] = '그 외';
            $rates[]  = $etc_count;
        }

        $response = ['data' => ['title' => $titles, 'rate' => $rates]];
        break;


    default:
        $response = ['error' => '유효하지 않은 모드입니다.'];
        break;
}

// JSON 출력
header('Content-Type: application/json; charset=utf-8');
echo json_encode($response, JSON_UNESCAPED_UNICODE);

// 날짜 파트 추출 함수
function get_sql_date_part($type) {
    switch ($type) {
        case 'hour':  return "LPAD(SUBSTRING(vi_time,1,2),2,'0')";
        case 'week':  return "WEEKDAY(vi_date)";
        case 'day':   return "DATE(vi_date)";
        case 'month': return "DATE_FORMAT(vi_date,'%Y-%m')";
        case 'year':  return "YEAR(vi_date)";
        default:      return "vi_date";
    }
}
