<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/style.css">', 0);
$list_count = (is_array($list) && $list) ? count($list) : 0;
$thumb_width = 2000;
$thumb_height = 70;
?>
<!-- //top_banner -->
<div id="top_banner" data-key="top_banner_1064" style="background-color: #fff">
    <div class="banner-container">
		<?php
		for ($i=0; $i<$list_count; $i++) {
			$thumb = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);

			if($thumb['src']) {
				$img = $thumb['src'];
			} else {
				$img = $latest_skin_url.'/img/banner_s1.jpg';
				$thumb['alt'] = '이미지가 없습니다.';
			}
			$img_content = '<img src="'.$img.'" alt="'.$thumb['alt'].'" >';
		?>
        <a href="<?php echo $list[$i]['href'] ?>"><?php echo $img_content; ?></a>
		<?php }  ?>
		<?php if ($list_count == 0) { //게시물이 없을 때  ?>
		<a href="#"><img src="<?php echo $latest_skin_url;?>/img/banner_s1.jpg" alt="배너" /></a>
		<?php }  ?>
    </div>
	<ul class="arrow_wrap">
		<span class="arrow prev" onclick="moveBanner('prev')"></span>
		<span class="arrow next" onclick="moveBanner('next')"></span>
	</ul>
    <div class="controls">
        <label><input type="checkbox" /> 오늘 하루 보지않기</label>
        <a href="#n" class="close" onclick="fnCloseTopBanner();"><img src="<?php echo $latest_skin_url;?>/img/btn_x.png" alt="닫기"></a>
    </div>
</div>

<script type="text/javascript">
function fnCloseTopBanner() {
    $("#top_banner").hide();
    if ($("#top_banner input[type=checkbox]").is(":checked")) {
        fnSetCookie("top_banner_1064", true, 1);
    }
}

$(document).ready(function() {
    const $bannerContainer = $("#top_banner .banner-container");
    const $banners = $bannerContainer.find("a");
    const bannerCount = $banners.length;
    let currentIndex = 0;

    // 초기 높이 설정
    $bannerContainer.css("height", bannerCount * 70 + "px");

    function rollBanner() {
        currentIndex = (currentIndex + 1) % bannerCount;
        $bannerContainer.css("transform", `translateY(-${currentIndex * 70}px)`);
    }

    // 3초마다 롤링 시작
    let rollInterval = setInterval(rollBanner, 3000);

    // 마우스 호버 시 롤링 일시 중지
    $("#top_banner").hover(
        function() {
            clearInterval(rollInterval);
        },
        function() {
            rollInterval = setInterval(rollBanner, 3000);
        }
    );

    // 위/아래 버튼 클릭 처리
    window.moveBanner = function(direction) {
        clearInterval(rollInterval); // 버튼 클릭 시 자동 롤링 중지
        if (direction === 'prev') {
            currentIndex = (currentIndex - 1 + bannerCount) % bannerCount;
        } else if (direction === 'next') {
            currentIndex = (currentIndex + 1) % bannerCount;
        }
        $bannerContainer.css("transform", `translateY(-${currentIndex * 70}px)`);
        // 호버가 끝나면 자동 롤링 재개
        rollInterval = setInterval(rollBanner, 3000);
    };
});
</script>
<!-- //top_banner -->