<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$faq_skin_url.'/style.css">', 0);
?>

<!-- FAQ 시작 { -->
<?php
if ($himg_src)
    echo '<div id="faq_himg" class="faq_img"><img src="'.$himg_src.'" alt=""></div>';

// 상단 HTML
echo '<div id="faq_hhtml">'.conv_content($fm['fm_head_html'], 1).'</div>';
?>

<div class="faq_search">
	<div class="container">
		<h2 class="text-center pt-5">FAQ 검색</h2>
		<form name="faq_search_form" method="get">
		<input type="hidden" name="fm_id" value="<?php echo $fm_id;?>">
		<div class="input-group input-group-lg pt-2 pb-5">
  			<input type="text" name="stx" value="<?php echo $stx;?>" id="stx" class="form-control" placeholder="검색어를 입력해주세요." aria-label="검색어를 입력해주세요." aria-describedby="search-addon">
  			<button type="submit" value="검색" class="btn btn-secondary" type="button" id="search-addon"><i class="bi bi-search"></i> 검색</button>
		</div>
		</form>	
	</div>
</div>

<div class="container">
<?php
if( count($faq_master_list) ){
?>	
<ul class="nav nav-tabs mb-3 mt-5">
        <?php
        foreach( $faq_master_list as $v ){
            $category_msg = '';
            $category_option = '';
            if($v['fm_id'] == $fm_id){ // 현재 선택된 카테고리라면
                $category_option = ' active';
            }
        ?>	
  <li class="nav-item">
    <a class="nav-link<?php echo $category_option;?>" aria-current="page" href="<?php echo $category_href;?>?fm_id=<?php echo $v['fm_id'];?>"><?php echo $v['fm_subject'];?></a>
  </li>
       <?php
        }
        ?>	
</ul>	
<?php } ?>		
	
	
<?php // FAQ 내용
if( count($faq_list) ){
?>	
<div class="accordion accordion-flush" id="accordionlist">
<?php
			$i = 0;
            foreach($faq_list as $key=>$v){
                if(empty($v))
                    continue;
?>
<div class="accordion-item">
<h2 class="accordion-header" id="heading<?=$i?>">
<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?=$i?>" aria-expanded="false" aria-controls="collapse<?=$i?>">
	<div class="p-1"><span class="badge bg-secondary">Q</span></div>
	<div class="p-1"><?php echo strip_tags(conv_content($v['fa_subject'], 1)); ?></div>
</button>
</h2>
<div id="collapse<?=$i?>" class="accordion-collapse collapse" aria-labelledby="heading<?=$i?>" data-bs-parent="#accordionlist">
	<div class="accordion-body" >
    <div class="d-flex">
  		<div class="p-1"><span class="badge text-bg-danger">A</span></div>
		<div class="p-1"><?php echo conv_content($v['fa_content'], 1); ?></div>
	</div>
	</div><!--// accordion-body END -->  
</div><!--// accordion-collapse END -->  
</div><!--// accordion-item END-->    
<?php 
	$i++;
			} 
	?>
</div><!--// accordion END -->	

    <?php

    } else {
        if($stx){
            echo '<p class="empty_list">검색된 게시물이 없습니다.</p>';
        } else {
            echo '<div class="empty_list">등록된 FAQ가 없습니다.';
            if($is_admin)
                echo '<br><a href="'.G5_ADMIN_URL.'/faqmasterlist.php">FAQ를 새로 등록하시려면 FAQ관리</a> 메뉴를 이용하십시오.';
            echo '</div>';
        }
    }

    ?>


<?php echo get_paging($page_rows, $page, $total_page, $_SERVER['SCRIPT_NAME'].'?'.$qstr.'&amp;page='); ?>
</div> <!-- container END  -->
<?php
// 하단 HTML
echo '<div id="faq_thtml">'.conv_content($fm['fm_tail_html'], 1).'</div>';

if ($timg_src)
    echo '<div id="faq_timg" class="faq_img"><img src="'.$timg_src.'" alt=""></div>';
?>
<!-- } FAQ 끝 -->

<?php
if ($admin_href)
    echo '<div class="faq_admin"><a href="'.$admin_href.'" class="btn_admin btn" title="FAQ 수정"><i class="fa fa-cog fa-spin fa-fw"></i><span class="sound_only">FAQ 수정</span></a></div>';
?>

<script src="<?php echo G5_JS_URL; ?>/viewimageresize.js"></script>
<script>
jQuery(function() {
    $(".closer_btn").on("click", function() {
        $(this).closest(".con_inner").slideToggle('slow', function() {
			var $h3 = $(this).closest("li").find("h3");

			$("#faq_con li h3").removeClass("faq_li_open");
			if($(this).is(":visible")) {
				$h3.addClass("faq_li_open");
			}
		});
    });
});

function faq_open(el)
{	
    var $con = $(el).closest("li").find(".con_inner"),
		$h3 = $(el).closest("li").find("h3");

    if($con.is(":visible")) {
        $con.slideUp();
		$h3.removeClass("faq_li_open");
    } else {
        $("#faq_con .con_inner:visible").css("display", "none");

        $con.slideDown(
            function() {
                // 이미지 리사이즈
                $con.viewimageresize2();
				$("#faq_con li h3").removeClass("faq_li_open");

				$h3.addClass("faq_li_open");
            }
        );
    }

    return false;
}
</script>