<?php

// 공지(활성/비활성) 롤오버배너 게시물20250130
function latest_rollbanner($skin_dir='', $bo_table, $rows=10, $subject_len=40, $cache_time=1, $category_name='', $options='')
{
    global $g5;
    if (!$skin_dir) $skin_dir = 'basic';
    
    // 스킨 경로 설정 (기존 코드 유지)
    if(preg_match('#^theme/(.+)$#', $skin_dir, $match)) {
        if (G5_IS_MOBILE) {
            $latest_skin_path = G5_THEME_MOBILE_PATH.'/'.G5_SKIN_DIR.'/latest/'.$match[1];
            if(!is_dir($latest_skin_path))
                $latest_skin_path = G5_THEME_PATH.'/'.G5_SKIN_DIR.'/latest/'.$match[1];
            $latest_skin_url = str_replace(G5_PATH, G5_URL, $latest_skin_path);
        } else {
            $latest_skin_path = G5_THEME_PATH.'/'.G5_SKIN_DIR.'/latest/'.$match[1];
            $latest_skin_url = str_replace(G5_PATH, G5_URL, $latest_skin_path);
        }
        $skin_dir = $match[1];
    } else {
        if(G5_IS_MOBILE) {
            $latest_skin_path = G5_MOBILE_PATH.'/'.G5_SKIN_DIR.'/latest/'.$skin_dir;
            $latest_skin_url  = G5_MOBILE_URL.'/'.G5_SKIN_DIR.'/latest/'.$skin_dir;
        } else {
            $latest_skin_path = G5_SKIN_PATH.'/latest/'.$skin_dir;
            $latest_skin_url  = G5_SKIN_URL.'/latest/'.$skin_dir;
        }
    }
    
    $list = array();
    
    // 게시판 정보 불러오기
    $board = get_board_db($bo_table, true);
    $tmp_write_table = $g5['write_prefix'] . $bo_table;
    
    $arr_notice = explode(',', trim($board['bo_notice']));
    $board_notice_count = count($arr_notice);
    
    for ($k=0; $k<$board_notice_count; $k++) {
        if (trim($arr_notice[$k]) == '') continue;
        
        // 공지사항 정보 가져오기
        $row = sql_fetch(" select * from g5_write_$bo_table where wr_id = '{$arr_notice[$k]}' ");
        
        $list[$k] = get_list($row, $board, $latest_skin_url, $subject_len);
        
        // 첫 번째 썸네일 이미지 처리
        $thumb_width = 100; // 썸네일 너비
        $thumb_height = 100; // 썸네일 높이
        $thumb = get_list_thumbnail($bo_table, $row['wr_id'], $thumb_width, $thumb_height, false, true);
        
        if ($thumb['src']) {
            $img_content = '<img src="'.$thumb['src'].'" alt="'.$thumb['alt'].'" width="'.$thumb_width.'" height="'.$thumb_height.'">';
            
            // 두 번째 이미지 (롤오버 이미지 처리)
            $second_img = $row['wr_second_image'] ? $row['wr_second_image'] : 'path/to/default/image.jpg'; // 두 번째 이미지가 없으면 기본 이미지로 설정
            
            $list[$k]['img_thumbnail'] = '<a href="'.$list[$k]['href'].'" class="lt_img">
                                              <div class="image-wrapper">
                                                  <img src="'.$thumb['src'].'" alt="'.$thumb['alt'].'">
                                                  <div class="rollover-image">
                                                      <img src="'.$second_img.'" alt="'.$row['wr_subject'].'">
                                                  </div>
                                              </div>
                                          </a>';
        }
    }
    
    // 출력
    ob_start();
    include $latest_skin_path.'/latest.skin.php';
    $content = ob_get_contents();
    ob_end_clean();
    
    return $content;
}

$table_name = 'g5_write_' . $board['bo_table'];
// 필드 추가 함수 정의
function add_column_if_not_exists($table_name, $column_name, $column_definition) {
    $check_column = "SHOW COLUMNS FROM {$table_name} LIKE '{$column_name}'";
    $result = sql_fetch($check_column);
    if (!$result) {
        $alter_query = "ALTER TABLE {$table_name} ADD COLUMN {$column_name} {$column_definition}";
        sql_query($alter_query);
    }
}
