/*!
 * JJ-basic — write.custom.js
 * (c) 2025 JEILJOA — https://jeiljoa.com
 * Free use with attribution. DO NOT REMOVE THIS NOTICE.
 */
(function(){ if(!window.__JJ_BASIC_LICENSE__){
  try { console.warn('JJ-basic: License header missing. (Do not remove) https://jeiljoa.com'); } catch(e){}
}})();

/* write.custom.js : 파일 슬롯 고정 + 모든 열린 슬롯에 −, 맨 아래 슬롯에만 + + 번호배지(버튼 오른쪽) — Safari 호환 + “슬롯키 맵” 우선 적용 */
(function () {
  'use strict';

  var root = document.querySelector('#bo_w.skin-write') || document.querySelector('#bo_w');
  if (!root) return;
  if (root.getAttribute('data-wc-init') === '1') return;
  root.setAttribute('data-wc-init', '1');

  // ===== 유틸 =====
  function $(sel, ctx){ return (ctx||document).querySelector(sel); }
  function $all(sel, ctx){ return Array.prototype.slice.call((ctx||document).querySelectorAll(sel)); }
  function isImg(ext){ return ['jpg','jpeg','png','gif','webp','bmp','svg'].indexOf(String(ext||'').toLowerCase()) !== -1; }
  function setThumbVisible(row, visible){
    var img = row.querySelector('.file-thumb');
    if (!img) return;
    if (visible){ img.style.display = 'inline-block'; }
    else { img.removeAttribute('src'); img.style.display = 'none'; }
  }
  function isUsed(row){ return row.dataset.hasFile === '1' || row.classList.contains('is-old'); }
  function isOpen(row){ return !row.classList.contains('is-collapsed'); }
  function safeRemove(el){ if (el && el.parentNode) el.parentNode.removeChild(el); }
  function clearIdxBadges(row){ var badges = $all('.file-idx-badge', row); for (var i=0; i<badges.length; i++) safeRemove(badges[i]); }

  // ===== 템플릿 안전 생성기 (Safari 호환) =====
  function createFromTemplate(tplId){
    var tpl = document.getElementById(tplId);
    if (!tpl) return null;
    if ('content' in tpl && tpl.content){
      var frag = tpl.content;
      var first = frag && frag.firstElementChild ? frag.firstElementChild : null;
      if (first) return document.importNode(first, true);
      var tmp = document.createElement('div');
      tmp.appendChild(document.importNode(frag, true));
      return tmp.firstElementChild;
    }
    var temp = document.createElement('div');
    temp.innerHTML = tpl.innerHTML.trim();
    return temp.firstElementChild;
  }

  // ===== 링크(그대로) =====
  (function initLinks(){
    var linkSection = $('#linkSection'); if (!linkSection) return;
    var linkRows = $('#linkRows');
    var maxLinks = parseInt(linkSection.getAttribute('data-max')||'2',10);
    var hasExisting = linkRows && linkRows.children.length > 0;

    function renumber(){
      $all('input[type="text"]', linkRows).forEach(function(inp, idx){
        inp.name = 'wr_link' + (idx+1);
      });
    }

    function addLinkRow(value, canDelete, afterNode){
      if (linkRows.children.length >= maxLinks) return;
      var row = createFromTemplate('tpl-link-row');
      if (!row) return;

      var input = row.querySelector('input[type="text"]');
      if (input){
        input.name = 'wr_link' + (linkRows.children.length + 1);
        if (typeof value === 'string') input.value = value;
      }

      var btnAdd = row.querySelector('.btnAddLinkRow');
      var btnDel = row.querySelector('.btnDelLinkRow');

      if (btnAdd) btnAdd.addEventListener('click', function(){ addLinkRow('', true, row); });
      if (btnDel) btnDel.addEventListener('click', function(){
        if (!canDelete && linkRows.children.length<=1) return;
        if (linkRows.children.length<=1) return;
        linkRows.removeChild(row);
        renumber();
      });

      if (!canDelete && btnDel){
        btnDel.disabled = true; btnDel.setAttribute('title','기본 행은 삭제 불가');
      }

      if (afterNode && afterNode.parentNode === linkRows) afterNode.insertAdjacentElement('afterend', row);
      else linkRows.appendChild(row);
    }

    if (!hasExisting) {
      var initVals = Array.isArray(window.__WRITE_LINK_VALUES) ? window.__WRITE_LINK_VALUES : [];
      if (initVals.length){
        initVals.forEach(function(v, i){ addLinkRow(v, i>0); });
      } else {
        addLinkRow('', false);
      }
    }
  })();

  // ===== 파일 섹션 =====
  (function initFiles(){
    var fileSection = $('#fileSection'); if (!fileSection) return;
    var fileRowsBox = $('#fileRows');
    var maxFiles = parseInt(fileSection.getAttribute('data-max')||'0',10);
    if (!maxFiles) return;

    // 1) 서버가 내려준 “슬롯→데이터” 맵(1-base 문자열 키) 최우선 사용
    var bySlot = (typeof window.__WRITE_OLD_BY_SLOT === 'object' && window.__WRITE_OLD_BY_SLOT) ? window.__WRITE_OLD_BY_SLOT : null;

    // 2) 호환용 배열(있다면 보조 맵 구성)
    var oldList = Array.isArray(window.__WRITE_OLD_FILES) ? window.__WRITE_OLD_FILES : [];
    var oldMapFallback = {};
    if (!bySlot && oldList.length){
      for (var oi=0; oi<oldList.length; oi++){
        var o = oldList[oi];
        var s1 = null;
        if (o != null && typeof o.slot0 !== 'undefined' && o.slot0 !== null && !isNaN(parseInt(o.slot0,10))) {
          s1 = parseInt(o.slot0,10) + 1;
        } else if (o != null && typeof o.index !== 'undefined' && o.index !== null && !isNaN(parseInt(o.index,10))) {
          s1 = parseInt(o.index,10) + 1;
        }
        if (s1 != null) oldMapFallback[String(s1)] = o;
      }
    }

    var rows = [];
    for (var i=1;i<=maxFiles;i++){
      var node = createFromTemplate('tpl-file-row');
      if (!node) break;
      node.dataset.slot = String(i);
      node.classList.add('is-collapsed'); // 기본 접힘

      bindFileRow(node, { slot:i });

      var data = bySlot ? bySlot[String(i)] : oldMapFallback[String(i)];
      if (data){
        applyOld(node, data);
        node.classList.remove('is-collapsed'); // 사용 슬롯은 열린 상태
      }

      fileRowsBox.appendChild(node);
      rows.push(node);
    }

    // 초기 오픈: 사용 슬롯 + 가장 앞의 미사용 1칸 (신규는 1번만)
    var hasOld = !!(bySlot ? Object.keys(bySlot).length : Object.keys(oldMapFallback).length);
    if (hasOld){
      for (var j=1;j<=maxFiles;j++){
        var key = String(j);
        var used = bySlot ? !!bySlot[key] : !!oldMapFallback[key];
        if (!used && rows[j-1]) { rows[j-1].classList.remove('is-collapsed'); break; }
      }
    } else if (rows[0]) {
      rows[0].classList.remove('is-collapsed');
    }

    updateUI();

    // ===== 내부 함수 =====
    function bindFileRow(row, opts){
      var slot    = parseInt(opts.slot,10);
      var inpFile = row.querySelector('input[type="file"]');
      var btnPick = row.querySelector('.btnPickFile');
      var inpDesc = row.querySelector('input[name="bf_content[]"]');
      var thumb   = row.querySelector('.file-thumb');
      var delWrap = row.querySelector('.file-del-wrap');
      var delCb   = row.querySelector('.bf_file_del_cb');
      var btnAdd  = row.querySelector('.btnAddFileRow');
      var btnDel  = row.querySelector('.btnDelFileRow');
      var oldName = row.querySelector('.old-file-name');
      var badgeOld= row.querySelector('.badge-old');

      // 버튼 래퍼 보정
      (function ensurePickWrap(){
        if (!btnPick) return;
        var parent = btnPick.parentElement;
        if (!parent || !parent.classList || !parent.classList.contains('pick-wrap')){
          var wrap = document.createElement('span');
          wrap.className = 'pick-wrap';
          btnPick.parentNode.insertBefore(wrap, btnPick);
          wrap.appendChild(btnPick);
        }
      })();

      if (btnPick) btnPick.addEventListener('click', function(){ if (inpFile) inpFile.click(); });

      if (btnAdd) btnAdd.addEventListener('click', function(){
        for (var k=1;k<=maxFiles;k++){
          var r = rows[k-1];
          if (r && !isOpen(r)){
            r.classList.remove('is-collapsed');
            break;
          }
        }
        updateUI();
      });

      if (btnDel) btnDel.addEventListener('click', function(){
        var used = isUsed(row);
        var hasNewFile = inpFile && inpFile.files && inpFile.files.length > 0;
        var isOldFile  = row.classList.contains('is-old');

        var canCollapse = (slot !== 1);

        if (used){
          var fname = '';
          if (isOldFile){
            fname = (oldName && oldName.textContent ? oldName.textContent.trim() : '');
          } else if (hasNewFile){
            fname = inpFile.files[0].name;
          }
          if (!confirm((fname ? '"' + fname + '" ' : '') + '파일을 삭제하시겠습니까?')) return;

          if (isOldFile){
            if (delCb) delCb.checked = true;
            row.classList.remove('is-old');
            setThumbVisible(row,false);
            if (oldName){ oldName.textContent = '삭제 예정'; oldName.style.display='inline'; }
            if (badgeOld){ badgeOld.textContent = 'to delete'; badgeOld.style.display='inline-block'; }
            row.dataset.hasFile = '0';
          } else if (hasNewFile){
            inpFile.value = '';
            setThumbVisible(row,false);
            if (oldName){ oldName.style.display='none'; oldName.textContent=''; }
            if (badgeOld){ badgeOld.style.display='none'; }
            row.dataset.hasFile = '0';
          }

          if (canCollapse) row.classList.add('is-collapsed');
          updateUI();
          return;
        }

        if (canCollapse){
          row.classList.add('is-collapsed');
          if (inpDesc) inpDesc.value = '';
          setThumbVisible(row,false);
          if (oldName){ oldName.style.display='none'; oldName.textContent=''; }
          row.dataset.hasFile = '0';
          updateUI();
        }
      });

      if (inpFile) inpFile.addEventListener('change', function(){
        var f = inpFile.files && inpFile.files[0] ? inpFile.files[0] : null;
        if (!f){
          row.dataset.hasFile = '0';
          setThumbVisible(row, false);
          if (oldName){ oldName.style.display='none'; oldName.textContent=''; }
          if (badgeOld){ badgeOld.style.display='none'; }
          if (btnPick) btnPick.textContent = '첨부';
          updateUI();
          return;
        }
        row.dataset.hasFile = '1';

        var ext = (f.name.split('.').pop()||'').toLowerCase();
        if (isImg(ext)){
          var fr = new FileReader();
          fr.onload = function(ev){
            if (thumb){
              thumb.src = ev.target.result;
              setThumbVisible(row, true);
            }
          };
          fr.readAsDataURL(f);
        } else {
          setThumbVisible(row, false);
        }

        if (oldName){ oldName.textContent = f.name; oldName.style.display = 'inline'; }
        if (badgeOld){ badgeOld.textContent = 'selected'; badgeOld.style.display = 'inline-block'; }

        if (inpDesc && !inpDesc.value.trim()){
          inpDesc.value = f.name.replace(/\.[^/.]+$/, '');
          inpDesc.classList.add('file-name-dim');
        }
        if (btnPick) btnPick.textContent = '변경';

        updateUI();
      });

      if (inpDesc) inpDesc.addEventListener('input', function(){
        if (inpDesc.value.trim().length) inpDesc.classList.remove('file-name-dim');
      });

      if (delWrap) delWrap.style.display = 'none';
      if (delCb)   delCb.name = 'bf_file_del[' + String(slot-1) + ']';
      row.dataset.hasFile = '0';
    }

    function applyOld(row, o){
      var thumb   = row.querySelector('.file-thumb');
      var inpDesc = row.querySelector('input[name="bf_content[]"]');
      var oldName = row.querySelector('.old-file-name');
      var badgeOld= row.querySelector('.badge-old');
      var delWrap = row.querySelector('.file-del-wrap');
      var btnPick = row.querySelector('.btnPickFile');

      if (o && typeof o.desc === 'string' && o.desc.length && inpDesc) inpDesc.value = o.desc;

      var hasThumb = !!(o && o.url && o.ext && isImg(o.ext));
      if (hasThumb && thumb){ thumb.src = o.url; }
      setThumbVisible(row, hasThumb);

      var sizeTxt = (o && o.size) ? (' ('+o.size+')') : '';
      var label   = (o && o.source) ? o.source : '파일 보기';
      if (oldName && o && o.url){
        oldName.innerHTML = '<a href="'+o.url+'" target="_blank" rel="noopener">'+label+'</a>'+sizeTxt;
        oldName.style.display = 'inline';
      }

      if (badgeOld){ badgeOld.textContent = 'uploaded'; badgeOld.style.display = 'inline-block'; }

      if (delWrap) delWrap.style.display = '';
      row.classList.add('is-old');
      row.dataset.hasFile = '1';
      if (btnPick) btnPick.textContent = '변경';
    }

    function updateUI(){
      for (var rIdx=0; rIdx<rows.length; rIdx++){
        var r = rows[rIdx];
        var slotNo = parseInt(r.dataset.slot,10);
        var btnAdd = r.querySelector('.btnAddFileRow');
        var btnDel = r.querySelector('.btnDelFileRow');
        var btnPick= r.querySelector('.btnPickFile');
        var wrap   = btnPick ? btnPick.parentElement : null;

        if (isUsed(r)) r.classList.remove('is-empty'); else r.classList.add('is-empty');

        clearIdxBadges(r);
        if (wrap && wrap.classList && wrap.classList.contains('pick-wrap')){
          var badge = document.createElement('span');
          badge.className = 'file-idx-badge';
          badge.textContent = String(slotNo);
          wrap.appendChild(badge);
        }

        if (btnAdd){ btnAdd.style.display = 'none'; btnAdd.disabled = false; }
        if (btnDel){ btnDel.style.display = 'none'; btnDel.disabled = false; }
      }

      var openRows = rows.filter(isOpen);
      if (!openRows.length && rows[0]){
        rows[0].classList.remove('is-collapsed');
        openRows = rows.filter(isOpen);
      }

      for (var i1=0; i1<openRows.length; i1++){
        var rr = openRows[i1];
        var slot = parseInt(rr.dataset.slot,10);
        var btnDelR = rr.querySelector('.btnDelFileRow');
        if (btnDelR){
          btnDelR.style.display = 'inline-flex';
          if (slot === 1 && !isUsed(rr)) btnDelR.disabled = true;
        }
      }

      var lastOpen = openRows[openRows.length-1];
      if (lastOpen){
        var addBtn = lastOpen.querySelector('.btnAddFileRow');
        if (addBtn){
          addBtn.style.display = 'inline-flex';
          var hasClosed = rows.some(function(rr){ return !isOpen(rr); });
          if (!hasClosed) addBtn.disabled = true;
        }
      }
    }

    // 제출 직전 ALT 자동 채움
    var frm = $('#fwrite');
    if (frm){
      frm.addEventListener('submit', function(){
        for (var i2=0; i2<rows.length; i2++){
          var row = rows[i2];
          var f = row.querySelector('input[type="file"]');
          var d = row.querySelector('input[name="bf_content[]"]');
          if (f && f.files && f.files[0] && d && !d.value.trim()){
            d.value = f.files[0].name.replace(/\.[^/.]+$/, '');
          }
        }
      });
    }
  })();

  // ===== 캡챠 접근성(변경 없음) =====
  (function adjustCaptchaA11y(){
    var capRoot = document.querySelector('#bo_w #captcha, #bo_w fieldset.captcha, #bo_w .captcha');
    if(!capRoot) return;

    var btns = capRoot.querySelectorAll('button, .btn_frmline, a');
    for (var i=0; i<btns.length; i++){
      var btn = btns[i];
      for (var j=0; j<btn.childNodes.length; j++){
        var n = btn.childNodes[j];
        if(n.nodeType === 3 && n.nodeValue.trim().length){
          var s = document.createElement('span');
          s.className = 'sr-only';
          s.textContent = n.nodeValue;
          btn.replaceChild(s, n);
        }
      }
      var hasIcon = btn.querySelector('i, svg');
      if (hasIcon){
        var spans = btn.querySelectorAll('span');
        for (var k=0; k<spans.length; k++){
          var sp = spans[k];
          if(sp.textContent && sp.textContent.trim().length && !sp.classList.contains('sr-only')){
            sp.classList.add('sr-only');
          }
        }
      }
    }

    var info = document.querySelector('#bo_w #captcha_info');
    if (info) {
      info.classList.add('sr-only');
      var key = capRoot.querySelector('#captcha_key, input[name="captcha_key"]');
      if (key) {
        var id = info.id || 'captcha_info';
        info.id = id;
        var prev = key.getAttribute('aria-describedby');
        key.setAttribute('aria-describedby', prev ? (prev + ' ' + id) : id);
      }
    }
  })();

})();