<?php
/*
 * JJ-basic — 그누보드 기본 디자인 + 파일 슬롯/번호 보존
 * Folder: /skin/board/jj_basic
 * Copyright (c) 2025 JEILJOA — https://jeiljoa.com
 * License: Free to use (personal & commercial)
 * Conditions:
 *   - 본 주석과 하단 HTML 라이선스 표기는 "절대 삭제 금지"
 *   - 수정/재배포 시 출처(jeiljoa.com) 명시 필수
 *   - 재판매/유료 재배포 금지
 */
// ------------------------------------------------------------
// 기본 스킨 및 커스텀 CSS/JS 로드(버전쿼리로 캐시 무효화)
// ------------------------------------------------------------
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css?ver=25.08.31">', 0);
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/write.custom.css?ver=25.08.31">', 0);
// Font Awesome (아이콘)
echo '<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">';
// 커스텀 JS (defer)  ※ 캐시 회피 위해 버전 한번 올려도 좋아요
add_javascript('<script src="'.$board_skin_url.'/write.custom.js?ver=2025-08-30-3" defer></script>', 1);

/* ===== 준비 ===== */
$__can_file  = (isset($is_file) && $is_file);
$__max_files = isset($file_count) ? (int)$file_count : 0;

$__old_files = array();
if ($w === 'u' && !empty($file) && is_array($file)) {
    foreach ($file as $idx => $frow) {
        if (!empty($frow['file'])) {
            $__old_files[] = $frow + ['__idx' => $idx];
        }
    }
}
$__has_old_files = count($__old_files) > 0;

$__can_link  = (isset($is_link) && $is_link);
$__max_links = defined('G5_LINK_COUNT') ? (int) G5_LINK_COUNT : 2;

/* ▶ 파일설명 사용 여부(보드 설정)
 - PC: 항상 ALT 노출
 - 모바일: bo_use_file_content = 0(사용안함)일 때 ALT 숨김 */
$__use_file_desc = isset($board['bo_use_file_content']) ? (int) $board['bo_use_file_content'] : 1;

/* 옵션 원형 유지 */
$option = '';
$option_hidden = '';
if ($is_notice || $is_html || $is_secret || $is_mail) {
    if ($is_notice) {
        $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="notice" name="notice" class="selec_chk" value="1" '.$notice_checked.'><label for="notice"><span></span>공지</label></li>';
    }
    if ($is_html) {
        if ($is_dhtml_editor) {
            $option_hidden .= '<input type="hidden" value="html1" name="html">';
        } else {
            $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="html" name="html" onclick="html_auto_br(this);" class="selec_chk" value="'.$html_value.'" '.$html_checked.'><label for="html"><span></span>html</label></li>';
        }
    }
    if ($is_secret) {
        if ($is_admin || $is_secret == 1) {
            $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="secret" name="secret" class="selec_chk" value="secret" '.$secret_checked.'><label for="secret"><span></span>비밀글</label></li>';
        } else {
            $option_hidden .= '<input type="hidden" name="secret" value="secret">';
        }
    }
    if ($is_mail) {
        $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="mail" name="mail" class="selec_chk" value="mail" '.$recv_email_checked.'><label for="mail"><span></span>답변메일받기</label></li>';
    }
}
echo $option_hidden;
?>

<section id="bo_w" class="skin-write">
  <h2 class="sound_only"><?php echo $g5['title'] ?></h2>

  <!-- 게시물 작성/수정 시작 { -->
  <form
    name="fwrite"
    id="fwrite"
    action="<?php echo $action_url ?>"
    onsubmit="return fwrite_submit(this);"
    method="post"
    enctype="multipart/form-data"
    autocomplete="off"
    style="width:<?php echo $width; ?>"
  >
    <input type="hidden" name="uid" value="<?php echo get_uniqid(); ?>">
    <input type="hidden" name="w" value="<?php echo $w ?>">
    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
    <input type="hidden" name="wr_id" value="<?php echo $wr_id ?>">
    <input type="hidden" name="sca" value="<?php echo $sca ?>">
    <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
    <input type="hidden" name="stx" value="<?php echo $stx ?>">
    <input type="hidden" name="spt" value="<?php echo $spt ?>">
    <input type="hidden" name="sst" value="<?php echo $sst ?>">
    <input type="hidden" name="sod" value="<?php echo $sod ?>">
    <input type="hidden" name="page" value="<?php echo $page ?>">

    <?php
    $option = '';
    $option_hidden = '';
    if ($is_notice || $is_html || $is_secret || $is_mail) {
        $option = '';
        if ($is_notice) {
            $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="notice" name="notice" class="selec_chk" value="1" '.$notice_checked.'>'.PHP_EOL.'<label for="notice"><span></span>공지</label></li>';
        }
        if ($is_html) {
            if ($is_dhtml_editor) {
                $option_hidden .= '<input type="hidden" value="html1" name="html">';
            } else {
                $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="html" name="html" onclick="html_auto_br(this);" class="selec_chk" value="'.$html_value.'" '.$html_checked.'>'.PHP_EOL.'<label for="html"><span></span>html</label></li>';
            }
        }
        if ($is_secret) {
            if ($is_admin || $is_secret == 1) {
                $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="secret" name="secret" class="selec_chk" value="secret" '.$secret_checked.'>'.PHP_EOL.'<label for="secret"><span></span>비밀글</label></li>';
            } else {
                $option_hidden .= '<input type="hidden" name="secret" value="secret">';
            }
        }
        if ($is_mail) {
            $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="mail" name="mail" class="selec_chk" value="mail" '.$recv_email_checked.'>'.PHP_EOL.'<label for="mail"><span></span>답변메일받기</label></li>';
        }
    }
    echo $option_hidden;
    ?>

    <?php if ($is_category) { ?>
      <div class="bo_w_select write_div">
        <label for="ca_name" class="sound_only">분류<strong>필수</strong></label>
        <select name="ca_name" id="ca_name" required>
          <option value="">분류를 선택하세요</option>
          <?php echo $category_option ?>
        </select>
      </div>
    <?php } ?>

    <div class="bo_w_info write_div">
      <?php if ($is_name) { ?>
        <label for="wr_name" class="sound_only">이름<strong>필수</strong></label>
        <input
          type="text"
          name="wr_name"
          value="<?php echo $name ?>"
          id="wr_name"
          required
          class="frm_input half_input required"
          placeholder="이름"
        >
      <?php } ?>

      <?php if ($is_password) { ?>
        <label for="wr_password" class="sound_only">비밀번호<strong>필수</strong></label>
        <input
          type="password"
          name="wr_password"
          id="wr_password"
          <?php echo $password_required ?>
          class="frm_input half_input <?php echo $password_required ?>"
          placeholder="비밀번호"
        >
      <?php } ?>

      <?php if ($is_email) { ?>
        <label for="wr_email" class="sound_only">이메일</label>
        <input
          type="text"
          name="wr_email"
          value="<?php echo $email ?>"
          id="wr_email"
          class="frm_input half_input email"
          placeholder="이메일"
        >
      <?php } ?>

      <?php if ($is_homepage) { ?>
        <label for="wr_homepage" class="sound_only">홈페이지</label>
        <input
          type="text"
          name="wr_homepage"
          value="<?php echo $homepage ?>"
          id="wr_homepage"
          class="frm_input half_input"
          size="50"
          placeholder="홈페이지"
        >
      <?php } ?>
    </div>

    <?php if ($option) { ?>
      <div class="write_div">
        <span class="sound_only">옵션</span>
        <ul class="bo_v_option">
          <?php echo $option ?>
        </ul>
      </div>
    <?php } ?>

    <div class="bo_w_tit write_div">
      <label for="wr_subject" class="sound_only">제목<strong>필수</strong></label>
      <div id="autosave_wrapper" class="write_div">
        <input
          type="text"
          name="wr_subject"
          value="<?php echo $subject ?>"
          id="wr_subject"
          required
          class="frm_input full_input required"
          size="50"
          maxlength="255"
          placeholder="제목"
        >
        <?php if ($is_member) { // 임시 저장된 글 기능 ?>
          <script src="<?php echo G5_JS_URL; ?>/autosave.js"></script>
          <?php if ($editor_content_js) echo $editor_content_js; ?>
          <button type="button" id="btn_autosave" class="btn_frmline">
            임시 저장된 글 (<span id="autosave_count"><?php echo $autosave_count; ?></span>)
          </button>
          <div id="autosave_pop">
            <strong>임시 저장된 글 목록</strong>
            <ul></ul>
            <div><button type="button" class="autosave_close">닫기</button></div>
          </div>
        <?php } ?>
      </div>
    </div>

    <div class="write_div">
      <label for="wr_content" class="sound_only">내용<strong>필수</strong></label>
      <div class="wr_content <?php echo $is_dhtml_editor ? $config['cf_editor'] : ''; ?>">
        <?php if ($write_min || $write_max) { ?>
          <p id="char_count_desc">
            이 게시판은 최소 <strong><?php echo $write_min; ?></strong>글자 이상,
            최대 <strong><?php echo $write_max; ?></strong>글자 이하까지 글을 쓰실 수 있습니다.
          </p>
        <?php } ?>

        <?php echo $editor_html; // 에디터 사용시는 에디터로, 아니면 textarea 로 노출 ?>

        <?php if ($write_min || $write_max) { ?>
          <div id="char_count_wrap"><span id="char_count"></span>글자</div>
        <?php } ?>
      </div>
    </div>

    <?php if ($__can_link) { ?>
      <div class="bo_w_links write_div" id="linkSection" data-max="<?php echo $__max_links; ?>">
        <div class="link-rows" id="linkRows"></div>
      </div>
    <?php } ?>

    <?php if ($__can_file && ($__max_files > 0 || $__has_old_files)) { ?>
      <div
        class="bo_w_files write_div"
        id="fileSection"
        data-max="<?php echo max($__max_files, count($__old_files)); ?>"
        data-upload-max="<?php echo $upload_max_filesize; ?>"
        data-use-desc="<?php echo $__use_file_desc; ?>"
      >
        <div class="file-rows" id="fileRows"></div>
      </div>
    <?php } ?>

    <?php if ($is_use_captcha) { ?>
      <div class="write_div"><?php echo $captcha_html ?></div>
    <?php } ?>

    <div class="btn_confirm write_div">
      <a href="<?php echo get_pretty_url($bo_table); ?>" class="btn_cancel btn">취소</a>
      <button type="submit" id="btn_submit" accesskey="s" class="btn_submit btn">작성완료</button>
    </div>
  </form>

  <!-- 템플릿: 링크 -->
  <template id="tpl-link-row">
    <div class="link-row">
      <div class="icon-input icon-link">
        <i class="fa-solid fa-link icon-left" aria-hidden="true"></i>
        <input type="text" name="__WR_LINK_NAME__" class="frm_input with-icon" placeholder="링크 URL">
      </div>
      <div class="col-act">
        <button type="button" class="icon-btn btnAddLinkRow" title="링크 추가" aria-label="링크 추가">
          <i class="fa-solid fa-plus"></i>
        </button>
        <button type="button" class="icon-btn btnDelLinkRow" title="링크 삭제" aria-label="링크 삭제">
          <i class="fa-solid fa-minus"></i>
        </button>
      </div>
    </div>
  </template>

  <!-- 템플릿: 파일 -->
  <template id="tpl-file-row">
    <div class="file-row">
      <div class="cell-file">
        <input type="file" name="bf_file[]" class="frm_file file-input-hidden" aria-hidden="true">
        <span class="pick-wrap"><button type="button" class="pick-btn btnPickFile">첨부</button></span>
        <img class="file-thumb" alt="">
        <span class="old-file-name" style="display:none;"></span>

        <!-- 삭제 체크박스: 파일명 바로 오른쪽 -->
        <label class="file-del-wrap" style="display:none;" title="기존 파일 삭제">
          <input type="checkbox" class="bf_file_del_cb" name="" value="1" aria-label="기존 파일 삭제">
        </label>

        <span class="badge-old" style="display:none;">uploaded</span>
      </div>

      <div class="cell-alt" style="width:100%;">
        <div class="icon-input icon-folder" style="width:100%;">
          <i class="fa-regular fa-folder-open icon-left" aria-hidden="true"></i>
          <input
            type="text"
            name="bf_content[]"
            class="frm_input with-icon"
            placeholder="파일 설명(이미지 alt). 미입력 시 파일명으로 자동 지정"
          >
        </div>
      </div>

      <div class="cell-action">
        <button type="button" class="icon-btn btnAddFileRow" title="파일 행 추가" aria-label="파일 행 추가">
          <i class="fa-solid fa-plus"></i>
        </button>
        <button type="button" class="icon-btn btnDelFileRow" title="파일 행 삭제" aria-label="파일 행 삭제">
          <i class="fa-solid fa-minus"></i>
        </button>
      </div>
    </div>
  </template>

  <?php
  /* ====== (핵심) 기존 파일 정보를 “슬롯 번호로 키” 잡아 JS로 전달 ======
     - __WRITE_OLD_BY_SLOT : {"1": {...}, "2": {...}} 형식 (키는 1-base 문자열)
     - __WRITE_OLD_FILES   : 호환용 배열(기존 로직 유지 필요 시) */
  $__old_by_slot_js = array(); // 슬롯→데이터(1-base 키)
  $__old_files_js   = array(); // 호환용 배열

  if ($w === 'u' && $__has_old_files) {

      // bf_no(실제 슬롯, 0-base)를 안전 취득 (파일명 기준 매핑)
      $slot_map = array();
      $sql = " select bf_no, bf_file
               from {$g5['board_file_table']}
               where bo_table = '{$bo_table}'
                 and wr_id    = '{$wr_id}'
                 and bf_file <> ''
               order by bf_no asc ";
      $res = sql_query($sql);
      while ($row = sql_fetch_array($res)) {
          $slot_map[$row['bf_file']] = (int) $row['bf_no']; // 0-base
      }

      foreach ($__old_files as $i => $fr) {
          $enc  = $fr['file']; // 저장 파일명(암호화)
          $ext  = strtolower(pathinfo($enc, PATHINFO_EXTENSION));
          $url  = G5_DATA_URL.'/file/'.$bo_table.'/'.$enc;
          $src  = isset($fr['source'])     ? $fr['source']     : '';
          $desc = isset($fr['bf_content']) ? $fr['bf_content'] : '';
          $size = isset($fr['size'])       ? $fr['size']       : '';

          // 실제 슬롯(0-base) 결정
          $slot0 = isset($fr['bf_no']) ? (int) $fr['bf_no'] : null;
          if ($slot0 === null && isset($slot_map[$enc])) $slot0 = (int) $slot_map[$enc];
          if ($slot0 === null) $slot0 = (int) $i; // 최후 폴백

          $item = array(
              'old'    => true,
              'slot0'  => $slot0, // 0-base 슬롯(참조용)
              'desc'   => $desc,
              'url'    => $url,
              'ext'    => $ext,
              'source' => $src,
              'size'   => $size
          );

          // ✅ 1-base 문자열 키로 맵 구성 (← 여기 오타가 문제였음)
          $key = (string) ($slot0 + 1);
          $__old_by_slot_js[$key] = $item;

          // 호환용 배열에도 넣어둠
          $__old_files_js[] = $item + array('index' => (int) $i);
      }
  }

  // 링크 값
  $__link_values_js = array();
  if ($w === 'u' && $is_link) {
      for ($i = 1; $i <= G5_LINK_COUNT; $i++) {
          $val = isset($write['wr_link'.$i]) ? trim($write['wr_link'.$i]) : '';
          if ($i === 1 || $val !== '') $__link_values_js[] = $val;
      }
  }
  ?>
  <script>
    window.__WRITE_OLD_BY_SLOT = <?php echo json_encode($__old_by_slot_js, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>;
    window.__WRITE_OLD_FILES   = <?php echo json_encode($__old_files_js,   JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>;
    window.__WRITE_LINK_VALUES = <?php echo json_encode($__link_values_js, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>;
  </script>

  <!-- 글자수/에디터/캡챠/제출 -->
  <script>
    <?php if ($write_min || $write_max) { ?>
      var char_min = parseInt(<?php echo $write_min; ?>),
          char_max = parseInt(<?php echo $write_max; ?>);
      check_byte("wr_content", "char_count");
      $(function () {
        $("#wr_content").on("keyup", function () {
          check_byte("wr_content", "char_count");
        });
      });
    <?php } ?>

    function html_auto_br(obj) {
      if (obj.checked) {
        var result = confirm("자동 줄바꿈을 하시겠습니까?\n\n자동 줄바꿈은 게시물 내용중 줄바뀐 곳을<br>태그로 변환하는 기능입니다.");
        obj.value = result ? "html2" : "html1";
      } else {
        obj.value = "";
      }
    }

    function fwrite_submit(f) {
      <?php echo $editor_js; ?>
      var subject = "", content = "";
      $.ajax({
        url: g5_bbs_url + "/ajax.filter.php",
        type: "POST",
        data: { subject: f.wr_subject.value, content: f.wr_content.value },
        dataType: "json",
        async: false,
        cache: false,
        success: function (d) {
          subject = d.subject;
          content = d.content;
        }
      });

      if (subject) {
        alert("제목에 금지단어('" + subject + "')가 포함되어있습니다");
        f.wr_subject.focus();
        return false;
      }
      if (content) {
        alert("내용에 금지단어('" + content + "')가 포함되어있습니다");
        if (typeof (ed_wr_content) != "undefined") ed_wr_content.returnFalse();
        else f.wr_content.focus();
        return false;
      }

      <?php echo $captcha_js; ?>
      document.getElementById("btn_submit").disabled = "disabled";
      return true;
    }
  </script>
</section>
<!-- } 게시물 작성/수정 끝 -->