<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);

// 커스텀 검색 처리
$custom_search = false;

// 커스텀 검색 조건이 있는지 확인
if ((isset($_GET['year_min']) && $_GET['year_min'] != '') || 
    (isset($_GET['year_max']) && $_GET['year_max'] != '') || 
    (isset($_GET['mileage_min']) && $_GET['mileage_min'] != '') || 
    (isset($_GET['mileage_max']) && $_GET['mileage_max'] != '') || 
    (isset($_GET['car_name']) && $_GET['car_name'] != '')) {
    
    $custom_search = true;
    $search_conditions = array();
    
    // 기본 조건
    $search_conditions[] = "wr_is_comment = 0";
    
    // 분류 조건
    if ($sca) {
        $search_conditions[] = "ca_name = '" . sql_real_escape_string($sca) . "'";
    }
    
    // 연식 검색
    if (isset($_GET['year_min']) && $_GET['year_min'] != '') {
        $year_min = (int)$_GET['year_min'];
        $search_conditions[] = "wr_9 >= '$year_min'";
    }
    
    if (isset($_GET['year_max']) && $_GET['year_max'] != '') {
        $year_max = (int)$_GET['year_max'];
        $search_conditions[] = "wr_9 <= '$year_max'";
    }
    
    // 주행거리 검색
    if (isset($_GET['mileage_min']) && $_GET['mileage_min'] != '') {
        $mileage_min = (int)$_GET['mileage_min'];
        $search_conditions[] = "CAST(wr_7 as UNSIGNED) >= $mileage_min";
    }
    
    if (isset($_GET['mileage_max']) && $_GET['mileage_max'] != '') {
        $mileage_max = (int)$_GET['mileage_max'];
        $search_conditions[] = "CAST(wr_7 as UNSIGNED) <= $mileage_max";
    }
    
    // 차량명 검색
    if (isset($_GET['car_name']) && $_GET['car_name'] != '') {
        $car_name = sql_real_escape_string($_GET['car_name']);
        $search_conditions[] = "(wr_3 LIKE '%$car_name%' OR wr_subject LIKE '%$car_name%')";
    }
    
    // 검색 쿼리 실행
    $search_sql = implode(' AND ', $search_conditions);
    $sql_common = " FROM {$write_table} WHERE {$search_sql} ORDER BY wr_num, wr_reply ";
    $sql = " SELECT COUNT(*) as cnt {$sql_common} ";
    $row = sql_fetch($sql);
    $total_count = $row['cnt'];
    
    if ($total_count > 0) {
        $rows = $config['cf_page_rows'];
        $total_page = ceil($total_count / $rows);
        if ($page < 1) $page = 1;
        if ($page > $total_page) $page = $total_page;
        $from_record = ($page - 1) * $rows;
        
        $sql = " SELECT * {$sql_common} LIMIT {$from_record}, {$rows} ";
        $result = sql_query($sql);
        
        $list = array();
        for ($i=0; $row=sql_fetch_array($result); $i++) {
            $list[$i] = get_list($row, $board, $board_skin_url, G5_IS_MOBILE ? $board['bo_mobile_subject_len'] : $board['bo_subject_len']);
        }
        
        $write_pages = get_paging(G5_IS_MOBILE ? $config['cf_mobile_pages'] : $config['cf_write_pages'], $page, $total_page, get_pretty_url($bo_table, '', $qstr.'&amp;page='));
    } else {
        $list = array();
        $write_pages = '';
    }
}
?>

<style>
/* 기본 검색박스 스타일 */
.car_search_box {
    background: #f8f9fa;
    padding: 15px 20px;
    margin-bottom: 20px;
    border-radius: 8px;
    border: 1px solid #e9ecef;
    display: flex;
    align-items: center;
    flex-wrap: wrap;
    gap: 8px;
}

.search_category {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 10px;
}

.search_category input[type="radio"] {
    margin-right: 5px;
}

.search_category label {
    font-size: 14px;
    margin-right: 15px;
    cursor: pointer;
    color: #333;
}

.search_filters {
    display: flex;
    align-items: center;
    gap: 8px;
    flex-wrap: wrap;
}

.search_filters select, .search_filters input[type="number"], .search_filters input[type="text"] {
    padding: 8px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 13px;
    height: 36px;
}

.search_filters select {
    min-width: 100px;
}

.search_filters input[type="number"] {
    width: 90px;
}

.search_filters input[type="text"] {
    width: 140px;
}

.search_btn, .search_reset {
    height: 36px;
    padding: 8px 16px;
    border-radius: 4px;
    cursor: pointer;
    font-size: 13px;
    border: none;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.search_btn {
    background: #007bff;
    color: white;
}

.search_reset {
    background: #6c757d;
    color: white;
}

/* 차량 아이템 스타일 */
.car_item {
    border: 1px solid #e9ecef;
    border-radius: 8px;
    overflow: hidden;
    margin-bottom: 20px;
    background: white;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    transition: box-shadow 0.3s ease;
    display: flex;
    align-items: flex-start;
    min-height: 180px;
}

.car_item:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.car_image {
    position: relative;
    width: 220px;
    height: 180px;
    overflow: hidden;
    flex-shrink: 0;
}

.car_image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.car_info {
    padding: 0;
    flex: 1;
    display: flex;
    flex-direction: column;
    height: 180px;
    position: relative;
}

.car_main_info {
    flex: 1;
    padding: 20px 20px 80px 20px;
}

.car_title {
    font-size: 18px;
    font-weight: bold;
    margin-bottom: 12px;
    line-height: 1.3;
    color: #2d3436;
}

.car_title a {
    color: #2d3436;
    text-decoration: none;
}

.car_title a:hover {
    color: #6c5ce7;
}

.car_specs {
    font-size: 13px;
    color: #636e72;
    line-height: 1.5;
    margin-bottom: 15px;
}

.car_thumbnails {
    display: flex;
    gap: 5px;
    position: absolute;
    bottom: 15px;
    left: 20px;
    right: 140px;
}

.thumbnail_small {
    width: 60px;
    height: 45px;
    overflow: hidden;
    border: 1px solid #ddd;
    background: #f8f9fa;
    border-radius: 4px;
}

.thumbnail_small img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.car_status_button {
    position: absolute;
    top: 20px;
    right: 20px;
    width: 100px;
    height: 40px;
    border: none;
    border-radius: 4px;
    font-size: 12px;
    font-weight: bold;
    color: white;
    text-align: center;
    display: flex;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    cursor: pointer;
}

.status_selling_btn {
    background: #28a745;
}

.status_sold_btn {
    background: #6c757d;
}

.car_count {
    font-size: 14px;
    color: #74b9ff;
    margin-bottom: 15px;
    padding: 0 5px;
}

/* 모바일 상태 버튼 (이미지 아래 위치) */
.mobile_status_button {
    display: none;
    width: 80px;
    height: 35px;
    border: none;
    border-radius: 4px;
    font-size: 11px;
    font-weight: bold;
    color: white;
    text-align: center;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    cursor: pointer;
    position: absolute;
    bottom: 10px;
    right: 15px;
}

/* PC 버전에서는 오른쪽에만 표시 */
@media (min-width: 769px) {
    .mobile_status_button {
        display: none !important;
    }
    
    .car_status_button {
        display: flex !important;
    }
}

/* 모바일 최적화 스타일 */
@media (max-width: 768px) {
    .car_search_box {
        padding: 15px;
        flex-direction: column;
        align-items: stretch;
        gap: 15px;
    }
    
    .search_category {
        justify-content: center;
        margin-bottom: 0;
        padding-bottom: 15px;
        border-bottom: 1px solid #e9ecef;
    }
    
    .search_filters {
        flex-direction: column;
        gap: 12px;
    }
    
    .search_filters > div {
        width: 100%;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .search_filters select,
    .search_filters input[type="number"],
    .search_filters input[type="text"] {
        flex: 1;
        min-width: 0;
        height: 40px;
        font-size: 14px;
    }
    
    .search_btn, .search_reset {
        height: 32px;
        font-size: 12px;
        margin-top: 5px;
        padding: 6px 12px;
    }
    
    /* 모바일 차량 아이템 레이아웃 */
    .car_item {
        flex-direction: column;
        min-height: auto;
        margin-bottom: 15px;
        position: relative;
    }
    
    .car_image {
        width: 100%;
        height: 200px;
        position: relative;
    }
    
    .car_info {
        height: auto;
        padding: 0;
        position: relative;
    }
    
    /* 모바일에서 PC용 버튼 숨기기 */
    .car_status_button {
        display: none !important;
    }
    
    /* 모바일 전용 버튼 표시 (이미지 아래) */
    .mobile_status_button {
        display: flex !important;
    }
    
    .car_main_info {
        padding: 15px 15px 60px 15px;
    }
    
    .car_title {
        font-size: 16px;
        margin-bottom: 10px;
        line-height: 1.4;
    }
    
    .car_specs {
        font-size: 12px;
        line-height: 1.6;
        margin-bottom: 10px;
    }
    
    .car_thumbnails {
        position: absolute;
        bottom: 10px;
        left: 15px;
        right: 100px;
        gap: 6px;
        justify-content: flex-start;
    }
    
    .thumbnail_small {
        width: 55px;
        height: 40px;
        border-radius: 3px;
    }
    
    /* 모바일 검색 필터 개별 스타일링 */
    .year-range, .mileage-range {
        display: flex;
        align-items: center;
        gap: 8px;
        width: 100%;
    }
    
    .year-range select,
    .mileage-range input {
        flex: 1;
    }
    
    .range-separator {
        color: #666;
        font-size: 14px;
        margin: 0 5px;
    }
}

@media (max-width: 480px) {
    .car_title {
        font-size: 15px;
    }
    
    .car_specs {
        font-size: 11px;
    }
    
    .thumbnail_small {
        width: 45px;
        height: 35px;
    }
    
    .car_main_info {
        padding: 12px 12px 60px 12px;
    }
    
    .car_thumbnails {
        bottom: 8px;
        left: 12px;
        right: 100px;
    }
}
</style>

<div class="container mt-2.5 mb-2.5">
    <div class="row">
        <div class="col-sm-12">
            <!-- 검색 폼 -->
            <div class="car_search_box">
                <form name="fsearch_car" method="get">
                    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
                    
                    <!-- 분류 라디오 버튼 -->
                    <div class="search_category">
                        <input type="radio" id="cat_all" name="sca" value="" 
                               <?php echo (!$sca || $sca == '') ? 'checked' : ''; ?>>
                        <label for="cat_all">전체</label>
                        
                        <input type="radio" id="cat_domestic" name="sca" value="국산" 
                               <?php echo ($sca == '국산') ? 'checked' : ''; ?>>
                        <label for="cat_domestic">국산</label>
                        
                        <input type="radio" id="cat_import" name="sca" value="수입" 
                               <?php echo ($sca == '수입') ? 'checked' : ''; ?>>
                        <label for="cat_import">수입</label>
                    </div>
                    
                    <!-- 검색 필터 -->
                    <div class="search_filters">
                        <!-- 연식 범위 -->
                        <div class="year-range">
                            <select name="year_min">
                                <option value="">연식최소</option>
                                <?php for($year = 1990; $year <= date('Y'); $year++) { 
                                    $selected = (isset($_GET['year_min']) && $_GET['year_min'] == $year) ? 'selected' : '';
                                ?>
                                <option value="<?php echo $year ?>" <?php echo $selected ?>><?php echo $year ?></option>
                                <?php } ?>
                            </select>
                            
                            <span class="range-separator">~</span>
                            
                            <select name="year_max">
                                <option value="">연식최대</option>
                                <?php for($year = 1990; $year <= date('Y'); $year++) { 
                                    $selected = (isset($_GET['year_max']) && $_GET['year_max'] == $year) ? 'selected' : '';
                                ?>
                                <option value="<?php echo $year ?>" <?php echo $selected ?>><?php echo $year ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        
                        <!-- 주행거리 범위 -->
                        <div class="mileage-range">
                            <input type="number" name="mileage_min" value="<?php echo isset($_GET['mileage_min']) ? $_GET['mileage_min'] : '' ?>" placeholder="최소 Km">
                            <span class="range-separator">~</span>
                            <input type="number" name="mileage_max" value="<?php echo isset($_GET['mileage_max']) ? $_GET['mileage_max'] : '' ?>" placeholder="최대 Km">
                        </div>
                        
                        <!-- 차량명 검색 -->
                        <div>
                            <input type="text" name="car_name" value="<?php echo isset($_GET['car_name']) ? htmlspecialchars($_GET['car_name']) : '' ?>" placeholder="차량명 검색">
                        </div>
                        
                        <!-- 검색 버튼 -->
                        <div style="display: flex; gap: 8px;">
                            <button type="submit" class="search_btn">검색</button>
                            <a href="<?php echo G5_BBS_URL; ?>/board.php?bo_table=<?php echo $bo_table; ?>" class="search_reset">초기화</a>
                        </div>
                    </div>
                </form>
            </div>

            <!-- 게시판 목록 시작 -->
            <div id="bo_gall" style="width:<?php echo $width; ?>">
                
                <!-- 게시판 페이지 정보 및 버튼 시작 -->
                <div id="bo_btn_top">
                    <div id="bo_list_total">
                        <span>Total <?php echo number_format($total_count) ?>건</span>
                        <?php echo $page ?> 페이지
                        <?php if ($custom_search) { ?>
                        <span style="color: #e74c3c; margin-left: 10px;">(검색결과)</span>
                        <?php } ?>
                    </div>

                    <?php if ($admin_href || $write_href) { ?>
                    <ul class="btn_bo_user">
                        <?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn_admin btn"><i class="fa fa-cog" aria-hidden="true"></i> 관리자</a></li><?php } ?>
                        <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b02 btn"><i class="fa fa-pencil" aria-hidden="true"></i> 글쓰기</a></li><?php } ?>
                    </ul>
                    <?php } ?>
                </div>

                <form name="fboardlist" id="fboardlist" action="./board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
                <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
                <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
                <input type="hidden" name="stx" value="<?php echo $stx ?>">
                <input type="hidden" name="spt" value="<?php echo $spt ?>">
                <input type="hidden" name="sst" value="<?php echo $sst ?>">
                <input type="hidden" name="sod" value="<?php echo $sod ?>">
                <input type="hidden" name="page" value="<?php echo $page ?>">
                <input type="hidden" name="sw" value="">

                <!-- 차량 개수 표시 -->
                <div class="car_count">
                    총 <?php echo number_format($total_count) ?>대의 차량이 있습니다.
                    <?php if ($custom_search) { ?>
                    <span style="color: #e74c3c;">(검색된 결과)</span>
                    <?php } ?>
                </div>

                <!-- 차량 목록 출력 -->
                <section class="wrapper">
                    <?php if (count($list) > 0) { ?>
                        <?php for ($i=0; $i<count($list); $i++) { ?>
                        <div class="car_item">
                            <!-- 체크박스 (관리자용) -->
                            <?php if ($is_checkbox) { ?>
                            <input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>" style="position:absolute; top:10px; left:10px; z-index:10;">
                            <?php } ?>
                            
                            <!-- 차량 이미지 영역 -->
                            <div class="car_image">
                                <a href="<?php echo $list[$i]['href'] ?>">
                                    <?php
                                    $thumb = get_list_thumbnail($board['bo_table'], $list[$i]['wr_id'], 220, 180, false, true);
                                    if($thumb['src']) {
                                        echo '<img src="'.$thumb['src'].'" alt="'.$thumb['alt'].'">';
                                    } else {
                                        echo '<div style="height:180px; background:#f8f9fa; display:flex; align-items:center; justify-content:center; color:#6c757d; font-size:14px;">이미지 없음</div>';
                                    }
                                    ?>
                                </a>
                            </div>
                            
                            <!-- 차량 정보 영역 -->
                            <div class="car_info">
                                <!-- PC용 판매상태 버튼 (오른쪽 위) -->
                                <div class="car_status_button <?php echo ($list[$i]['wr_2'] == '판매완료') ? 'status_sold_btn' : 'status_selling_btn'; ?>">
                                    <?php echo $list[$i]['wr_2'] ? $list[$i]['wr_2'] : '판매중'; ?>
                                </div>
                                
                                <!-- 모바일용 판매상태 버튼 (아래) -->
                                <div class="mobile_status_button <?php echo ($list[$i]['wr_2'] == '판매완료') ? 'status_sold_btn' : 'status_selling_btn'; ?>">
                                    <?php echo $list[$i]['wr_2'] ? $list[$i]['wr_2'] : '판매중'; ?>
                                </div>
                                
                                <div class="car_main_info">
                                    <div class="car_title">
                                        <a href="<?php echo $list[$i]['href'] ?>">
                                            <?php echo $list[$i]['subject']; ?>
                                            <?php if ($list[$i]['comment_cnt']) { ?>
                                            <span class="cnt_cmt"> [<?php echo $list[$i]['wr_comment']; ?>]</span>
                                            <?php } ?>
                                        </a>
                                    </div>
                                    
                                    <!-- 차량 주요 스펙 정보 -->
                                    <div class="car_specs">
                                        <?php 
                                        $specs = array();
                                        if($list[$i]['wr_9'] && $list[$i]['wr_6']) {
                                            $year_month = $list[$i]['wr_9'];
                                            if($list[$i]['wr_6']) {
                                                $month = date('m', strtotime($list[$i]['wr_6']));
                                                $year_month .= '.' . str_pad($month, 2, '0', STR_PAD_LEFT);
                                            }
                                            $specs[] = $year_month . ' (' . ($list[$i]['wr_9'] ? (date('Y') - $list[$i]['wr_9']) . '년식' : '') . ')';
                                        } elseif($list[$i]['wr_9']) {
                                            $specs[] = $list[$i]['wr_9'] . ' (' . (date('Y') - $list[$i]['wr_9']) . '년식)';
                                        }
                                        
                                        if($list[$i]['wr_7']) {
                                            $specs[] = number_format($list[$i]['wr_7']) . ' Km';
                                        }
                                        
                                        if($list[$i]['wr_10']) {
                                            $specs[] = $list[$i]['wr_10'];
                                        }
                                        
                                        if($list[$i]['wr_12']) {
                                            $specs[] = number_format($list[$i]['wr_12']) . ' cc';
                                        }
                                        
                                        if($list[$i]['wr_8']) {
                                            $specs[] = $list[$i]['wr_8'];
                                        }
                                        
                                        if($list[$i]['wr_11']) {
                                            $specs[] = $list[$i]['wr_11'];
                                        }
                                        
                                        echo implode(' | ', $specs);
                                        ?>
                                    </div>
                                </div>
                                
                                <!-- 썸네일 이미지들 -->
                                <div class="car_thumbnails">
                                    <?php 
                                    // 게시물의 첨부 이미지들을 가져와서 썸네일로 표시
                                    $sql = "SELECT bf_file FROM {$g5['board_file_table']} WHERE bo_table = '{$board['bo_table']}' AND wr_id = '{$list[$i]['wr_id']}' AND bf_type BETWEEN '1' AND '3' ORDER BY bf_no LIMIT 4";
                                    $file_result = sql_query($sql);
                                    
                                    $thumbnail_count = 0;
                                    while($file_row = sql_fetch_array($file_result)) {
                                        if($file_row['bf_file'] && $thumbnail_count < 4) {
                                            $file_path = G5_DATA_PATH.'/file/'.$board['bo_table'].'/'.$file_row['bf_file'];
                                            if(file_exists($file_path)) {
                                                $file_url = G5_DATA_URL.'/file/'.$board['bo_table'].'/'.$file_row['bf_file'];
                                                echo '<div class="thumbnail_small">';
                                                echo '<a href="'.$list[$i]['href'].'">';
                                                echo '<img src="'.$file_url.'" alt="썸네일'.($thumbnail_count+1).'">';
                                                echo '</a>';
                                                echo '</div>';
                                                $thumbnail_count++;
                                            }
                                        }
                                    }
                                    
                                    // 부족한 썸네일은 빈 박스로 채우기 (최대 4개)
                                    for($j = $thumbnail_count; $j < 4; $j++) {
                                        echo '<div class="thumbnail_small">';
                                        echo '<div style="height:100%; background:#f1f2f6;"></div>';
                                        echo '</div>';
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                    <?php } else { ?>
                        <div style="padding: 50px; text-align: center; color: #999;">
                            검색 조건에 맞는 차량이 없습니다.
                        </div>
                    <?php } ?>
                </section>

                <?php if ($list_href || $is_checkbox || $write_href) { ?>
                <div class="bo_fx">
                    <?php if ($is_checkbox) { ?>
                    <ul class="btn_bo_user">
                        <li><input type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value" class="btn btn_b01"></li>
                        <li><input type="button" class="btn btn_b01" value="전체선택" onclick="if (this.value=='전체선택') { all_checked(true); this.value='선택해제'; } else { all_checked(false); this.value='전체선택'; }"></li>
                    </ul>
                    <?php } ?>
                    
                    <ul class="btn_bo_user">
                        <?php if ($list_href) { ?><li><a href="<?php echo $list_href ?>" class="btn_b01 btn">목록</a></li><?php } ?>
                        <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b02 btn">글쓰기</a></li><?php } ?>
                    </ul>
                </div>
                <?php } ?>
                </form>

                <!-- 게시판 검색 -->
                <fieldset id="bo_sch">
                    <form name="fsearch" method="get">
                        <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
                        <input type="hidden" name="sca" value="<?php echo $sca ?>">
                        <input type="hidden" name="sop" value="and">
                        
                        <select name="sfl" id="sfl">
                            <option value="wr_subject"<?php echo get_selected($sfl, 'wr_subject', true); ?>>제목</option>
                            <option value="wr_content"<?php echo get_selected($sfl, 'wr_content'); ?>>내용</option>
                            <option value="wr_subject||wr_content"<?php echo get_selected($sfl, 'wr_subject||wr_content'); ?>>제목+내용</option>
                            <option value="wr_3"<?php echo get_selected($sfl, 'wr_3'); ?>>차량명</option>
                            <option value="wr_1"<?php echo get_selected($sfl, 'wr_1'); ?>>제조사</option>
                            <option value="wr_name,1"<?php echo get_selected($sfl, 'wr_name,1'); ?>>글쓴이</option>
                        </select>
                        
                        <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx" class="sch_input" placeholder="검색어를 입력해주세요">
                        <input type="submit" value="검색" class="sch_btn">
                    </form>
                </fieldset>
            </div>
        </div>
    </div>
</div>

<!-- 페이지네비게이션 -->
<?php echo $write_pages; ?>

<?php if($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;
    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;
    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?"))
            return false;
        f.action = g5_bbs_url+"/board_list_update.php";
    }
    return true;
}
</script>
<?php } ?>