<?php
if (!defined("_GNUBOARD_")) exit;
include_once(G5_LIB_PATH.'/thumbnail.lib.php');
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
?>

<script src="<?php echo G5_JS_URL; ?>/viewimageresize.js"></script>

<style>
.car_detail_wrap {
    background: white;
    border-radius: 0;
    box-shadow: none;
    overflow: visible;
    margin-bottom: 30px;
    border: 1px solid #e9ecef;
}

.car_status_header {
    background: white;
    color: #333;
    padding: 20px 25px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 1px solid #eee;
}

.car_status_header h1 {
    margin: 0;
    font-size: 20px;
    font-weight: bold;
    color: #2d3436;
}

.car_status_badge {
    background: #6c5ce7;
    padding: 6px 15px;
    border-radius: 0;
    font-size: 12px;
    font-weight: bold;
    color: white;
}

.status_sold .car_status_badge {
    background: #636e72;
}

.car_main_info {
    padding: 0;
    border-bottom: none;
}

.car_price_section {
    padding: 20px 25px;
    border-bottom: 1px solid #eee;
    background: #f8f9fa;
}

.car_price {
    font-size: 24px;
    font-weight: bold;
    color: #e17055;
    margin: 0;
}

.car_basic_info {
    padding: 25px;
}

.car_basic_title {
    font-size: 16px;
    font-weight: bold;
    margin-bottom: 15px;
    color: #2d3436;
}

.car_specs_table {
    width: 100%;
    border-collapse: collapse;
    margin: 0;
    font-size: 13px;
}

.car_specs_table th,
.car_specs_table td {
    padding: 10px 12px;
    text-align: left;
    border-bottom: 1px solid #f1f2f6;
    vertical-align: middle;
}

.car_specs_table th {
    background: #f8f9fa;
    font-weight: bold;
    color: #636e72;
    width: 120px;
    font-size: 12px;
}

.car_specs_table td {
    color: #2d3436;
}

.car_images {
    padding: 25px;
    border-bottom: 1px solid #eee;
}

.car_images h3 {
    margin-bottom: 20px;
    font-size: 16px;
    font-weight: bold;
    color: #2d3436;
}

.car_images_layout {
    display: flex;
    gap: 10px;
}

.main_image_container {
    flex: 2;
}

.main_image_box {
    width: 100%;
    height: 400px;
    overflow: hidden;
    border: 1px solid #ddd;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
}

.main_image_box img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center;
    transition: opacity 0.3s ease;
}

.thumbnails_container {
    flex: 1;
}

.thumbnails_grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 5px;
}

.thumbnail_hover {
    width: 100%;
    height: 90px;
    overflow: hidden;
    border: 1px solid #ddd;
    cursor: pointer;
    background: #f8f9fa;
    transition: border-color 0.2s;
}

.thumbnail_hover:hover {
    border-color: #6c5ce7;
}

.thumbnail_hover img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.thumbnail_empty {
    width: 100%;
    height: 90px;
    background: #f5f5f5;
    border: 1px solid #ddd;
}

/* 모바일 반응형 */
@media (max-width: 768px) {
    .car_images_layout {
        flex-direction: column;
    }
    
    .main_image_container {
        order: 1;
        width: 100%;
    }
    
    .main_image_box {
        height: 250px;
    }
    
    .thumbnails_container {
        order: 2;
        width: 100%;
        margin-top: 10px;
    }
    
    .thumbnails_grid {
        grid-template-columns: repeat(3, 1fr);
        grid-template-rows: repeat(2, 1fr);
        gap: 5px;
    }
    
    .thumbnail_hover,
    .thumbnail_empty {
        height: 80px;
    }
}

.additional_info {
    background: #ffeaa7;
    padding: 15px 20px;
    margin: 15px 25px;
    border-radius: 0;
    font-size: 13px;
}

.additional_info h4 {
    margin: 0 0 10px 0;
    font-size: 14px;
    color: #e17055;
    font-weight: bold;
}

.additional_info ul {
    margin: 0;
    padding-left: 18px;
    color: #636e72;
}

.additional_info li {
    margin-bottom: 3px;
}

.car_description {
    padding: 25px;
    border-bottom: 1px solid #eee;
}

.car_description h3 {
    margin-bottom: 20px;
    font-size: 18px;
    font-weight: bold;
}

@media (max-width: 768px) {
    .car_status_header {
        flex-direction: column;
        gap: 10px;
        text-align: center;
    }
    
    .car_price_section, .car_basic_info, .car_images {
        padding: 15px 20px;
    }
    
    .car_specs_table th,
    .car_specs_table td {
        padding: 8px;
        font-size: 12px;
    }
    
    .image_thumbnails {
        justify-content: center;
    }
}
</style>

<div class="container">
    <div class="row">
        <div class="col-sm-12">
            <article id="bo_v" style="width:<?php echo $width; ?>">
                
                <!-- 차량 상태 헤더 -->
                <div class="car_detail_wrap">
                    <div class="car_status_header">
                        <h1><?php echo get_text($view['wr_subject']); ?></h1>
                        <div class="car_status_badge">
                            <?php echo $view['wr_2'] ? $view['wr_2'] : '판매중'; ?>
                        </div>
                    </div>

                    <!-- 가격 정보 -->
                    <div class="car_price_section">
                        <div class="car_price">
                            <?php if($view['wr_17']) { ?>
                                <?php echo number_format($view['wr_17']); ?> 만원
                            <?php } else { ?>
                                가격문의
                            <?php } ?>
                        </div>
                        <div style="margin-top: 10px; font-size: 14px; color: #666;">
                            <?php 
                            $specs = array();
                            if($view['wr_9']) {
                                $specs[] = $view['wr_9'] . '년';
                            }
                            if($view['wr_7']) {
                                $specs[] = number_format($view['wr_7']) . ' Km';
                            }
                            if($view['wr_10']) {
                                $specs[] = $view['wr_10'];
                            }
                            if($view['wr_12']) {
                                $specs[] = number_format($view['wr_12']) . ' cc';
                            }
                            if($view['wr_8']) {
                                $specs[] = $view['wr_8'];
                            }
                            echo implode(' | ', $specs);
                            ?>
                        </div>
                    </div>

                    <?php
                    // 이미지 파일 확인
                    $v_img_count = count($view['file']);
                    if($v_img_count) {
                        $images = array();
                        for ($i=0; $i<$v_img_count; $i++) {
                            if (isset($view['file'][$i]['view']) && $view['file'][$i]['view']) {
                                $images[] = array(
                                    'src' => $view['file'][$i]['path'].'/'.$view['file'][$i]['file'],
                                    'alt' => $view['file'][$i]['bf_content'] ? $view['file'][$i]['bf_content'] : '이미지'.($i+1)
                                );
                            }
                        }
                        
                        if(count($images) > 0) {
                    ?>
                    <!-- 차량 사진 -->
                    <div class="car_images">
                        <div class="car_images_layout">
                            <!-- 메인 이미지 -->
                            <div class="main_image_container">
                                <div id="main_image" class="main_image_box">
                                    <img src="<?php echo $images[0]['src']; ?>" alt="<?php echo $images[0]['alt']; ?>">
                                </div>
                            </div>
                            
                            <!-- 썸네일 이미지들 -->
                            <div class="thumbnails_container">
                                <div class="thumbnails_grid">
                                    <?php 
                                    for($j = 0; $j < 6; $j++) { 
                                        if(isset($images[$j])) {
                                            echo '<div class="thumbnail_hover" onclick="changeMainImage(\''.$images[$j]['src'].'\', \''.$images[$j]['alt'].'\')" onmouseover="changeMainImage(\''.$images[$j]['src'].'\', \''.$images[$j]['alt'].'\')">';
                                            echo '<img src="'.$images[$j]['src'].'" alt="'.$images[$j]['alt'].'">';
                                            echo '</div>';
                                        } else {
                                            echo '<div class="thumbnail_empty"></div>';
                                        }
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php 
                        }
                    } 
                    ?>

                    <!-- 차량 기본정보 -->
                    <div class="car_basic_info">
                        <h3 class="car_basic_title">차량 기본정보</h3>
                        <table class="car_specs_table">
                            <tr>
                                <th>차량명</th>
                                <td><?php echo $view['wr_3'] ? $view['wr_3'] : '-'; ?></td>
                                <th>차대번호</th>
                                <td><?php echo $view['wr_4'] ? $view['wr_4'] : '-'; ?></td>
                            </tr>
                            <tr>
                                <th>등록번호</th>
                                <td><?php echo $view['wr_5'] ? $view['wr_5'] : '-'; ?></td>
                                <th>최초 등록 년월</th>
                                <td><?php echo $view['wr_6'] ? date('Y.m', strtotime($view['wr_6'])) : '-'; ?></td>
                            </tr>
                            <tr>
                                <th>주행거리</th>
                                <td><?php echo $view['wr_7'] ? number_format($view['wr_7']).' Km' : '-'; ?></td>
                                <th>색상</th>
                                <td><?php echo $view['wr_8'] ? $view['wr_8'] : '-'; ?></td>
                            </tr>
                            <tr>
                                <th>연식(연식번호)</th>
                                <td><?php echo $view['wr_9'] ? $view['wr_9'].'년' : '-'; ?></td>
                                <th>연료</th>
                                <td><?php echo $view['wr_10'] ? $view['wr_10'] : '-'; ?></td>
                            </tr>
                            <tr>
                                <th>배기량</th>
                                <td><?php echo $view['wr_12'] ? number_format($view['wr_12']).' CC' : '-'; ?></td>
                                <th>변속기</th>
                                <td><?php echo $view['wr_11'] ? $view['wr_11'] : '-'; ?></td>
                            </tr>
                            <tr>
                                <th>구동방식</th>
                                <td><?php echo $view['wr_13'] ? $view['wr_13'] : '-'; ?></td>
                                <th>정원</th>
                                <td><?php echo $view['wr_14'] ? $view['wr_14'].' 명' : '-'; ?></td>
                            </tr>
                            <tr>
                                <th>사용용도</th>
                                <td><?php echo $view['wr_16'] ? $view['wr_16'] : '-'; ?></td>
                                <?php if($view['wr_15']) { ?>
                                <th>적재량</th>
                                <td><?php echo number_format($view['wr_15']).' kg'; ?></td>
                                <?php } else { ?>
                                <th></th>
                                <td></td>
                                <?php } ?>
                            </tr>
                        </table>
                    </div>

                    <!-- 차량 상세 설명 -->
                    <div class="car_description">
                        <h3>차량 상세설명</h3>
                        <div id="bo_v_con">
                            <?php echo get_view_thumbnail($view['content']); ?>
                        </div>
                    </div>
                </div>

                <!-- 판매자 정보 -->
                <div style="border-top: 1px solid #e9ecef; padding: 20px 0; margin-top: 20px;">
                    <strong>글쓴이:</strong> <?php echo $view['name'] ?>
                    <span style="margin-left: 20px; color: #666;">등록일: <?php echo date("Y-m-d", strtotime($view['wr_datetime'])) ?></span>
                    <span style="margin-left: 20px; color: #666;">조회: <?php echo number_format($view['wr_hit']) ?></span>
                </div>

                <!-- 추천/비추천 -->
                <?php if ($good_href || $nogood_href) { ?>
                <div id="bo_v_act">
                    <?php if ($good_href) { ?>
                    <span class="bo_v_act_gng">
                        <a href="<?php echo $good_href.'&amp;'.$qstr ?>" id="good_button" class="bo_v_good"><i class="fa fa-thumbs-o-up" aria-hidden="true"></i><span class="sound_only">추천</span><strong><?php echo number_format($view['wr_good']) ?></strong></a>
                        <b id="bo_v_act_good"></b>
                    </span>
                    <?php } ?>
                    <?php if ($nogood_href) { ?>
                    <span class="bo_v_act_gng">
                        <a href="<?php echo $nogood_href.'&amp;'.$qstr ?>" id="nogood_button" class="bo_v_nogood"><i class="fa fa-thumbs-o-down" aria-hidden="true"></i><span class="sound_only">비추천</span><strong><?php echo number_format($view['wr_nogood']) ?></strong></a>
                        <b id="bo_v_act_nogood"></b>
                    </span>
                    <?php } ?>
                </div>
                <?php } ?>

                <!-- 공유 -->
                <?php if($scrap_href || $good_href || $nogood_href) { ?>
                <div id="bo_v_share">
                    <?php if ($scrap_href) { ?><a href="<?php echo $scrap_href; ?>" target="_blank" class="btn btn_b03" onclick="win_scrap(this.href); return false;"><i class="fa fa-thumb-tack" aria-hidden="true"></i> 스크랩</a><?php } ?>

                    <?php if($board['bo_use_sns']) { ?>
                    <button type="button" class="btn btn_b03"><i class="fa fa-share-alt" aria-hidden="true"></i> SNS 공유</button>
                    <?php } ?>
                </div>
                <?php } ?>

                <div id="bo_v_top">
                    <!-- 이전글/다음글 네비게이션 -->
                    <?php if ($prev_href || $next_href) { ?>
                    <ul class="bo_v_nb">
                        <?php if ($prev_href) { ?><li><a href="<?php echo $prev_href ?>" class="btn_b01 btn"><i class="fa fa-chevron-up" aria-hidden="true"></i> 이전글</a></li><?php } ?>
                        <?php if ($next_href) { ?><li><a href="<?php echo $next_href ?>" class="btn_b01 btn"><i class="fa fa-chevron-down" aria-hidden="true"></i> 다음글</a></li><?php } ?>
                    </ul>
                    <?php } ?>

                    <!-- 버튼들 - 왼쪽 그룹과 오른쪽 그룹으로 분리 -->
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <!-- 왼쪽 버튼 그룹 (4개) -->
                        <ul class="btn_bo_user" style="margin: 0;">
                            <?php if ($update_href) { ?><li><a href="<?php echo $update_href ?>" class="btn_b01 btn"><i class="fa fa-pencil-square-o" aria-hidden="true"></i> 수정</a></li><?php } ?>
                            <?php if ($delete_href) { ?><li><a href="<?php echo $delete_href ?>" class="btn_b01 btn" onclick="del(this.href); return false;"><i class="fa fa-trash-o" aria-hidden="true"></i> 삭제</a></li><?php } ?>
                            <li><a href="#" class="btn_b01 btn" onclick="alert('복사 기능');"><i class="fa fa-files-o" aria-hidden="true"></i> 복사</a></li>
                            <li><a href="#" class="btn_b01 btn" onclick="alert('이동 기능');"><i class="fa fa-arrows" aria-hidden="true"></i> 이동</a></li>
                        </ul>
                        
                        <!-- 오른쪽 버튼 그룹 (3개) -->
                        <ul class="btn_bo_user" style="margin: 0;">
                            <li><a href="<?php echo $list_href ?>" class="btn_b01 btn"><i class="fa fa-list" aria-hidden="true"></i> 목록</a></li>
                            <?php if ($reply_href) { ?><li><a href="<?php echo $reply_href ?>" class="btn_b01 btn"><i class="fa fa-reply" aria-hidden="true"></i> 답변</a></li><?php } ?>
                            <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b02 btn"><i class="fa fa-pencil" aria-hidden="true"></i> 글쓰기</a></li><?php } ?>
                        </ul>
                    </div>
                </div>

                <?php
                // 코멘트 입출력
                include_once(G5_BBS_PATH.'/view_comment.php');
                ?>

            </article>
        </div>
    </div>
</div>

<script>
// 메인 이미지 변경 함수
function changeMainImage(src, alt) {
    var mainImageBox = document.getElementById('main_image');
    mainImageBox.innerHTML = '<img src="' + src + '" alt="' + alt + '">';
}

$(function() {
    // 이미지 클릭 시 큰 이미지로 보기
    $("a.view_image").click(function() {
        window.open(this.href, "large_image", "location=yes,links=no,toolbar=no,top=10,left=10,width=10,height=10,resizable=yes,scrollbars=no,status=no");
        return false;
    });

    // 추천/비추천 버튼
    $("#good_button, #nogood_button").click(function() {
        var $tx;
        if(this.id == "good_button")
            $tx = $("#bo_v_act_good");
        else
            $tx = $("#bo_v_act_nogood");

        excute_good(this.href, $(this), $tx);
        return false;
    });

    // 이미지 리사이즈
    $("#bo_v_con").viewimageresize();
});

function excute_good(href, $el, $tx) {
    $.post(
        href,
        { js: "on" },
        function(data) {
            if(data.error) {
                alert(data.error);
                return false;
            }
            if(data.count) {
                $el.find("strong").text(number_format(String(data.count)));
                if($tx && $tx.attr("id").search("nogood") > -1) {
                    alert("이 글을 비추천하셨습니다.");
                } else {
                    alert("이 글을 추천하셨습니다.");
                }
            }
        }, "json"
    );
}

function board_move(href) {
    window.open(href, "boardmove", "left=50, top=50, width=500, height=550, scrollbars=1");
}
</script>