<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
?>

<style>
/* 중고차 매매 전용 스타일 */
.car_form_section {
    background: #f8f9fa;
    padding: 20px;
    margin: 15px 0;
    border-radius: 8px;
    border-left: 4px solid #007bff;
}

.car_form_section h3 {
    margin: 0 0 15px 0;
    color: #333;
    font-size: 16px;
    font-weight: bold;
}

.form_row {
    display: flex;
    flex-wrap: wrap;
    gap: 15px;
    margin-bottom: 15px;
}

.form_col {
    flex: 1;
    min-width: 200px;
}

.form_col label {
    display: block;
    margin-bottom: 5px;
    font-weight: bold;
    color: #555;
}

.form_col input, .form_col select {
    width: 100%;
    padding: 8px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 14px;
}

.price_input {
    background: #fff9e6;
    border-color: #ffc107;
}

.status_select {
    background: #e6f7ff;
    border-color: #1890ff;
}

@media (max-width: 768px) {
    .form_row {
        flex-direction: column;
    }
    .form_col {
        min-width: 100%;
    }
}
</style>

<div class="container mb-2.5">
    <div class="row">
        <div class="col-sm-12">
            <section id="bo_w">
                <h2 class="sound_only"><?php echo $g5['title'] ?></h2>

                <form name="fwrite" id="fwrite" action="<?php echo $action_url ?>" onsubmit="return fwrite_submit(this);" method="post" enctype="multipart/form-data" autocomplete="off" style="width:<?php echo $width; ?>">
                <!-- 기본 히든 필드들 -->
                <input type="hidden" name="uid" value="<?php echo get_uniqid(); ?>">
                <input type="hidden" name="w" value="<?php echo $w ?>">
                <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
                <input type="hidden" name="wr_id" value="<?php echo $wr_id ?>">
                <input type="hidden" name="sca" value="<?php echo $sca ?>">
                <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
                <input type="hidden" name="stx" value="<?php echo $stx ?>">
                <input type="hidden" name="spt" value="<?php echo $spt ?>">
                <input type="hidden" name="sst" value="<?php echo $sst ?>">
                <input type="hidden" name="sod" value="<?php echo $sod ?>">
                <input type="hidden" name="page" value="<?php echo $page ?>">

                <!-- 분류 선택 -->
                <?php if ($is_category) { ?>
                <div class="car_form_section">
                    <h3>차량 분류</h3>
                    <div class="form_row">
                        <div class="form_col">
                            <label for="ca_name">분류 <span style="color:red;">*</span></label>
                            <select name="ca_name" id="ca_name" required>
                                <option value="">분류를 선택하세요</option>
                                <?php echo $category_option ?>
                            </select>
                        </div>
                    </div>
                </div>
                <?php } ?>

                <!-- 기본 정보 -->
                <div class="car_form_section">
                    <h3>기본 정보</h3>
                    <div class="bo_w_tit write_div">
                        <label for="wr_subject">제목 <span style="color:red;">*</span></label>
                        <input type="text" name="wr_subject" value="<?php echo $subject ?>" id="wr_subject" required class="frm_input full_input required" placeholder="예: 현대 더 뉴 팰리세이드 디젤 2.2 4WD 프레스티지">
                    </div>
                    
                    <div class="form_row">
                        <div class="form_col">
                            <label for="wr_2">판매상태 <span style="color:red;">*</span></label>
                            <select name="wr_2" id="wr_2" class="status_select" required>
                                <option value="">선택하세요</option>
                                <option value="판매중" <?php echo ($write['wr_2'] == '판매중') ? 'selected' : ''; ?>>판매중</option>
                                <option value="판매완료" <?php echo ($write['wr_2'] == '판매완료') ? 'selected' : ''; ?>>판매완료</option>
                            </select>
                        </div>
                        <div class="form_col">
                            <label for="wr_17">판매가격 (만원) <span style="color:red;">*</span></label>
                            <input type="number" name="wr_17" value="<?php echo $write['wr_17'] ?>" id="wr_17" class="price_input" placeholder="3000" required>
                        </div>
                    </div>
                </div>

                <!-- 차량 기본정보 -->
                <div class="car_form_section">
                    <h3>차량 기본정보</h3>
                    <div class="form_row">
                        <div class="form_col">
                            <label for="wr_1">제조사명 <span style="color:red;">*</span></label>
                            <select name="wr_1" id="wr_1" required>
                                <option value="">제조사 선택</option>
                                <option value="현대" <?php echo ($write['wr_1'] == '현대') ? 'selected' : ''; ?>>현대</option>
                                <option value="기아" <?php echo ($write['wr_1'] == '기아') ? 'selected' : ''; ?>>기아</option>
                                <option value="제네시스" <?php echo ($write['wr_1'] == '제네시스') ? 'selected' : ''; ?>>제네시스</option>
                                <option value="쌍용" <?php echo ($write['wr_1'] == '쌍용') ? 'selected' : ''; ?>>쌍용</option>
                                <option value="BMW" <?php echo ($write['wr_1'] == 'BMW') ? 'selected' : ''; ?>>BMW</option>
                                <option value="벤츠" <?php echo ($write['wr_1'] == '벤츠') ? 'selected' : ''; ?>>벤츠</option>
                                <option value="아우디" <?php echo ($write['wr_1'] == '아우디') ? 'selected' : ''; ?>>아우디</option>
                                <option value="기타" <?php echo ($write['wr_1'] == '기타') ? 'selected' : ''; ?>>기타</option>
                            </select>
                        </div>
                        <div class="form_col">
                            <label for="wr_3">차량명 <span style="color:red;">*</span></label>
                            <input type="text" name="wr_3" value="<?php echo $write['wr_3'] ?>" id="wr_3" placeholder="팰리세이드" required>
                        </div>
                        <div class="form_col">
                            <label for="wr_9">연식 <span style="color:red;">*</span></label>
                            <select name="wr_9" id="wr_9" required>
                                <option value="">연식 선택</option>
                                <?php for($year = date('Y'); $year >= 1990; $year--) { ?>
                                <option value="<?php echo $year ?>" <?php echo ($write['wr_9'] == $year) ? 'selected' : ''; ?>><?php echo $year ?>년</option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form_row">
                        <div class="form_col">
                            <label for="wr_7">주행거리 (km) <span style="color:red;">*</span></label>
                            <input type="number" name="wr_7" value="<?php echo $write['wr_7'] ?>" id="wr_7" placeholder="50000" required>
                        </div>
                        <div class="form_col">
                            <label for="wr_8">색상</label>
                            <input type="text" name="wr_8" value="<?php echo $write['wr_8'] ?>" id="wr_8" placeholder="흰색">
                        </div>
                        <div class="form_col">
                            <label for="wr_6">최초등록년월일</label>
                            <input type="date" name="wr_6" value="<?php echo $write['wr_6'] ?>" id="wr_6">
                        </div>
                    </div>
                </div>

                <!-- 차량 상세정보 -->
                <div class="car_form_section">
                    <h3>차량 상세정보</h3>
                    <div class="form_row">
                        <div class="form_col">
                            <label for="wr_10">연료 <span style="color:red;">*</span></label>
                            <select name="wr_10" id="wr_10" required>
                                <option value="">연료 선택</option>
                                <option value="휘발유" <?php echo ($write['wr_10'] == '휘발유') ? 'selected' : ''; ?>>휘발유</option>
                                <option value="경유(디젤)" <?php echo ($write['wr_10'] == '경유(디젤)') ? 'selected' : ''; ?>>경유(디젤)</option>
                                <option value="LPG" <?php echo ($write['wr_10'] == 'LPG') ? 'selected' : ''; ?>>LPG</option>
                                <option value="하이브리드" <?php echo ($write['wr_10'] == '하이브리드') ? 'selected' : ''; ?>>하이브리드</option>
                                <option value="전기" <?php echo ($write['wr_10'] == '전기') ? 'selected' : ''; ?>>전기</option>
                            </select>
                        </div>
                        <div class="form_col">
                            <label for="wr_11">변속기</label>
                            <select name="wr_11" id="wr_11">
                                <option value="">변속기 선택</option>
                                <option value="자동" <?php echo (isset($write['wr_11']) && $write['wr_11'] == '자동') ? 'selected' : ''; ?>>자동</option>
                                <option value="수동" <?php echo (isset($write['wr_11']) && $write['wr_11'] == '수동') ? 'selected' : ''; ?>>수동</option>
                                <option value="CVT" <?php echo (isset($write['wr_11']) && $write['wr_11'] == 'CVT') ? 'selected' : ''; ?>>CVT</option>
                            </select>
                        </div>
                        <div class="form_col">
                            <label for="wr_12">배기량 (cc)</label>
                            <input type="number" name="wr_12" value="<?php echo isset($write['wr_12']) ? $write['wr_12'] : '' ?>" id="wr_12" placeholder="2200">
                        </div>
                    </div>
                    
                    <div class="form_row">
                        <div class="form_col">
                            <label for="wr_13">구동방식</label>
                            <select name="wr_13" id="wr_13">
                                <option value="">구동방식 선택</option>
                                <option value="전륜구동(FF)" <?php echo (isset($write['wr_13']) && $write['wr_13'] == '전륜구동(FF)') ? 'selected' : ''; ?>>전륜구동(FF)</option>
                                <option value="후륜구동(FR)" <?php echo (isset($write['wr_13']) && $write['wr_13'] == '후륜구동(FR)') ? 'selected' : ''; ?>>후륜구동(FR)</option>
                                <option value="4WD" <?php echo (isset($write['wr_13']) && $write['wr_13'] == '4WD') ? 'selected' : ''; ?>>4WD</option>
                                <option value="AWD" <?php echo (isset($write['wr_13']) && $write['wr_13'] == 'AWD') ? 'selected' : ''; ?>>AWD</option>
                            </select>
                        </div>
                        <div class="form_col">
                            <label for="wr_14">정원 (명)</label>
                            <input type="number" name="wr_14" value="<?php echo isset($write['wr_14']) ? $write['wr_14'] : '' ?>" id="wr_14" placeholder="7">
                        </div>
                        <div class="form_col">
                            <label for="wr_16">사용용도</label>
                            <select name="wr_16" id="wr_16">
                                <option value="">사용용도 선택</option>
                                <option value="자가용" <?php echo (isset($write['wr_16']) && $write['wr_16'] == '자가용') ? 'selected' : ''; ?>>자가용</option>
                                <option value="영업용" <?php echo (isset($write['wr_16']) && $write['wr_16'] == '영업용') ? 'selected' : ''; ?>>영업용</option>
                                <option value="사업용" <?php echo (isset($write['wr_16']) && $write['wr_16'] == '사업용') ? 'selected' : ''; ?>>사업용</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- 차량 등록정보 -->
                <div class="car_form_section">
                    <h3>차량 등록정보</h3>
                    <div class="form_row">
                        <div class="form_col">
                            <label for="wr_4">차대번호</label>
                            <input type="text" name="wr_4" value="<?php echo isset($write['wr_4']) ? $write['wr_4'] : '' ?>" id="wr_4" placeholder="KMHL00000000000">
                        </div>
                        <div class="form_col">
                            <label for="wr_5">등록번호</label>
                            <input type="text" name="wr_5" value="<?php echo isset($write['wr_5']) ? $write['wr_5'] : '' ?>" id="wr_5" placeholder="12가1234">
                        </div>
                        <div class="form_col">
                            <label for="wr_15">적재량 (kg)</label>
                            <input type="number" name="wr_15" value="<?php echo isset($write['wr_15']) ? $write['wr_15'] : '' ?>" id="wr_15" placeholder="1000">
                        </div>
                    </div>
                </div>

                <!-- 차량 설명 -->
                <div class="car_form_section">
                    <h3>차량 상세설명</h3>
                    <div class="write_div">
                        <label for="wr_content">상세설명 <span style="color:red;">*</span></label>
                        <div class="wr_content <?php echo $is_dhtml_editor ? $config['cf_editor'] : ''; ?>">
                            <?php echo $editor_html; ?>
                        </div>
                    </div>
                </div>

                <!-- 차량 사진 첨부 -->
                <div class="car_form_section">
                    <h3>차량 사진 (최대 6장)</h3>
                    <?php for ($i=0; $is_file && $i<$file_count; $i++) { ?>
                    <div class="bo_w_flie write_div">
                        <div class="file_wr write_div">
                            <label for="bf_file_<?php echo $i+1 ?>">
                                <i class="fa fa-camera" aria-hidden="true"></i> 
                                사진 #<?php echo $i+1 ?>
                            </label>
                            <input type="file" name="bf_file[]" id="bf_file_<?php echo $i+1 ?>" accept="image/*" class="frm_file">
                        </div>
                        <?php if ($is_file_content) { ?>
                        <input type="text" name="bf_content[]" value="<?php echo ($w == 'u') ? $file[$i]['bf_content'] : ''; ?>" placeholder="사진 설명 (예: 외관, 내부, 엔진룸)" class="full_input frm_input">
                        <?php } ?>
                        
                        <?php if($w == 'u' && $file[$i]['file']) { ?>
                        <span class="file_del">
                            <input type="checkbox" id="bf_file_del<?php echo $i ?>" name="bf_file_del[<?php echo $i; ?>]" value="1"> 
                            <label for="bf_file_del<?php echo $i ?>"><?php echo $file[$i]['source'].'('.$file[$i]['size'].')'; ?> 파일 삭제</label>
                        </span>
                        <?php } ?>
                    </div>
                    <?php } ?>
                </div>

                <div class="btn_confirm write_div">
                    <a href="/bbs/board.php?bo_table=<?php echo $bo_table ?>" class="btn_cancel btn">취소</a>
                    <input type="submit" value="등록완료" id="btn_submit" accesskey="s" class="btn_submit btn">
                </div>
                </form>

                <script>
                function fwrite_submit(f) {
                    // 필수 항목 검증
                    if (!f.ca_name.value) {
                        alert('분류를 선택해주세요.');
                        f.ca_name.focus();
                        return false;
                    }
                    
                    if (!f.wr_2.value) {
                        alert('판매상태를 선택해주세요.');
                        f.wr_2.focus();
                        return false;
                    }
                    
                    if (!f.wr_17.value) {
                        alert('판매가격을 입력해주세요.');
                        f.wr_17.focus();
                        return false;
                    }
                    
                    if (!f.wr_1.value) {
                        alert('제조사명을 선택해주세요.');
                        f.wr_1.focus();
                        return false;
                    }
                    
                    if (!f.wr_3.value) {
                        alert('차량명을 입력해주세요.');
                        f.wr_3.focus();
                        return false;
                    }
                    
                    if (!f.wr_9.value) {
                        alert('연식을 선택해주세요.');
                        f.wr_9.focus();
                        return false;
                    }
                    
                    if (!f.wr_7.value) {
                        alert('주행거리를 입력해주세요.');
                        f.wr_7.focus();
                        return false;
                    }
                    
                    if (!f.wr_10.value) {
                        alert('연료를 선택해주세요.');
                        f.wr_10.focus();
                        return false;
                    }

                    document.getElementById("btn_submit").disabled = "disabled";
                    return true;
                }
                </script>
            </section>
        </div>
    </div>
</div>