<?php
/**
 * 기존 게시판에 중고차 매매용 필드 추가 스크립트
 * 
 * 이미 존재하는 게시판에 중고차 관련 필드들을 추가합니다.
 * 
 * 사용법: http://도메인/add_car_fields.php
 */

// 그누보드 환경 설정 파일 로드
$g5_path = './';
include_once($g5_path.'common.php');

// 관리자만 실행 가능
if (!$is_admin) {
    alert('관리자만 실행할 수 있습니다.');
}

// POST 요청 처리
if ($_POST['add_fields_action']) {
    $bo_table = trim($_POST['bo_table']);
    
    if (!$bo_table) {
        alert('게시판 아이디를 입력해주세요.');
    }
    
    try {
        $result = add_car_fields_to_board($bo_table);
        if ($result['success']) {
            echo "<script>alert('중고차 필드가 성공적으로 추가되었습니다.\\n\\n" . implode("\\n", $result['messages']) . "'); location.href='".G5_ADMIN_URL."/board_form.php?w=u&bo_table={$bo_table}';</script>";
        } else {
            alert('필드 추가 중 오류가 발생했습니다: ' . $result['error']);
        }
    } catch (Exception $e) {
        alert('필드 추가 중 오류가 발생했습니다: ' . $e->getMessage());
    }
}

/**
 * 기존 게시판에 중고차 필드 추가 함수
 */
function add_car_fields_to_board($bo_table) {
    global $g5;
    
    $messages = array();
    
    try {
        // 1. 게시판이 존재하는지 확인
        $sql = "SELECT bo_table FROM {$g5['board_table']} WHERE bo_table = '{$bo_table}'";
        $result = sql_query($sql);
        
        if (sql_num_rows($result) == 0) {
            return array('success' => false, 'error' => '존재하지 않는 게시판입니다.');
        }
        
        // 2. 게시판 테이블 존재 확인
        $table_name = $g5['write_prefix'] . $bo_table;
        $sql = "SHOW TABLES LIKE '{$table_name}'";
        $result = sql_query($sql);
        
        if (sql_num_rows($result) == 0) {
            return array('success' => false, 'error' => '게시판 테이블이 존재하지 않습니다.');
        }
        
        // 3. 기존 필드 확인
        $sql = "SHOW COLUMNS FROM {$table_name} LIKE 'wr_11'";
        $result = sql_query($sql);
        
        if (sql_num_rows($result) > 0) {
            return array('success' => false, 'error' => '이미 추가 필드가 존재합니다.');
        }
        
        // 4. 추가 필드 생성 (wr_11 ~ wr_17)
        $car_fields = array(
            'wr_11' => '변속기',
            'wr_12' => '배기량',
            'wr_13' => '구동방식',
            'wr_14' => '정원',
            'wr_15' => '적재량',
            'wr_16' => '사용용도',
            'wr_17' => '판매가격'
        );
        
        foreach ($car_fields as $field => $comment) {
            $sql = "ALTER TABLE `{$table_name}` ADD COLUMN `{$field}` varchar(255) DEFAULT '' COMMENT '{$comment}'";
            if (sql_query($sql)) {
                $messages[] = "필드 {$field}({$comment}) 추가 완료";
            } else {
                return array('success' => false, 'error' => "필드 {$field} 추가 실패: " . sql_error());
            }
        }
        
        // 5. 검색 성능을 위한 인덱스 추가
        $indexes = array(
            'idx_car_search' => array('wr_1', 'wr_2', 'wr_9', 'wr_10', 'wr_datetime'),
            'idx_mileage' => array('wr_7'),
            'idx_price' => array('wr_17'),
            'idx_year' => array('wr_9'),
            'idx_status' => array('wr_2')
        );
        
        foreach ($indexes as $index_name => $columns) {
            // 인덱스가 이미 존재하는지 확인
            $sql = "SHOW INDEX FROM {$table_name} WHERE Key_name = '{$index_name}'";
            $result = sql_query($sql);
            
            if (sql_num_rows($result) == 0) {
                $column_list = implode(', ', $columns);
                $sql = "ALTER TABLE `{$table_name}` ADD INDEX `{$index_name}` ({$column_list})";
                if (sql_query($sql)) {
                    $messages[] = "인덱스 {$index_name} 추가 완료";
                }
            }
        }
        
        // 6. 게시판 설정 업데이트 (필드 제목 설정)
        $sql = "UPDATE {$g5['board_table']} SET 
                    bo_1_subj = '제조사명',
                    bo_2_subj = '판매상태',
                    bo_3_subj = '차량명',
                    bo_4_subj = '차대번호',
                    bo_5_subj = '등록번호',
                    bo_6_subj = '최초등록년월일',
                    bo_7_subj = '주행거리',
                    bo_8_subj = '색상',
                    bo_9_subj = '연식',
                    bo_10_subj = '연료',
                    bo_use_category = '1',
                    bo_category_list = '전체|국산|수입',
                    bo_gallery_cols = '2',
                    bo_upload_count = '6'
                WHERE bo_table = '{$bo_table}'";
        
        if (sql_query($sql)) {
            $messages[] = "게시판 설정이 업데이트되었습니다.";
        }
        
        // 7. 완료 메시지
        $messages[] = "게시판 주소: " . G5_BBS_URL . "/board.php?bo_table={$bo_table}";
        $messages[] = "관리 주소: " . G5_ADMIN_URL . "/board_form.php?w=u&bo_table={$bo_table}";
        
        return array('success' => true, 'messages' => $messages);
        
    } catch (Exception $e) {
        return array('success' => false, 'error' => $e->getMessage());
    }
}

/**
 * 게시판 목록 가져오기
 */
function get_board_list() {
    global $g5;
    
    $boards = array();
    $sql = "SELECT bo_table, bo_subject FROM {$g5['board_table']} ORDER BY bo_table";
    $result = sql_query($sql);
    
    while ($row = sql_fetch_array($result)) {
        $boards[] = $row;
    }
    
    return $boards;
}

$board_list = get_board_list();
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>중고차 필드 추가</title>
    <link rel="stylesheet" href="<?php echo G5_ADMIN_URL ?>/css/admin.css">
    <style>
        .setup-container {
            max-width: 700px;
            margin: 50px auto;
            padding: 30px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #333;
        }
        .form-group select, .form-group input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }
        .btn {
            background: #007bff;
            color: white;
            padding: 12px 30px;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
        }
        .btn:hover {
            background: #0056b3;
        }
        .btn-secondary {
            background: #6c757d;
        }
        .btn-secondary:hover {
            background: #5a6268;
        }
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
        .alert-info {
            background: #d1ecf1;
            border: 1px solid #bee5eb;
            color: #0c5460;
        }
        .alert-warning {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            color: #856404;
        }
        .field-list {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 4px;
            margin: 20px 0;
        }
        .field-list table {
            width: 100%;
            border-collapse: collapse;
        }
        .field-list th,
        .field-list td {
            padding: 8px 12px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }
        .field-list th {
            background: #e9ecef;
            font-weight: bold;
        }
        .board-info {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 4px;
            margin-top: 15px;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="setup-container">
        <h1>기존 게시판에 중고차 필드 추가</h1>
        
        <div class="alert alert-info">
            <strong>주의사항:</strong><br>
            • 이 작업은 기존 게시판의 데이터베이스 구조를 변경합니다.<br>
            • 반드시 데이터베이스 백업을 먼저 진행하세요.<br>
            • 작업 후에는 중고차 전용 스킨을 적용해야 합니다.
        </div>
        
        <form method="post" action="">
            <input type="hidden" name="add_fields_action" value="1">
            
            <div class="form-group">
                <label for="bo_table">게시판 선택 <span style="color:red;">*</span></label>
                <select name="bo_table" id="bo_table" required onchange="showBoardInfo(this.value)">
                    <option value="">게시판을 선택하세요</option>
                    <?php foreach ($board_list as $board) { ?>
                    <option value="<?php echo $board['bo_table'] ?>"><?php echo $board['bo_table'] ?> - <?php echo $board['bo_subject'] ?></option>
                    <?php } ?>
                </select>
                
                <div id="board-info" class="board-info" style="display: none;">
                    <strong>선택된 게시판 정보:</strong><br>
                    <span id="board-details"></span>
                </div>
            </div>
            
            <div class="field-list">
                <h3>추가될 필드 목록:</h3>
                <table>
                    <thead>
                        <tr>
                            <th>필드명</th>
                            <th>용도</th>
                            <th>기존 필드</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr><td>wr_1</td><td>제조사명</td><td>기존 필드 활용</td></tr>
                        <tr><td>wr_2</td><td>판매상태</td><td>기존 필드 활용</td></tr>
                        <tr><td>wr_3</td><td>차량명</td><td>기존 필드 활용</td></tr>
                        <tr><td>wr_4</td><td>차대번호</td><td>기존 필드 활용</td></tr>
                        <tr><td>wr_5</td><td>등록번호</td><td>기존 필드 활용</td></tr>
                        <tr><td>wr_6</td><td>최초등록년월일</td><td>기존 필드 활용</td></tr>
                        <tr><td>wr_7</td><td>주행거리</td><td>기존 필드 활용</td></tr>
                        <tr><td>wr_8</td><td>색상</td><td>기존 필드 활용</td></tr>
                        <tr><td>wr_9</td><td>연식</td><td>기존 필드 활용</td></tr>
                        <tr><td>wr_10</td><td>연료</td><td>기존 필드 활용</td></tr>
                        <tr style="background: #fff3cd;"><td>wr_11</td><td>변속기</td><td>🆕 새로 추가</td></tr>
                        <tr style="background: #fff3cd;"><td>wr_12</td><td>배기량</td><td>🆕 새로 추가</td></tr>
                        <tr style="background: #fff3cd;"><td>wr_13</td><td>구동방식</td><td>🆕 새로 추가</td></tr>
                        <tr style="background: #fff3cd;"><td>wr_14</td><td>정원</td><td>🆕 새로 추가</td></tr>
                        <tr style="background: #fff3cd;"><td>wr_15</td><td>적재량</td><td>🆕 새로 추가</td></tr>
                        <tr style="background: #fff3cd;"><td>wr_16</td><td>사용용도</td><td>🆕 새로 추가</td></tr>
                        <tr style="background: #fff3cd;"><td>wr_17</td><td>판매가격</td><td>🆕 새로 추가</td></tr>
                    </tbody>
                </table>
            </div>
            
            <div class="alert alert-warning">
                <strong>작업 후 해야할 일:</strong><br>
                1. 중고차 전용 스킨 파일들을 해당 디렉토리에 업로드<br>
                2. 게시판 관리에서 스킨을 'car'로 변경<br>
                3. 분류 설정을 '전체|국산|수입'으로 변경<br>
                4. 첨부파일 개수를 6개로 설정
            </div>
            
            <div style="text-align: center; margin-top: 30px;">
                <button type="submit" class="btn" onclick="return confirm('선택한 게시판에 중고차 필드를 추가하시겠습니까?\\n\\n※ 이 작업은 되돌릴 수 없습니다.')">필드 추가하기</button>
                <a href="<?php echo G5_ADMIN_URL ?>/board_list.php" class="btn btn-secondary">취소</a>
            </div>
        </form>
        
        <div style="margin-top: 40px; padding-top: 20px; border-top: 1px solid #eee;">
            <h3>추가되는 기능:</h3>
            <ul>
                <li>중고차 매매에 필요한 17개 데이터 필드</li>
                <li>검색 성능 향상을 위한 인덱스</li>
                <li>분류 기능 (전체/국산/수입)</li>
                <li>이미지 업로드 6장 가능</li>
                <li>갤러리 형태 목록</li>
            </ul>
        </div>
    </div>
    
    <script>
    function showBoardInfo(bo_table) {
        const boardInfo = document.getElementById('board-info');
        const boardDetails = document.getElementById('board-details');
        
        if (bo_table) {
            const selectedOption = document.querySelector(`option[value="${bo_table}"]`);
            const boardName = selectedOption.textContent;
            
            boardDetails.innerHTML = `
                <strong>게시판 ID:</strong> ${bo_table}<br>
                <strong>게시판명:</strong> ${boardName}<br>
                <strong>테이블명:</strong> g5_write_${bo_table}<br>
                <strong>작업 후 관리 URL:</strong> <a href="<?php echo G5_ADMIN_URL ?>/board_form.php?w=u&bo_table=${bo_table}" target="_blank">관리페이지</a>
            `;
            boardInfo.style.display = 'block';
        } else {
            boardInfo.style.display = 'none';
        }
    }
    </script>
</body>
</html>