<?php
  if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
  include_once(G5_LIB_PATH.'/thumbnail.lib.php');

  // fontawesome CSS
  add_stylesheet('<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" />', 9);

  //스킨 CSS,JS 인클루드
  //add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
  add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/css/style.css?'.time().'" />', 11);
  if(G5_IS_MOBILE) {
    add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/css/style_mobile.css?'.time().'" media="all and (max-width: 768px)" />', 12);
  }

  $list_count = (is_array($list) && $list) ? count($list) : 0;
?>


<div class="xns_gnuboard_latest_list_style1<?php if($skin_colorset) { ?> <?php echo $skin_colorset_class ?><?php } ?>">
  <div class="title_center">
    <span>
      <?php echo $bo_subject ?>
    </span>
    <a class="btn_more" href="<?php echo get_pretty_url($bo_table); ?>">
      <i class="fas fa-plus"></i>
    </a>
  </div>

  <div class="docu_list">
    <ul>
      <?php for ($i=0; $i<$list_count; $i++) { ?>
        <li>
          <a href="<?php echo $list[$i]['href'] ?>">
            <div class="title_area">
              &#183;
              <?php if($list[$i]['ca_name']) { ?>
                [<?php echo $list[$i]['ca_name'] ?>]
              <?php } ?>
              <?php echo $list[$i]['wr_subject'] ?>
              <?php if($list[$i]['wr_comment']>0) { ?>
                <em><?php echo number_format($list[$i]['wr_comment']); ?></em>
              <?php } ?>
	  		      <?php if($list[$i]['icon_new']) { ?>
		  	        <span class="icon_new">N</span>
			        <?php } ?>
			      </div>
            <span class="date">
              <?php
                $wr_datetime_array = explode(' ',$list[$i]['wr_datetime']);
              ?>
              <i class="far fa-clock"></i>
              <?php echo $wr_datetime_array[0] ?>
            </span>
          </a>
        </li>
      <?php } ?>
    </ul>
  </div>
</div>
