<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 5;

if ($is_checkbox) $colspan++;
if ($is_good) $colspan++;
if ($is_nogood) $colspan++;

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 99);
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/icon.css">', 99);

$xedition_write_pages = get_xedition_paging(G5_IS_MOBILE ? $config['cf_mobile_pages'] : $config['cf_write_pages'], $page, $total_page, './board.php?bo_table='.$bo_table.$qstr.'&amp;page=');

// 분류 사용 여부
$category_option2 = '';
if ($board['bo_use_category']) {
    $is_category = true;
    $category_href = G5_BBS_URL.'/board.php?bo_table='.$bo_table;

    $category_option2 .= '<li';
    if ($sca=='')
        $category_option2 .= ' class="on"';
        $category_option2 .= '><a href="'.$category_href.'"';
    $category_option2 .= '>전체</a></li>';

    $categories = explode('|', $board['bo_category_list']); // 구분자가 , 로 되어 있음
    for ($i=0; $i<count($categories); $i++) {
        $category = trim($categories[$i]);
        if ($category=='') continue;
        $category_option2 .= '<li';
        $category_msg = '';
        if ($category==$sca) { // 현재 선택된 카테고리라면
            $category_option2 .= ' class="on"';
            $category_option2 .= '><a href="'.($category_href."&amp;sca=".urlencode($category)).'"';
        }else{
            $category_option2 .= '><a href="'.($category_href."&amp;sca=".urlencode($category)).'"';
        }
        $category_option2 .= '>'.$category_msg.$category.'</a></li>';
    }
}

// 한페이지에 보여줄 행, 현재페이지, 총페이지수, URL
function get_xedition_paging($write_pages, $cur_page, $total_page, $url, $add="")
{
    //$url = preg_replace('#&amp;page=[0-9]*(&amp;page=)$#', '$1', $url);
    $url = preg_replace('#&amp;page=[0-9]*#', '', $url) . '&amp;page=';

    $str = '';
    if ($cur_page) {
        $str .= '<a href="'.$url.'1'.$add.'" class="direction prev"><i class="xi-angle-left"></i>&nbsp;첫 페이지</a>'.PHP_EOL;
    }

    $start_page = ( ( (int)( ($cur_page - 1 ) / $write_pages ) ) * $write_pages ) + 1;
    $end_page = $start_page + $write_pages - 1;

    if ($end_page >= $total_page) $end_page = $total_page;

    //if ($start_page > 1) $str .= '<a href="'.$url.($start_page-1).$add.'" class="pg_page pg_prev">이전</a>'.PHP_EOL;

    if ($total_page > 1) {
        for ($k=$start_page;$k<=$end_page;$k++) {
            if ($cur_page != $k)
                $str .= '<a href="'.$url.$k.$add.'">'.$k.'</a>'.PHP_EOL;
            else
                $str .= '<strong>'.$k.'</strong>'.PHP_EOL;
        }
    }

    //if ($total_page > $end_page) $str .= '<a href="'.$url.($end_page+1).$add.'" class="pg_page pg_next">다음</a>'.PHP_EOL;

    if ($cur_page) {
        $str .= '<a href="'.$url.$total_page.$add.'" class="direction next">끝 페이지&nbsp;<i class="xi-angle-right"></i></a>'.PHP_EOL;
    }

    if ($str)
        return "<nav class=\"pg_wrap\"><span class=\"pg\">{$str}</span></nav>";
    else
        return "";
}
?>
<div class="board">
<div class="list_footer">
  <?php if ($rss_href || $write_href) { ?>
  <div class="btnArea">
    <?php if ($write_href) { ?><a href="<?php echo $admin_href ?>" class="btn"><i class="xi-cog"></i>설정</a><?php } ?>
    <?php if ($write_href) { ?><a href="<?php echo $write_href ?>" class="btn"><i class="xi-pen"></i> 쓰기</a><?php } ?>
  </div>
  <?php } ?>
</div>
<?php if ($is_category) { ?>
<ul class="cTab">
<?php echo $category_option2 ?>
</ul>
<?php } ?>
<div class="board_list" id="board_list"><form name="fboardlist" id="fboardlist" action="./board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
<input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
<input type="hidden" name="sfl" value="<?php echo $sfl ?>">
<input type="hidden" name="stx" value="<?php echo $stx ?>">
<input type="hidden" name="spt" value="<?php echo $spt ?>">
<input type="hidden" name="sca" value="<?php echo $sca ?>">
<input type="hidden" name="sst" value="<?php echo $sst ?>">
<input type="hidden" name="sod" value="<?php echo $sod ?>">
<input type="hidden" name="page" value="<?php echo $page ?>">
<input type="hidden" name="sw" value="">
<table width="100%" border="1" cellspacing="0" summary="List of Articles">
<thead>
<!-- LIST HEADER -->
<tr>
<th scope="col"><span>번호</span></th>
<?php if ($is_checkbox) { ?>
<th scope="col"><label for="chkall" class="sound_only">현재 페이지 게시물 전체</label><input type="checkbox" id="chkall" onclick="if (this.checked) all_checked(true); else all_checked(false);"></th>
<?php } ?>
<th scope="col" class="title"><span>제목</span></th>
<th scope="col"><span>글쓴이</span></th>
<th scope="col"><?php echo subject_sort_link('wr_datetime', $qstr2, 1) ?>날짜</a></th>
<th scope="col"><?php echo subject_sort_link('wr_hit', $qstr2, 1) ?>조회 수</a></th>
<?php if ($is_good) { ?><th scope="col"><?php echo subject_sort_link('wr_good', $qstr2, 1) ?>추천</a></th><?php } ?>
<?php if ($is_nogood) { ?><th scope="col"><?php echo subject_sort_link('wr_nogood', $qstr2, 1) ?>비추천</a></th><?php } ?>
</tr>
<!-- /LIST HEADER -->
</thead>
        <tbody>
        <?php
        for ($i=0; $i<count($list); $i++) {
         ?>
        <tr<?php if ($list[$i]['is_notice']) echo ' class="notice"'; ?>">
            <td class="no">
            <?php
            if ($list[$i]['is_notice']) // 공지사항
                echo '<strong>공지</strong>';
            else if ($wr_id == $list[$i]['wr_id'])
                echo "<span class=\"bo_current\">열람중</span>";
            else
                echo $list[$i]['num'];
             ?>
            </td>
            <?php if ($is_checkbox) { ?>
            <td class="td_chk">
                <label for="chk_wr_id_<?php echo $i ?>" class="sound_only"><?php echo $list[$i]['subject'] ?></label>
                <input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>">
            </td>
            <?php } ?>
            <td class="title">
                <?php
                echo $list[$i]['icon_reply'];
                if ($is_category && $list[$i]['ca_name']) {
                 ?>
                <a href="<?php echo $list[$i]['ca_name_href'] ?>" class="bo_cate_link"><?php echo $list[$i]['ca_name'] ?></a>
                <?php } ?>

                <a href="<?php echo $list[$i]['href'] ?>">
                    <?php echo $list[$i]['subject'] ?>
                    <?php if ($list[$i]['comment_cnt']) { ?><span class="sound_only">댓글</span><?php echo $list[$i]['comment_cnt']; ?><span class="sound_only">개</span><?php } ?>
                </a>

                <?php
                // if ($list[$i]['link']['count']) { echo '['.$list[$i]['link']['count']}.']'; }
                // if ($list[$i]['file']['count']) { echo '<'.$list[$i]['file']['count'].'>'; }

                if (isset($list[$i]['icon_new'])) echo $list[$i]['icon_new'];
                //if (isset($list[$i]['icon_hot'])) echo $list[$i]['icon_hot'];
                if (isset($list[$i]['icon_file'])) echo $list[$i]['icon_file'];
                //if (isset($list[$i]['icon_link'])) echo $list[$i]['icon_link'];
                if (isset($list[$i]['icon_secret'])) echo $list[$i]['icon_secret'];

                 ?>
            </td>
            <td class="author"><?php echo $list[$i]['name'] ?></td>
            <td class="time"><?php echo $list[$i]['datetime2'] ?></td>
            <td class="readNum"><?php echo $list[$i]['wr_hit'] ?></td>
            <?php if ($is_good) { ?><td class="td_num"><?php echo $list[$i]['wr_good'] ?></td><?php } ?>
            <?php if ($is_nogood) { ?><td class="td_num"><?php echo $list[$i]['wr_nogood'] ?></td><?php } ?>
        </tr>
        <?php } ?>
        <?php if (count($list) == 0) { ?>
        <tr class="no_article">
        <td colspan="<?php echo $colspan ?>">
        <p style="text-align:center">등록된 글이 없습니다.</p>
        </td>
        </tr>
        <?php } ?>
        </tbody>
        </table>

<div class="list_footer">
  <?php if ($is_checkbox) { ?>
  <div class="btn_bo_adm">
    <input type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value">
    <input type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value">
    <input type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value">
  </div>
  </form>
  <?php }else{ ?>
  </form>
  <?php } ?>
  <div class="btnArea">
    <?php if ($list_href) { ?><a href="<?php echo $list_href ?>" class="btn"><i class="xi-list-ul-l"></i> 목록</a><?php } ?>
    <?php if ($write_href) { ?><a href="<?php echo $write_href ?>" class="btn"><i class="xi-pen"></i> 쓰기</a><?php } ?>
  </div>
  <form name="fsearch" method="get" class="board_search">
  <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
  <input type="hidden" name="sca" value="<?php echo $sca ?>">
  <input type="hidden" name="sop" value="and">
  <select name="sfl" id="sfl">
    <option value="wr_subject"<?php echo get_selected($sfl, 'wr_subject', true); ?>>제목</option>
    <option value="wr_content"<?php echo get_selected($sfl, 'wr_content'); ?>>내용</option>
    <option value="wr_subject||wr_content"<?php echo get_selected($sfl, 'wr_subject||wr_content'); ?>>제목+내용</option>
    <option value="mb_id,1"<?php echo get_selected($sfl, 'mb_id,1'); ?>>회원아이디</option>
    <option value="mb_id,0"<?php echo get_selected($sfl, 'mb_id,0'); ?>>회원아이디(코)</option>
    <option value="wr_name,1"<?php echo get_selected($sfl, 'wr_name,1'); ?>>글쓴이</option>
    <option value="wr_name,0"<?php echo get_selected($sfl, 'wr_name,0'); ?>>글쓴이(코)</option>
  </select>
  <div class="search_input">
    <i class="xi-magnifier"></i>
    <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx" class="iText" size="15" maxlength="20">
  </div>
    <input type="submit" value="검색" class="btn">
  </form>
  <div class="pagination">
  <?php echo $xedition_write_pages;  ?>
  </div>
</div>
</div>
</div>


<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = "./board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == "copy")
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = "./move.php";
    f.submit();
}
</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->