<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 
?>
<script src="http://maps.google.com/maps/api/js?v=3.3&sensor=false&language=ko"></script>
<script>
	// 구글맵
	var map;
	var marker;
	var infowindow;

	function initialize() {
		var myLatlng = new google.maps.LatLng(<?=$map['map_lat']?>, <?=$map['map_lng']?>);
		var myOptions = {
			zoom: <?=$map['map_zoom']?>,
			scaleControl: true,

			navigationControl: true,
			navigationControlOptions: {
					style: google.maps.NavigationControlStyle.SMALL,
					position: google.maps.ControlPosition.TOP_RIGHT
			},

			center: myLatlng,
			mapTypeId: google.maps.MapTypeId.ROADMAP
		}
		map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);

		infowindow = new google.maps.InfoWindow();

		google.maps.event.addListener(map, 'zoom_changed', function() {
			zoomLevel = map.getZoom(); 
			if (zoomLevel > 19) { 
			  map.setZoom(19); 
			}   
			if (zoomLevel < 1) { 
			  map.setZoom(1); 
			}   
		});

		marker = new google.maps.Marker({
			position: myLatlng,
			map: map
		});

		infowindow.setContent("<?=$marker?>");
		infowindow.open(map,marker);
	}
</script>

<?php
	//Check Mobile
	$map_width = ($map['map_width'] > 0 && !G5_IS_MOBILE) ? $map['map_width'].'px' : '90%';
	$map_height = $map['map_height'] > 0 ? $map['map_height'].'px' : '450px';
?>

<div id="map_canvas" class="google_map" style="width:<?=$map_width?>; height:<?=$map_height?>;"></div>
<script> addLoadEvent(initialize); </script>
