<?php
include_once('./_common.php');

include_once(AMINA_PATH.'/lib/head.lib.php');

if (!$bo_table) {
	alert_close("값이 넘어오지 않았습니다.");
}

?>
<!doctype html>
<html lang="ko">
<head>
<meta charset="utf-8">
<? if (G5_IS_MOBILE) {?>
<meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=0,maximum-scale=10,user-scalable=yes">
<meta name="HandheldFriendly" content="true">
<meta name="format-detection" content="telephone=no">
<? } ?>
<title>도움말</title>
<style>
	body { 
		margin:0; padding:0; font:normal 12px dotum; -webkit-text-size-adjust:100%; 
	}
	.title { 
		padding:12px; text-align:center; font:bold 14px dotum; color:gold; background:#333; border:0px; 
	}
	.box {
		padding:15px;
	}
	.box .wr_tip{
		padding:10px; background:#f5f5f5; font-weight:bold;
	}
	.box li {
		line-height:1.7;
	}
	.box ul li {
		list-style:disc; line-height:1.7;
	}
	.win-close { 
		cursor:pointer; padding:12px; text-align:center; font:bold 12px dotum; color:white; background:#333; border:0px; 
	}
</style>
<script> 
	function addLoadEvent(func) {
		var oldonload = window.onload;
		if (typeof window.onload != 'function') {
			window.onload = func;
		} else {
			window.onload = function() {
				if (oldonload) {
					oldonload();
				}
				func();
			}
		}
	}
</script>
</head>
<body>
<div class="title">게시물 등록 관련 도움말</div>
<div class="box">
	<div class="wr_tip">동영상 등록 안내</div>
	<ol>
	<li><b>등록가능 동영상 공유주소형태 안내</b>
		<ul>
		<li>유튜브 : http://youtu.be/oL2AlXWVbKU 또는 http://www.youtube.com/watch?v=oL2AlXWVbKU</li>
		<li>비메오 : http://vimeo.com/18923281</li>
		<li>다음TV : http://tvpot.daum.net/v/kxxUvNy1ndg$</li>
		<li>네이트TV : http://pann.nate.com/video/221313865</li>
		<li>판도라TV : http://channel.pandora.tv/channel/video.ptv?ch_userid=sobboso&prgid=47491832</li>
		<li>태그스토리 : http://www.tagstory.com/video/100470056</li>
		<li>테드(TED) : http://www.ted.com/talks/lang/ko/cesar_kuriyama_one_second_every_day.html</li>
		<li>데일리모션 : http://www.dailymotion.com/video/xzh0jv_iron-man-3-review_shortfilms</li>
		</ul>
	</li>
	<li><b>직접입력방법 - 
		<? if($amina['video']) { ?>
			동영상 입력창에 각 동영상별 공유주소 또는 파일주소 입력.
		<? } else { ?>
			본 게시판은 동영상 직접입력을 지원하지 않습니다.
		<? } ?>
	</b></li>
	<li><b>본문에 동영상 삽입 방법</b>
		<ul>
		<li>본문에 {동영상:동영상 공유주소 } 형태로 입력 ex) {동영상:http://youtu.be/oL2AlXWVbKU }</li>
		<li>또는 본문에 {동영상:동영상 파일주소|file=1 } 형태로 입력 ex) {동영상:http://xxx.xxx.xxx/xxx.mp4|file=1 }</li>
		<li>동영상용 이미지를 별도로 넣고자 할 경우 {동영상:동영상 공유주소|img=이미지URL } 형태 또는 {동영상:동영상 파일주소|file=1 img=이미지URL } 형태로 입력</li>
		<li>본문에 넣는 동영상은 갯수제한없이 입력 가능</li>
		</ul>
	</li>
	</ol>

	<div class="wr_tip">파일/이미지 등록 안내</div>
	<ol>
	<li>첨부이미지 중 BMP 파일은 일반파일로 분류되어 출력되지 않습니다.</li>
	<li>첨부이미지 위치가 본문상단 또는 하단일 경우에만 '붙이기' 기능이 작동합니다.</li>
	<li>첨부이미지 본문삽입 방법
		<ul>
		<li>본문에 {이미지:0}, {이미지:1}, {이미지:2} 형태로 입력(숫자는 첨부순서)</li>
		<li>{이미지:0:width=숫자} 또는 {이미지:0:width=숫자 height=숫자} 형태로 이미지 크기조정 가능</li>
		<li>html 태그 또는 에디트의 정렬기능을 이용하여 이미지 정렬 가능</li>
		</ul>
	</li>
	</ol>

	<div class="wr_tip">첨부이미지 자동 리사이즈 안내</div>
	<ul>
	<? if($amina['upimg_size'] > 0 && $amina['upimg_quality'] > 0) { ?>
		<li>본 게시판은 첨부이미지 자동 리사이즈 설정이 적용되어 있습니다.(제한크기 : <?=$amina['upimg_size']?>px)</li>
	<? } else { ?>
		<li>본 게시판은 첨부이미지 자동 리사이즈 설정이 적용되어 있지 않습니다.</li>
	<? } ?>
	<li>첨부이미지 자동 리사이즈란 첨부이미지의 폭(width)이 설정한 크기보다 클 경우 글등록시 자동 리사이즈되는 것을 말하며, 이때 원본 이미지 자체가 리사이즈된 이미지로 교체됩니다.</li>
	<li>JPG 파일의 경우 리사이즈시 다소 화질저하가 있을 수 있으며, 첨부이미지가 많을 경우 글등록에 시간이 걸릴 수 있습니다.</li>
	</ul>

	<div class="wr_tip">구글지도 등록 방법</div>
	<ol>
	<? if($amina['google_map']) { ?>
		<li>본 게시판은 구글지도 등록이 가능합니다.</li>
	<? } else { ?>
		<li>본 게시판은 구글지도 등록기능을 지원하지 않습니다.</li>
	<? } ?>
	<li>지도설정을 클릭하여 등록할 지도 정보 입력합니다.</li>
	<li>지도설정후 본문에 지도를 넣을 곳에 <b>[map]지도마커내용[/map]</b> 이라고 입력해야 지도가 본문에 출력됩니다.</li>
	<li>html 태그 또는 에디트의 정렬기능을 이용하여 지도 정렬 가능합니다.</li>
	</ol>

	<div class="wr_tip">설문조사 등록 방법</div>
	<ol>
	<li>설문조사 등록은 게시판설정 또는 회원등급에 따라 등록권한이 설정됩니다.</li>
	<li>'등록하기'를 클릭하여 설문입력창을 오픈합니다.</li>
	<li>조사하고자 하는 설문제목, 기간, 항목 등을 입력합니다.</li>
	<li>설문항목은 최대 9개까지 설정 가능합니다.</li>
	</ol>

	<div class="wr_tip">포인트 등록 안내</div>
	<ul>
	<li>포인트 등록은 게시판설정 또는 회원등급에 따라 등록권한이 설정됩니다.</li>
	<li><b>열람포인트</b>는 글 열람시 약속된 룰에 따라 글작성자에게 적립되는 포인트를 말합니다.</li>
	<li>열람포인트 적립이 발생할 경우 설정한
		<? if($amina['po_view_fee'] > 0) { ?>
			포인트에서 수수료 <?=$amina['po_view_fee']?>% 차감후 적립됩니다.
		<? } else { ?>
			포인트만틈 적립됩니다.</li>
		<? } ?>
		<? if($amina['po_view_term'] > 0) { ?>
			(적립기간 : 등록후 <?=$amina['po_view_term']?>일)
		<? } ?>
	</li>
	<li><b>다운포인트</b>는 자료 다운로드시 약속된 룰에 따라 글작성자에게 적립되는 포인트를 말합니다.</li>
	<li>다운포인트 적립이 발생할 경우 설정한
		<? if($amina['po_down_fee'] > 0) { ?>
			다운포인트에서 수수료 <?=$amina['po_down_fee']?>% 차감후 적립됩니다.
		<? } else { ?>
			다운포인트만틈 적립됩니다.
		<? } ?>
		<? if($amina['po_down_term'] > 0) { ?>
			(적립기간 : 등록후 <?=$amina['po_down_term']?>일)
		<? } ?>
	</li>
	<li><b><?=$amina['cmt_choice_txt']?>포인트</b>로 건 포인트는 글등록시 선차감되며, 글등록후 수정 또는 복구되지 않습니다.</li>
	</ul>

	<div class="wr_tip">관련글/태그 등록 안내</div>
	<ul>
		<li>관련글과 태그 등록은 게시판설정 또는 회원등급에 따라 등록권한이 설정됩니다.</li>
		<li>관련글은 등록된 태그 또는 태그관련 단어를 입력하며, 복수 입력시 각 단어는 콤마(,)로 구분합니다.</li>
		<li>태그는 '등록'이 체크되어야 저장되며, 복수 입력시 각 태그는 콤마(,)로 구분합니다.</li>
	</ul>
</div>
<div class="win-close" onclick="javascript:window.close();">창닫기</div>

<script> 
	function move_center() {
		var sw = screen.width;
	    var sh = screen.height;
		var cw = document.body.clientWidth;
	    var ch = document.body.clientHeight;
	    var top  = sh / 2 - ch / 2 - 100;
		var left = sw / 2 - cw / 2;
	    moveTo(left, top);
	}

	addLoadEvent(function() {
		move_center();
	});
</script>
</body>
</html>