<?php if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 ?>

<link rel="stylesheet" href="<?=AMINA_URL?>/html/style.css" />

<? if(!$hide_title) { ?>
	<div class="html_title">
		<span class="html_name"># User Guide</span><span class="html_desc"> - 사이트 이용안내</span>
	</div>
<? } ?>

<div class="html_content">

<div class="sub_title" style="padding-top:0px;">1. 이용시 주의사항</div>

<p>본 사이트 이용시 기본적으로 아래 4가지 사항은 반드시 지켜주세요.</p>

<ol>
	<li><b>무분별한 비방성글이나 욕설 금지</b>
	<li><b>무분별한 광고글 및 불법자료 관련글 금지</b>
	<li><b>개인정보 또는 금전거래를 목적으로 하는 글 금지</b>
	<li><b>펌글 또는 이미지는 반드시 출처 기록(저작권 문제)</b>
</ol>


<p>해당되는 게시물은 발견 즉시 차단되며, 해당 게시물을 작성한 회원은 불량회원이 되어 일정기간 접속이 차단됩니다.
욕설이나 광고글 등 분위기를 어지럽히는 글작성으로 차된되거나 불량회원이 되시면 직접 탈퇴하는 것이 불가능하니 주의해 주시길 바랍니다.</p>
                  
<div class="sub_title">2. 회원등급 제도 안내</div>

<p>본 사이트는 회원등급에 따라 이용하실 수 있는 서비스에 차이가 발생할 수 있습니다.</p>

<table border=0 class="html_tbl2">
<col width=100><col width=200>
<thead>
<tr><th scope="col">회원등급</th><th scope="col">등급명</th><th scope="col">설명</th><th scope="col">비고</th></tr>
</thead>
<tbody>
<tr><td>Ⅰ</td><td><?=$xp['grade'][1]?></td><td>&nbsp;</td><td>&nbsp;</td></tr>
<tr><td>Ⅱ</td><td><?=$xp['grade'][2]?></td><td>&nbsp;</td><td>&nbsp;</td></tr>
<tr><td>Ⅲ</td><td><?=$xp['grade'][3]?></td><td>&nbsp;</td><td>&nbsp;</td></tr>
<tr><td>Ⅳ</td><td><?=$xp['grade'][4]?></td><td>&nbsp;</td><td>&nbsp;</td></tr>
<tr><td>Ⅴ</td><td><?=$xp['grade'][5]?></td><td>&nbsp;</td><td>&nbsp;</td></tr>
<tr><td>Ⅵ</td><td><?=$xp['grade'][6]?></td><td>&nbsp;</td><td>&nbsp;</td></tr>
<tr><td>Ⅶ</td><td><?=$xp['grade'][7]?></td><td>&nbsp;</td><td>&nbsp;</td></tr>
<tr><td>Ⅷ</td><td><?=$xp['grade'][8]?></td><td>&nbsp;</td><td>&nbsp;</td></tr>
<tr><td>Ⅸ</td><td><?=$xp['grade'][9]?></td><td>&nbsp;</td><td>&nbsp;</td></tr>
<tr><td>Ⅹ</td><td><?=$xp['grade'][10]?></td><td>&nbsp;</td><td>&nbsp;</td></tr>
</tbody>
</table>

<br>

<div class="sub_title">3. 포인트 제도 안내</div>

<p>본 사이트는 사이트 활성화와 다양한 혜택을 서비스하기 위해 포인트 제도를 운영하고 있습니다.</p>
<ol>
	<li> 포인트 정책은 수시로 변경될 수 있으며, 이를 별도로 통보하지 않습니다.
	<li> 포인트 획득을 위한 도배 및 어뷰징 등의 행위자는 통보없이 "포인트 몰수" 또는 "회원정지"나 "사이트 접근차단" 등이 조치를 받을 수 있습니다.
	<li> 적립된 포인트는 사이트내 서비스를 이용하는 목적 이외의 어떠한 효력도 갖고 있지 않습니다.
	<li> 회원가입시 <span class="p_txt"><?=number_format($config['cf_register_point']);?></span> 포인트 적립(1회), 로그인시  <span class="p_txt"><?=number_format($config['cf_login_point']);?></span> 포인트 적립(매일), 쪽지발송 시 <span class="p_txt"><?=number_format($config['cf_memo_send_point']);?></span> 포인트 차감(매회)
</ol>

<br>

<table border=0 class="html_tbl">
<thead>
<tr>
<th scope="col">그룹</th>
<th scope="col">게시판</th>
<th scope="col">글읽기</th>
<th scope="col">글쓰기</th>
<th scope="col">댓글/답글</th>
<th scope="col">다운로드</th>
<th scope="col">추천(보상)</th>
<th scope="col">댓글공감</th>
<th scope="col">별점(보상)</th>
<th scope="col">설문참여</th>
<th scope="col">채택보상</th>
</tr>
</thead>
<tbody>
<?
	//설정
	$p_gr_exclude = "test;test1"; //제외그룹 세미콜론(;)으로 표시
	$p_bo_exclude = "test;test1"; //제외게시판 세미콜론(;)으로 표시

	//-----------------------------------------------------------
	//Show Check
	function chk_p_exclude($arr, $item) {
		$item = trim($item);
		if($item) {
			for ($i=0; $i<count($arr); $i++) { 
				$chk_item = trim($arr[$i]);
				if($chk_item == "") continue;
				if($chk_item == $item) return true;
			}
		}

		return false;
	}

	$p_gr_exclude = explode(";",$p_gr_exclude);
	$p_bo_exclude = explode(";",$p_bo_exclude);

	$list = array();

	if(AMINA) {
		$gr_order = 'gr_order';
		$gr_show = "and gr_show_menu = '1' and gr_device <> 'mobile'";
		$bo_order = 'bo_order';
		$bo_show = "and bo_show_menu = '1' and bo_device <> 'mobile'";
		$bo_search = "and bo_use_search = '1'";
	} else {
		$gr_order = 'gr_10';
		$gr_show = "and gr_10 <> 'mobile'";
		$bo_order = 'bo_order_search';
		$bo_show = "and bo_10 <> 'mobile'";
		$bo_search = "and bo_use_search = '1'";
	}

	$n = 0;
	$total_post = 0;
	$total_cmt = 0;

	// Group
	$sql = " select * from {$g4['group_table']} where 1 $gr_show order by $gr_order ";
	$result = sql_query($sql);
	for ($i=0; $row=sql_fetch_array($result); $i++) {

		if(chk_p_exclude($p_gr_exclude,$row['gr_id'])) continue;

		// Board
		$sql2 = " select * from {$g4['board_table']} where gr_id = '{$row['gr_id']}' $bo_show order by $bo_order ";
		$result2 = sql_query($sql2);
		for ($k=0; $row2=sql_fetch_array($result2); $k++) { 

			if(chk_p_exclude($p_bo_exclude,$row2['bo_table'])) continue;

			$bo_write_cnt = $row2['bo_count_write'] ? number_format($row2['bo_count_write']).'개' : '-';
			$bo_cmt_cnt = $row2['bo_count_comment'] ? number_format($row2['bo_count_comment']).'개' : '-';
			$total_post = $total_post + $row2['bo_count_write'];
			$total_cmt = $total_cmt + $row2['bo_count_comment'];

			$read_point = $row2['bo_read_point'] ? number_format($row2['bo_read_point']) : '-';
			$write_point = $row2['bo_write_point'] ? number_format($row2['bo_write_point']) : '-';
			$cmt_point = $row2['bo_comment_point'] ? number_format($row2['bo_comment_point']) : '-';
			$down_point = $row2['bo_download_point'] ? number_format($row2['bo_download_point']) : '-';

			// Amina
			$row3 = sql_fetch(" select * from {$g4['amina']} where bo_table = '{$row2['bo_table']}' limit 0,1 ");

			$good_repoint = $row3['good_repoint'] ? '('.number_format($row3['good_repoint']).')' : '';
			$good_point = $row3['good_point'] ? number_format($row3['good_point']).$good_repoint : '-';
			$cmt_good_point = $row3['cmt_point'] ? number_format($row3['cmt_point']) : '-';
			$star_repoint = $row3['star_repoint'] ? '('.number_format($row3['star_repoint']).')' : '';
			$star_point = $row3['star_point'] ? number_format($row3['star_point']).$star_repoint : '-';
			$poll_point = $row3['poll_point'] ? number_format($row3['poll_point']) : '-';
			$choice_point = $row3['cmt_choice_return'] ? number_format($row3['cmt_choice_return']).'%' : '-';

			$n++;
		?>
		<tr>
		<? if($k==0) { ?>
			<td rowspan="<?=mysql_num_rows($result2)?>"><b><!--<a href="<?=G5_BBS_URL?>/group.php?gr_id=<?=$row['gr_id']?>"> --><?=$row['gr_subject']?></a></b></td>
		<? } ?>
		<td><a href="<?=G5_BBS_URL?>/board.php?bo_table=<?=$row2['bo_table']?>"><?=get_text($row2['bo_subject'])?></a></td>
		<td class="pt"><?=$read_point?></td>
		<td class="pt"><?=$write_point?></td>
		<td class="pt"><?=$cmt_point?></td>
		<td class="pt"><?=$down_point?></td>
		<td class="pt"><?=$good_point?></td>
		<td class="pt"><?=$cmt_good_point?></td>
		<td class="pt"><?=$star_point?></td>
		<td class="pt"><?=$poll_point?></td>
		<td class="pt"><?=$choice_point?></td>
		</tr>
	<? } ?>
<?}?>
</tbody>
</table>

<br>

<ol class="ul_li">
	<li> 추천(보상) : 추천 또는 비추천시 포인트 ( 추천 또는 비추천 받은 글쓴이에게 보상 포인트 ) 
	<li> 별점(보상) : 별점 주기 참여시 받는 포인트 ( 별점 받은 글쓴이에게 적립되는 포인트 )
	<li> 댓글공감 : 댓글 공감시 포인트 적립 ( 공감 받은 글쓴이에게 포인트 적립 )
	<li> 채택보상 : 질문 또는 게시글에 대한 댓글의 채택(당첨, 선정)시 건 포인트의 일정 % 를 돌려 받음
	<li> 그 외에 열람, 다운, 채택(당첨, 선정), 럭키포인트 등에 의해 추가 포인트 적립이 있음
</ol>

<br>

<div class="sub_title">4. 레벨별 경험치 안내</div>

<?
	//Exp
	$xp_point = $xp['xp_point'];
	$xp_max = $xp['xp_max'];
	$xp_rate = $xp['xp_rate'];
?>

<table border=0 class="html_tbl2">
<col width=100><col width=160><col width=160><col width=160>
<thead>
<tr>
<th scope="col">레벨</th>
<th scope="col">최소 경험치</th>
<th scope="col">최대 경험치</th>
<th scope="col">레벨업 경험치</th>
<th scope="col">비고</th>
</tr>
</thead>
<tbody>
<tr>
<td><?=xp_icon('@member', 1)?></td>
<td>0</td>
<td><?=number_format($xp_point)?></td>
<td><?=number_format($xp_point)?></td>
<td></td>
</tr>
<?
	$min_xp = $xp_point;
	for ($i=2; $i <= $xp_max; $i++) {
		$xp_plus = $xp_point + $xp_point * ($i - 1) * $xp_rate;
		$max_xp = $min_xp + $xp_plus;
?>
	<tr>
	<td><?=xp_icon('@member', $i)?></td>
	<td><?=number_format($min_xp)?></td>
	<td><?=number_format($max_xp)?></td>
	<td><?=number_format($xp_plus)?></td>
	<td>&nbsp;</td>
	</tr>
		
<?	$min_xp = $max_xp; } ?>
<tr bgcolor="#fafafa">
<td><?=xp_icon('@admin', 0)?></td>
<td>관리자</td>
<td>-</td>
<td>-</td>
<td></td>
</tr>
<tr bgcolor="#fafafa">
<td><?=xp_icon('@special', 0)?></td>
<td>스페셜</td>
<td>-</td>
<td>-</td>
<td></td>
</tr>
</tbody>
<tfoot>
<tr bgcolor="#fafafa">
<td><?=xp_icon('', 0)?></td>
<td>비회원</td>
<td>-</td>
<td>-</td>
<td></td>
</tr>
</tfoot>
</table>

<br>

<div class="sub_title">5. 게시물 규제정책</div>

<p>본 사이트의 게시물 규제정책은 방송통신심의위원회의 SafeNet 등급기준에 대한 연령별 권장사항 중 12세 이상 (중학생가) 레벨을 따르고자 노력합니다.</p>

<p>본 사이트의 각종 게시판에 게시자가 올린 게시물이 아래과 같은 게시물에 해당되는 경우 관리자는 사전 통지 없이 해당 게시물을 삭제할 수 있으며, 이를 작성한 게시자는 웹사이트의 이용이 차단될 수 있습니다. 또한, 명예훼손 및 저작권침해에 해당 되는 내용에 대해서는 사이버 명예 훼손 분쟁 조정부(http://www.bj.or.kr) 또는 저작권 보호센터(http://www.cleancopyright.or.kr)에 신고될 수 있습니다.</p>

<ol>
	<li>인종이나 성(性), 국적, 종교적, 정치적 분쟁 등 사회문화적 편견에 기반을 둔 내용의 글
	<li>자신 또는 타인의 전화번호, 주민등록번호, 실명등의 개인정보를 포함하고 있는 글
	<li>회사가 인정하지 않는 프로그램, 부적절한 파일 등의 유포나 사용을 유도하는 글
	<li>회사에서 규정한 게시물 원칙에 어긋나거나, 게시판 성격에 부합하지 않는 글
	<li>와레즈사이트, 토렌트사이트 또는 이와 유사한 사이트를 소개, 권유하는 글
	<li>회사 또는 회사 임직원을 사칭하거나 회사 및 회사 임직원을 비방하는 글
	<li>회사에서 판매하였거나 판매하는 제품을 허락없이 재판매하는 글
	<li>같은 내용을 의도적으로 수 차례에 걸쳐 반복적으로 게재한 글
	<li>도배 또는 욕설, 음란한 단어 및 표현을 포함한 글
	<li>이용약관 및 관련법령에 위배되는 내용의 글
	<li>현행법상 처벌의 근거가 되는 글
	<li>관계법령에 위배된다고 판단되는 글
	<li>불법복제 또는 해킹을 조장하는 내용의 글
	<li>저작권 침해 및 이와 유사한 내용을 담은 글
	<li>타인에게 불쾌감이나 혐오감을 줄 수 있는 글
	<li>기타 게시판의 성격에 맞지 않는다고 판단되는 글
	<li>기타 정당한 권한 없이 타인의 권리를 침해하는 내용
	<li>공공질서 및 미풍양속에 위반되는 내용이나 링크를 포함한 글
	<li>회사의 자산을 악의적으로 평가 저하시키려는 내용이 포함된 글
	<li>계정거래, 현금거래 등 불법적인 시도 또는 타 고객들을 선동하는 글
	<li>허위사실을 유포하거나 다수의 고객에게 오해를 불러일으킬 수 있는 내용의 글
	<li>다른 회원 또는 제3자에게 불쾌감을 주거나 비방함으로써 명예를 손상시키는 글
	<li>회사 또는 타인을 비방하거나 중상 모략으로 명예를 훼손시키거나 모욕을 주는 글
	<li>회사에서 인정하지 않은 영리를 목적으로 하거나 광고 및 홍보 또는 그와 유사한 내용임이 객관적으로 확인되는 글
</ol>

<br>

<div class="sub_title">6. 이메일 무단수집 거부</div>

<p>본 사이트에 게시된 이메일 주소가 전자우편 수집 프로그램이나 그 밖의 기술적 장치를 이용하여 무단으로 수집 되는 것을 거부하며, 이를 위반시 정보 통신망법에 의해 형사처벌됨을 유념하시기 바랍니다.</p>

<b>■ 정보통신망법 제50조의2(전자우편주소의 무단 수집행위 등 금지) - <span style="color:red;">위반 시 1천만원 이하의 벌금</span></b>

<ol>
<li>누구든지 전자우편주소의 수집을 거부하는 의사가 명시된 인터넷 홈페이지에서 자동으로 전자우편주소를 수집하는 프로그램이나 그 밖의 기술적 장치를 이용하여 전자우편주소를 수집하여서는 아니된다. 
<li>누구든지 제1항의 규정을 위반하여 수집된 전자우편주소를 판매 유통하여서는 아니된다. 
<li>누구든지 제1항 및 제2항의 규정에 의하여 수집·판매 및 유통이 금지된 전자우편주소임을 알고 이를 정보 전송에 용하여서는 아니된다. 
</ol>

<br>

<div class="sub_title">7. 책임의 한계와 법적고지</div>

<p>본 사이트는 링크, 다운로드, 광고 등을 포함하여 본 사이트에 포함되어 있거나, 본 사이트를 통해 배포, 전송되거나, 본 사이트에 포함되어 있는 서비스로부터 접근되는 정보(이하 "자료")의 정확성이나 신뢰성에 대해 어떠한 보증도 하지 않으며, 서비스상의, 또는 서비스와 관련된 광고, 기타 정보 또는 제안의 결과로서 디스플레이, 구매 또는 취득하게 되는 제품 또는 기타 정보(이하 "제품")의 질에 대해서도 어떠한 보증도 하지 않습니다.</p>

<p>귀하는 자료에 대한 신뢰 여부가 전적으로 귀하의 책임임을 인정합니다. 사이트는 자료 및 서비스의 내용을 수정할 의무를 지지 않으나, 필요에 따라 개선할 수는 있습니다.</p>

<p>사이트는 자료와 서비스를 "있는 그대로" 제공하며, 서비스 또는 기타 자료 및 제품과 관련하여 상품성, 특정 목적에의 적합성에 대한 보증을 포함하되 이에 제한되지 않고 모든 명시적 또는 묵시적인 보증을 명시적으로 부인합니다. 어떠한 경우에도 서비스, 자료 및 제품과 관련하여 직접, 간접, 부수적, 징벌적, 파생적인 손해에 대해서 책임을 지지 않습니다. 따라서 본 사이트를 통하여 인터넷을 접속함에 있어 사용자의 개인적인 판단에 따라 하시기를 바랍니다. </p>

<p>본 사이트를 통해 일부 사람들이 불쾌하거나 부적절 하다고 여기는 정보가 포함되어 있는 사이트로 연결될 수 있습니다. 
이와 관련하여 본 사이트 또는 자료에 열거되어 있는 사이트의 내용을 검토하려는 노력과 관련하여 어떠한 보증도 하지 않습니다. 또한 본 사이트 또는 자료에 열거되어 있는 사이트 상의 자료의 정확성, 저작권 준수, 적법성 또는 도덕성에 대해 아무런 책임을 지지 않습니다. </p>

<p>본 사이트는 지적재산권을 포함한 타인의 권리를 존중하며, 사용자들도 마찬가지로 행동해 주시기를 기대합니다. 본 사이트는 필요한 경우 그 재량에 의해 타인의 권리를 침해하거나 위반하는 사용자에 대하여 사전 통지 없이 서비스 이용 제한 조치를 취할 수 있습니다. </p>

<p>본 사이트는 책임의 한계와 법적고지의 내용을 인터넷산업의 상관례에 맞추어 적절한 방법으로 사전 통지없이 수시로 변경할 수 있습니다. 또한 책임의 한계와 법적고지사항에서 다루고 있는 세부사항들은 관계당사자들간의 총체적인 합의사항이며, 본 사이트의 개별서비스에서 정하고 있는 별도의 약관, 고지사항 등과 상충되는 경우에는 별도의 약관 또는 고지사항을 우선 적용합니다.</p> 

<br>

<p>부 칙(시행일) 본 방침은 2012년 07월 01일부터 시행합니다.</p>

</div>
<br><br><br>
