<?php
include_once('./_common.php');

include_once(AMINA_PATH.'/lib/head.lib.php');


//설정값
if(!$lat) $lat = '37.566535';
if(!$lng) $lng = '126.977969';
if(!$zoom) $zoom = 14;

?>
<!doctype html>
<html lang="ko">
<head>
<meta charset="utf-8">
<?php if (G5_IS_MOBILE) {?>
	<meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=0,maximum-scale=10,user-scalable=yes">
	<meta name="HandheldFriendly" content="true">
	<meta name="format-detection" content="telephone=no">
<? } ?>
<title>구글지도보기</title>
<style>
	body { margin:0; padding:0; font:normal 12px dotum; -webkit-text-size-adjust:100%; }
</style>
<script src="http://maps.google.com/maps/api/js?v=3.3&sensor=false&language=ko"></script>
<script>
	// 구글맵
	var map;
	var marker;
	var infowindow;

	function addLoadEvent(func) {
		var oldonload = window.onload;
		if (typeof window.onload != 'function') {
			window.onload = func;
		} else {
			window.onload = function() {
				if (oldonload) {
					oldonload();
				}
				func();
			}
		}
	}

	function initialize() {
		var myLatlng = new google.maps.LatLng("<?php echo $lat; ?>", "<?php echo $lng; ?>");
		var myOptions = {
			zoom: <?php echo $zoom; ?>,
			scaleControl: true,

			navigationControl: true,
			navigationControlOptions: {
					style: google.maps.NavigationControlStyle.SMALL,
					position: google.maps.ControlPosition.TOP_RIGHT
			},

			center: myLatlng,
			mapTypeId: google.maps.MapTypeId.ROADMAP
		}
		map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);

		infowindow = new google.maps.InfoWindow();

		google.maps.event.addListener(map, 'zoom_changed', function() {
			zoomLevel = map.getZoom(); 
			if (zoomLevel > 19) { 
			  map.setZoom(19); 
			}   
			if (zoomLevel < 1) { 
			  map.setZoom(1); 
			}   
		});

		marker = new google.maps.Marker({
			position: myLatlng,
			map: map
		});

		infowindow.setContent("<?php echo $marker; ?>");
		infowindow.open(map,marker);
	}
</script>
</head>
<body>
	<div id="map_canvas" class="google_map" style="width:100%; height:<?php echo $height; ?>px;"></div>
	<script> addLoadEvent(initialize); </script>
</body>
</html>