<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
//pc skin 정의
$board_pc_path = str_replace("/mobile","",$board_skin_path);
$board_pc_url = str_replace("/mobile","",$board_skin_url);
include_once($board_pc_path.'/ladder.lib.php');
include_once(G5_PLUGIN_PATH.'/jquery-ui/datepicker.php');
// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_pc_url.'/style.css">', 0);
add_javascript('<script src="'.$board_pc_url.'/js/jquery.mask.min.js"></script>', 1);
add_javascript('<script src="'.$board_pc_url.'/js/jquery.mask.opt.js"></script>', 1);

if(!$is_admin) {
    alert('관리자만 접속 가능합니다.');
    return;
}

?>


    <div class="board_list_top flex-row flex-justify-between mobile_padding">
        <ul class="board_category flex-row">
        </ul>
        <ul class="board_category flex-row">
            <li><a href="<?php echo get_pretty_url($bo_table) ?>" class="">게임목록</a></li>
        </ul>
    </div>

    <div id="board_write" class="mobile_padding">
        <?php if(!$board['bo_1']) { ?>
        <div class="div_write flex-row flex-justify-between">
            <div class="write_form flex-col">
                <div class="input-form-group">
                    <div class="input-form-tle adm"><span>게시판테이블명</span></div>
                    <div class="input-form-field">
                        <input type="text" name="bo_1" class="input-type-text" value="<?php echo $bo_table?>" placeholder="" readonly>
                        <button type="button" id="crt">게임 DB 생성</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="div_write flex-row flex-justify-between">
            <div class="write_form flex-col">
                <div class="input-form-explain adm"><div class="alert_info"><span>게임데이터베이스 생성 및 게임 기본환경을 설정합니다. .<br>게시판테이블명은 게시판테이블(board_table) 칼럼 bo_1에 저장됩니다.<br>게시판테이블명을 변경하거나 삭제하시면 게임DB가 초기화됩니다.</span></div></div>
            </div>
        </div>
        <?php } else { ?>
        <b id="msg" class="adm_msg"></b>
        <form name="admform">
        <input type="hidden" name="act" value="adm">
        <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
        <div class="div_write flex-row flex-justify-between">
            <div class="write_form flex-col">
                <div class="input-form-group">
                    <div class="input-form-tle adm"><span>사다리수(최소)</span></div>
                    <div class="input-form-field">
                        <input type="number" name="bo_2" class="input-type-text" value="<?php echo $board['bo_2']?>" min="3" placeholder="">
                    </div>
                </div>
            </div>
        </div>
        <div class="div_write flex-row flex-justify-between">
            <div class="write_form flex-col">
                <div class="input-form-group">
                    <div class="input-form-tle adm"><span>사다리수(최대)</span></div>
                    <div class="input-form-field">
                        <input type="number" name="bo_3" class="input-type-text" value="<?php echo $board['bo_3']?>" max="6" placeholder="">
                    </div>
                </div>
            </div>
        </div>
        <div class="div_write flex-row flex-justify-between">
            <div class="write_form flex-col">
                <div class="input-form-group">
                    <div class="input-form-tle adm"><span>게임생성 레벨</span></div>
                    <div class="input-form-field">
                        <input type="text" name="bo_4" class="input-type-text" value="<?php echo $board['bo_4']?>" placeholder="">
                    </div>
                </div>
            </div>
        </div>
        <div class="div_write flex-row flex-justify-between">
            <div class="write_form flex-col">
                <div class="input-form-explain adm"><div class="alert_info"><span>게임을 생성할 수 있는 레벨입니다.<br>2~9를 입력할 경우 회원레벨로 제한이 됩니다.<br>11이상 입력할 경우 회원포인트로 제한됩니다.<br>ex) 3입력시 3레벨부터, 20,000 입력시 20,000포인트 이상 보유시 생성 가능</span></div></div>
            </div>
        </div>
        <div class="div_write flex-row flex-justify-between">
            <div class="write_form flex-col">
                <div class="input-form-group">
                    <div class="input-form-tle adm"><span>최소사용포인트</span></div>
                    <div class="input-form-field">
                        <input type="text" name="bo_5" class="input-type-text" value="<?php echo $board['bo_5']?>" placeholder="">
                    </div>
                </div>
            </div>
        </div>
        <div class="div_write flex-row flex-justify-between">
            <div class="write_form flex-col">
                <div class="input-form-explain adm"><div class="alert_info"><span>게임 생성 시 최소 사용해야 하는 포인트 입니다.</span></div></div>
            </div>
        </div>
        <div class="div_write flex-row flex-justify-between">
            <div class="write_form flex-col">
                <div class="input-form-group">
                    <div class="input-form-tle adm"><span>이벤트게임생성</span></div>
                    <div class="input-form-field">
                        <select name="bo_7">
                            <?php
                            for($i=2;$i<10;$i++) {
                                $_select = '';
                                if($board['bo_7'] == $i) {
                                    $_select = 'selected';
                                }
                                echo '<option value="'.$i.'" '.$_select.'>'.$i.'레벨</option>';
                            }
                            ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <div class="div_write flex-row flex-justify-between">
            <div class="write_form flex-col">
                <div class="input-form-explain adm"><div class="alert_info"><span>이벤트 게임 생성이 가능한 회원레벨입니다.</span></div></div>
            </div>
        </div>
        
        <div class="div_write write_btn flex-row flex-justify-between">
            <div class="write_form flex-col-6 p_right_5">
                <a href="<?php echo get_pretty_url($bo_table); ?>" class="btn btn_cancel">취소</a>
            </div>
            <div class="write_form flex-col-6 p_left_5">
                <button type="button" id="btn_submit" accesskey="s" class="btn btn_submit">확인</button>
            </div>
        </div>
        </form>
        <?php } ?>
    </div>
<script>
$(function() {
    $('#crt').on('click', function() {
        var $this = $(this),
            $wrap = $this.closest('form');
        console.log('1111');
        $.ajax({
            type: "POST",
            data: {act:'crt',bo_table:g5_bo_table},
            url:'<?php echo $board_pc_url ?>/ajax.ladder.php',
            success: function(data) {
                location.reload(true);
            }
        });
    });

    $('#btn_submit').on('click', function() {
        var $this = $(this),
            $wrap = $this.closest('form');
        $.ajax({
            type: "POST",
            data: $wrap.serialize(),
            url:'<?php echo $board_pc_url ?>/ajax.ladder.php',
            success: function(data) {
                console.log(data);
                $('#msg').text(data.message);
                $('#msg').fadeIn(200).delay(2500).fadeOut(200);
            }
        });
    });
    $('input[name="bo_4"],input[name="bo_5"]').mask("#,##0", {reverse: true});
});
</script>