<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
$board_pc_path = str_replace("/mobile","",$board_skin_path);
$board_pc_url = str_replace("/mobile","",$board_skin_url);
include_once($board_pc_path.'/ladder.lib.php');
//글쓰기버튼 재설정
$write_href = '';
if( ($member['mb_level'] >= $create_user && $create_user < 10) || ($member['mb_point'] >= $create_point && $create_point > 10) || $is_admin) {
    $write_href = short_url_clean(G5_BBS_URL.'/write.php?bo_table='.$bo_table);
}

// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 5;

if ($is_checkbox) $colspan++;
if ($is_good) $colspan++;
if ($is_nogood) $colspan++;

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_pc_url.'/style.css">', 0);
?>

<!-- 게시판 목록 시작 { -->
<div id="board_list">

    <?php if($pagetype == 'my') { ?>
        <?php include_once($board_pc_path.'/my.list.skin.php'); ?>
    <?php } else if($pagetype == 'adm' || $board['bo_1'] != $bo_table) { ?>
        <?php include_once($board_pc_path.'/adm.skin.php'); ?>
    <?php } else { ?>
    <div class="board_btn_wrap flex-row flex-justify-between mobile_padding">
        <div class="btn_wrap">
            <?php if($is_admin == 'super' || $is_auth) { ?>
                <a href="<?php echo get_pretty_url($bo_table,'','pagetype=adm'); ?>" id="is_run" class="btn btn-dark">게임설정</a>
            <?php } ?>
        </div>
        <div class="btn_wrap">
            <a href="<?php echo get_pretty_url($bo_table,'','pagetype=my'); ?>" class="btn btn-dark" id="mygame">내 게임</a>
            <?php if($write_href) { ?><a href="<?php echo $write_href ?>"class="btn btn-dark">게임만들기</a><?php } ?>
        </div>
    </div>
    
    <form name="fboardlist" id="fboardlist" action="<?php echo G5_BBS_URL; ?>/board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
    <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
    <input type="hidden" name="stx" value="<?php echo $stx ?>">
    <input type="hidden" name="spt" value="<?php echo $spt ?>">
    <input type="hidden" name="sca" value="<?php echo $sca ?>">
    <input type="hidden" name="sst" value="<?php echo $sst ?>">
    <input type="hidden" name="sod" value="<?php echo $sod ?>">
    <input type="hidden" name="page" value="<?php echo $page ?>">
    <input type="hidden" name="sw" value="">

    <!--게시판 페이지 정보 및 카테고리 시작-->
    <div class="board_list_top flex-row flex-justify-between mobile_padding">
        <ul class="board_category flex-row">
            <li><a href="<?php echo get_pretty_url($bo_table) ?>" class="<?php if(!$sca) { echo 'active'; }?>">전체게임<span class="mobile_none">(<?php echo $total_count ?>)</span></a></li>
            <?php
            $categories = explode('|', $board['bo_category_list']);
            foreach($categories as $v) {
                $category = trim($v);
                if ($category=='') continue;
                //카테고리 글 갯수
                $cate_cnt = sql_fetch("select count(wr_id) as cnt from {$write_table} where ca_name = '{$v}'");
                $active = ($category==$sca) ? 'active':'';
                echo '<li><a href="'.(get_pretty_url($bo_table,'','sca='.urlencode($category).'&amp;sfl='.$sfl.'&amp;stx='.$stx)).'" class="'.$active.'">'.$category.'<span class="mobile_none">('.$cate_cnt['cnt'].')</span></a></li>';
            }
            ?>
        </ul>
        <ul class="board_category cr flex-row">
            <li><a href="<?php echo short_url_clean(G5_BBS_URL.'/board.php?bo_table='.$bo_table.'&amp;sca='.urlencode($sca).'&amp;sfl=wr_10&amp;stx=진행') ?>" class="<?php echo ($sfl=='wr_10'&&$stx=='진행')? 'active':'' ?>">진행중</a></li>
            <li><a href="<?php echo short_url_clean(G5_BBS_URL.'/board.php?bo_table='.$bo_table.'&amp;sca='.urlencode($sca).'&amp;sfl=wr_10&amp;stx=종료') ?>" class="<?php echo ($sfl=='wr_10'&&$stx=='종료')? 'active':'' ?>">종료</a></li>
            <li><a href="<?php echo short_url_clean(G5_BBS_URL.'/board.php?bo_table='.$bo_table.'&amp;sca='.urlencode($sca).'&amp;sfl=wr_10&amp;stx=대기') ?>" class="<?php echo ($sfl=='wr_10'&&$stx=='대기')? 'active':'' ?>">대기중</a></li>
        </ul>
    </div>
    <!--게시판 페이지 정보 및 카테고리 끝-->
    <div class="board_list_table mobile_padding">
        <div class="board_list board_list_head flex-row flex-justify-between">
            <div class="wr_num">번호</div>
            <div class="wr_caname">구분</div>
            <div class="wr_caname">추첨</div>
            <div class="wr_subject">제목</div>
            <div class="wr_num">전체픽</div>
            <div class="wr_num">참여</div>
            <div class="wr_num">남은픽</div>
            <div class="wr_date">종료일</div>
            <div class="wr_state">상태</div>
        </div>
        <ul class="board_list_body">
        <?php
        for($i=0;$i<count($list);$i++) {
            $bg = 'bg'.($i%2);
            //분류
            $game_type = '';
            if($list[$i]['wr_1'] == 'gift') {
                $game_type = '이벤트';
            } else {
                $giftlist = unserialize($list[$i]['wr_3']);
                $game_type = max($giftlist['user_offer']);
                $game_type = 'X'.$game_type;
            }
            $draw_type = $list[$i]['wr_draw_type'] == '1' ? '즉시' : '종료후';
            $totaluser = number_format($list[$i]['wr_7']);
            $pick = sql_fetch("select count(gl_id) as cnt from {$g5['g5_game_ladder_join']} where bo_table='{$bo_table}' and wr_id='{$list[$i]['wr_id']}'");
            $pickuser = number_format($pick['cnt']);
            $spareuser = number_format($list[$i]['wr_7'] - $pick['cnt']);
            $per = ($pick['cnt']/$list[$i]['wr_7']) * 100;
            $per_txt = round($per,1);
            if($per < 10) {
                $per = 10;
            }
            echo '<li class="board_list flex-row flex-justify-between '.$bg.'">';
                echo '<div class="wr_num">'.$list[$i]['num'].'</div>';
                echo '<div class="wr_caname">'.$game_type.'</div>';
                echo '<div class="wr_caname">'.$draw_type.'</div>';
                echo '<div class="wr_subject"><a href="'.$list[$i]['href'].'">'.$list[$i]['subject'].'</a></div>';
                echo '<div class="wr_num">'.number_format($totaluser).'명</div>';
                echo '<div class="wr_num">'.number_format($pick['cnt']).'명</div>';
                echo '<div class="wr_num">'.number_format($spareuser).'명</div>';
                echo '<div class="wr_date">'.substr($list[$i]['wr_9'],5,5).'</div>';
                echo '<div class="wr_state">'.$list[$i]['wr_10'].'</div>';
            echo '</li>';
        }
        ?>
        </ul>
    </div>
    
    </form>
    <!-- 페이지 -->
	<?php echo $write_pages; ?>
	<!-- 페이지 -->
    <?php } ?>
</div>

<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = g5_bbs_url+"/board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == "copy")
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = g5_bbs_url+"/move.php";
    f.submit();
}

// 게시판 리스트 관리자 옵션
jQuery(function($){
    $(".btn_more_opt.is_list_btn").on("click", function(e) {
        e.stopPropagation();
        $(".more_opt.is_list_btn").toggle();
    });
    $(document).on("click", function (e) {
        if(!$(e.target).closest('.is_list_btn').length) {
            $(".more_opt.is_list_btn").hide();
        }
    });
});
</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->
