<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

if (!$board['bo_use_sns']) return;

$sns_url = G5_BBS_URL.'/board.php?bo_table='.$bo_table.'&amp;'.'wr_id='.$wr_id;

$sns_txt = strip_tags($subject);
$sns_txt = str_replace(array("\"","'","","‘","’"),array("","","","",""),$sns_txt);
$sns_msg = str_replace('\"', '"', $sns_txt);

$sns_send  = G5_BBS_URL.'/bbs/sns_send.php?longurl='.urlencode($sns_url).'&amp;title='.$sns_msg;

$facebook_url = $sns_send.'&amp;sns=facebook';
$twitter_url  = $sns_send.'&amp;sns=twitter';
$gplus_url = $sns_send.'&amp;sns=gplus';
$naverband_url = $sns_send.'&amp;sns=naverband';
$kakaostory_url = $sns_send.'&amp;sns=kakaostory';
$naver_url = $sns_send.'&amp;sns=naver';
$tumblr_url = $sns_send.'&amp;sns=tumblr';
$bo_v_sns_class = $config['cf_kakao_js_apikey'] ? 'show_kakao' : '';
?>

<?php if($config['cf_kakao_js_apikey']) { ?>
<script src="//developers.kakao.com/sdk/js/kakao.min.js" charset="utf-8"></script>
<script src="<?php echo G5_JS_URL; ?>/kakaolink.js" charset="utf-8"></script>
<script type='text/javascript'>
    //<![CDATA[
        // 사용할 앱의 Javascript 키를 설정해 주세요.
        Kakao.init("<?php echo $config['cf_kakao_js_apikey']; ?>");

        function Kakao_sendLink() {
            var webUrl = location.protocol+"<?php echo '//'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']; ?>",
                imageUrl = $("#bo_v_img").find("img").attr("src") || $(".view_image").find("img").attr("src") || '';

            Kakao.Link.sendDefault({
                objectType: 'feed',
                content: {
                    title: "<?php echo str_replace(array('%27', '&#034;' , '\"'), '', strip_tags($view['subject'])); ?>",
                    description: "<?php echo preg_replace('/\r\n|\r|\n/','', strip_tags(get_text(cut_str(strip_tags($view['wr_content']), 200), 1))); ?>",
                    imageUrl: imageUrl,
                    link: {
                        mobileWebUrl: webUrl,
                        webUrl: webUrl
                    }
                },
                buttons: [{
                    title: '자세히 보기',
                    link: {
                        mobileWebUrl: webUrl,
                        webUrl: webUrl
                    }
                }]
            });
        }
    //]]>
</script>
<?php } ?>

<?php
$basic_url = G5_BBS_URL.'/board.php?bo_table='.$bo_table.'&'.'wr_id='.$wr_id;
$twitter_url  = "https://twitter.com/intent/tweet?url=".urlencode($basic_url)."&text=".urlencode($sns_msg)."&hashtags=";
$facebook_url = "http://www.facebook.com/sharer/sharer.php?s=100&u=".urlencode($basic_url)."&p=".urlencode($sns_msg);
$kakaostory_url = "https://story.kakao.com/share?url=".urlencode($basic_url);
$naverband_url = "http://www.band.us/plugin/share?route=todaygiregi.com&body=".urlencode($basic_url .' ' . $sns_msg);
$naver_url = "http://share.naver.com/web/shareView.nhn?url=".urlencode(urlencode($basic_url))."&title=".urlencode($sns_msg);
$tumblr_url = "http://tumblr.com/widgets/share/tool?canonicalUrl=".urlencode($basic_url);
?>

<script>
// SNS
function send_sns_win(id, url) {
    switch(id) {
        case 'facebook'		: window.open(url, "win_facebook", "menubar=0,resizable=1,width=600,height=400"); break;
        case 'twitter'		: window.open(url, "win_twitter", "menubar=0,resizable=1,width=600,height=400"); break;
        case 'googleplus'	: window.open(url, "win_googleplus", "menubar=0,resizable=1,width=600,height=600"); break;
        case 'naverband'	: window.open(url, "win_naverband", "menubar=0,resizable=1,width=410,height=540"); break;
        case 'naver'		: window.open(url, "win_naver", "menubar=0,resizable=1,width=450,height=540"); break;
        case 'kakaostory'	: window.open(url, "win_kakaostory", "menubar=0,resizable=1,width=500,height=500"); break;
        case 'tumblr'		: window.open(url, "win_tumblr", "menubar=0,resizable=1,width=540,height=600"); break;
        case 'pinterest'	: window.open(url, "win_pinterest", "menubar=0,resizable=1,width=800,height=500"); break;
    }
    return false;
}
</script>
<ul id="bo_v_sns" class="<?php echo $bo_v_sns_class; ?>">
	<li><a href="<?php echo $facebook_url; ?>" onclick="send_sns_win('facebook','<?php echo $facebook_url; ?>'); return false;" target="_blank"><img src="<?php echo $board_pc_url; ?>/img/facebook.png" alt="페이스북으로 보내기"></a></li>
    <li><a href="<?php echo $twitter_url; ?>" onclick="send_sns_win('twitter','<?php echo $twitter_url; ?>'); return false;" target="_blank"><img src="<?php echo $board_pc_url; ?>/img/twitter.png" alt="트위터로 보내기"></a></li>
    <li><a href="<?php echo $kakaostory_url; ?>" onclick="send_sns_win('kakaostory','<?php echo $kakaostory_url; ?>'); return false;" target="_blank"><img src="<?php echo $board_pc_url; ?>/img/kakaostory.png" alt="카카오스토리로 보내기"></a></li>
    <?php if($config['cf_kakao_js_apikey']) { ?>
	    <li><a href="javascript:kakaolink_send('<?php echo str_replace(array('%27', '\''), '', $sns_txt); ?>', '<?php echo $sns_url; ?>','<?php echo $seometa['img']['src'];?>');"><img src="<?php echo $board_pc_url; ?>/img/kakaotalk.png" alt="카카오톡으로 보내기"></a></li>
    <?php } ?>
	<li><a href="<?php echo $naverband_url; ?>" onclick="send_sns_win('naverband','<?php echo $naverband_url; ?>'); return false;" target="_blank"><img src="<?php echo $board_pc_url; ?>/img/naverband.png" alt="네이버밴드로 보내기"></a></li>
	<li><a href="<?php echo $naver_url; ?>" onclick="send_sns_win('naver','<?php echo $naver_url; ?>'); return false;" target="_blank"><img src="<?php echo $board_pc_url; ?>/img/naver.png" alt="네이버로 보내기"></a></li>
	<li><a href="<?php echo $tumblr_url; ?>" onclick="send_sns_win('tumblr','<?php echo $tumblr_url; ?>'); return false;" target="_blank"><img src="<?php echo $board_pc_url; ?>/img/tumblr.png" alt="텀블러로 보내기"></a></li>
</ul>
