<?php
$sub_menu = "100290";
include_once('./_common.php');

if ($is_admin != 'super') {
    alert('최고관리자만 접근 가능합니다.');
}

// 메뉴테이블 생성
if( !isset($g5['menu_table']) ){
    die('<meta charset="utf-8">dbconfig.php 파일에 <strong>$g5[\'menu_table\'] = G5_TABLE_PREFIX.\'menu\';</strong> 를 추가해 주세요.');
}

if(!sql_query(" DESCRIBE {$g5['menu_table']} ", false)) {
    sql_query(" CREATE TABLE IF NOT EXISTS `{$g5['menu_table']}` (
                  `me_id` int(11) NOT NULL AUTO_INCREMENT,
                  `me_code` varchar(255) NOT NULL DEFAULT '',
                  `me_name` varchar(255) NOT NULL DEFAULT '',
                  `me_link` varchar(255) NOT NULL DEFAULT '',
                  `me_target` varchar(255) NOT NULL DEFAULT '0',
                  `me_order` int(11) NOT NULL DEFAULT '0',
                  `me_use` tinyint(4) NOT NULL DEFAULT '0',
                  `me_mobile_use` tinyint(4) NOT NULL DEFAULT '0',
                  `me_parent` int(11) NOT NULL,
                  `me_depth` tinyint(4) NOT NULL,
                  `me_type` varchar(25) DEFAULT '' NOT NULL,
                  `me_cate` varchar(25) DEFAULT '' NOT NULL,
                  PRIMARY KEY (`me_id`),
                  UNIQUE KEY `me_code` (`me_code`)
                ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ", true);
}

//필드 추가
if(!sql_query(" select `me_parent` from {$g5['menu_table']} limit 1 ", false)) {
    $sql = " ALTER TABLE `{$g5['menu_table']}`  ADD `me_parent` int(11) NOT NULL ";
    sql_query($sql, false);
    sql_query("ALTER TABLE `{$g5['menu_table']}` ADD UNIQUE `UNI` (`me_code`)");
}
if(!sql_query(" select `me_depth` from {$g5['menu_table']} limit 1 ", false)) {
    $sql = " ALTER TABLE `{$g5['menu_table']}`  ADD `me_depth` tinyint(4) NOT NULL ";
    sql_query($sql, false);
}
if(!sql_query(" select `me_type` from {$g5['menu_table']} limit 1 ", false)) {
    $sql = " ALTER TABLE `{$g5['menu_table']}`  ADD `me_type` varchar(25) DEFAULT '' NOT NULL ";
    sql_query($sql, false);
}
if(!sql_query(" select `me_cate` from {$g5['menu_table']} limit 1 ", false)) {
    $sql = " ALTER TABLE `{$g5['menu_table']}`  ADD `me_cate` varchar(25) DEFAULT '' NOT NULL ";
    sql_query($sql, false);
}

$sitemenu = get_menu_data();
$znodeArray = array();
$znodeArray['isRoot'] = true;
$znodeArray['name']   = 'Index';
$znodeArray['meid']   = 0;
$znodeArray['code']   = 0;
$znodeArray['parent'] = 0;
$znodeArray['depth']  = 0;
$znodeArray['open']   = true;
$znodeArray['type']   = 'root';
if(!empty($sitemenu['data'])) {
    foreach($sitemenu['data'] as $k=>$v) {
        $znodeArray['children'][$k]['type']   = 'sub';
        $znodeArray['children'][$k]['meid']   = $v['me_id'];
        $znodeArray['children'][$k]['code']   = $v['me_code'];
        $znodeArray['children'][$k]['name']   = $v['me_name'];
        $znodeArray['children'][$k]['parent'] = $v['me_parent'];
        $znodeArray['children'][$k]['depth']  = $v['me_depth'];
        $znodeArray['children'][$k]['open']   = true;
        if(!empty($v['sub'])) {
            foreach($v['sub'] as $key=>$val) {
                $znodeArray['children'][$k]['children'] = znode_sub($v,0,1);
            }
        }
    }
}

$g5['title'] = "메뉴설정";
include_once('./admin.head.php');
add_stylesheet('<link rel="stylesheet" href="'.G5_PLUGIN_URL.'/ztree/css/zTreeStyle/zTreeStyle.custom.css" />', 1);
add_javascript('<script src="'.G5_PLUGIN_URL.'/ztree/js/jquery.ztree.all.min.js"></script>', 1);
?>
<style>
/* Freeze the Root Node */
.ztree li span.button.switch.level0 {visibility:hidden; width:1px;}
.ztree li ul.level0 {padding:0; background:none;}
.ztree li.level1 span.button.roots_docu,
.ztree li.level1 span.button.center_docu,
.ztree li.level1 span.button.bottom_docu {background-position: -74px -18px;}
.ztree li.level2 span.button.ico_docu{margin-right:6px; background-position:-126px -64px; vertical-align: top; *vertical-align: middle;}
.ztree li.level2 span.button.roots_docu{background-position:-56px 0}
.ztree li.level2 span.button.center_docu{background-position:-56px -18px}
.ztree li.level2 span.button.bottom_docu{background-position:-56px -36px}
.material-icons { font-size:16px; }
.frm_input { min-width: 150px; }
.d-none { display: none; }
.menu_wrap { display: flex; justify-content: space-between; }
.menu_wrap .menu_tree { width: 20%; }
.menu_wrap .menu_tree .menu_box { position: relative; padding: 15px; border: 1px solid #ddd; min-height: 300px; }
.menu_wrap .menu_conf { width: 35%; }
.menu_wrap .menu_head { width: 35%; }
.btn_confirm { display: flex; justify-content: space-between; margin-top: 15px; }
</style>
<div class="menu_wrap">
    <div class="menu_tree">
        <h3 class="h3 mt-3 mb-3">메뉴맵</h3>
        <div class="menu_box">
            <div id="menutree" class="cstree ztree" style="max-height: 500px;overflow-y:auto;"></div>
        </div>
        <div class="btn_confirm">
            <button type="button" class="btn" id="add_depth1"><i class="fa fa-fw fa-lg fa-folder" aria-hidden="true"></i>1단계 메뉴추가</button>
            <button type="button" class="btn d-none" id="add_sub"><i class="fa fa-fw fa-lg fa-star" aria-hidden="true"></i>하위 메뉴추가</button>
        </div>
    </div>
    <div class="menu_conf">
        <div id="menuform" class="menuinfo zinfo" style="display:none">
            <h3 class="h3 mt-3 mb-3" id="sc_title">메뉴명</h3>
            <form name="fmenuform" id="fmenuform" method="post" action="" enctype="multipart/form-data" onsubmit="return fmenuform_submit(this)" class="csform">
            <input type="hidden" name="act" value="update">
            <input type="hidden" name="type" value="sub">
            <input type="hidden" name="me_id" id="me_id" value="">
            <input type="hidden" name="me_code" id="me_code" value="">
            <div class="tbl_frm01 tbl_wrap">
                <table>
                <caption></caption>
                <colgroup>
                    <col width="20%">
                    <col width="80%">
                </colgroup>
                <tbody>
                    <tr>
                        <th><label for="me_type">메뉴분류</label></th>
                        <td>
                            <select name="me_type" id="me_type" class="frm_input">
                                <option value="">분류 선택</option>
                                <option value="group">게시판 그룹</option>
                                <option value="board">게시판</option>
                                <option value="content">내용관리</option>
                                <option value="direct">직접입력</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="me_cate">메뉴선택</label></th>
                        <td>
                            <select name="me_cate" id="me_cate" class="frm_input">
                                <option value="">메뉴 선택</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="me_name">메뉴명</label></th>
                        <td><input type="text" name="me_name" id="me_name" class="frm_input required" value="" maxlength="20" required></td>
                    </tr>
                    <tr>
                        <th><label for="me_link">연결주소</label></th>
                        <td><input type="text" name="me_link" id="me_link" class="frm_input frm_full required" value=""  required></td>
                    </tr>
                    <tr>
                        <th><label for="me_target">새창</label></th>
                        <td>
                            <select name="me_target" id="me_target" class="frm_input">
                                <option value="self">사용안함</option>
                                <option value="blank">사용함</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="me_use">PC사용</label></th>
                        <td>
                            <select name="me_use" id="me_use" class="frm_input">
                                <option value="1">사용함</option>
                                <option value="0">사용안함</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="me_mobile_use">모바일사용</label></th>
                        <td>
                            <select name="me_mobile_use" id="me_mobile_use" class="frm_input">
                                <option value="1">사용함</option>
                                <option value="0">사용안함</option>
                            </select>
                        </td>
                    </tr>
                </tbody>
                </table>
            </div>
            <div class="btn_confirm">
                <button type="button" class="btn btn-primary" id="menuUpateButton">수정</button>
            </div>
            </form>
        </div>
    </div>
    <div class="menu_head"></div>
</div>

<script>
var treeId = "menutree";

function fcoursecate_submit(f)
{
    // ajax update
    // form validate check
    return false;
}

function fmenuform_submit(f)
{
    // ajax update
    // form validate check
    return false;
}


function dropPrev(treeId, nodes, targetNode) {
    //console.log('dropPrev');
    var is_break = false;
    try {
        var pNode = targetNode.getParentNode();
        if (pNode && pNode.dropInner === false) {
            //return false;
        } else {
            for (var i=0,l=curDragNodes.length; i<l; i++) {
                var curPNode = curDragNodes[i].getParentNode();
                // 다른 부모로 이동 불가
                if (curPNode && curPNode !== targetNode.getParentNode()) {
                    //is_break = true;
                    //return false;
                }
                // 다른 레벨로 이동 불가
                if (curPNode && curPNode.level !== targetNode.getParentNode().level) {
                    //is_break = true;
                    //return false;
                }
            }
        }
        //console.log(is_break);
        return true;
    } catch (e) {
    }
}
function dropNext(treeId, nodes, targetNode) {
    try {
        var pNode = targetNode.getParentNode();
        if (pNode && pNode.dropInner === false) {
            return false;
        } else {
            for (var i=0,l=curDragNodes.length; i<l; i++) {
                var curPNode = curDragNodes[i].getParentNode();
                // 다른 부모로 이동 불가
                if (curPNode && curPNode !== targetNode.getParentNode()) {
                    //return false;
                }
                // 다른 레벨로 이동 불가
                if (curPNode && curPNode.level !== targetNode.getParentNode().level) {
                    //return false;
                }
            }
        }
        return true;
    } catch (e) {
    }
}
function dropInner(treeId, nodes, targetNode) {
    try {
        var pNode = targetNode.getParentNode();
        if (pNode && pNode.dropInner === false) {
            return false;
        } else {
                for (var i=0,l=curDragNodes.length; i<l; i++) {
                    var curPNode = curDragNodes[i].getParentNode();
                    // 같은 레벨로 드랍 불가
                    if (curPNode && curPNode.level === targetNode.getParentNode().level) {
                        //return false;
                    }
                    // 하위 레벨로 드랍 불가
                    if (curPNode && curPNode.level < targetNode.level) {
                        //return false;
                    }
                }
        }
        return true;
    } catch (e) {
    }
}

var curDragNodes, autoExpandNode;
function beforeDrag(treeId, treeNodes) {
    //console.log('beforeDrag');
    for (var i=0,l=treeNodes.length; i<l; i++) {
        if (treeNodes[i].drag === false) {
            curDragNodes = null;
            return false;
        } else if (treeNodes[i].parentTId && treeNodes[i].getParentNode().childDrag === false) {
            curDragNodes = null;
            return false;
        }
    }
    curDragNodes = treeNodes || new Array();
    return true;
}
function beforeDrop(treeId, treeNodes, targetNode, moveType, isCopy) { //아래로 이동
    //console.log('beforeDrop');
    return targetNode ? targetNode.drop !== false : true;
}
function onDrag(event, treeId, treeNodes) {
    //console.log('onDrag');
}
function onDrop(event, treeId, treeNodes, targetNode, moveType, isCopy) {
    //console.log('onDrop');
}
function dblClickExpand(treeId, treeNode) {
    return treeNode.level > 0;
}

var newCount = 1;
function addHoverDom(treeId, treeNode) {
    if (treeNode.level >= 5) return; // 2단계까지
    var sObj = $("#" + treeNode.tId + "_span");
    if (treeNode.editNameFlag || $("#addBtn_"+treeNode.tId).length>0) return;
    var addStr = '<span class="button add" id="addBtn_' + treeNode.tId + '" title="" onfocus="this.blur();"></span>';
    sObj.after(addStr);

    var btn = $("#addBtn_"+treeNode.tId);
    if (btn) btn.bind("click", function(){
        var zTree = $.fn.zTree.getZTreeObj(treeId);
        var nodeName = treeNode.name + "의 하위" + (newCount++);
        switch (treeNode.type) {
            case 'root': nodeName = '1단계 메뉴명'; break;
            case 'sub': nodeName = '하위메뉴명'; break;
        }
        nodeName += '' + (Math.floor(Math.random() * 1000) + 1111);
        // 바로 등록
        $.ajax({
            type: "POST",
            data: {
                act: 'insert',
                type: treeNode.type,
                name: nodeName,
                me_code: treeNode.code,
                me_parent: treeNode.parent,
                me_depth: treeNode.depth,
            },
            url: './ajax.menu.php',
            success: function(data) {
                //console.log(data);
                if (data.result == 'success') {
                    var $i = data.data;
                    var newNodes = zTree.addNodes(treeNode, {
                        name: $i.name,
                        isParent: $i.isParent,
                        open: $i.open,
                        type: 'sub',
                        meid: $i.me_id,
                        code: $i.me_code,
                        depth: $i.me_depth,
                        parent: $i.me_parent,
                    });
                    zTree.selectNode(newNodes[0]);
                    categoryLoader(event, zTree, newNodes[0]);
                }
            }
        });

        return false;
    });
}

function removeHoverDom(treeId, treeNode) {
    $("#addBtn_"+treeNode.tId).unbind().remove();
}

function setEdit() {
    var zTree = $.fn.zTree.getZTreeObj(treeId),
    remove = $("#remove").attr("checked"),
    rename = $("#rename").attr("checked"),
    removeTitle = $.trim($("#removeTitle").get(0).value),
    renameTitle = $.trim($("#renameTitle").get(0).value);
    zTree.setting.edit.showRemoveBtn = remove;
    zTree.setting.edit.showRenameBtn = rename;
    zTree.setting.edit.removeTitle = removeTitle;
    zTree.setting.edit.renameTitle = renameTitle;
}

// menu form view
function categoryLoader(event, treeId, treeNode) {
    // dom init
    var $menuinfo = $('.csinfo'),
        $menuform = $('#menuform'),
        $cscateform = $('#fcoursecate'),
        $csnodeform = $('#fmenuform'),
        $csform = $('form.csform');

    $menuinfo.hide();
    $('#add_sub').addClass('d-none');
    $('#sc_title').text('메뉴설정');
    
    $csform.each(function() { 
        this.reset();
        $(this).find('input[type="hidden"]:not([name="act"]):not([name="type"])').val('');
    });

    //treeNode info
    //console.log(treeNode);

    try {
        var type   = treeNode.type;
        var meid   = treeNode.meid;
        var code   = treeNode.code;
        var name   = treeNode.name;
        var depth  = treeNode.depth;
        var parent = treeNode.parent;

        // 추가 버튼
        if (type == 'sub') {
            $('#add_sub').removeClass('d-none');
        }

        if (type) {
            $.ajax({
                type: "POST",
                data: {
                    act: 'loader',
                    type: type,
                    me_id: meid,
                    code: code,
                    depth: depth,
                    parent: parent
                },
                url: './ajax.menu.php',
                success: function(data) {
                    //console.log(data);
                    var $i = data.data;
                    $menuform.show();
                    $('#me_id').val($i.me_id);
                    $('#me_code').val($i.me_code);
                    $('#me_type').val($i.me_type).prop('selected',true).trigger('init');
                    $('#me_name').val($i.me_name);
                    $('#me_link').val($i.me_link);
                    var target = 'self';
                    if($i.me_target) {
                        target = $i.me_target;
                    }
                    $('#me_target').val(target).prop('selected',true);
                    $('#me_use').val($i.me_use).prop('selected',true);
                    $('#me_mobile_use').val($i.me_mobile_use).prop('selected',true)
                    
                    
                }
            });
        }
    } catch (e) {
    }
}

function categoryPublic(event, treeId, treeNode) {
}

function menuOrder(event, treeId, treeNodes, targetNode, moveType, isCopy) {
    var zTree = $.fn.zTree.getZTreeObj(treeId);
    var nodes = zTree.transformToArray(zTree.getNodes()),
        pNode = targetNode ? targetNode.getParentNode() : {},
        pNodeChild = pNode.children ? pNode.children : [];

    categoryLoader(event, treeId, treeNodes[0]);

    // all nodes
    for (var i=0,l=nodes.length,menu=[]; i<l; i++) {
        var type = nodes[i].type,
            me_id = nodes[i].meid,
            me_code = nodes[i].code,
            me_parent = nodes[i].parent,
            me_depth = nodes[i].depth,
            level = nodes[i].level ;

        paId = nodes[i].parentTId;
        $.each(nodes, function(j, $j) {
            if($j.tId == paId) {
                me_parent = $j.meid;
            }
        });
        menu[i] = {type: type, me_id:me_id, me_code: me_code, me_parent:me_parent, me_depth:me_depth, level:level};
    }
    $.ajax({
        type: "POST",
        data: {
            act: 'menuorder',
            menu: menu
        },
        url: './ajax.menu.php',
        success: function(data) {
            //console.log(data);
            /* 순서변경 시 코드가 변경되므로 새로고침 */
        }
    });
}

function menuUpdate(f) {
    var $this = $(event.target),
        $form = $(f);
    var zTree = $.fn.zTree.getZTreeObj(treeId),
        nodes = zTree.getSelectedNodes();

    if ( ! $('#me_code').val() ) {
       return false;
    }
    //메뉴명, link 체크
    if ( ! $('#me_name').val() ) {
        alert('메뉴명을 입력해 주세요');
        $('#me_name').focus();
        return false;
    }
    if ( ! $('#me_link').val() ) {
        alert('연결 주소를 입력해 주세요.');
        $('#me_link').focus();
        return false;
    }
    

    $this.prop('disabled', true);
    $.ajax({
        type: "POST",
        data: new FormData(f),
        url: './ajax.menu.php',
        async: false,
        cache: false,
        processData: false,
        contentType: false,
        success: function(data) {
            //console.log(data);
            if (data.result == 'success') {
                nodes[0].name = data.data.name;
                zTree.updateNode(nodes[0]);
                alert('수정했습니다.');
            } else {
                if (data.message) {
                    alert(data.message);
                }
            }
        },
        complete: function() {
            $this.prop('disabled', false);
        }
    });
}

// 더블클릭으로 이름변경 trigger
function onDblClick(event, treeId, treeNode) {
    event.preventDefault();
    return false;
}

function showRemoveBtn(treeId, treeNode) {
    return treeNode.level > 0;
    return treeNode.level > 0 && !treeNode.children;
}

function showRenameBtn(treeId, treeNode) {
    return false;
    return treeNode.level > 0;
}

function beforeEditName(treeId, treeNode) {
    return true;
}

function beforeRename(treeId, treeNode) {
    // 변경점 검사, 이름이 바뀌었을 때만
}

function beforeRemove(treeId, treeNode) {
    var zTree = $.fn.zTree.getZTreeObj(treeId);
    zTree.selectNode(treeNode);
    var msg = "";

    
    msg += "[ " + treeNode.name + " ] ";
    msg += "\n\n정말로 삭제하시겠습니까? \n한번 삭제한 자료는 복구할 수 없습니다.";
    if (treeNode.type == 'sub' && treeNode.children) {
        msg += "\n\n※ 주의 ※ 하위 " + treeNode.children.length +" 개의 하위메뉴도 함께 삭제됩니다. ";
    }
    return confirm(msg);
}

// 바로 삭제
function categoryRemove(event, treeId, treeNode) {
    var zTree = $.fn.zTree.getZTreeObj(treeId);
    $.ajax({
        type: "POST",
        data: {
            act: 'delete',
            type: treeNode.type,
            me_id: treeNode.meid,
        },
        url: './ajax.menu.php',
        success: function(data) {
            //console.log(data);
            var $i = data.data;
            categoryLoader();
            zTree.updateNode(treeNode.getParentNode());
        }
    });
    return false;
}

var setting = {
    data: {
        simpleData: {
            enable: false
        }
    },
    edit: {
        enable: true,
        showRemoveBtn: showRemoveBtn,
        showRenameBtn: showRenameBtn,
        drag: {
            prev: dropPrev,
            next: dropNext,
            inner: dropInner,
        },
        removeTitle: '',
        renameTitle: '',
    },
    check: {
        enable: false
    },
    view: {
        showTitle : false,
        selectedMulti: false,
        addHoverDom: addHoverDom,
        removeHoverDom: removeHoverDom,
        dblClickExpand: dblClickExpand
    },
    callback: {
        beforeDrag: beforeDrag,
        beforeDrop: beforeDrop,
        onClick: categoryLoader,
        onCheck: categoryPublic,
        onDrag:  categoryLoader,
        onDrop:  menuOrder,
        beforeEditName: beforeEditName,
        beforeRename: beforeRename,
        beforeRemove: beforeRemove,
        onRemove: categoryRemove,
        onDblClick: onDblClick,
    }
};

var zNodes =[<?php echo json_encode($znodeArray)?>];
$(function() {
    $.fn.zTree.init($("#"+treeId), setting, zNodes);

    $('#add_depth1').on('click', function() {
        var zTree = $.fn.zTree.getZTreeObj(treeId),
            zRoot = zTree.getNodeByParam('code', 0);
        zTree.selectNode(zRoot);
        $('#addBtn_menutree_1').trigger('click');
    });
    $('#add_sub').on('click', function() {
        var zTree = $.fn.zTree.getZTreeObj(treeId),
            nodes = zTree.getSelectedNodes(),
            treeNode = nodes[0];
        if (treeNode) {
            console.log($('#addBtn_' + treeNode.tId));
            $('#addBtn_' + treeNode.tId).trigger('click');
        }
    });

    $('#menuUpateButton').on('click', function() {
        menuUpdate(this.form);
    });
});

$(function() {
    $(document).on("change init","#me_type",function(e){
        var $this = $(this),
            me_code = $('#me_code').val(),
            value = $this.val();
        if(!value) {
            //메뉴선택 초기화
            $('#me_cate option').not('[value=""]').remove();
            return false;
        }
        /* 초기화 */
        $('#me_cate option').not('[value=""]').remove();
        $('#me_name').val('');
        $('#me_link').val('');
        
        $.ajax({
            type: "POST",
            data: { act: 'select_metype', me_code: me_code, me_type:value },
            url: './ajax.menu.php',
            success: function(data) {
                //console.log(data);
                var html = '';
                html += '<option value="">메뉴선택</option>';
                $.each(data.data, function(i, $i) {
                    var _selected = (data.cate == $i.id) ? 'selected' : '';
                    html += '<option value="'+$i.id+'" data-subject="'+$i.subject+'" '+_selected+'>'+$i.subject+'</option>';
                });
                $('#me_cate').empty().html(html);
            }
        });
        return false;
    });
    $(document).on("change init","#me_cate",function(e){
        var $this   = $(this),
            subject = $this.children('option:selected').data('subject'),
            me_code = $('#me_code').val(),
            me_type = $('#me_type').val(),
            me_cate = $('#me_cate').val();

        if(!me_type || !me_cate) {
            return false;
        }
        if(me_type == 'direct') {
            return false;
        }
        
        $.ajax({
            type: "POST",
            data: { act: 'select_mecate', me_code:me_code, me_type:me_type, me_cate:me_cate },
            url: './ajax.menu.php',
            success: function(data) {
                //console.log(data);
                if(data.link) {
                    $('#me_name').val(subject);
                    $('#me_link').val(data.link);
               }
            }
        });
        return false;
    });
});
</script>


<?php
include_once ('./admin.tail.php');