<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 5;

if ($is_checkbox) $colspan++;
if ($is_good) $colspan++;
if ($is_nogood) $colspan++;

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
add_stylesheet('<link rel="stylesheet" href="'.G5_THEME_CSS_URL.'/board.css">', 0);
?>

<!-- 게시판 목록 시작 { -->
<div id="bo_list" style="width:<?php echo $width; ?>">

<h2 class="sound_only"><?php echo $board['bo_subject']; ?></h2>
	
	<?php if ($is_category) { ?>
	<!-- 게시판 카테고리 시작 { -->
	<nav id="bo_cate">		
		<ul id="bo_cate_ul">
			<?php echo $category_option ?>
		</ul>
	</nav>
	<!-- } 게시판 카테고리 끝 -->
	<?php } ?>	

	<form name="fboardlist" id="fboardlist" action="<?php echo G5_BBS_URL; ?>/board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
    
	<input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
	<input type="hidden" name="sfl" value="<?php echo $sfl ?>">
	<input type="hidden" name="stx" value="<?php echo $stx ?>">
	<input type="hidden" name="spt" value="<?php echo $spt ?>">
	<input type="hidden" name="sca" value="<?php echo $sca ?>">
	<input type="hidden" name="sst" value="<?php echo $sst ?>">
	<input type="hidden" name="sod" value="<?php echo $sod ?>">
	<input type="hidden" name="page" value="<?php echo $page ?>">
	<input type="hidden" name="sw" value="">

	<!-- 게시판 페이지 정보 및 버튼 시작 { -->
	<div id="bo_btn_top">
	
	<div id="bo_list_total">
		<span>TOTAL : <strong><?php echo number_format($total_count) ?></strong>개</span> /
		<strong><?php echo $page ?></strong>페이지
	</div>

	<?php if ($rss_href || $write_href) { ?>
	<ul class="btn_bo_user">
		<?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn btn_admin_icon" title="관리자"><i class="xi-cog xi-spin"></i></a></li><?php } ?>
		<?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" target="_blank" class="btn btn_rss" title="RSS">RSS</a></li><?php } ?>
		<!--<li><button type="button" class="btn_bo_sch" title="게시판 검색"><i class="xi-search xi-x"></i></button></li>-->
		<!--<?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn btn_act" title="글쓰기">글쓰기</a></li><?php } ?>-->
		<?php if ($is_admin == 'super' || $is_auth) {  ?>
		<li>
			<button type="button" class="btn_more_opt is_list_btn" title="게시판 리스트 옵션">
				<i class="xi-ellipsis-v xi-x"></i>
				<span class="sound_only">게시판 리스트 옵션</span>
			</button>
			<?php if ($is_checkbox) { ?>	
			<ul class="more_opt is_list_btn">  
				<li><button type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value"><i class="xi-trash xi-x"></i> 선택삭제</button></li>
				<li><button type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value"><i class="xi-documents xi-x"></i> 선택복사</button></li>
				<li><button type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value"><i class="xi-arrows xi-x"></i> 선택이동</button></li>
			</ul>
		<?php } ?>
		</li>
		<?php }  ?>
	</ul>
	<?php } ?>

	</div>




	<div id="list_type">
	<table>
	<caption><?php echo $board['bo_subject'] ?> 목록</caption>
	<thead>
	<tr>
		<?php if ($is_checkbox) { ?>
		<th scope="col" class="all_chk chk_box">
			<input type="checkbox" id="chkall" onclick="if (this.checked) all_checked(true); else all_checked(false);" class="selec_chk">
			<label for="chkall"><span></span><b class="sound_only">현재 페이지 게시물  전체선택</b></label>
		</th>
		<?php } ?>
		<th scope="col">번호</th>
		<th scope="col">제목</th>
		<th scope="col">글쓴이</th>
		<th scope="col"><?php echo subject_sort_link('wr_hit', $qstr2, 1) ?>조회 </a></th>
		<?php if ($is_good) { ?><th scope="col"><?php echo subject_sort_link('wr_good', $qstr2, 1) ?>추천 </a></th><?php } ?>
		<?php if ($is_nogood) { ?><th scope="col"><?php echo subject_sort_link('wr_nogood', $qstr2, 1) ?>비추천 </a></th><?php } ?>
		<th scope="col"><?php echo subject_sort_link('wr_datetime', $qstr2, 1) ?>날짜  </a></th>
	</tr>
	</thead>

	<tbody>
	<?php for ($i=0; $i<count($list); $i++) { ?>
	<tr class="<?php if ($list[$i]['is_notice']) echo "bo_notice"; ?>">
		<?php if ($is_checkbox) { ?>
		<td class="td_chk chk_box"">
			<input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>" class="selec_chk">
			<label for="chk_wr_id_<?php echo $i ?>"><span></span><b class="sound_only"><?php echo $list[$i]['subject'] ?></b></label>
		</td>
		<?php } ?>
		<td class="td_num">
			<?php
			if ($list[$i]['is_notice']) // 공지사항
				echo '<strong class="notice_icon">공지</strong>';
			else if ($wr_id == $list[$i]['wr_id'])
				echo "<span class=\"bo_current\">열람중</span>";
			else
				echo $list[$i]['num'];
			?>
		</td>
		<td class="td_subject">
		<div style="padding-left:<?php echo $list[$i]['reply'] ? (strlen($list[$i]['wr_reply'])*10) : '0'; ?>px">
			<?php if($is_category && $list[$i]['ca_name']) { ?><a href="<?php echo $list[$i]['ca_name_href'] ?>" class="bo_cate_link"><?php echo $list[$i]['ca_name'] ?></a><?php } ?>
			<div class="bo_tit">
				<a href="<?php echo $list[$i]['href'] ?>">
				<?php echo $list[$i]['icon_reply'] ?>
				<?php 
					//if(isset($list[$i]['icon_secret'])) { echo rtrim($list[$i]['icon_secret']); } 
					if(isset($list[$i]['icon_secret'])) { echo rtrim($list[$i]['icon_secret']); } 
				?>
				<?php echo $list[$i]['subject'] ?>
				<?php
				if ($list[$i]['icon_new']) echo "<strong class=\"icon_new\"><i class=\"xi-new xi-x\"></i><span class=\"sound_only\">새글</span></strong>";
				// if ($list[$i]['file']['count']) { echo '<'.$list[$i]['file']['count'].'>'; }
				//if (isset($list[$i]['icon_file'])) echo rtrim($list[$i]['icon_file']);
				//if (isset($list[$i]['icon_link'])) echo rtrim($list[$i]['icon_link']);
				if (isset($list[$i]['icon_hot'])) echo rtrim($list[$i]['icon_hot']);
				?>
				<?php if ($list[$i]['comment_cnt']) { ?><span class="sound_only">댓글</span><strong class="cnt_cmt">[<?php echo $list[$i]['wr_comment']; ?>]</strong><span class="sound_only">개</span><?php } ?>
				</a>
			</div>

			<ul class="bo_tit_mobile">
				<li><?php echo $list[$i]['wr_name'] ?></li>
				<?php if ($is_good) { ?><li><i class="xi-heart xi-x"></i> <?php echo $list[$i]['wr_good'] ?></li><?php } ?>
				<!--<?php if ($is_nogood) { ?><li><?php echo $list[$i]['wr_nogood'] ?></li><?php } ?>-->
				<li class="date">작성일 : <?php echo $list[$i]['datetime2'] ?></li>
				<li class="view">조회 : <?php echo $list[$i]['wr_hit'] ?></li>
			</ul>
		</div>
		</td>
		<td class="td_name sv_use"><?php echo $list[$i]['name'] ?></td>
		<td class="td_num"><?php echo $list[$i]['wr_hit'] ?></td>
		<?php if ($is_good) { ?><td class="td_num"><?php echo $list[$i]['wr_good'] ?></td><?php } ?>
		<?php if ($is_nogood) { ?><td class="td_num"><?php echo $list[$i]['wr_nogood'] ?></td><?php } ?>
		<td class="td_datetime"><?php echo $list[$i]['datetime2'] ?></td>
	</tr>
	<?php } ?>
	<?php if (count($list) == 0) { echo '<tr><td colspan="'.$colspan.'" class="empty_table">게시물이 없습니다.</td></tr>'; } ?>
	</tbody>
	</table>
	</div>

<?php if ($list_href || $is_checkbox || $write_href) { ?>
<div class="bo_fx">
	<?php if ($list_href || $write_href) { ?>
	<ul class="btn_bo_user">
		<?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn btn_admin" title="관리자">관리자</a></li><?php } ?>
		<?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" target="_blank" class="btn btn_rss" title="RSS">RSS</a></li><?php } ?>
		<?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn btn_act" title="글쓰기">글쓰기</a></li><?php } ?>
	</ul>	
	<?php } ?>
</div>
<?php } ?>   
</form>

<?php echo $write_pages; ?>

<!-- 게시판 검색 시작 { -->
<div class="bo_sch_wrap">
<fieldset class="bo_sch">
	<form name="fsearch" method="get">
	<input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
	<input type="hidden" name="sca" value="<?php echo $sca ?>">
	<input type="hidden" name="sop" value="and">
	
	<div class="sch_select">
	<label for="sfl">제목</label>
	<select name="sfl" id="sfl">
		<?php echo get_board_sfl_select_options($sfl); ?>
	</select>
	</div>

	<label for="stx" class="sound_only">검색어<strong class="sound_only"> 필수</strong></label>
	<div class="sch_bar">
		<input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx" class="sch_input" maxlength="20" placeholder=" 검색어를 입력해주세요">
		<button type="submit" value="검색" class="sch_btn"><i class="xi-search xi-x"></i><span class="sound_only">검색</span></button>
	</div>
	</form>
</fieldset>
</div>


<script>
jQuery(function($){	
	var select = $('.sch_select select');
	select.change(function(){
		var select_name = $(this).children('option:selected').text();
		$(this).siblings("label").text(select_name);
	});
});
</script>
<!-- } 게시판 검색 끝 --> 
</div>

<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = g5_bbs_url+"/board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == "copy")
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = g5_bbs_url+"/move.php";
    f.submit();
}

// 게시판 리스트 관리자 옵션
jQuery(function($){
    $(".btn_more_opt.is_list_btn").on("click", function(e) {
        e.stopPropagation();
        $(".more_opt.is_list_btn").toggle();
    });
    $(document).on("click", function (e) {
        if(!$(e.target).closest('.is_list_btn').length) {
            $(".more_opt.is_list_btn").hide();
        }
    });
});
</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->
