<?php
include_once('./_common.php');
include_once(G5_LIB_PATH.'/thumbnail.lib.php');
include_once($board_skin_path.'/board.lib.php');

header("Content-Type: application/json; charset=utf-8");

$data = array();
$data['result'] = '';
$data['message'] = '';
$data['data'] = array();

$act  = $_REQUEST['act'];
$w  = $_POST['w'] ?  clean_xss_tags($_POST['w']) : ''; //게시판

if($act == 'emoticon') {
    $emoticon = get_emoticon();
    if( empty($emoticon['dir']) || empty($emoticon['emoticon']) ) {
        $data['result']    = 'failer';
        $data['message']   = '이모티콘 정보가 없습니다.';
        die(json_encode($data));
    }
    $data['result']    = 'success';
    $data['message']   = '';
    $data['emoti_dir'] = $emoticon['dir'];
    $data['emoticon']  = $emoticon['emoticon'];
    die(json_encode($data));
}

if($member['mb_level'] < $board['bo_comment_level']) { //댓글 이용 가능 레벨 체크
    $data['result']  = 'failer';
    $data['message'] = '댓글을 작성할 권한이 없습니다.';
    $data['board']   = $board;
    die(json_encode($data));
}



//토큰 체크
if($w) {
    $comment_token = trim(get_session('ss_comment_token'));
    set_session('ss_comment_token','');
    if(!$_POST['token'] || !$comment_token ||  $comment_token != $_POST['token']) {
        $data['result']  = 'failer';
        $data['message'] = '올바른 방법으로 이용해 주십시요.';
        die(json_encode($data));
    }
}

//게시판 댓글
$comment_id = $_POST['comment_id'];
$wr_id      = $_POST['wr_id'];
$wr_content = '';
if (isset($_POST['wr_content'])) {
    $wr_content = substr(trim($_POST['wr_content']),0,65536);
    $wr_content = preg_replace("#[\\\]+$#", "", $wr_content);
}

$upload_max_filesize = ini_get('upload_max_filesize');

if (empty($_POST)) {
    $data['result']  = 'failer';
    $data['message'] = '파일 또는 글내용의 크기가 서버에서 설정한 값을 넘어 오류가 발생하였습니다.npost_max_size="'.ini_get('post_max_size').'" , upload_max_filesize="'.$upload_max_filesize.'"게시판관리자 또는 서버관리자에게 문의 바랍니다.';
    die(json_encode($data));
}

if($w && $w != 'cd') {
    $wr_name  = isset($_POST['wr_name']) ? clean_xss_tags(trim($_POST['wr_name'])) : '';
    $wr_secret = isset($_POST['wr_secret']) ? clean_xss_tags($_POST['wr_secret']) : '';
    $wr_email = $wr_subject = '';
    $reply_array = array();
    $wr_1 = isset($_POST['wr_1']) ? $_POST['wr_1'] : ''; //url
    $wr_2 = isset($_POST['wr_2']) ? $_POST['wr_2'] : '';
    $wr_3 = isset($_POST['wr_3']) ? $_POST['wr_3'] : '';
    $wr_4 = isset($_POST['wr_4']) ? $_POST['wr_4'] : '';
    $wr_5 = isset($_POST['wr_5']) ? $_POST['wr_5'] : '';
    $wr_6 = isset($_POST['wr_6']) ? $_POST['wr_6'] : '';
    $wr_7 = isset($_POST['wr_7']) ? $_POST['wr_7'] : '';
    $wr_8 = isset($_POST['wr_8']) ? $_POST['wr_8'] : '';
    $wr_9 = isset($_POST['wr_9']) ? $_POST['wr_9'] : '';
    $wr_10 = isset($_POST['wr_10']) ? $_POST['wr_10'] : '';
    $wr_facebook_user = isset($_POST['wr_facebook_user']) ? clean_xss_tags($_POST['wr_facebook_user'], 1, 1) : '';
    $wr_twitter_user = isset($_POST['wr_twitter_user']) ? clean_xss_tags($_POST['wr_twitter_user'], 1, 1) : '';
    $wr_homepage = isset($_POST['wr_homepage']) ? clean_xss_tags($_POST['wr_homepage'], 1, 1) : '';
    $wr_movie_url = isset($_POST['wr_movie_url']) ? clean_xss_tags($_POST['wr_movie_url'], 1, 1) : '';
    //utv url이 있을 경우
    if($wr_movie_url) {
        $movie_id  = get_movie_id($wr_movie_url);
        if(!$movie_id) {
            $data['result']  = 'failer';
            $data['message'] = '유튜브 주소 경로가 잘못되었습니다. 유튜브 경로를 다시 입력해 주세요.';
            die(json_encode($data));
        }
    }


    // 세션의 시간 검사
    // 4.00.15 - 댓글 수정시 연속 게시물 등록 메시지로 인한 오류 수정
    if ($w == 'c' && !$is_admin && isset($_SESSION['ss_datetime']) && $_SESSION['ss_datetime'] >= (G5_SERVER_TIME - $config['cf_delay_sec'])) {
        $data['result']  = 'failer';
        $data['message'] = '너무 빠른 시간내에 게시물을 연속해서 올릴 수 없습니다.';
        die(json_encode($data));
    }

    set_session('ss_datetime', G5_SERVER_TIME);
    $wr = get_write($write_table, $wr_id);
    if (!$wr['wr_id']) {
        $data['result']  = 'failer';
        $data['message'] = '글이 존재하지 않습니다.\\n글이 삭제되었거나 이동하였을 수 있습니다.';
        die(json_encode($data));
    }

    $post_wr_password = '';
    if($is_member) {
        $mb_id = $member['mb_id'];
        // 4.00.13 - 실명 사용일때 댓글에 닉네임으로 입력되던 오류를 수정
        $wr_name = addslashes(clean_xss_tags($board['bo_use_name'] ? $member['mb_name'] : $member['mb_nick']));
        $wr_password = '';
        $wr_email = addslashes($member['mb_email']);
        $wr_homepage = addslashes(clean_xss_tags($member['mb_homepage']));
    } else {
        $mb_id = '';
        $post_wr_password = $wr_password;
        $wr_password = get_encrypt_string($wr_password);
    }

}
if($w == 'c') {
    $tmp_point = ($member['mb_point'] > 0) ? $member['mb_point'] : 0;
    if ($tmp_point + $board['bo_comment_point'] < 0 && !$is_admin) {
        $data['result']  = 'failer';
        $data['message'] = '보유하신 포인트('.number_format($member['mb_point']).')가 없거나 모자라서 댓글쓰기('.number_format($board['bo_comment_point']).')가 불가합니다.\\n\\n포인트를 적립하신 후 다시 댓글을 써 주십시오.';
        die(json_encode($data));
    }

    $sql = "select max(wr_comment) as max_comment from {$write_table} where wr_parent = '{$wr_id}' and wr_is_comment = 1";
    $row = sql_fetch($sql);
    $row['max_comment'] += 1;
    $tmp_comment = $row['max_comment'];
    $tmp_comment_reply = '';

    $wr_subject = get_text(stripslashes($wr['wr_subject']));

    $sql = " insert into {$write_table}
                set ca_name = '{$wr['ca_name']}',
                     wr_option = '{$wr_secret}',
                     wr_num = '{$wr['wr_num']}',
                     wr_reply = '',
                     wr_parent = '{$wr_id}',
                     wr_is_comment = 1,
                     wr_comment = '{$tmp_comment}',
                     wr_comment_reply = '{$tmp_comment_reply}',
                     wr_subject = '',
                     wr_content = '{$wr_content}',
                     mb_id = '{$mb_id}',
                     wr_password = '{$wr_password}',
                     wr_name = '{$wr_name}',
                     wr_email = '{$wr_email}',
                     wr_homepage = '{$wr_homepage}',
                     wr_datetime = '".G5_TIME_YMDHIS."',
                     wr_last = '',
                     wr_ip = '{$_SERVER['REMOTE_ADDR']}',
                     wr_1 = '{$wr_1}',
                     wr_2 = '{$wr_2}',
                     wr_3 = '{$wr_3}',
                     wr_4 = '{$wr_4}',
                     wr_5 = '{$wr_5}',
                     wr_6 = '{$wr_6}',
                     wr_7 = '{$wr_7}',
                     wr_8 = '{$wr_8}',
                     wr_9 = '{$wr_9}',
                     wr_10 = '{$wr_10}',
                     wr_movie_url = '{$wr_movie_url}',
                     wr_cmt_depth = '1' ";

    sql_query($sql);
    $comment_id = sql_insert_id();
    // 원글에 댓글수 증가 & 마지막 시간 반영
    sql_query(" update {$write_table} set wr_comment = wr_comment + 1, wr_last = '".G5_TIME_YMDHIS."' where wr_id = '{$wr_id}' ");
    // 새글 INSERT
    sql_query(" insert into {$g5['board_new_table']} ( bo_table, wr_id, wr_parent, bn_datetime, mb_id ) values ( '{$bo_table}', '{$comment_id}', '$wr_id', '".G5_TIME_YMDHIS."', '{$member['mb_id']}' ) ");
    // 댓글 1 증가
    sql_query(" update {$g5['board_table']} set bo_count_comment = bo_count_comment + 1 where bo_table = '{$bo_table}' ");
    // 포인트 부여
    insert_point($member['mb_id'], $board['bo_comment_point'], "{$board['bo_subject']} {$wr_id}-{$comment_id} 댓글쓰기", $bo_table, $comment_id, '댓글');
    
    //추가된 쿼리
    sql_query(" update {$write_table} set wr_cmt_parent = '{$comment_id}' where wr_id = '{$comment_id}'");
    sql_query(" update {$write_table} set wr_cmt_num = wr_cmt_num + 1 where wr_id = '{$wr_id}'");

    //order update
    $sql = "update {$write_table} set wr_cmt_order = wr_cmt_order + 1 where wr_is_comment = '1' and wr_id != '{$comment_id}' and wr_num = '{$wr['wr_num']}'";
    sql_query($sql);
    
    $data['result']  = 'success';
    $data['message'] = '댓글을 등록하였습니다.';
    $data['comment_id'] = $comment_id;
    $data['wr_id']      = $wr_id;
    $comment = sql_fetch("select * from {$write_table} where wr_id = '{$comment_id}'");
    $data['comment'] = $comment;
    $data['comment']['movie'] = $movie_id;
    $data['comment']['photo'] = get_member_profile_img($comment['mb_id']);
}

if($w == 'cr' && $comment_id) {
    $pa_id = $comment_id;
    $reply_array = get_write($write_table, $comment_id, true);
    if (!$reply_array['wr_id']) {
        $data['result']  = 'failer';
        $data['message'] = '답변할 댓글이 없습니다.\\n\\n답변하는 동안 댓글이 삭제되었을 수 있습니다.';
        die(json_encode($data));
    }
    if($wr['wr_parent'] != $reply_array['wr_parent']) {
        $data['result']  = 'failer';
        $data['message'] = '댓글을 등록할 수 없습니다.';
        die(json_encode($data));
    }
    
    // !---그누보드 원본에 있으나 댓글 로직 변경으로 삭제해도 무방
    $tmp_comment = $reply_array['wr_comment'];
    if (strlen($reply_array['wr_comment_reply']) == 5) {
        $data['result']  = 'failer';
        $data['message'] = '더 이상 답변하실 수 없습니다.\\n\\n답변은 5단계 까지만 가능합니다.';
        //die(json_encode($data));
    }
    
    
    $reply_len = strlen($reply_array['wr_comment_reply']) + 1;
    if ($board['bo_reply_order']) {
        $begin_reply_char = 'A';
        $end_reply_char = 'Z';
        $reply_number = +1;
        $sql = " select MAX(SUBSTRING(wr_comment_reply, $reply_len, 1)) as reply
                    from {$write_table}
                    where wr_parent = '{$wr_id}'
                    and wr_comment = '{$tmp_comment}'
                    and SUBSTRING(wr_comment_reply, {$reply_len}, 1) <> '' ";
    } else {
        $begin_reply_char = 'Z';
        $end_reply_char = 'A';
        $reply_number = -1;
        $sql = " select MIN(SUBSTRING(wr_comment_reply, {$reply_len}, 1)) as reply
                    from {$write_table}
                    where wr_parent = '{$wr_id}'
                    and wr_comment = '{$tmp_comment}'
                    and SUBSTRING(wr_comment_reply, {$reply_len}, 1) <> '' ";
    }
    if ($reply_array['wr_comment_reply']) {
        $sql .= " and wr_comment_reply like '{$reply_array['wr_comment_reply']}%' ";
    }
    $row = sql_fetch($sql);
    if (!$row['reply']) {
        $reply_char = $begin_reply_char;
    } else if ($row['reply'] == $end_reply_char) { // A~Z은 26 입니다.
        $data['result']  = 'failer';
        $data['message'] = '더 이상 답변하실 수 없습니다.\\n\\n답변은 26개 까지만 가능합니다.';
        //die(json_encode($data));
    } else {
        $reply_char = chr(ord($row['reply']) + $reply_number);
    }
    $tmp_comment_reply = $reply_array['wr_comment_reply'] . $reply_char;
    //여기까지구문은 실제 사용하지 않는 구문 -----!!!

    $sql = "select * from {$write_table} where wr_id = '{$comment_id}'";
    $res = sql_fetch($sql);
    if(!$res['wr_id']) {
        $data['result']  = 'failer';
        $data['message'] = '원글 정보를 찾을 수 없습니다.';
        die(json_encode($data));
    }

    if(!$wr_content) {
        $data['result']  = 'failer';
        $data['message'] = '입력된 내용이 없습니다.';
        die(json_encode($data));
    }
    
    $wr_num    = $res['wr_num'];
    $wr_cmt_parent = $res['wr_id'];
    $wr_cmt_depth  = (int) $res['wr_cmt_depth'] + 1;
    $wr_cmt_order  = (int) $res['wr_cmt_order'] + 1;

    $sql = " insert into {$write_table}
                set ca_name = '{$wr['ca_name']}',
                     wr_option = '{$wr_secret}',
                     wr_num = '{$wr['wr_num']}',
                     wr_reply = '',
                     wr_parent = '{$wr_id}',
                     wr_is_comment = 1,
                     wr_comment = '{$tmp_comment}',
                     wr_comment_reply = '{$tmp_comment_reply}',
                     wr_subject = '',
                     wr_content = '{$wr_content}',
                     mb_id = '{$mb_id}',
                     wr_password = '{$wr_password}',
                     wr_name = '{$wr_name}',
                     wr_email = '{$wr_email}',
                     wr_homepage = '{$wr_homepage}',
                     wr_datetime = '".G5_TIME_YMDHIS."',
                     wr_last = '',
                     wr_ip = '{$_SERVER['REMOTE_ADDR']}',
                     wr_1 = '{$wr_1}',
                     wr_2 = '{$wr_2}',
                     wr_3 = '{$wr_3}',
                     wr_4 = '{$wr_4}',
                     wr_5 = '{$wr_5}',
                     wr_6 = '{$wr_6}',
                     wr_7 = '{$wr_7}',
                     wr_8 = '{$wr_8}',
                     wr_9 = '{$wr_9}',
                     wr_10 = '{$wr_10}',
                     wr_movie_url = '{$wr_movie_url}',
                     wr_cmt_parent = '".(int)$wr_cmt_parent."',
                     wr_cmt_depth  = '".(int)$wr_cmt_depth."',
                     wr_cmt_order  = '".(int)$wr_cmt_order."' ";
    sql_query($sql);
    $comment_id = sql_insert_id();
    
    // 원글에 댓글수 증가 & 마지막 시간 반영
    sql_query(" update {$write_table} set wr_comment = wr_comment + 1, wr_last = '".G5_TIME_YMDHIS."' where wr_id = '{$wr_id}' ");
    // 새글 INSERT
    sql_query(" insert into {$g5['board_new_table']} ( bo_table, wr_id, wr_parent, bn_datetime, mb_id ) values ( '{$bo_table}', '{$comment_id}', '{$wr_id}', '".G5_TIME_YMDHIS."', '{$member['mb_id']}' ) ");
    // 댓글 1 증가
    sql_query(" update {$g5['board_table']} set bo_count_comment = bo_count_comment + 1 where bo_table = '{$bo_table}' ");
    // 포인트 부여
    insert_point($member['mb_id'], $board['bo_comment_point'], "{$board['bo_subject']} {$wr_id}-{$comment_id} 댓글쓰기", $bo_table, $comment_id, '댓글');
    
    //추가된 쿼리
    sql_query(" update {$write_table} set wr_cmt_num = wr_cmt_num + 1 where wr_id = '{$wr_id}'");
    sql_query(" update {$write_table} set wr_cmt_num = wr_cmt_num + 1 where wr_id = '{$reply_array['wr_id']}'");

    //order update
    $sql = "update {$write_table} set wr_cmt_order = wr_cmt_order + 1 where wr_is_comment = '1' and wr_id != '{$comment_id}' and wr_num = '{$reply_array['wr_num']}' and wr_cmt_order > '{$reply_array['wr_cmt_order']}'";
    sql_query($sql);

    $data['result']  = 'success';
    $data['message'] = '댓글을 등록하였습니다.';
    $data['comment_id'] = $comment_id;
    $data['wr_id']      = $wr_id;
    $comment = sql_fetch("select * from {$write_table} where wr_id = '{$comment_id}'");
    $data['comment'] = $comment;
    $data['comment']['depth']   = $comment['wr_cmt_depth'];
    $data['comment']['pa_id']   = $pa_id;
    $data['comment']['pa_name'] = $reply_array['wr_name'];
    $data['comment']['movie'] = $movie_id;
    $data['comment']['photo'] = get_member_profile_img($comment['mb_id']);
}

if($w == 'cu' && $comment_id) {
    $comment = get_write($write_table, $comment_id, true);
    if(!$is_admin || $comment['mb_id'] != $member['mb_id']) {
        $data['result']  = 'failer';
        $data['message'] = '댓글을 수정할 권한이 없습니다.';
        die(json_encode($data));
    }
    if (!$comment['wr_id']) {
        $data['result']  = 'failer';
        $data['message'] = '댓글 정보를 찾을 수 없습니다.';
        die(json_encode($data));
    }
    $sql = "update {$write_table} set wr_option = '{$wr_secret}', wr_content = '{$wr_content}', wr_last = '".G5_TIME_YMDHIS."', wr_movie_url = '{$wr_movie_url}' where wr_id = '{$comment['wr_id']}'";
    sql_query($sql);
    $comment = sql_fetch("select * from {$write_table} where wr_id = '{$comment_id}'");
    $data['result']  = 'success';
    $data['comment'] = $comment;
    $data['comment']['movie'] = $movie_id;
    $data['comment']['photo'] = get_member_profile_img($comment['mb_id']);
}

if($w == 'cd' && $comment_id) {
    $comment = get_write($write_table, $comment_id, true);
    if(!$is_admin || $comment['mb_id'] != $member['mb_id']) {
        $data['result']  = 'failer';
        $data['message'] = '댓글을 삭제할 권한이 없습니다.';
        die(json_encode($data));
    }
    if (!$comment['wr_id']) {
        $data['result']  = 'failer';
        $data['message'] = '댓글 정보를 찾을 수 없습니다.';
        die(json_encode($data));
    }
    $sql = "update {$write_table} set wr_cmt_del = '1', wr_last = '".G5_TIME_YMDHIS."' where wr_id = '{$comment['wr_id']}'";
    sql_query($sql);
    
    // 원글에 댓글수 증가 & 마지막 시간 반영
    sql_query("update $write_table set wr_comment = wr_comment - 1, wr_last = '".G5_TIME_YMDHIS."' where wr_id = '{$wr_id}'");
    // 새글 DELETE
    sql_query("delete from {$g5['board_new_table']} where bo_table = '{$bo_table}' and wr_id = '{$comment_id}' and wr_id = '{$wr_id}' and mb_id = '{$member['mb_id']}'");
    // 댓글 1 증가
    sql_query(" update {$g5['board_table']} set bo_count_comment = bo_count_comment - 1 where bo_table = '{$bo_table}' ");
    // 포인트 부여
    $del_point = $board['bo_comment_point'] * -1;
    insert_point($member['mb_id'], $del_point, "{$board['bo_subject']} {$wr_id}-{$comment_id} 댓글삭제", $bo_table, $comment_id, '댓글');
    
    //추가된 쿼리
    sql_query(" update {$write_table} set wr_cmt_num = wr_cmt_num - 1 where wr_id = '{$wr_id}'");
    if($comment['wr_cmt_depth'] > 1) { //댓글이 1단계 이상인 경우에만 부모댓글의 댓글 수를 -1 해줌
        sql_query(" update {$write_table} set wr_cmt_num = wr_cmt_num - 1 where wr_id = '{$comment['wr_cmt_parent']}'");
    }
    
    $comment = sql_fetch("select * from {$write_table} where wr_id = '{$comment_id}'");
    $data['result']  = 'success';
    $data['comment']['wr_id'] = $comment['wr_id'];
    $data['comment']['wr_content'] = '<p class="cmt_del">삭제된 댓글입니다.</p>';
    //$data['comment']['cmt_num'] = $comment['wr_cmt_num'];
}

if($w == 'c' || $w == 'cr') {
    // 메일발송 사용
    if ($config['cf_email_use'] && $board['bo_use_email']) {
        // 관리자의 정보를 얻고
        $super_admin = get_admin('super');
        $group_admin = get_admin('group');
        $board_admin = get_admin('board');
        $wr_content = nl2br(get_text(stripslashes("원글\n{$wr['wr_subject']}\n\n\n댓글\n{$wr_content}")));
        $warr = array( ''=>'입력', 'u'=>'수정', 'r'=>'답변', 'c'=>'댓글 ', 'cu'=>'댓글 수정' );
        $str = $warr[$w];
        $subject = '['.$config['cf_title'].'] '.$board['bo_subject'].' 게시판에 '.$str.'글이 올라왔습니다.';
        // 4.00.15 - 메일로 보내는 댓글의 바로가기 링크 수정
        $link_url = get_pretty_url($bo_table, $wr_id, $qstr."#c_".$comment_id);
        include_once(G5_LIB_PATH.'/mailer.lib.php');
        ob_start();
        include_once (G5_BBS_PATH.'/write_update_mail.php');
        $content = ob_get_contents();
        ob_end_clean();
        $array_email = array();
        // 게시판관리자에게 보내는 메일
        if ($config['cf_email_wr_board_admin']) $array_email[] = $board_admin['mb_email'];
        // 게시판그룹관리자에게 보내는 메일
        if ($config['cf_email_wr_group_admin']) $array_email[] = $group_admin['mb_email'];
        // 최고관리자에게 보내는 메일
        if ($config['cf_email_wr_super_admin']) $array_email[] = $super_admin['mb_email'];
        // 원글게시자에게 보내는 메일
        if ($config['cf_email_wr_write']) $array_email[] = $wr['wr_email'];
        // 댓글 쓴 모든이에게 메일 발송이 되어 있다면 (자신에게는 발송하지 않는다)
        if ($config['cf_email_wr_comment_all']) {
            $sql = " select distinct wr_email from {$write_table}
                        where wr_email not in ( '{$wr['wr_email']}', '{$member['mb_email']}', '' )
                        and wr_parent = '$wr_id' ";
            $result = sql_query($sql);
            while ($row=sql_fetch_array($result))
                $array_email[] = $row['wr_email'];
        }
        // 중복된 메일 주소는 제거
        $unique_email = array_unique($array_email);
        $unique_email = array_values($unique_email);
        for ($i=0; $i<count($unique_email); $i++) {
            mailer($wr_name, $wr_email, $unique_email[$i], $subject, $content, 1);
        }
    }

    // SNS 등록
    include_once(G5_BBS_PATH."/write_comment_update.sns.php");
    if($wr_facebook_user || $wr_twitter_user) {
        $sql = " update {$write_table}
                    set wr_facebook_user = '{$wr_facebook_user}',
                        wr_twitter_user  = '{$wr_twitter_user}'
                    where wr_id = '{$comment_id}' ";
        sql_query($sql);
    }
}

/* 첨부파일 등록 */
// 파일개수 체크
$file_count   = 0;
$upload_count = (isset($_FILES['bf_file']['name']) && is_array($_FILES['bf_file']['name'])) ? count($_FILES['bf_file']['name']) : 0;

for ($i=0; $i<$upload_count; $i++) {
    if($_FILES['bf_file']['name'][$i] && is_uploaded_file($_FILES['bf_file']['tmp_name'][$i])) {
        $file_count++;
    }
}

if($w == 'cu') { //수정
    $file = get_file($bo_table, $comment_id);
    if($file_count && (int)$file['count'] > $board['bo_upload_count']) {
        $data['result']  = 'fm_failer';
        $data['message'] = '기존 파일을 삭제하신 후 첨부파일을 '.number_format($board['bo_upload_count']).'개 이하로 업로드 해주십시오.';
        die(json_encode($data));
    }
} else {
    if($file_count > $board['bo_upload_count']) {
        $data['result']  = 'fm_failer';
        $data['message'] = '첨부파일 등록에 실패하였습니다. 첨부파일을 '.number_format($board['bo_upload_count']).'개 이하로 업로드 해주십시오.';
        die(json_encode($data));
    }
}

$data['comment']['file'] = array();
if($w && $w != 'cd') { //파일 첨부
    // 디렉토리가 없다면 생성합니다. (퍼미션도 변경하구요.)
    @mkdir(G5_DATA_PATH.'/file/'.$bo_table, G5_DIR_PERMISSION);
    @chmod(G5_DATA_PATH.'/file/'.$bo_table, G5_DIR_PERMISSION);
    $chars_array = array_merge(range(0,9), range('a','z'), range('A','Z'));

    $data['files'] = $_FILES;
    // 가변 파일 업로드
    $file_upload_msg = '';
    $upload = array();
    if(isset($_FILES['bf_file']['name']) && is_array($_FILES['bf_file']['name'])) {
        for ($i=0; $i<count($_FILES['bf_file']['name']); $i++) {
            $upload[$i]['file']     = '';
            $upload[$i]['source']   = '';
            $upload[$i]['filesize'] = 0;
            $upload[$i]['image']    = array();
            $upload[$i]['image'][0] = 0;
            $upload[$i]['image'][1] = 0;
            $upload[$i]['image'][2] = 0;
            $upload[$i]['fileurl'] = '';
            $upload[$i]['thumburl'] = '';
            $upload[$i]['storage'] = '';

            // 삭제에 체크가 되어있다면 파일을 삭제합니다.
            if (isset($_POST['bf_file_del'][$i]) && $_POST['bf_file_del'][$i]) {
                $upload[$i]['del_check'] = true;
                $row = sql_fetch(" select * from {$g5['board_file_table']} where bo_table = '{$bo_table}' and wr_id = '{$comment_id}' and bf_no = '{$i}' ");
                $delete_file = run_replace('delete_file_path', G5_DATA_PATH.'/file/'.$bo_table.'/'.str_replace('../', '', $row['bf_file']), $row);
                if( file_exists($delete_file) ){
                    @unlink($delete_file);
                }
                // 썸네일삭제
                if(preg_match("/\.({$config['cf_image_extension']})$/i", $row['bf_file'])) {
                    delete_board_thumbnail($bo_table, $row['bf_file']);
                }
            } else {
                $upload[$i]['del_check'] = false;
            }

            $tmp_file  = $_FILES['bf_file']['tmp_name'][$i];
            $filesize  = $_FILES['bf_file']['size'][$i];
            $filename  = $_FILES['bf_file']['name'][$i];
            $filename  = get_safe_filename($filename);

            // 서버에 설정된 값보다 큰파일을 업로드 한다면
            if ($filename) {
                if ($_FILES['bf_file']['error'][$i] == 1) {
                    $file_upload_msg .= '\"'.$filename.'\" 파일의 용량이 서버에 설정('.$upload_max_filesize.')된 값보다 크므로 업로드 할 수 없습니다.\\n';
                    continue;
                } else if ($_FILES['bf_file']['error'][$i] != 0) {
                    $file_upload_msg .= '\"'.$filename.'\" 파일이 정상적으로 업로드 되지 않았습니다.\\n';
                    continue;
                }
            }

            if (is_uploaded_file($tmp_file)) {
                // 관리자가 아니면서 설정한 업로드 사이즈보다 크다면 건너뜀
                if (!$is_admin && $filesize > $board['bo_upload_size']) {
                    $file_upload_msg .= '\"'.$filename.'\" 파일의 용량('.number_format($filesize).' 바이트)이 게시판에 설정('.number_format($board['bo_upload_size']).' 바이트)된 값보다 크므로 업로드 하지 않습니다.\\n';
                    continue;
                }

                //=================================================================\
                // 090714
                // 이미지나 플래시 파일에 악성코드를 심어 업로드 하는 경우를 방지
                // 에러메세지는 출력하지 않는다.
                //-----------------------------------------------------------------
                $timg = @getimagesize($tmp_file);
                // image type
                if ( preg_match("/\.({$config['cf_image_extension']})$/i", $filename) ||
                     preg_match("/\.({$config['cf_flash_extension']})$/i", $filename) ) {
                    if ($timg['2'] < 1 || $timg['2'] > 16) {
                        continue;
                    }
                }
                //=================================================================

                $upload[$i]['image'] = $timg;
                // 4.00.11 - 글답변에서 파일 업로드시 원글의 파일이 삭제되는 오류를 수정
                if ($w == 'u') {
                    // 존재하는 파일이 있다면 삭제합니다.
                    $row = sql_fetch(" select * from {$g5['board_file_table']} where bo_table = '{$bo_table}' and wr_id = '{$comment_id}' and bf_no = '{$i}' ");
                    if(isset($row['bf_file']) && $row['bf_file']){
                        $delete_file = run_replace('delete_file_path', G5_DATA_PATH.'/file/'.$bo_table.'/'.str_replace('../', '', $row['bf_file']), $row);
                        if( file_exists($delete_file) ){
                            @unlink(G5_DATA_PATH.'/file/'.$bo_table.'/'.$row['bf_file']);
                        }
                        // 이미지파일이면 썸네일삭제
                        if(preg_match("/\.({$config['cf_image_extension']})$/i", $row['bf_file'])) {
                            delete_board_thumbnail($bo_table, $row['bf_file']);
                        }
                    }
                }

                // 프로그램 원래 파일명
                $upload[$i]['source'] = $filename;
                $upload[$i]['filesize'] = $filesize;

                // 아래의 문자열이 들어간 파일은 -x 를 붙여서 웹경로를 알더라도 실행을 하지 못하도록 함
                $filename = preg_replace("/\.(php|pht|phtm|htm|cgi|pl|exe|jsp|asp|inc)/i", "$0-x", $filename);
                shuffle($chars_array);
                $shuffle = implode('', $chars_array);
                // 첨부파일 첨부시 첨부파일명에 공백이 포함되어 있으면 일부 PC에서 보이지 않거나 다운로드 되지 않는 현상이 있습니다. (길상여의 님 090925)
                $upload[$i]['file'] = abs(ip2long($_SERVER['REMOTE_ADDR'])).'_'.substr($shuffle,0,8).'_'.replace_filename($filename);
                $dest_file = G5_DATA_PATH.'/file/'.$bo_table.'/'.$upload[$i]['file'];
                // 업로드가 안된다면 에러메세지 출력하고 죽어버립니다.
                $error_code = move_uploaded_file($tmp_file, $dest_file) or die($_FILES['bf_file']['error'][$i]);
                // 올라간 파일의 퍼미션을 변경합니다.
                chmod($dest_file, G5_FILE_PERMISSION);
                //$dest_file = run_replace('write_update_upload_file', $dest_file, $board, $wr_id, $w);
                //$upload[$i] = run_replace('write_update_upload_array', $upload[$i], $dest_file, $board, $comment_id, $w);
            }
        }   // end for
    }   // end if

    // 나중에 테이블에 저장하는 이유는 $wr_id 값을 저장해야 하기 때문입니다.
    for ($i=0; $i<count($upload); $i++) {
        $upload[$i]['source'] = sql_real_escape_string($upload[$i]['source']);
        $bf_content[$i] = isset($bf_content[$i]) ? sql_real_escape_string($bf_content[$i]) : '';
        $bf_width = isset($upload[$i]['image'][0]) ? (int) $upload[$i]['image'][0] : 0;
        $bf_height = isset($upload[$i]['image'][1]) ? (int) $upload[$i]['image'][1] : 0;
        $bf_type = isset($upload[$i]['image'][2]) ? (int) $upload[$i]['image'][2] : 0;

        $row = sql_fetch(" select count(*) as cnt from {$g5['board_file_table']} where bo_table = '{$bo_table}' and wr_id = '{$comment_id}' and bf_no = '{$i}' ");
        if ($row['cnt']) {
            // 삭제에 체크가 있거나 파일이 있다면 업데이트를 합니다.
            // 그렇지 않다면 내용만 업데이트 합니다.
            if ($upload[$i]['del_check'] || $upload[$i]['file']) {
                $sql = " update {$g5['board_file_table']}
                            set bf_source = '{$upload[$i]['source']}',
                                 bf_file = '{$upload[$i]['file']}',
                                 bf_content = '{$bf_content[$i]}',
                                 bf_fileurl = '{$upload[$i]['fileurl']}',
                                 bf_thumburl = '{$upload[$i]['thumburl']}',
                                 bf_storage = '{$upload[$i]['storage']}',
                                 bf_filesize = '".(int)$upload[$i]['filesize']."',
                                 bf_width = '".$bf_width."',
                                 bf_height = '".$bf_height."',
                                 bf_type = '".$bf_type."',
                                 bf_datetime = '".G5_TIME_YMDHIS."'
                          where bo_table = '{$bo_table}'
                                    and wr_id = '{$comment_id}'
                                    and bf_no = '{$i}' ";
                sql_query($sql);
            } else {
                $sql = " update {$g5['board_file_table']}
                            set bf_content = '{$bf_content[$i]}'
                            where bo_table = '{$bo_table}'
                                      and wr_id = '{$comment_id}'
                                      and bf_no = '{$i}' ";
                sql_query($sql);
            }
        } else {
            $sql = " insert into {$g5['board_file_table']}
                        set bo_table = '{$bo_table}',
                             wr_id = '{$comment_id}',
                             bf_no = '{$i}',
                             bf_source = '{$upload[$i]['source']}',
                             bf_file = '{$upload[$i]['file']}',
                             bf_content = '{$bf_content[$i]}',
                             bf_fileurl = '{$upload[$i]['fileurl']}',
                             bf_thumburl = '{$upload[$i]['thumburl']}',
                             bf_storage = '{$upload[$i]['storage']}',
                             bf_download = 0,
                             bf_filesize = '".(int)$upload[$i]['filesize']."',
                             bf_width = '".$bf_width."',
                             bf_height = '".$bf_height."',
                             bf_type = '".$bf_type."',
                             bf_datetime = '".G5_TIME_YMDHIS."' ";
            sql_query($sql);

            //run_event('write_update_file_insert', $bo_table, $comment_id, $upload[$i], $w);
        }
    }

    // 업로드된 파일 내용에서 가장 큰 번호를 얻어 거꾸로 확인해 가면서
    // 파일 정보가 없다면 테이블의 내용을 삭제합니다.
    $row = sql_fetch(" select max(bf_no) as max_bf_no from {$g5['board_file_table']} where bo_table = '{$bo_table}' and wr_id = '{$comment_id}' ");
    for ($i=(int)$row['max_bf_no']; $i>=0; $i--) {
        $row2 = sql_fetch(" select * from {$g5['board_file_table']} where bo_table = '{$bo_table}' and wr_id = '{$comment_id}' and bf_no = '{$i}' ");
        // 정보가 있다면 빠집니다.
        if ($row2['bf_file']) {
            $data['comment']['file'] = get_file($bo_table, $comment_id); //댓글 업데이트를 위해 파일 정보를 내보냄
            break;
        }
        // 그렇지 않다면 정보를 삭제합니다.
        sql_query(" delete from {$g5['board_file_table']} where bo_table = '{$bo_table}' and wr_id = '{$comment_id}' and bf_no = '{$i}' ");
    }

    // 파일의 개수를 게시물에 업데이트 한다.
    $row = sql_fetch(" select count(*) as cnt from {$g5['board_file_table']} where bo_table = '{$bo_table}' and wr_id = '{$comment_id}' ");
    sql_query(" update {$write_table} set wr_file = '{$row['cnt']}' where wr_id = '{$comment_id}' ");
    $data['fw_message'] = $file_upload_msg;
}


//추천, 비추천
if($act == 'good' || $act == 'nogood') {
    if($bo_table && $wr_id) { //게시판
        $write = sql_fetch(" select * from {$g5['write_prefix']}{$bo_table} where wr_id = '{$wr_id}'", FALSE);
        $msg = '추천';
        if($act == 'nogood') {
            $msg = '비추천';
        }
        if(!$write['wr_id']) {
            $data['result']  = 'failer';
            $data['message'] = '존재하는 글이 아닙니다.';
            die(json_encode($data));
        }
        if($member['mb_id'] == $write['mb_id']) {
            $data['result']  = 'failer';
            $data['message'] = '자신의 글은 '.$msg.' 할 수 없습니다.';
            die(json_encode($data));
        }
        $sql = " select bg_flag from {$g5['board_good_table']}
                    where bo_table = '{$bo_table}'
                    and wr_id = '{$wr_id}'
                    and mb_id = '{$member['mb_id']}'
                    and bg_flag in ('good', 'nogood') ";
        $row = sql_fetch($sql);
        if($row['bg_flag']) {
            if ($row['bg_flag'] == 'good') {
                $status = '추천';
            } else {
                $status = '비추천';
            }
            $data['result']  = 'failer';
            $data['message'] = '이미 '.$status.' 하신 글입니다.';
            die(json_encode($data));
        }

        // 추천(찬성), 비추천(반대) 카운트 증가
        sql_query(" update {$g5['write_prefix']}{$bo_table} set wr_{$act} = wr_{$act} + 1 where wr_id = '{$wr_id}' ");
        // 내역 생성
        sql_query(" insert {$g5['board_good_table']} set bo_table = '{$bo_table}', wr_id = '{$wr_id}', mb_id = '{$member['mb_id']}', bg_flag = '{$act}', bg_datetime = '".G5_TIME_YMDHIS."' ");
        $sql = " select wr_{$act} as count from {$g5['write_prefix']}{$bo_table} where wr_id = '$wr_id' ";
        $row = sql_fetch($sql);
        $data['result']  = 'success';
        $data['message'] = '이 글을 '.$msg.' 하였습니다.';
        $data['count']   = $row['count'];
    }
}

$data['w']  = $w;
die(json_encode($data));