<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once($board_skin_path.'/board.lib.php');

/* DB 체크 */
board_table_replace();


// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 1);

if($is_category) {
    $category = explode('|', $board['bo_category_list']);
}
?>

<!-- 게시판 목록 시작 { -->
<div id="board-list">
    <!-- 게시판 카테고리 시작 { -->
    <?php if ($is_category) { ?>
    <nav id="bo_cate">
        <h2><?php echo $board['bo_subject'] ?> 카테고리</h2>
        <ul id="bo_cate_ul">
            <?php
            $on = $sca ? '' : ' id="bo_cate_on"';
            echo '<li><a href="'.$category_href.'" '.$on.'>전체<span class="total_count">('.number_format($total_count).')</span></a></li>';
            foreach($category as $k=>$v) {
                $on = ($v == $sca) ? ' id="bo_cate_on"' : '';
                echo '<li><a href="'.(get_pretty_url($bo_table,'','sca='.urlencode(trim($v)))).'" '.$on.'>'.trim($v).'<span class="total_count">('.number_format($total_count).')</span></a></li>';
            }
            ?>
        </ul>
    </nav>
    <?php } ?>
    <!-- } 게시판 카테고리 끝 -->
    <?php if (!$is_category) { ?>
    <div class="list-total">
        <span class="total_txt"><?php echo ($stx) ? '<b>'.$stx.'</b>' : 'Total'; ?> <?php echo number_format($total_count) ?></span>
        <span class="total_page"><?php echo $page ?> Page</span>
    </div>
    <?php } ?>
    
    <form name="fboardlist" id="fboardlist" action="<?php echo G5_BBS_URL; ?>/board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
    <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
    <input type="hidden" name="stx" value="<?php echo $stx ?>">
    <input type="hidden" name="spt" value="<?php echo $spt ?>">
    <input type="hidden" name="sca" value="<?php echo $sca ?>">
    <input type="hidden" name="sst" value="<?php echo $sst ?>">
    <input type="hidden" name="sod" value="<?php echo $sod ?>">
    <input type="hidden" name="page" value="<?php echo $page ?>">
    <input type="hidden" name="sw" value="">
    <!-- 게시판 목록 -->
    <div class="list-article">
        <ul>
            <li class="list-head mobile-none">
                <?php if ($is_checkbox) { ?>
                <div class="cell-check mobile-none">
                    <input type="checkbox" id="chkall" onclick="if (this.checked) all_checked(true); else all_checked(false);" class="selec_chk">
                    <label for="chkall"><b class="sound_only">현재 페이지 게시물  전체선택</b></label>
                </div>
                <?php } ?>
                <div class="cell-num mobile-none">번호</div>
                <?php if($is_category) { ?><div class="cell-cate">분류</div><?php } ?>
                <div class="cell-subject">제목</div>
                <div class="cell-name">닉네임</div>
                <?php if ($is_good) { ?><div class="cell-good"><?php echo subject_sort_link('wr_good', $qstr2, 1) ?>추천 </a></div><?php } ?>
                <?php if ($is_nogood) { ?><div class="cell-nogood"><?php echo subject_sort_link('wr_nogood', $qstr2, 1) ?>비추천 </a></div><?php } ?>
                <div class="cell-hit">조회</div>
                <div class="cell-date">날짜</div>
            </li>
            <?php
            for($i=0; $i<count($list); $i++) {
                $lt_class = ($i%2==0) ? 'even' : '';
                $lt_padding = $list[$i]['reply'] ? 'style="padding-left:'.(strlen($list[$i]['wr_reply'])*10).'px;"' : '';
                $lt_new     = $list[$i]['icon_new'] ? 'new_article' : '';

                $movie_id = '';
                if($list[$i]['wr_movie_url']) {
                    $movie_id = get_movie_id($list[$i]['wr_movie_url']);
                }
                
                echo '<li class="list-body '.$lt_class.'">';
                    if($is_checkbox) {
                        echo '<div class="cell-check mobile-none">';
                            echo '<input type="checkbox" name="chk_wr_id['.$i.']" value="'.$list[$i]['subject'].'" id="chk_wr_id_'.$i.'" class="list_chk">';
                            echo '<label for="chk_wr_id_'.$i.'"><span class="sound_only"></span></label>';
                        echo '</div>';
                    }
                    if ($list[$i]['is_notice']) { //notice or num
                        echo '<div class="cell-num cell-notice"><span class="notice"><i class="fa fa-volume-up"></i></span></div>'; 
                    } else if($wr_id == $list[$i]['wr_id']) {
                        echo '<div class="cell-num cell-notice"><span class="notice read"><i class="fa fa-spinner fa-spin"></i></span></div>';
                    } else {
                        echo '<div class="cell-num mobile-none">'.$list[$i]['num'].'</div>';
                    }
                    if($is_category) { echo '<div class="cell-cate"><a href="'.$list[$i]['ca_name_href'].'" class="cate_link">'.$list[$i]['ca_name'].'</a></div>'; }
                    
                    echo '<div class="cell-subject" '.$lt_padding.'>';
                        echo '<a href="'.$list[$i]['href'].'" class="'.$lt_new.'">';
                            //아이콘 - reply secret new
                            if($list[$i]['icon_reply']) { echo '<span class="reply"><i class="fa fa-reply"></i></span>'; }
                            if($list[$i]['icon_secret']) { echo '<span class="secret"><i class="fa fa-lock"></i></span>'; }
                            if($list[$i]['icon_new']) { echo '<span class="new">N</span>'; }
                            echo $list[$i]['subject'];
                            //아이콘
                            //if (isset($list[$i]['icon_hot']) && $list[$i]['icon_hot'] )  { echo '<span class="hot">H</span>'; } //사용안함
                            //if (isset($list[$i]['icon_file']) && $list[$i]['icon_file'] ) { echo '<span class="file"><i class="fa fa-file-image-o"></i></span>'; } 사용안함
                            //if (isset($list[$i]['icon_link']) && $list[$i]['icon_link'] ) { echo '<span class="link"></span>'; } //사용안함
                            //댓글
                            if ($list[$i]['wr_cmt_num'] > 0) { echo '<span class="cnt_cmt">'.$list[$i]['wr_cmt_num'].'</span>'; }
                        echo '</a>';
                        /* movie는 차후 리스트에서 클릭 가능하도록 a 태그 밖으로 뺌. 플레이리스트 */
                        if (isset($list[$i]['wr_movie_url']) && $movie_id) { echo '<span class="movie" data-uid="'.$movie_id.'"><i class="fa fa-youtube-play"></i></span>'; }
                    echo '</div>';
                    echo '<div class="cell-name"><span class="name">'.$list[$i]['name'].'</span></div>';
                    if($is_good) { echo '<div class="cell-good"><span class="mobile-title">추천</span><span class="good">'.$list[$i]['wr_good'].'</span></div>'; }
                    if($is_nogood) { echo '<div class="cell-nogood"><span class="mobile-title">비추천</span><span class="nogood">'.$list[$i]['wr_nogood'].'</span></div>'; }
                    echo '<div class="cell-hit"><span class="hit"><span class="mobile-title">조회</span>'.$list[$i]['wr_hit'].'</span></div>';
                    echo '<div class="cell-date"><span class="date"><span class="mobile-title">날짜</span>'.$list[$i]['datetime2'].'</span></div>';
                echo '</li>';
            }
            ?>
        </ul>
        <?php if(count($list) == 0) { ?>
            <div class="list-empty">게시물이 없습니다.</div>';
        <?php } ?>
    </div>
    <!-- 게시판 목록 -->
    <!-- 버튼 -->
    <div class="list-btn mobile-padding">
        <div class="list-check">
        <?php if ($is_checkbox) { ?>	
            <ul class="mobile-none">
                <li><button type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value" class="btn_board btn_board_del">선택삭제</button></li>
                <li><button type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value" class="btn_board btn_board_copy">선택복사</button></li>
                <li><button type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value" class="btn_board btn_board_move">선택이동</button></li>
            </ul>
        <?php } ?>
        </div>
        <div class="list-search">
            <button type="button" class="btn_board btn_board_search mobile-only" id="open_search"><i class="fa fa-search"></i></button>
            <form name="fsearch" method="get" class="fsearch">
                <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
                <input type="hidden" name="sca" value="<?php echo $sca ?>">
                <input type="hidden" name="sop" value="and">
                <div class="search-form">
                    <div class="search-box">
                        <label for="sfl" class="sound_only">검색대상</label>
                        <select name="sfl" id="sfl">
                            <?php echo get_board_sfl_select_options($sfl); ?>
                        </select>
                        <label for="stx" class="sound_only">검색어<strong class="sound_only"> 필수</strong></label>
                        <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx" class="sch_input" size="25" maxlength="20" placeholder=" 검색어를 입력해주세요">
                        <button type="submit" value="검색" class="btn_board btn_board_search"><i class="fa fa-search" aria-hidden="true"></i><span class="sound_only">검색</span></button>
                        <button type="button" class="btn_board btn_board_close" id="close_search">닫기</button>
                    </div>
                </div>
            </form>
        </div>
        <div class="list-user mobile-padding">
        <?php if ($list_href || $write_href) { ?>
            <ul>
                <?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="btn_board btn_board_admin" title="관리자">관리자</a></li><?php } ?>
                <?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" class="btn_board btn_board_rss" title="RSS">RSS</a></li><?php } ?>
                <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_board btn_board_write" title="글쓰기">글쓰기</a></li><?php } ?>
            </ul>
        <?php } ?>
        </div>
    </div>
    <!-- 버튼 -->
	<!-- 페이지 -->
    <div class="page-wrapper">
	    <?php echo $write_pages; ?>
    </div>
	<!-- 페이지 -->
    </form>
</div>

<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<?php if ($is_checkbox) { ?>
<script>
$(function() {
    $('#open_search').click(function(){
        if( $('.list-search').hasClass('open')) {
            $('.list-search').removeClass('open');
        } else {
            $('.list-search').addClass('open');
        }
    });
    $('#close_search').click(function(){
        $('#open_search').trigger('click');
    });
});

function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = g5_bbs_url+"/board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == "copy")
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = g5_bbs_url+"/move.php";
    f.submit();
}

</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->
