<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');
$thumb_long = 960; // 썸네일 긴축
$thumb_width = 399; // 화면에 표시될 썸네일 너비
/*
1880px 기준
width: 399,  4개
width: 320,  5개
width: 270,  6개
width: 244,  7개
*/

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/css/style.css">', 1000);
/* add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/css/imagelightbox.css">', 1000); */
add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/css/lightgallery.css">', 1000);

// 게시글리스트 썸네일 생성
function get_list_thumbnail_masonry($bo_table, $wr_id, $thumb_long, $is_create=false, $is_crop=false, $crop_mode='center', $is_sharpen=false, $um_value='80/0.5/3')
{
    global $g5, $config;
    $filename = $alt = "";
    $edt = false;

    $sql = " select bf_file, bf_content from {$g5['board_file_table']}
                where bo_table = '$bo_table' and wr_id = '$wr_id' and bf_type between '1' and '3' order by bf_no limit 0, 1 ";
    $row = sql_fetch($sql);

    if($row['bf_file']) {
        $filename = $row['bf_file'];
        $filepath = G5_DATA_PATH.'/file/'.$bo_table;
        $alt = get_text($row['bf_content']);
        $srcfile = $filepath.'/'.$filename;
        $size = @getimagesize($srcfile);
    } else {
        $write_table = $g5['write_prefix'].$bo_table;
        $sql = " select wr_content from $write_table where wr_id = '$wr_id' ";
        $write = sql_fetch($sql);
        $matches = get_editor_image($write['wr_content'], false);
        $edt = true;

        for($i=0; $i<count($matches[1]); $i++)
        {
            // 이미지 path 구함
            $p = parse_url($matches[1][$i]);
            if(strpos($p['path'], '/'.G5_DATA_DIR.'/') != 0)
                $data_path = preg_replace('/^\/.*\/'.G5_DATA_DIR.'/', '/'.G5_DATA_DIR, $p['path']);
            else
                $data_path = $p['path'];

            $srcfile = G5_PATH.$data_path;

            if(preg_match("/\.({$config['cf_image_extension']})$/i", $srcfile) && is_file($srcfile)) {
                $size = @getimagesize($srcfile);
                if(empty($size))
                    continue;

                $filename = basename($srcfile);
                $filepath = dirname($srcfile);

                preg_match("/alt=[\"\']?([^\"\']*)[\"\']?/", $matches[0][$i], $malt);
                $alt = get_text($malt[1]);

                break;
            }
        }
    }

    // jpg 이면 exif 체크
    if($size[2] == 2 && function_exists('exif_read_data')) {
        $degree = 0;
        $exif = @exif_read_data($srcfile);
        if(!empty($exif['Orientation'])) {
            switch($exif['Orientation']) {
                case 8:
                    $degree = 90;
                    break;
                case 3:
                    $degree = 180;
                    break;
                case 6:
                    $degree = -90;
                    break;
            }
            // 세로사진의 경우 가로, 세로 값 바꿈
            if($degree == 90 || $degree == -90) {
                $tmp = $size;
                $size[0] = $tmp[1];
                $size[1] = $tmp[0];
            }
        }
    }

    $thumb_width = $thumb_height = $thumb_long;
    if($size[0] > $size[1]) {
        // 가로 사진
        $thumb_width = $thumb_long;
        $thumb_height = round(($thumb_long * $size[1]) / $size[0]);
    } else if($size[0] < $size[1]) {
        // 세로사진
        $thumb_width = round(($thumb_long * $size[0]) / $size[1]);
        $thumb_height = $thumb_long;
    }
    if(!$filename)
        return false;

    $tname = thumbnail($filename, $filepath, $filepath, $thumb_width, $thumb_height, $is_create, $is_crop, $crop_mode, $is_sharpen, $um_value);

    if($tname) {
        if($edt) {
            // 오리지날 이미지
            $ori = G5_URL.$data_path;
            // 썸네일 이미지
            $src = G5_URL.str_replace($filename, $tname, $data_path);
        } else {
            $ori = G5_DATA_URL.'/file/'.$bo_table.'/'.$filename;
            $src = G5_DATA_URL.'/file/'.$bo_table.'/'.$tname;
        }
    } else {
        return false;
    }

    $thumb = array("src"=>$src, "ori"=>$ori, "alt"=>$alt);

    return $thumb;
}
?>
<!-- 게시판 목록 시작 { -->
<div>
    <div class="waterfall_wrap">
        <ul id="waterfall">
        <?php for ($i=0; $i<count($list); $i++) {
            if($bo_gallery_cols > 0 && $i>0 && ($i % $bo_gallery_cols == 0))
                $style = 'clear:both;';
            else
                $style = '';
            if ($i == 0) $k = 0;
            $k += 1;
            if ($bo_gallery_cols > 0 && $k % $bo_gallery_cols == 0) $style .= "margin:0 !important;";
            $thumb = get_list_thumbnail_masonry($bo_table, $list[$i]['wr_id'], $thumb_long);
            if($thumb['src']) {
                $img_content = '<img src="'.$thumb['src'].'" alt="'.$thumb['alt'].'" style="width:100%">';
            } else {
                continue;
            }
         ?>
			<li data-src="<?php echo $thumb['src']; ?>" data-sub-html="<?php echo $list[$i]['subject']; ?>" class="photo">
			<div>
				<a href=""><?php echo $img_content ?></a>
			</div>							<span class="caption">
								<?php echo $list[$i]['subject'] ?>
							</span>

			</li>
        <?php } ?>
        </ul>
        </form>
    </div>
</div>

<script type="text/javascript" src="<?php echo $latest_skin_url ?>/js/lightgallery-all.min.js"></script>
<script type="text/javascript" src="<?php echo $latest_skin_url ?>/js/newWaterfall.js"></script>
<script type="text/javascript" src="<?php echo $latest_skin_url ?>/js/jquery.mousewheel.min.js"></script>
<script type="text/javascript" src="<?php echo $latest_skin_url ?>/js/picturefill.min.js"></script>
<script type="text/javascript">
$(document).ready(function ()
{
    $('#waterfall').NewWaterfall({
        width: <?php echo $thumb_width ?>,
        delay: 50,
    });
    
    $('#waterNone').NewWaterfall({
        width: <?php echo $thumb_width ?>,
        delay: 50,
    }); 
   
    $('#waterfall').lightGallery();

});
</script>

