<div style="display: none">
<h1>Speech wave</h1>
   
    <p id="txt1"></p>
    <form>
    <input type="text" class="txt" id="txt" value="<?=strip_tags($view['wr_content'])?>">
    <div>
      <label for="rate">Rate</label><input type="range" min="0.5" max="2" value="1.5" step="0.1" id="rate">
      <div class="rate-value">1.5</div>
      <div class="clearfix"></div>
    </div>
    <div>
      <label for="pitch">Pitch</label><input type="range" min="0" max="2" value="1" step="0.1" id="pitch">
      <div class="pitch-value">1</div>
      <div class="clearfix"></div>
    </div>
      <div>
      <label for="volume">Volume</label><input type="range" min="0" max="2" value="1" step="0.1" id="volume">
      <div class="volume-value">1</div>
      <div class="clearfix"></div>
      </div>      
    <select>

    </select>
    </form>
    <button onclick="voiceStart()"></button>
</div>
<script>
var synth = window.speechSynthesis;

var inputForm = document.querySelector('form');
var inputTxt = document.querySelector('.txt');
var voiceSelect = document.querySelector('select');

var pitch = document.querySelector('#pitch');
var pitchValue = document.querySelector('.pitch-value');
var rate = document.querySelector('#rate');
var rateValue = document.querySelector('.rate-value');
var volume = document.querySelector('#volume');
var volumeValue = document.querySelector('.volume-value');

var voices = [];
var texttimer = 0;


function populateVoiceList() {
	  voices = synth.getVoices();

	  for(i = 0; i < voices.length ; i++) {
	    var option = document.createElement('option');
	    option.textContent = voices[i].name + ' (' + voices[i].lang + ')';
	    
	    if(voices[i].default) {
	      option.textContent += ' -- DEFAULT';
	    }
	    if(i==2){
	    option.setAttribute('data-lang', voices[i].lang);
	    option.setAttribute('data-name', voices[i].name);
	    voiceSelect.appendChild(option);
	    break;
	    }
	  }
	}

populateVoiceList();
if (speechSynthesis.onvoiceschanged !== undefined) {
  speechSynthesis.onvoiceschanged = populateVoiceList;
}

inputForm.onsubmit = function(event) {
  event.preventDefault();
  
  var utterThis = new SpeechSynthesisUtterance(inputTxt.value);
  var selectedOption = voiceSelect.selectedOptions[0].getAttribute('data-name');
  for(i = 0; i < voices.length ; i++) {
    if(voices[i].name === selectedOption) {
      utterThis.voice = voices[i];
    }
  }
  utterThis.pitch = pitch.value;
  utterThis.rate = rate.value;
  utterThis.volume = volume.value;
  synth.speak(utterThis);

  utterThis.onstart   = function(event) {
    var char = event.utterance.text.charAt(event.charIndex);
    var x = 'Speech paused at character ' + event.charIndex + ' of "' +
    event.utterance.text + '", which is "' + char + '".';
    var str = event.utterance.text;
    texttimer = event.elapsedTime;
    textAnimaion();
  }

  inputTxt.blur();
}

 function voiceStart() {
	  
	  var utterThis = new SpeechSynthesisUtterance(inputTxt.value);
	  var selectedOption = voiceSelect.selectedOptions[0].getAttribute('data-name');
	  for(i = 0; i < voices.length ; i++) {
	    if(voices[i].name === selectedOption) {
	      utterThis.voice = voices[i];
	    }
	  }
	  utterThis.pitch = pitch.value;
	  utterThis.rate = rate.value;
	  utterThis.volume = volume.value;
	  synth.speak(utterThis);

	  utterThis.onstart   = function(event) {
	    var char = event.utterance.text.charAt(event.charIndex);
	    var x = 'Speech paused at character ' + event.charIndex + ' of "' +
	    event.utterance.text + '", which is "' + char + '".';
	    var str = event.utterance.text;
	    texttimer = event.elapsedTime;
	    textAnimaion();
	  }

	  inputTxt.blur();
}

pitch.onchange = function() {
  pitchValue.textContent = pitch.value;
}

rate.onchange = function() {
  rateValue.textContent = rate.value;
}

volume.onchange= function(){
  volumeValue.textContent = volume.value;
}
function textAnimaion(){
    var txt = document.getElementById("txt1");
    var txt1 = document.getElementById("txt");

    var str = txt1.value;
    var count = 0;
    var max = str.length;
    txt.innerHTML = "";
    texttimer = texttimer/10000000/3.514718625761431; //milliseconds
    var id = setInterval(countA, texttimer);
    function countA(){
      txt.innerHTML = txt.innerHTML+str[count]; count++;

       if(count==max)clearInterval(id);
    }
}
</script>