<?php
if (! defined("_GNUBOARD_"))
    exit(); // 개별 페이지 접근 불가

add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/css/modal.css">', 0);
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/css/kakaoMap.css">', 0);
?>
<style>
p {margin:0!important}
#marker-info {
    background: rgba(255, 255, 255, 0.49)!important;
} 
.road-img, .road-title, .road-content {
    float: left;
}
.road-img {
    padding: 10px;
    width: 80px;
}
.road-title {
    margin-top: 10px;
    width: 200px;
}
.road-content {
    margin-top: 0px;
    width: 120px;
}
</style>
<!-- 지도를 생성합니다 -->
<button type="button" class="btn btn-primary btn-lg btn-block mb-1"
	onclick="list_on('#kakaomap','list_on')">카카오맵</button>
<script>
function list_on (div_id,div_class) {
	$(div_id).toggleClass(div_class);
}
</script>
<div id="kakaomap">
	<!-- 지도를 표시할 div 입니다 -->
	<div id="map" style="width: 100%; height: 350px;"></div>
	<!-- 로드뷰를 표시할 div 입니다 -->
	<div id="roadview" style="width: 100%; height: 300px;"></div>

	<div class="input-group-text">
		<button type="button" class="btn btn-primary btn-sm m-1"
			onclick="sumSetAnchor('#wr_4','#wr_5')">+</button>
		<button type="button" class="btn btn-secondary btn-sm m-1"
			onclick="minSetAnchor('#wr_4','#wr_5')">-</button>
		<input id="wr_4" class="form-control m-1" name="wr_4" type="text"
			value="<?php if(strlen($write['wr_4']) > 0) echo $write['wr_4']; else echo 0;?>"
			readonly> <label for="exampleInputEmail1"
			class="d-flex justify-content-center align-items-center">#윈도우마커
			높이를 조절<br>지도를 클릭하세요
		</label>
	</div>
	<div class="input-group-text" style="display: none"> 
		<button type="button" class="btn btn-primary btn-sm m-1"
			onclick="RLsumSetAnchor('#wr_4','#wr_5')">+</button>
		<button type="button" class="btn btn-secondary btn-sm m-1"
			onclick="RLminSetAnchor('#wr_4','#wr_5')">-</button>
		<input id="wr_5" class="form-control m-1" name="wr_5" type="text"
			value="<?php if(strlen($write['wr_5']) > 0) echo $write['wr_5']; else echo 10;?>"
			readonly> <label for="exampleInputEmail1"
			class="d-flex justify-content-center align-items-center">#윈도우마커
			가 보일수있는 <br>반경을 설정합니다
		</label>
	</div>	
	<div class="bo_w_link write_div">
		<label for="wr_10"><i class="fa fa-globe" aria-hidden="true"></i><span
			class="sound_only">다음지도 API</span></label> <input type="text"
			name="wr_10" value="<?php if($w=="u"){echo$write['wr_10'];} ?>"
			id="wr_10" class="frm_input full_input" onkeyup="map_Search()"
			size="50" placeholder="주소를 입력하세요">
	</div>
	<label>위도를 검색하는 좌표입니다 <a target="_blank"
		href="https://www.geoplaner.com/"><strong>위도 경도 좌표얻기<i
				class="fa fa-external-link"></i></strong></a></label>
	<div class="bo_w_link write_div">
		<label for="wr_1"><i class="fa fa-globe" aria-hidden="true"></i><span
			class="sound_only">다음지도 API</span></label> <input type="text"
			name="wr_1" value="<?php if($w=="u"){echo$write['wr_1'];} ?>"
			id="wr_1" class="frm_input full_input" onkeyup="map_key_Search()" size="50"
			placeholder="위도 좌표를 입력합니다">
	</div>
	<label>경도를 검색하는 좌표입니다</label>
	<div class="bo_w_link write_div">
		<label for="wr_2"><i class="fa fa-globe" aria-hidden="true"></i><span
			class="sound_only">다음지도 API</span></label> <input type="text"
			name="wr_2" value="<?php if($w=="u"){echo$write['wr_2'];} ?>"
			id="wr_2" class="frm_input full_input" onkeyup="map_key_Search()" size="50"
			placeholder="경도 좌표를 입력합니다">
	</div>
	<label>길찾기 링크입니다</label>
	<div class="bo_w_link write_div">
		<label for="wr_3"><i class="fa fa-globe" aria-hidden="true"></i><span
			class="sound_only">다음지도 API</span></label> <input type="text"
			name="wr_3" value="<?php if($w=="u"){echo$write['wr_3'];} ?>"
			id="wr_3" class="frm_input full_input" size="50"
			placeholder="길찾기 링크입니다">
	</div>
</div>
<!-- 지도 생성 종료 -->

<script type="text/javascript"
	src="//dapi.kakao.com/v2/maps/sdk.js?appkey=<?=$config[cf_kakao_rest_key]?>&libraries=services""></script>
<script>
var x = $('#wr_1').val();
var y = $('#wr_2').val();

var mapContainer = document.getElementById('map'), // 지도를 표시할 div 
mapOption = { 
    center: new kakao.maps.LatLng(x, y), // 지도의 중심좌표
    level: 3 // 지도의 확대 레벨
};
 
// 지도를 생성합니다    
var map = new kakao.maps.Map(mapContainer, mapOption); 

// 장소 검색 객체를 생성합니다
var ps = new kakao.maps.services.Places(); 

//마커가 표시될 위치입니다 
var markerPosition  = new kakao.maps.LatLng(x, y);

//마커를 생성합니다
var marker = new kakao.maps.Marker({
    position: markerPosition
});

//마커가 지도 위에 표시되도록 설정합니다
marker.setMap(map);

var iwContent = infoSeDiv("#wr_10","#wr_3");
var iwPosition = new kakao.maps.LatLng(x, y); //인포윈도우 표시 위치입니다
setTimeout(function(){
$("#marker-info").parent("div").parent("div").attr("id","Infomation");
},500);
    
// 인포윈도우를 생성합니다
var infowindow = new kakao.maps.InfoWindow({
    position : iwPosition, 
    content : iwContent 
});
//로드뷰를 로드합니다 
roadView(x, y);

// 마커 위에 인포윈도우를 표시합니다. 두번째 파라미터인 marker를 넣어주지 않으면 지도 위에 표시됩니다
//infowindow.open(map, marker); 
// 키워드로 장소를 검색합니다
function map_Search() {
	ps.keywordSearch($("#wr_10").val(), placesSearchCB); 
	var x = $('#wr_1').val();
	var y = $('#wr_2').val();
	roadView(x, y);
}
function map_key_Search() {
	var x = $('#wr_1').val();
	var y = $('#wr_2').val();
	roadView(x, y);
}
// 키워드 검색 완료 시 호출되는 콜백함수 입니다
function placesSearchCB (data, status, pagination) {
    if (status === kakao.maps.services.Status.OK) {

        // 검색된 장소 위치를 기준으로 지도 범위를 재설정하기위해
        // LatLngBounds 객체에 좌표를 추가합니다
        var bounds = new kakao.maps.LatLngBounds();

        for (var i=0; i<data.length; i++) {
            //displayMarker(data[i]);    
            bounds.extend(new kakao.maps.LatLng(data[i].y, data[i].x));
        }       
        var latlng = map.getCenter(); 
        setInput($("#wr_10").val(),latlng.getLat(),latlng.getLng());
        // 검색된 장소 위치를 기준으로 지도 범위를 재설정합니다
        map.setBounds(bounds);
    } 
}

// 지도에 마커를 표시하는 함수입니다
function displayMarker(place) {
    
    // 마커를 생성하고 지도에 표시합니다
    var marker = new kakao.maps.Marker({
        map: map,
        position: new kakao.maps.LatLng(place.y, place.x) 
    });

    // 마커에 클릭이벤트를 등록합니다
    kakao.maps.event.addListener(marker, 'click', function() {
        // 마커를 클릭하면 장소명이 인포윈도우에 표출됩니다
        infowindow.setContent('<div style="padding:5px;font-size:12px;">' + place.place_name + '</div>');
        infowindow.open(map, marker);
    });
}

//주소-좌표 변환 객체를 생성합니다
var geocoder = new kakao.maps.services.Geocoder();

// 지도를 클릭했을 때 클릭 위치 좌표에 대한 주소정보를 표시하도록 이벤트를 등록합니다
kakao.maps.event.addListener(map, 'click', function(mouseEvent) {
    searchDetailAddrFromCoords(mouseEvent.latLng, function(result, status) {
        if (status === kakao.maps.services.Status.OK) {
            var detailAddr = !!result[0].road_address ? '<div>도로명주소 : ' + result[0].road_address.address_name + '</div>' : '';
            detailAddr += '<div>지번 주소 : ' + result[0].address.address_name + '</div>';
            
            var content = '<div class="bAddr">' +
                            '<span class="title">법정동 주소정보</span>' + 
                            detailAddr + 
                        '</div>';

						var addr = !!result[0].road_address ? result[0].road_address.address_name :'';
						var getLat = mouseEvent.latLng.getLat();
						var getLng = mouseEvent.latLng.getLng();
						setInput(addr,getLat,getLng);
						var iwPosition = new kakao.maps.LatLng(getLat, getLng); //인포윈도우 표시 위치입니다
                        // 마커를 클릭한 위치에 표시합니다 
                        marker.setPosition(mouseEvent.latLng);
                        marker.setMap(map);
                        marker.setZIndex(3);
                        
                        roadView(getLat, getLng);
						var addr_text = $("#wr_10").val();
						var map_navi_href = $("#wr_3").val();
						var iwContent = infoSeDiv("#wr_10","#wr_3");
                        // 인포윈도우에 클릭한 위치에 대한 법정동 상세 주소정보를 표시합니다
                        infowindow.setPosition(iwPosition);
                        infowindow.setContent(iwContent);
            
            			infowindow.open(map, marker);
        }   
    });
});

function infoSeDiv(id,id2) {
	var addr_text = $(id).val();
	var map_navi_href = $(id2).val();

    var img = '<div class="road-img" style="background-color: rgba(0,0,0,0)!important;"><i style="font-size: 90px;" class="fa fa-map-marker"></i></div>';
    var title = '<div class="road-title" style="background-color: rgba(0,0,0,0)!important;"><span>'+addr_text+'</span></div>';
    var content = '<div class="road-content" style="background-color: rgba(0,0,0,0)!important;"><a href="'+map_navi_href+'" target="_blank">길안내하기<i class="fa fa-external-link"></i></a></div>';
    var iwContent = '<div class="" id="marker-info" style="width: 300px; height: 100px;">'+img+title+content+'</div>'; // 인포윈도우에 표출될 내용으로 HTML 문자열이나 document element가 가능합니다
    setTimeout(function(){
        $("#marker-info").parent("div").parent("div").attr("id","Infomation");
        },500);
	return iwContent;
}

function setInput(addr,getLat,getLng) {
    $("#wr_10").val(addr);
    
    $("#wr_1").val(getLat);
    $("#wr_2").val(getLng);

    $("#wr_3").val("https://map.kakao.com/link/to/"+addr+","+getLat+","+getLng);
}

function searchAddrFromCoords(coords, callback) {
    // 좌표로 행정동 주소 정보를 요청합니다
    geocoder.coord2RegionCode(coords.getLng(), coords.getLat(), callback);         
}

function searchDetailAddrFromCoords(coords, callback) {
    // 좌표로 법정동 상세 주소 정보를 요청합니다
    geocoder.coord2Address(coords.getLng(), coords.getLat(), callback);
}

// 지도 좌측상단에 지도 중심좌표에 대한 주소정보를 표출하는 함수입니다
function displayCenterInfo(result, status) {
    if (status === kakao.maps.services.Status.OK) {
        var infoDiv = document.getElementById('centerAddr');

        for(var i = 0; i < result.length; i++) {
            // 행정동의 region_type 값은 'H' 이므로
            if (result[i].region_type === 'H') {
                infoDiv.innerHTML = result[i].address_name;
                break;
            }
        }
    }    
}



//로드뷰를 생성합니다
function roadView(x,y){ 
    $("#roadview").html("");
	var rvContainer = document.getElementById('roadview'); //로드뷰를 표시할 div
	var rv = new kakao.maps.Roadview(rvContainer); //로드뷰 객체
	var rvClient = new kakao.maps.RoadviewClient(); //좌표로부터 로드뷰 파노ID를 가져올 로드뷰 helper객체
    var mapCenter = new kakao.maps.LatLng(x, y);
    var number = $("#wr_4").val();
    var val_Altitude = parseInt(number);
    // 특정 위치의 좌표와 가까운 로드뷰의 panoId를 추출하여 로드뷰를 띄운다.
    rvClient.getNearestPanoId(mapCenter, 50, function(panoId) {
    	rv.setPanoId(panoId, mapCenter); //panoId와 중심좌표를 통해 로드뷰 실행
    });
    /////////////////////////////////////////////////////////////////////////////////////////////////////
    kakao.maps.event.addListener(rv, 'init', function() {
    	// 커스텀 오버레이를 생성합니다
    	var iwContent = infoSeDiv("#wr_10","#wr_3");
    	var rvCustomOverlay = new kakao.maps.CustomOverlay({
    	    position: mapCenter,
    	    content: iwContent,
    	    altitude : parseInt(val_Altitude), //커스텀 오버레이의 고도값을 설정합니다.(로드뷰 화면 중앙이 0입니다)
    	    xAnchor: 0.5, // 커스텀 오버레이의 x축 위치입니다. 1에 가까울수록 왼쪽에 위치합니다. 기본값은 0.5 입니다
    	    yAnchor: 0.5 // 커스텀 오버레이의 y축 위치입니다. 1에 가까울수록 위쪽에 위치합니다. 기본값은 0.5 입니다
    	}); 
    	rvCustomOverlay.setMap(rv);
    	var projection = rv.getProjection(); // viewpoint(화면좌표)값을 추출할 수 있는 projection 객체를 가져옵니다.

    	// 커스텀오버레이의 position과 altitude값을 통해 viewpoint값(화면좌표)를 추출합니다.
    	var viewpoint = projection.viewpointFromCoords(rvCustomOverlay.getPosition(), rvCustomOverlay.getAltitude());

    	rv.setViewpoint(viewpoint); //커스텀 오버레이를 로드뷰의 가운데에 오도록 로드뷰의 시점을 변화 시킵니다.
    	});
}

function markerRoadSet(xAltitude,yAltitude)  {
    $("#roadview").html("");
	var rvContainer = document.getElementById('roadview'); //로드뷰를 표시할 div
	var rv = new kakao.maps.Roadview(rvContainer); //로드뷰 객체
	var rvClient = new kakao.maps.RoadviewClient(); //좌표로부터 로드뷰 파노ID를 가져올 로드뷰 helper객체
    var mapCenter = new kakao.maps.LatLng($("#wr_1").val(), $("#wr_2").val());
    // 특정 위치의 좌표와 가까운 로드뷰의 panoId를 추출하여 로드뷰를 띄운다.
    rvClient.getNearestPanoId(mapCenter, 50, function(panoId) {
    	rv.setPanoId(panoId, mapCenter); //panoId와 중심좌표를 통해 로드뷰 실행
    });

    /////////////////////////////////////////////////////////////////////////////////////////////////////
    kakao.maps.event.addListener(rv, 'init', function() {
    	// 커스텀 오버레이를 생성합니다
    	var rvCustomOverlay = new kakao.maps.CustomOverlay({
    	    position: mapCenter,
    	    content: iwContent,
    	    xAnchor: 1, // 커스텀 오버레이의 x축 위치입니다. 1에 가까울수록 왼쪽에 위치합니다. 기본값은 0.5 입니다
    	    yAnchor: 1 // 커스텀 오버레이의 y축 위치입니다. 1에 가까울수록 위쪽에 위치합니다. 기본값은 0.5 입니다
    	}); 
    	rvCustomOverlay.setMap(rv);
    	rvCustomOverlay.setAltitude(parseInt(yAltitude)); //마커의 높이를 설정합니다. (단위는 m입니다.)
    	rMarker.setRange(xAltitude); //마커가 보일 수 있는 범위를 설정합니다. (단위는 m입니다.)
    	var projection = rv.getProjection(); // viewpoint(화면좌표)값을 추출할 수 있는 projection 객체를 가져옵니다.

    	// 커스텀오버레이의 position과 altitude값을 통해 viewpoint값(화면좌표)를 추출합니다.
    	var viewpoint = projection.viewpointFromCoords(rvCustomOverlay.getPosition(), rvCustomOverlay.getAltitude());

    	rv.setViewpoint(viewpoint); //커스텀 오버레이를 로드뷰의 가운데에 오도록 로드뷰의 시점을 변화 시킵니다.
    	});
}
//로드뷰 초기화 이벤트 핸들러
function resetRoadview(){
    //초기화를 위해 저장해둔 변수를 통해 로드뷰를 초기상태로 돌립니다.
    rv.setViewpoint({
        pan: rvResetValue.pan, tilt: rvResetValue.tilt, zoom: rvResetValue.zoom
    });
    rv.setPanoId(rvResetValue.panoId);
}

function sumSetAnchor (id,id2) {
      var val = parseInt($(id).val())+1;
      $(id).val(val);

      markerRoadSet($(id2).val(), val);
}

function minSetAnchor (id,id2) {
      var val = parseFloat($(id).val())-1;
      $(id).val(val);

      markerRoadSet($(id2).val(), val);
}
function RLsumSetAnchor (id,id2) {
    var val = parseInt($(id2).val())+1;
    $(id2).val(val);

    markerRoadSet(val, $(id).val());
}

function RLminSetAnchor (id,id2) {
    var val = parseFloat($(id2).val())-1;
    $(id2).val(val);

    markerRoadSet(val, $(id).val());
}
</script>