<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 

//==============================================================================
// g4s 상수 선언을 g4에 그대로 적용 - 모바일은 amina.extend.php 에서 별도 계산
//------------------------------------------------------------------------------

//아미나테마 사용시 G4에서 CSS Buffer 사용시 true 설정 - G4S는 자동 적용
define('G4_CSS_BUFFER', false);

//G4S Define 선언
define('G4_URL', $g4['url']);
define('G4_DOMAIN', $g4['url']);
define('G4_HTTPS_DOMAIN', $g4['https_url']);
define('G4_COOKIE_DOMAIN', $g4['cookie_domain']);
define('G4_DBCONFIG_FILE', 'dbconfig.php');

define('G4_ADMIN_DIR',      'adm');
define('G4_BBS_DIR',        'bbs');
define('G4_CSS_DIR',        'css');
define('G4_DATA_DIR',       'data');
define('G4_EXTEND_DIR',     'extend');
define('G4_IMG_DIR',        'img');
define('G4_JS_DIR',         'js');
define('G4_LIB_DIR',        'lib');
define('G4_PLUGIN_DIR',     'plugin');
define('G4_SKIN_DIR',       'skin');
define('G4_GCAPTCHA_DIR',   'gcaptcha');
define('G4_EDITOR_DIR',     'editor');
define('G4_MOBILE_DIR',     'mobile');
define('G4_KCPCERT_DIR',    'kcpcert');
define('G4_SNS_DIR',        'sns');
define('G4_SYNDI_DIR',      'syndi');

define('G4_ADMIN_URL',      G4_URL.'/'.G4_ADMIN_DIR);
define('G4_BBS_URL',        G4_URL.'/'.G4_BBS_DIR);
define('G4_CSS_URL',        G4_URL.'/'.G4_CSS_DIR);
define('G4_DATA_URL',       G4_URL.'/'.G4_DATA_DIR);
define('G4_IMG_URL',        G4_URL.'/'.G4_IMG_DIR);
define('G4_JS_URL',         G4_URL.'/'.G4_JS_DIR);
define('G4_SKIN_URL',       G4_URL.'/'.G4_SKIN_DIR);
define('G4_PLUGIN_URL',     G4_URL.'/'.G4_PLUGIN_DIR); // 아미나 app폴더로 변경
define('G4_GCAPTCHA_URL',   G4_PLUGIN_URL.'/'.G4_GCAPTCHA_DIR);
define('G4_EDITOR_URL',     G4_PLUGIN_URL.'/'.G4_EDITOR_DIR);
define('G4_KCPCERT_URL',    G4_PLUGIN_URL.'/'.G4_KCPCERT_DIR);
define('G4_SNS_URL',        G4_PLUGIN_URL.'/'.G4_SNS_DIR);
define('G4_SYNDI_URL',      G4_PLUGIN_URL.'/'.G4_SYNDI_DIR);
define('G4_MOBILE_URL',     G4_URL.'/'.G4_MOBILE_DIR);

// PATH 는 서버상에서의 절대경로
define('G4_ADMIN_PATH',     G4_PATH.'/'.G4_ADMIN_DIR);
define('G4_BBS_PATH',       G4_PATH.'/'.G4_BBS_DIR);
define('G4_DATA_PATH',      G4_PATH.'/'.G4_DATA_DIR);
define('G4_EXTEND_PATH',    G4_PATH.'/'.G4_EXTEND_DIR);
define('G4_LIB_PATH',       G4_PATH.'/'.G4_LIB_DIR);
define('G4_PLUGIN_PATH',    G4_PATH.'/'.G4_PLUGIN_DIR); // 아미나 app폴더로 변경
define('G4_SKIN_PATH',      G4_PATH.'/'.G4_SKIN_DIR);
define('G4_GCAPTCHA_PATH',  G4_PLUGIN_PATH.'/'.G4_GCAPTCHA_DIR);
define('G4_EDITOR_PATH',    G4_PLUGIN_PATH.'/'.G4_EDITOR_DIR);
define('G4_KCPCERT_PATH',   G4_PLUGIN_PATH.'/'.G4_KCPCERT_DIR);
define('G4_SNS_PATH',       G4_PLUGIN_PATH.'/'.G4_SNS_DIR);
define('G4_SYNDI_PATH',     G4_PLUGIN_PATH.'/'.G4_SYNDI_DIR);
define('G4_MOBILE_PATH',    G4_PATH.'/'.G4_MOBILE_DIR);
//==============================================================================

define('G4_USE_CACHE',      true); // 최신글등에 cache 기능 사용 여부
define('G4_SERVER_TIME',    $g4['server_time']);
define('G4_TIME_YMDHIS',    date('Y-m-d H:i:s', G4_SERVER_TIME));
define('G4_TIME_YMD',       substr(G4_TIME_YMDHIS, 0, 10));
define('G4_TIME_HIS',       substr(G4_TIME_YMDHIS, 11, 8));

define('G4_ALPHAUPPER',      1); // 영대문자
define('G4_ALPHALOWER',      2); // 영소문자
define('G4_ALPHABETIC',      4); // 영대,소문자
define('G4_NUMERIC',         8); // 숫자
define('G4_HANGUL',         16); // 한글
define('G4_SPACE',          32); // 공백
define('G4_SPECIAL',        64); // 특수문자

// 퍼미션 
define('G4_DIR_PERMISSION',  0755); // 디렉토리 생성시 퍼미션
define('G4_FILE_PERMISSION', 0644); // 파일 생성시 퍼미션

define('G4_MOBILE_AGENT', 'phone|samsung|lgtel|mobile|skt|nokia|blackberry|android|sony');
define('G4_LINK_COUNT', $g4['link_count']);

// 보안서버주소 설정
if (G4_HTTPS_DOMAIN) {
    define('G4_HTTPS_URL',     G4_HTTPS_DOMAIN);
    define('G4_HTTPS_BBS_URL', G4_HTTPS_DOMAIN.'/'.G4_BBS_DIR);
} else {
    define('G4_HTTPS_URL',     G4_URL);
    define('G4_HTTPS_BBS_URL', G4_BBS_URL);
}

// SQL
define('G4_MYSQL_HOST', $mysql_host);
define('G4_MYSQL_USER', $mysql_user);
define('G4_MYSQL_PASSWORD', $mysql_password);
define('G4_MYSQL_DB', $mysql_db);
define('G4_TABLE_PREFIX', $g4['table_prefix']);

// G4S의 g4값 추가
$g4['syndi_log_table'] = G4_TABLE_PREFIX.'syndi_log'; //네이버 신디케이션 컨텐츠 삭제 로그 테이블
$g4['uniqid_table'] = G4_TABLE_PREFIX.'uniqid'; //유니크한 값을 만드는 테이블
$g4['autosave_table'] = G4_TABLE_PREFIX.'autosave'; //게시글 작성시 일정시간마다 글을 임시 저장하는 테이블

?>