<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

//-------------------------------------------------------------------------------------
// AMINA Skin Lib for AMINA BBS & THEMA - Copyright (c) 2012 AMINA - http://amina.co.kr
//
// only for AMINA Write Skin
//-------------------------------------------------------------------------------------

// Check Keys
function amina_chk_keys($keys, $field) {

	if(!$keys || !$filed) return;

	$row = array_keys($keys);

	for($i=0; $i < count($row); $i++){ 
		if($row[$i] == $field) return $field;
	}

	return;
}

//GPS 정보 사용
function amina_photo_GPS() {

	$return = function_exists('exif_read_data') ? true : false;

	return $return;
}

//태그 사용권한 설정
function amina_tag_auth() {
	global $member, $amina, $is_admin;

	$is_tag = false;
	if($is_admin || ($amina['tag'] && $member['mb_level'] >= $amina['tag'])) {
		$is_tag = true;
	} else {
		if($member['mb_id'] && $amina['tag_mb']) {
			$tag_mb = array();
			$tag_mb = explode(",", $amina['tag_mb']);
			if(in_array($member['mb_id'], $tag_mb)) $is_tag = true;
		}
	}

    return $is_tag;
}

//분류 자동 선택
function amina_category($ca_name, $ca_list) {

    $arr = explode("|", $ca_list); // 구분자가 , 로 되어 있음
    $str = '';
    for ($i=0; $i<count($arr); $i++) {
        if (trim($arr[$i])) {
			if(trim($arr[$i]) == $ca_name) { $selected = 'selected'; } else { $selected = ''; }
			$str .= "<option value='$arr[$i]' $selected >$arr[$i]</option>\n";
		}
	}
    return $str;
}

//익명글
function amina_nameless_tail($num) {

	if($num > 0) {
		$temp = str_split('abcdefghijklmnopqrstuvwxyz012345678901234567890123456789'); 
		shuffle($temp); 
		$id = implode('',array_slice($temp,0,$num));
	} else {
		$id = '';
	}

	return $id;
} 

//동영상 이미지 등록 - 모바일 때문에 글등록시 동영상 이미지 미리 불러오기
function amina_video_all($wr_6, $wr_content) {

	include_once(AMINA_PATH.'/lib/video.lib.php');

	$img = array();
	$info = array();
	$video = array();

	//직접링크 동영상
	if($wr_6) {
		$info = amina_array_video($wr_6);
		if($info['movie_url']) {
			$video = amina_video_info($info['movie_info']);
			$video_img = amina_video_img($video['video_url'], $video['vid'], $video['type'], $opt, $video['img']);
			if($video_img) $img[] = $video_img;
		}
	}

	//본문첨부 동영상
	if(preg_match_all("/{동영상\:([^}]*)}/ie", $wr_content, $match)) {
		for ($i=0; $i<count($match[1]); $i++) {
			if(preg_match('/'.AMINA_VIDEO.'/i', $match[1][$i])) {
				list($url) = explode("|", trim(strip_tags($match[1][$i])));
				$video = amina_video_info($url);
				$video_img = amina_video_img($video['video_url'], $video['vid'], $video['type'], $opt, $video['img']);
				if($video_img) $img[] = $video_img;
			}
		}
	}

	return $img;
}

?>