<?
include_once('./_common.php');
include_once(AMINA_PATH.'/lib/view.lib.php');
include_once(AMINA_PATH.'/lib/tag.lib.php');

//RSS Setting
$rss_rows = 10; //뽑아올 글 수

$yoil = array("Sun","Mon","Tue","Wed","Thu","Fri","Sat");

// 특수문자 변환
function specialchars_replace($str, $len=0) {
    if ($len) {
        $str = substr($str, 0, $len);
    }

	$str = preg_replace("/&/", "&amp;", $str);
    $str = preg_replace("/</", "&lt;", $str);
    $str = preg_replace("/>/", "&gt;", $str);
    return $str;
}

// 비회원 읽기가 가능한 게시판만 RSS 지원
if ($board['bo_read_level'] >= 2) {
    echo "비회원 읽기가 가능한 게시판만 RSS 지원합니다.";
    exit;
}

// RSS 사용 체크
if (!$board['bo_use_rss_view']) {
    echo "RSS 보기가 금지되어 있습니다.";
    exit;
}

Header("Content-type: text/xml; charset=utf-8"); 
header("Cache-Control: no-cache, must-revalidate"); 
header("Pragma: no-cache");   

echo '<?xml version="1.0" encoding="UTF-8"?>'."\n";

?>

<rss version="2.0">
<channel>
<title><?=specialchars_replace("{$config['cf_title']} > {$board['bo_subject']}")?></title>
<link><?=specialchars_replace(G4_BBS_URL.'/board.php?bo_table='.$bo_table)?></link>
<description><?=specialchars_replace("{$config['cf_title']} 사이트의 {$board['bo_subject']} 게시판입니다.")?></description>
<language>ko</language>
<pubDate><?=$yoil[date('w', G4_SERVER_TIME)]?>, <?=date('d M Y H:i:s', G4_SERVER_TIME)?> +0900</pubDate>
<generator>AMINA SKIN for G4</generator>

<?
//RSS 추출
$sql = " select * from {$g4['write_prefix']}{$bo_table} where wr_is_comment = 0 and wr_option not like '%secret%' order by wr_num, wr_reply limit 0, $rss_rows ";
$result = sql_query($sql);
for ($i=0; $row=sql_fetch_array($result); $i++) {

	//링크설정
	$link = G4_BBS_URL.'/board.php?bo_table='.$bo_table.'&wr_id='.$row['wr_id']; //짧은 주소

	$row['file'] = get_file($bo_table, $row['wr_id']);
	$row['tag'] = amina_get_tag($bo_table, $row['wr_id']);

	$wr_icon = amina_array_icon($row['wr_5']);
	if($wr_icon['po_view_point'] > 0) {
		if($row['wr_3']) {
			$wr_content = amina_text($row['wr_3']);
		} else {
			$wr_content = amina_cut($row['wr_content'], 250);
		}

		$po_img_list = '';
		if($wr_icon['po_img_cnt'] > 0) {
			$po_img = amina_thumb_img($row['file'], $row['wr_6'], $row['wr_content'], $wr_icon['po_img_cnt'], $row['wr_4'], $row['wr_8'], '');

			for($p=0;$p < count($po_img);$p++) {
				$po_img_list .= "<br><br><img src='".$po_img[$p]."' border=0>";
			}
		}

		$row['wr_content'] = '[미리보기] '.$wr_content.$po_img_list;

	} else {
		$wr_post = amina_array_write($row['wr_10']);
		if($wr_post['img_location'] == "insert") $row['wr_content'] = preg_replace("/{이미지\:([0-9]+)[:]?([^}]*)}/ie", "view_image(\$row, '\\1', '\\2')", $row['wr_content']);
	}
?>
	<item>
	<title><?=specialchars_replace($row['wr_subject'])?></title>
	<link><?=specialchars_replace($link)?></link>
	<description><?=specialchars_replace(amina_view_contents($row['wr_content'], $row['file'], $row['wr_6'], $wr_post, (int)$board['bo_image_width'],"rss"))?></description>
	<? if($row['tag']) { ?>
		<tag><![CDATA[<?=specialchars_replace($row['tag'])?>]]></tag>
	<? } ?>
	<author><?=specialchars_replace($row['wr_name'])?></author>
	<guid><?=specialchars_replace($link)?></guid>
	<pubDate><?=$yoil[date('w', strtotime($row['wr_datetime']))]?>, <?=date('d M Y H:i:s', strtotime($row['wr_datetime']))?> +0900</pubDate>
	</item>
<? } ?>

</channel>
</rss>