<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/style.css">', 0);

add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/owl/owl.carousel.min.css">', 99);
add_stylesheet('<link rel="stylesheet" href="'.$latest_skin_url.'/owl/owl.theme.default.min.css">', 99);
add_javascript('<script src="'.$latest_skin_url.'/owl/owl.carousel.min.js"></script>', 99);

//썸네일 설정
$thumb_width = (isset($options['thumb_w']) && $options['thumb_w'] > 0) ? $options['thumb_w'] : 400;
$thumb_height = (isset($options['thumb_h']) && $options['thumb_h'] > 0) ? $options['thumb_h'] : 300;
$img_h = round(($thumb_height / $thumb_width) * 100, 2);

//제목&내용 라인설정
$options['line'] = (isset($options['line']) && $options['line'] > 0) ? $options['line'] : 1;
$line_height = 20 * $options['line'];
if($options['line'] > 1) $line_height = $line_height + 4;

// 분류
$is_cate = (isset($options['cate']) && $options['cate']) ? true : false;

// 반응형
$lg = (isset($options['lg']) && $options['lg'] > 0) ? $options['lg'] : 4;
$md = (isset($options['md']) && $options['md'] > 0) ? $options['md'] : 3;
$sm = (isset($options['sm']) && $options['sm'] > 0) ? $options['sm'] : 2;
$xs = (isset($options['xs']) && $options['xs'] > 0) ? $options['xs'] : 2;

// owl 옵션
$margin = (isset($options['margin']) && $options['margin'] > 0) ? $options['margin'] : 40;
$slideSpeed = (isset($options['slideSpeed']) && $options['slideSpeed'] > 0) ? $options['slideSpeed'] : 300;
$paginationSpeed = (isset($options['paginationSpeed']) && $options['paginationSpeed'] > 0) ? $options['paginationSpeed'] : 400;
$autoHeight = ($options['autoHeight'] == "1") ? true : false;
$nav = ($options['nav'] == "1") ? true : false;
$loop = ($options['loop'] == "1") ? true : false;
$autoplay = ($options['autoplay'] == "1") ? true : false;
$dots = ($options['dots'] == "1") ? true : false;

$list_count = (is_array($list) && $list) ? count($list) : 0;

?>
<style>
#pic-lt-owlCarousel .post-subject { height:<?php echo $line_height;?>px; }
#pic-lt-owlCarousel .img-wrap { padding-bottom:<?php echo $img_h;?>%; }
</style>
<!-- Start //-->
<div class="latest_box">

	<div class="latest_head">
		<a href="<?php echo get_pretty_url($bo_table); ?>">
			<span class="pull-right latest_more">+ 더보기</span>
			<?php echo $bo_subject ?>
		</a>
	</div>

	<div id="pic-lt-owlCarousel" class="pic-lt-owlCarousel owl-theme owl-carousel">
		<?php
		for ($i=0; $i<$list_count; $i++) {
		$thumb = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);

		if($thumb['src']) {
			$img = $thumb['src'];
		} else {
			$img = G5_IMG_URL.'/no_img.png';
			$thumb['alt'] = '이미지가 없습니다.';
		}
		$img_content = '<img src="'.$img.'" alt="'.$thumb['alt'].'" >';
		$wr_href = get_pretty_url($bo_table, $list[$i]['wr_id']);

		$list[$i]['subject'] = ($list[$i]['is_notice'])?'<strong>'.$list[$i]['subject'].'</strong>':$list[$i]['subject'];

		?>
		<div class="post-row" style="padding:0px;margin:0px;width: 100% !important;">
			<div class="post-list">
				<div class="post-image">
					<a href="<?php echo $wr_href; ?>" class="ellipsis">
						<div class="img-wrap">
							<div class="img-item">
								<?php echo run_replace('thumb_image_tag', $img_content, $thumb); ?>
							</div>
						</div>
					</a>
				</div>
				<div class="post-content">
					<div class="post-subject">
						<a href="<?php echo $wr_href; ?>">
						<?php echo $list[$i]['subject'];?>
						<?php
						if ($list[$i]['icon_new']) echo "<span class=\"new_icon\">N<span class=\"sound_only\">새글</span></span>";
						if ($list[$i]['icon_hot']) echo "<span class=\"hot_icon\">H<span class=\"sound_only\">인기글</span></span>";

						// if ($list[$i]['link']['count']) { echo "[{$list[$i]['link']['count']}]"; }
						// if ($list[$i]['file']['count']) { echo "<{$list[$i]['file']['count']}>"; }

						// echo $list[$i]['icon_reply']." ";
						// if ($list[$i]['icon_file']) echo " <i class=\"fa fa-download\" aria-hidden=\"true\"></i>" ;
						// if ($list[$i]['icon_link']) echo " <i class=\"fa fa-link\" aria-hidden=\"true\"></i>" ;

						?>
						<div class="post-text">
							<?php echo get_text(cut_str(strip_tags($list[$i]['wr_content']),300));?>
						</div>
						</a>
					</div>
					<div class="post-text txt-short ellipsis">
						<?php echo $list[$i]['name'];?>
						<?php if($is_cate && $list[$i]['ca_name']) { ?>
							<span class="post-sp">|</span>
							<?php echo $list[$i]['ca_name'];?>
						<?php } ?>

							<span class="post-sp">|</span>
							<span class="txt-normal">
								<?php echo $list[$i]['datetime2']; ?>
							</span>
						<?php if ($list[$i]['comment_cnt']) { ?>
							<span class="count orangered">+<?php echo $list[$i]['wr_comment']; ?></span>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		<?php } ?>
		<?php if ($list_count == 0) { //게시물이 없을 때  ?>
		<div class="post-none">등록된 글이 없습니다.</div>
		<?php } ?>
		<div class="clearfix"></div>
	</div>

</div>
<!--// End -->

<script>
	$('#pic-lt-owlCarousel').owlCarousel({
		items:<?php echo $rows;?>,
		slideSpeed : <?php echo $slideSpeed;?>,
		paginationSpeed : <?php echo $paginationSpeed;?>,
		autoHeight: '<?php echo $autoHeight;?>',
		margin:<?php echo $margin;?>,
		nav: '<?php echo $nav;?>',
		loop: '<?php echo $loop;?>',
		autoplay: '<?php echo $autoplay;?>',
		dots: '<?php echo $dots;?>',
		responsive:{
			0:{
				items:1
			},
			480:{
				items:<?php echo $xs;?>
			},
			767:{
				items:<?php echo $sm;?>
			},
			991:{
				items:<?php echo $md;?>
			},
			1199:{
				items:<?php echo $lg;?>
			}
		}
	});
</script>
















