<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="' . $member_skin_url . '/style.css">', 0);
?>

<!-- 쪽지 목록 시작 { -->
<div id="newwin" class="memo">
    <div class="top_fixed">
        <h1 class="memo">
            <div class="title_wrap">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" style="enable-background:new 0 0 16 16" xml:space="preserve"><path d="M14 0H2C.93 0 .06.84 0 1.9V14c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V1.9C15.94.84 15.07 0 14 0zM1 2c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v.9L8.71 9.19c-.19.19-.44.3-.71.3s-.52-.11-.71-.3L1 2.9V2zm14 12c0 .55-.45 1-1 1H2c-.55 0-1-.45-1-1V4.31L6.59 9.9c.39.39.9.59 1.41.59s1.02-.2 1.41-.59L15 4.31V14z"/></svg>
                <?php echo $g5['title'] ?>
            </div>
            <div class="win_total">전체 <?php echo $kind_title ?>쪽지 <span><?php echo $total_count ?>통</span></div>
        </h1>
        <div class="memo_nav">
            <ul>
                <li class="<?php if ($kind == 'recv') { ?>selected<?php } ?>" onclick="location.href=('./memo.php?kind=recv');">받은쪽지</li>
                <li class="<?php if ($kind == 'send') { ?>selected<?php } ?>" onclick="location.href=('./memo.php?kind=send');">보낸쪽지</li>
                <li onclick="location.href=('./memo_form.php');">쪽지쓰기</li>
            </ul>
            <ul>
                <li class="memo_notice"><i class="fa-solid fa-circle-info"></i>쪽지 보관일수는 최장
                    <?php echo $config['cf_memo_del'] ?>일 입니다.
                </li>
            </ul>
        </div>
        <div class="memo_hd_title">
            <span>보낸사람</span>
            <span>보낸시간</span>
            <span>읽은시간</span>
            <span>삭제</span>
        </div>
    </div>
    <div class="memo_list">
        <ul>
            <?php
            for ($i = 0; $i < count($list); $i++) {
                $readed = (substr($list[$i]['me_read_datetime'], 0, 1) == 0) ? '' : 'read';
                $memo_preview = utf8_strcut(strip_tags($list[$i]['me_memo']), 50, '..');
                ?>
                <li class="<?php echo $readed ?>">
                    <span class="memo_name"><?php echo $list[$i]['name']; ?></span>
                    <span class="memo_datetime"><?php echo $list[$i]['send_datetime']; ?></span>
                    <span class="memo_datetime"><?php echo $list[$i]['read_datetime']; ?></span>
                    <span class="newwin_delete_wrap">
                        <a href="<?php echo $list[$i]['del_href']; ?>" onclick="del(this.href); return false;" class="newwin_delete"><i class="fa-regular fa-xmark"></i><span class="sound_only">삭제</span></a>
                    </span>
                    <p class="memo_preview">
                        <a href="<?php echo $list[$i]['view_href']; ?>"><?php echo $memo_preview; ?></a>
                    </p>
                </li>
            <?php } ?>
            <?php if ($i == 0) {
                echo '<li class="empty_list"><i class="fa-thin fa-face-meh"></i>내역이 없습니다.</li>';
            } ?>
        </ul>
    </div>
    <div class="newwin_pages">
    <?php echo $write_pages; ?>
    </div>

</div>
<!-- } 쪽지 목록 끝 -->