
// 모바일 높이 조절 all
$(function(){
	window.addEventListener('resize', () => {
		let vh = window.innerHeight * 0.01;
		document.documentElement.style.setProperty('--vh', `${vh}px`);
	})
});

// 모바일 스크롤 반응 all
$(function(){
    var last_scrollTop = 0;
 
    $(window).scroll(function () {
        var tmp = $(this).scrollTop();
        if (tmp > last_scrollTop) {
            $("#app").removeClass("up");
            $("#app").addClass("down");
        } else {
            $("#app").addClass("up");
            $("#app").removeClass("down");
        }
        last_scrollTop = tmp;
    });
});

// 로그인 login.html
$(function() {
	$(document).ready(function() {
		$(".inp input").keyup(function (e){
			var content = $(this).val();
			if (content.length > 0){
				$(this).siblings('.btn_reset').addClass("on");
			} else if (content.length <= 0){
				$(this).siblings('.btn_reset').removeClass("on");
			}
		});
		$(".btn_reset").click('on',function(){
			$(this).siblings('input').val('');
			$(this).removeClass("on");
		});
	})
});

// 모바일 상단고정 script
$(function() {
	$(window).scroll( function() {
		if ($(document).scrollTop() > 0 ) {
			$('#app').addClass('fixed');
		} else {
			$('#app').removeClass('fixed');
		};
	});
})

// 모바일 탭메뉴 script
$(function() {
	$('.tab-area').on('click', '.tab-btns li', function(e){
		var idx =  $(this).index();
		$(this).closest('.tab-area').find('.tab-btns').find('li').removeClass('active');
		$(this).addClass('active');
		$(this).closest('.tab-area').find('.tab-box').removeClass('active').eq(idx).addClass('active');
		return false;
	});
});

// 모바일 select design 
$(function() {
	$(".sort .sort_btn").click(function() {
		if ($(this).hasClass('active')) {
			$(this).removeClass("active");
			$(this).siblings('.sort_menu').removeClass("active");
		} else {
			$(this).addClass("active");
			$(this).siblings('.sort_menu').addClass("active");
		}                                
	});
	$(".sort .sort_menu ul li a").click(function() {
		var sortext = $(this).text();
		if ($(this).hasClass('active')) {
			$(".sort .sort_menu ul li a").removeClass("active");
			$(".sort .sort_btn p").text(sortext).css('color','#000000');
			$(".sort .sort_menu, .sort .sort_btn").removeClass("active");
		} else {
			$(".sort .sort_menu ul li a").removeClass("active");
			$(this).addClass("active");
			$(".sort .sort_btn p").text(sortext).css('color','#000000');
			$(".sort .sort_menu, .sort .sort_btn").removeClass("active");
		}
	});
});
// 모바일 모달스크립트 script
$(document).ready(function(){
	$('.modal_open').on('click', modalOpen);
	$('.modal_close').on('click', modalClose);
	$('.modal_submit').on('click', modalClose);
	$('.modal_container').on('click', function(e){
		if(!$('.modal_wrapper').has(e.target).length){
			$('html').removeClass('modalOn');
			$(this).fadeOut(0);
			$(this).delay(50).fadeOut(0);
			$(this).removeClass('show');
			$('html').css('overflow-y','auto');
		}
	});
});
function modalOpen(modalID){
	$('html').css('overflow-y','hidden');
	$('.modal_container').fadeOut(0);
	$('.modal_container').removeClass('show');
	$(this).data('modal') ? modalID = $(this).data('modal') : '';
	$('.modal_container.show').length > 0 ? $('#' + modalID).css({
		'z-index': $('.modal_container.show').css('z-index') + 1,
		'background': 'transparent'
	}) : '';
	$('#' + modalID).css('display', 'flex').focus();
	$('#' + modalID + ' .modal-wrapper').delay(100).fadeIn(100).focus();
	$('#' + modalID).addClass('show').focus();
	
	return false;
}
function modalClose(){
	$('html').css('overflow-y','auto');
	$(this).closest('.modal_container').fadeOut(0);
	$(this).closest('.modal_container').removeClass('show');
}