<?php
include_once('./_common.php');

define('_INDEX_', true);
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

if(defined('G5_THEME_PATH')) {
    require_once(G5_THEME_PATH.'/index.php');
    return;
}

if (G5_IS_MOBILE) {
    include_once(G5_MOBILE_PATH.'/index.php');
    return;
}
error_reporting(0);
ini_set('display_errors', 0);

include_once(G5_PATH.'/head.php');
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Gothic+A1:wght@400;500;700&display=swap');

body{
    margin: 0;
    padding: 0;
    font-family: 'Gothic A1', sans-serif;
}
.wrap{
    margin: 0 auto;
    display: flex;
    justify-content: center;
    align-items: center;
    flex-direction: column;
}

.wrap section{
    display: flex;
    justify-content: center;
    align-items: center;
    width: 56%;
    text-align: center;
}
img{
    max-width: 100%;
    width: 100%;
    text-align: center;
    vertical-align: top;
}


.fourth{
    display: flex;
    flex-direction: column;
    width: 57%;
    margin: 0 auto;
}

/* 방명록 */
.guestbook{
    background-color: #fff;
    width: 80%;
    min-height: 500px; 
    margin: 50px auto 0;
    padding-bottom: 25px;
    border: 1px solid #000;
    box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
}
form{
    padding-top: 50px;
}
.inputt{
    margin: 0 auto;
    width: 80%;
    text-align: left;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 2px solid #edecec;
    height: 65px;
    padding: 20px 0;
}

.guestbook label{
    width: 155px;
    font-size: 25px;
    font-weight: 600;
}

#name{
    width: 100%;
}
#password{
    width: 80%;
}
#message{
    width: 84%;
}
#name,
#password,
#message{
    outline: none;
    border: none;
    background-color: white;
    height: 40px;
    font-size: 25px;
}


#btn{
    display: flex;
    flex-direction: column;
    width: 80%;
    margin: 0 auto;
    text-align: center;
}

#btn a{
    width: 100%;
    background-color: #000;
    color: #fff;
    margin-top: 40px;
    height: 60px;
    font-size: 22px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    margin-bottom: 20px;
}
#btn input{
    width: 100%;
    background-color: #ff7272;
    color: #fff;
    height: 60px;
    font-size: 22px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    margin-bottom: 30px;
}


.message {
    width: 80%;
    margin: 0 auto 5px auto;
    padding: 10px 10px;
  }

.message .header{
    color: #fff;
    font-size: 17px;
    margin-top: 15px;
}
.message .header .name{
    font-weight: bold;
}
.message .content{
    color: #fff;
    font-size: 17px;
    margin-top: 5px;

}
.message .delete{
    border: none;
    background-color: transparent;

}
  
.message.right {
background-image: url('../img/right.png');
background-position: right center;
background-repeat: no-repeat;
background-size: 700px;
height: 145px;
text-align: left;
position: relative;
}
  
.message.left {
background-image: url('../img/left.png');
background-position: left center;
background-repeat: no-repeat;
background-size: 700px;
height: 145px;
text-align: left;
position: relative;
}
.actions{
    display: flex;
    justify-content: end;
    position: absolute;
    right: 13px;
    bottom: 55px;
}
.delete-button{
    font-size: 17px;
    border: none;
    background-color: transparent;
}
.delete-form{
    padding-top: 0 !important;
}

/* 모달 */

.modal {
    display: none;
    position: fixed;
    z-index: 9999;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
  }
  
  .modal-content {
    background-color: #fff;
    margin: 20% auto;
    padding: 20px;
    max-width: 400px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
  }
  
  .close {
    color: #aaa;
    float: right;
    font-size: 28px;
    font-weight: bold;
    cursor: pointer;
  }
  
  .close:hover,
  .close:focus {
    color: #000;
    text-decoration: none;
    cursor: pointer;
  }
  
  .mo_password{
    width: 50% !important;
    border: 1px solid #9b9999 !important;
  }

  #del_btn{
    width: 95%;
    text-align: right;
    margin-top: 20px;
  }

#deleteForm{
    padding-top: 28px !important;
}




/* 반응형 */
@media screen and (max-width:1024px){
    .fourth{
        width: 100%;
    }
}
@media screen and (max-width:640px){ 
    .wrap section{
        width: 100%;
    }
    .guestbook label{
        font-size: 20px;
    }
    #name, #password, #message{
        font-size: 20px;
    }
    #btn a{
        height: 50px;
        font-size: 18px;
    }
    #btn input{
        height: 50px;
        font-size: 18px;
    }
    .input_wrap label{
        margin-top: 35px;
    }
}

@media screen and (max-width:480px){ 
    .guestbook label{
        font-size: 16px;
    }
    #btn input {
        height: 46px;
        font-size: 16px;
    }
    .guestbook{
        min-height: 444px;
    }
    .input_wrap label{
        margin-top: 25px;
    }
}
</style>
    
    <section class="fourth">
        <div class="guestbook">
            <form method="post" action="./write_ok.php">
                <div class="inputt">
                    <label for="name">NAME:</label>
                    <input type="text" id="name" name="wr_name" placeholder="이름" required>
                </div>
                <div class="inputt">
                    <label for="password">PASSWORD:</label>
                    <input type="password" id="password" name="wr_password" placeholder="비밀번호" required>
                </div>
                <div class="inputt">
                    <label for="message">MESSAGE:</label>
                    <input id="message" name="wr_content" placeholder="메시지" required style="background-color: #fff;"></input>
                </div>
                <div id="btn">
                    <input type="submit" value="방명록 남기기" >
                </div>
            </form>
            
            <?php
            
            $servername = "localhost";
            $username = "USER명";
            $password = "DB비밀번호";
            $dbname = "DB명";
            
            $conn = new mysqli($servername, $username, $password, $dbname);
            
            if ($conn->connect_error) {
                die("Connection failed: " . $conn->connect_error);
            }
            
            $sql = "SELECT * FROM guestbook";
            $result = $conn->query($sql);
            
            $messages = [];
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    $messages[] = $row;
                }
            }
            
            $userInputPassword = isset($_POST['wr_password']) ? $_POST['wr_password'] : '';
            
            $conn->close();
            ?>
            
            <?php foreach ($messages as $index => $message): ?>
    <?php $messagePosition = $index % 2 === 0 ? 'right' : 'left'; ?>
    <div class="message <?php echo $messagePosition; ?>">
        <div class="header">
            <span class="name"><?php echo $message['name']; ?> | </span>
            <span class="time"><?php echo date('Y-m-d', strtotime($message['time'])); ?></span>
        </div>
        <div class="content">
            <?php echo $message['content']; ?>
        </div>
        <div class="actions">
    <?php if ($message['password'] === $userInputPassword): ?>
        <?php echo $message['content']; ?>
    <?php endif; ?>

    <form class="delete-form" onsubmit="showModal('<?php echo $message['id']; ?>'); return false;">
        <input type="hidden" name="messageId" value="<?php echo $message['id']; ?>">
        <button type="submit" class="delete-button">[삭제]</button>
    </form>
</div>


<!-- 모달 -->
<div id="modal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeModal()">&times;</span>
        <form id="deleteForm" action="delete.php" method="post">
            <input type="hidden" name="messageId" id="deleteMessageId">
            <label for="password">비밀번호:</label>
            <input type="password" class="mo_password" id="password" name="userInputPassword" required autofocus>
            <button type="submit" id="del_btn" class="delete-button">[삭제]</button>
        </form>
    </div>
</div>
</div>

    <script>
        function showModal(messageId) {
        document.getElementById("deleteMessageId").value = messageId;
        const modal = document.getElementById('modal');
        const form = document.getElementById('deleteForm');
        form.messageId.value = messageId;
        modal.style.display = 'block';
        }

        function closeModal() {
        const modal = document.getElementById('modal');
        modal.style.display = 'none';
        }



    </script>
    
    <script>
        function addMessage(name, content, id) {
  const chatContainer = document.getElementById('chatContainer');
  const messageDiv = document.createElement('div');
  messageDiv.classList.add('message');

  if (chatContainer.lastElementChild && chatContainer.lastElementChild.classList.contains('right')) {
    messageDiv.classList.add('left');
  } else {
    messageDiv.classList.add('right');
  }
        }
    </script>

    
<?php endforeach; ?>
            
        </div>
    </section>
    
        
    <script>
       function addMessage(name, content) {
  const chatContainer = document.getElementById('chatContainer');
  const messageDiv = document.createElement('div');
  messageDiv.classList.add('message');

  if (chatContainer.children.length % 2 === 0) {
    messageDiv.classList.add('right');
  } else {
    messageDiv.classList.add('left');
  }

  const contentDiv = document.createElement('div');
  contentDiv.classList.add('content');
  contentDiv.textContent = `${name}: ${content}`;

  messageDiv.appendChild(contentDiv);
  chatContainer.appendChild(messageDiv);
}
    </script>
</div>
<?php
include_once(G5_PATH.'/tail.php');