<?php
if (!defined('_GNUBOARD_')) exit; //개별 페이지 접근 불가

na_script('slick');

//add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$widget_url.'/widget.css">', 0);

// 이미지 영역 크기 설정
$wset['thumb_w'] = (!isset($wset['thumb_w']) || !$wset['thumb_w']) ? 500 : (int)$wset['thumb_w'];
$wset['thumb_h'] = (!isset($wset['thumb_h']) || !$wset['thumb_h']) ? 400 : (int)$wset['thumb_h'];

// 간격
if(!isset($wset['margin']) || $wset['margin'] == "") {
	$wset['margin'] = (G5_IS_MOBILE) ? 16 : 12;
}

// 높이
$img_height = ($wset['thumb_w'] && $wset['thumb_h']) ? ($wset['thumb_h'] / $wset['thumb_w']) * 100 : '56.25';

// 이미지라운드
$round = (isset($wset['round']) && $wset['round']) ? ' na-r'.$wset['round'] : '';

// 회원정보
$is_profile = (isset($wset['profile']) && $wset['profile']) ? false : true;

// 제목길이
$cut_txt = (isset($wset['wcut']) && (int)$wset['wcut']) ? $wset['wcut'] : 120;

//이미지 가로수
$wset['xl'] = isset($wset['xl']) ? $wset['xl'] : 4;
$wset['lg'] = isset($wset['lg']) ? $wset['lg'] : 3;
$wset['md'] = isset($wset['md']) ? $wset['md'] : 3;
$wset['sm'] = isset($wset['sm']) ? $wset['sm'] : 2;

$list = na_board_rows($wset);
$list_cnt = count($list);

// 보드명, 분류명
$is_bo_name = (isset($wset['bo_name']) && $wset['bo_name']) ? true : false;
$bo_name = ($is_bo_name && (int)$wset['bo_name'] > 0) ? $wset['bo_name'] : 0;

// 글 이동
$is_link = false;
$wset['target'] = isset($wset['target']) ? $wset['target'] : '';
switch($wset['target']) {
	case '1' : $target = ' target="_blank"'; break;
	case '2' : $is_link = true; break;
	case '3' : $target = ' target="_blank"'; $is_link = true; break;
	default	 : $target = ''; break;
}

// 배경색상 랜덤
$bg_red = array("bg-red", "bg-orangered", "bg-green", "bg-blue", "bg-purple", "bg-yellow", "bg-navy");

$subject_line = (isset($wset['subject_line']) && $wset['subject_line'] > 0) ? $wset['subject_line'] : 1;
$subject_height = 20 * $subject_line + 2;

// 타이틀 추출하기
$title = (isset($wset['title']) && $wset['title']) ? $wset['title'] : 'WIDGET TITLE';
$link = (isset($wset['link']) && $wset['link']) ? $wset['link'] : 'javascript:;';
$target = (isset($wset['target']) && $wset['target']) ? $wset['target'] : '_self';

// 랜덤아이디
$id = 'wps_'.na_rid();

?>
<style>
.recent-sidebar-widget .post-title { height:<?php echo $subject_height;?>px; }
</style>
<div class="recent-sidebar-widget">
	<div class="widget-header">
		<h5 class="widget-title"><a href="<?php echo $link;?>" target="<?php echo $target;?>"><?php echo $title;?></a></h5>
		<div class="letter-background">W</div>
	</div>
	<div class="post-carausel-3 post-module-1 row">
		<?php

		// 랜덤
		if(isset($wset['rand']) && $wset['rand'] && $list_cnt)
			shuffle($list);

		for ($i=0; $i < $list_cnt; $i++) {

			// 아이콘 체크
			if ($list[$i]['icon_secret']) {
				$is_lock = true;
				$wr_icon = '<span class="na-icon na-secret"></span>';
			} else if($list[$i]['icon_new']) {
				$wr_icon = '<span class="na-icon na-new"></span>';
			} else {
				$wr_icon = $icon;
			}

			// 보드명, 분류명
			if($is_bo_name) {
				$ca_name = '';
				if(isset($list[$i]['bo_subject']) && $list[$i]['bo_subject']) {
					$ca_name = ($bo_name) ? cut_str($list[$i]['bo_subject'], $bo_name, '') : $list[$i]['bo_subject'];
				} else if($list[$i]['ca_name']) {
					$ca_name = ($bo_name) ? cut_str($list[$i]['ca_name'], $bo_name, '') : $list[$i]['ca_name'];
				}
			}

			// 링크 이동
			if($is_link && $list[$i]['wr_link1']) {
				$list[$i]['href'] = $list[$i]['link_href'][1];
			}

			// 이미지 추출
			$img = na_wr_img($list[$i]['bo_table'], $list[$i]);

			// 썸네일 생성
			$thumb = ($wset['thumb_w']) ? na_thumb($img, $wset['thumb_w'], $wset['thumb_h']) : $img;
		?>
		<div class="col">
			<div class="post-thumb position-relative">
				<div class="thumb-overlay img-hover-slide na-r3 position-relative" style="background-image: url('<?php echo $thumb ?>')">
					<span class="top-right-icon <?php echo $bg_red[rand(0, 6)];?>"><i class="fa fa-heart"></i></span>

                    <a class="img-link" href="<?php echo $list[$i]['href'] ?>"<?php echo $target ?>></a>
                    <div class="post-content-overlay">
						<?php if($ca_name){ ?>
						<div class="entry-meta meta-0">
							<a href="<?php echo $list[$i]['href'] ?>"<?php echo $target ?>><span class="post-cat <?php echo $bg_red[rand(0, 6)];?>"><?php echo $ca_name;?></span></a>
						</div>
						<?php } ?>
						<h6 class="post-title font-weight-bold">
							<a href="<?php echo $list[$i]['href'] ?>"<?php echo $target ?>>
								<?php echo $wr_icon ?>
								<?php echo $list[$i]['subject'] ?>
							</a>
						</h6>
						<?php if($wset['content']){ ?><p class="na-lh-4 text-white mt-2"><?php echo na_cut_text($list[$i]['wr_content'], $cut_txt) ?></p><?php } ?>
						<div class="entry-meta meta-1">
							<span class="post-on"><i class="fa fa-clock-o"></i> <?php echo na_date($list[$i]['wr_datetime'], 'orangered', 'H:i', 'm.d', 'y.m.d'); ?></span>
							<span class="hit-count has-dot"><i class="fa fa-eye"></i> <?php echo $list[$i]['wr_hit'];?></span>
							<a class="float-right" href="#"><i class="fa fa-heart-o"></i> <?php echo $list[$i]['wr_good'];?></a>
						</div>
                    </div>
				</div>
			</div>
		</div>
		<?php } ?>
		<?php
		if(!$list_cnt) { //게시물이 없을 때
			for ($i=0; $i<$wset['xl']; $i++) {
		?>
		<div class="col">
			<div class="post-thumb position-relative">
				<div class="thumb-overlay img-hover-slide na-r3 position-relative" style="background-image: url(<?php echo $widget_url;?>/images/slider-1.jpg)">
					<span class="top-right-icon <?php echo $bg_red[rand(0, 6)];?>"><i class="fa fa-heart"></i></span>

                    <a class="img-link" href="single.html"></a>
                    <div class="post-content-overlay">
						<div class="entry-meta meta-0">
							<a href="category.html"><span class="post-cat <?php echo $bg_red[rand(0, 6)];?>">분류</span></a>
						</div>
						<h6 class="post-title">
							<a href="single.html">최신게시글이 없습니다.</a>
						</h6>
						<div class="entry-meta meta-1">
							<span class="post-on"><i class="fa fa-clock-o"></i> 00.00.00</span>
							<span class="hit-count has-dot"><i class="fa fa-eye"></i> 0</span>
							<a class="float-right" href="#"><i class="fa fa-heart-o"></i> 0</a>
						</div>
                    </div>
				</div>
			</div>
		</div>
		<?php
			} // for End
		} // if End
		?>
	</div>
</div>

<script>
	$(function(){
        $('.post-carausel-3').slick({
            dots: <?php echo (isset($wset['dots']) && $wset['dots']) ? 'false' : 'true'; ?>,
            infinite: true,
            speed: <?php echo (isset($wset['speed']) && $wset['speed']) ? $wset['speed'] : 1000; ?>,
            arrows: false,
            slidesToShow: <?php echo $wset['xl'];?>,
            slidesToScroll: 1,
            autoplay: <?php echo (isset($wset['auto']) && $wset['auto']) ? 'false' : 'true'; ?>,
            loop: true,
            adaptiveHeight: true,
            cssEase: 'linear',
            centerPadding: 50,
            responsive: [{
                breakpoint: 1200,
                settings: {
                    slidesToShow: <?php echo $wset['xl'];?>,
                    slidesToScroll: <?php echo $wset['xl'];?>,
                    infinite: true,
                    dots: false,
                }
            },
            {
                breakpoint: 992,
                settings: {
                    slidesToShow: <?php echo $wset['lg'];?>,
                    slidesToScroll: <?php echo $wset['lg'];?>
                }
            },
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: <?php echo $wset['md'];?>,
                    slidesToScroll: <?php echo $wset['md'];?>
                }
            },
            {
                breakpoint: 576,
                settings: {
                    slidesToShow: <?php echo $wset['sm'];?>,
                    slidesToScroll: <?php echo $wset['sm'];?>
                }
            }
            ]
        });
	});
</script>
<?php if($setup_href) { ?>
	<div class="btn-wset">
		<a href="<?php echo $setup_href;?>" class="btn-setup">
			<span class="f-sm text-muted"><i class="fa fa-cog"></i> 위젯설정</span>
		</a>
	</div>
<?php } ?>