<?php
if (!defined('_GNUBOARD_')) exit; //개별 페이지 접근 불가

// 반응구간
$xs = (isset($wset['xs']) && $wset['xs']) ? $wset['xs'] : 1;
$sm = (isset($wset['sm']) && $wset['sm']) ? $wset['sm'] : 1;
$md = (isset($wset['md']) && $wset['md']) ? $wset['md'] : 1;
$lg = (isset($wset['lg']) && $wset['lg']) ? $wset['lg'] : 1;
$xl = (isset($wset['xl']) && $wset['xl']) ? $wset['xl'] : 1;

// 큰이미지 영역 및 썸네일 크기 설정
$wset['big_thumb_w'] = (isset($wset['big_thumb_w']) && $wset['big_thumb_w'] != "") ? (int)$wset['big_thumb_w'] : 400;
$wset['big_thumb_h'] = (isset($wset['big_thumb_h']) && $wset['big_thumb_h'] != "") ? (int)$wset['big_thumb_h'] : 300;

if($wset['big_thumb_w'] && $wset['big_thumb_h']) {
	$big_img_height = ($wset['big_thumb_h'] / $wset['big_thumb_w']) * 100;
} else {
	$big_img_height = (isset($wset['big_thumb_d']) && $wset['big_thumb_d']) ? $wset['big_thumb_d'] : '56.25';
}

// 큰이미지라운드
$big_round = (isset($wset['big_round']) && $wset['big_round']) ? ' na-r'.$wset['big_round'] : '';

// 큰이미지 제목줄
$big_subject_line = (isset($wset['big_subject_line']) && $wset['big_subject_line'] > 0) ? $wset['big_subject_line'] : 2;
$big_subject_height = 26 * $big_subject_line + 2;

// 큰이미지 글내용 길이
$big_cut_txt = (isset($wset['big_wcut']) && (int)$wset['big_wcut']) ? $wset['big_wcut'] : 100;

// 큰이미지 개수
$wset['big_rows'] = 1;


// 이미지 영역 및 썸네일 크기 설정
$wset['thumb_w'] = (isset($wset['thumb_w']) && $wset['thumb_w'] != "") ? (int)$wset['thumb_w'] : 400;
$wset['thumb_h'] = (isset($wset['thumb_h']) && $wset['thumb_h'] != "") ? (int)$wset['thumb_h'] : 250;

if($wset['thumb_w'] && $wset['thumb_h']) {
	$img_height = ($wset['thumb_h'] / $wset['thumb_w']) * 100;
} else {
	$img_height = (isset($wset['thumb_d']) && $wset['thumb_d']) ? $wset['thumb_d'] : '56.25';
}

// 추출하기
$wset['sideview'] = 1; // 이름 레이어

$wset['rows'] = isset($wset['rows']) ? $wset['rows'] : 4;
$wset['page'] = isset($wset['page']) ? $wset['page'] : '';
$wset['rank'] = isset($wset['rank']) ? $wset['rank'] : '';

$wset['rows'] = $wset['big_rows'] + $wset['rows'];

$list = na_board_rows($wset);
$list_cnt = count($list);

// 이미지라운드
$round = (isset($wset['round']) && $wset['round']) ? ' na-r'.$wset['round'] : '';

// 글내용 출력
$is_content = (isset($wset['content']) && $wset['content']) ? true : false;

// 글내용 길이
$cut_txt = (isset($wset['wcut']) && (int)$wset['wcut']) ? $wset['wcut'] : 80;

// 랭킹
$rank = na_rank_start($wset['rows'], $wset['page']);

// 새글
$cap_new = (isset($wset['new']) && $wset['new']) ? $wset['new'] : 'primary';

// 보드명, 분류명
$is_bo_name = (isset($wset['bo_name']) && $wset['bo_name']) ? true : false;
$bo_name = ($is_bo_name && (int)$wset['bo_name'] > 0) ? $wset['bo_name'] : 0;

// 배경색상 랜덤
$bg_red = array("bg-red", "bg-orangered", "bg-green", "bg-blue", "bg-purple", "bg-yellow", "bg-navy");

// 글 이동
$is_link = false;
$wset['target'] = isset($wset['target']) ? $wset['target'] : '';
switch($wset['target']) {
	case '1' : $target = ' target="_blank"'; break;
	case '2' : $is_link = true; break;
	case '3' : $target = ' target="_blank"'; $is_link = true; break;
	default	 : $target = ''; break;
}

$subject_line = (isset($wset['subject_line']) && $wset['subject_line'] > 0) ? $wset['subject_line'] : 2;
$subject_height = 22 * $subject_line + 2;

// 우측이미지
$img_loc = (isset($wset['wimg']) && $wset['wimg']) ? ' order-sm-3' : '';

// 이미지 크기
$wset['wxl'] = isset($wset['wxl']) ? (int)$wset['wxl'] : 5;
$wset['wlg'] = isset($wset['wlg']) ? (int)$wset['wlg'] : 0;
$wset['wmd'] = isset($wset['wmd']) ? (int)$wset['wmd'] : 0;
$wset['wsm'] = isset($wset['wsm']) ? (int)$wset['wsm'] : 5;

$img_cols = '';
if($wset['wsm'])
	$img_cols .= ' col-sm-'.$wset['wsm'];
if($wset['wmd'])
	$img_cols .= ' col-md-'.$wset['wmd'];
if($wset['wlg'])
	$img_cols .= ' col-lg-'.$wset['wlg'];
if($wset['wxl'])
	$img_cols .= ' col-xl-'.$wset['wxl'];


?>
<style>
.mix-gallery-widget2 .post-big-style .post-title { height:<?php echo $big_subject_height;?>px; }
.mix-gallery-widget2 .post-small-style .post-title { height:<?php echo $subject_height;?>px; }
</style>

	<div class="row">
		<div class="col-md-6">
			<?php

			// 랜덤
			if(isset($wset['rand']) && $wset['rand'] && $list_cnt)
				shuffle($list);

			// 리스트
			for ($i=0; $i < $wset['big_rows']; $i++) {

				// 아이콘 체크
				$wr_icon = $wr_tack = $wr_cap = '';
				if ($list[$i]['icon_secret']) {
					$is_lock = true;
					$wr_icon = '<span class="na-icon na-secret"></span>';
				}

				if ($wset['rank']) {
					$wr_tack = '<span class="label-tack rank-icon en bg-'.$wset['rank'].'">'.$rank.'</span>';
					$rank++;
				}

				if($list[$i]['icon_new']) {
					$wr_cap = '<span class="label-cap en bg-'.$cap_new.'">New</span>';
				}

				// 보드명, 분류명
				if($is_bo_name) {
					$ca_name = '';
					if(isset($list[$i]['bo_subject']) && $list[$i]['bo_subject']) {
						$ca_name = ($bo_name) ? cut_str($list[$i]['bo_subject'], $bo_name, '') : $list[$i]['bo_subject'];
						// 보드링크
						$list[$i]['href_ca'] = get_pretty_url($list[$i]['bo_table']);
					} else if($list[$i]['ca_name']) {
						$ca_name = ($bo_name) ? cut_str($list[$i]['ca_name'], $bo_name, '') : $list[$i]['ca_name'];
						// 분류링크
						$list[$i]['href_ca'] = get_pretty_url($list[$i]['bo_table'],'','sca='.urlencode($list[$i]['ca_name']));
					}
				}

				// 링크 이동
				if($is_link && $list[$i]['wr_link1']) {
					$list[$i]['href'] = $list[$i]['link_href'][1];
				}

				// 이미지 추출
				$img = na_wr_img($list[$i]['bo_table'], $list[$i]);

				// 썸네일 생성
				$thumb = ($wset['big_thumb_w']) ? na_thumb($img, $wset['big_thumb_w'], $wset['big_thumb_h']) : $img;

			?>
			<div class="post-big-style">
				<div class="img-wrap post-thumb img-hover-scale position-relative thumb-overlay bg-light<?php echo $big_round;?> mb-2" style="padding-bottom:<?php echo $big_img_height ?>%;">
					<div class="img-item">
						<a href="<?php echo $list[$i]['href'] ?>"<?php echo $target ?>>
							<?php echo $wr_tack ?>
							<?php echo $wr_cap ?>
							<?php if($thumb) { ?>
								<img src="<?php echo $thumb ?>" alt="Image <?php echo $list[$i]['wr_id'] ?>" class="img-render">
							<?php } ?>
						</a>
						<?php if($ca_name){ ?>
						<div class="post-content-overlay entry-meta meta-0 transition-ease-04"><a href="<?php echo $list[$i]['href_ca'];?>"><span class="post-cat <?php echo $bg_red[rand(0, 6)];?>"><?php echo $ca_name;?></span></a></div>
						<?php } ?>
					</div>
				</div>
				<div class="na-title">
					<div class="na-item">
						<a href="<?php echo $list[$i]['href'] ?>" class="post-title"<?php echo $target ?>>
							<?php echo $wr_icon ?>
							<?php echo $list[$i]['subject'] ?>
						</a>
					</div>
				</div>
				<div class="entry-meta meta-1 mt-3 mb-3">
					<span class="post-on"><i class="fa fa-clock-o"></i> <?php echo na_date($list[$i]['wr_datetime'], 'orangered', 'H:i', 'm.d', 'y.m.d'); ?></span>
					<span class="hit-count has-dot"><i class="fa fa-eye"></i> <?php echo $list[$i]['wr_hit'];?></span>
					<span class="float-right"><?php echo $list[$i]['name'];?></span>
				</div>
				<p class="d-none d-lg-block"><?php echo na_cut_text($list[$i]['wr_content'], $big_cut_txt) ?></p>
			</div>
			<?php } ?>
		</div>
		<div class="col-md-6">
			<ul class="row row-cols-<?php echo $xs ?> row-cols-sm-<?php echo $sm ?> row-cols-md-<?php echo $md ?> row-cols-lg-<?php echo $lg ?> row-cols-xl-<?php echo $xl ?> mx-n2">
				<?php
				// 리스트
				for ($i=1; $i < $list_cnt; $i++) {

					// 아이콘 체크
					$wr_icon = $wr_tack = $wr_cap = '';
					if ($list[$i]['icon_secret']) {
						$is_lock = true;
						$wr_icon = '<span class="na-icon na-secret"></span>';
					}

					if ($wset['rank']) {
						$wr_tack = '<span class="label-tack rank-icon en bg-'.$wset['rank'].'">'.$rank.'</span>';
						$rank++;
					}

					if($list[$i]['icon_new']) {
						$wr_cap = '<span class="label-cap en bg-'.$cap_new.'">New</span>';
					}

					// 보드명, 분류명
					if($is_bo_name) {
						$ca_name = '';
						if(isset($list[$i]['bo_subject']) && $list[$i]['bo_subject']) {
							$ca_name = ($bo_name) ? cut_str($list[$i]['bo_subject'], $bo_name, '') : $list[$i]['bo_subject'];
							// 보드링크
							$list[$i]['href_ca'] = get_pretty_url($list[$i]['bo_table']);
						} else if($list[$i]['ca_name']) {
							$ca_name = ($bo_name) ? cut_str($list[$i]['ca_name'], $bo_name, '') : $list[$i]['ca_name'];
							// 분류링크
							$list[$i]['href_ca'] = get_pretty_url($list[$i]['bo_table'],'','sca='.urlencode($list[$i]['ca_name']));
						}
					}

					// 링크 이동
					if($is_link && $list[$i]['wr_link1']) {
						$list[$i]['href'] = $list[$i]['link_href'][1];
					}

					// 이미지 추출
					$img = na_wr_img($list[$i]['bo_table'], $list[$i]);

					// 썸네일 생성
					$thumb = ($wset['thumb_w']) ? na_thumb($img, $wset['thumb_w'], $wset['thumb_h']) : $img;

				?>
                <li class="list-item post-small-style pb-2 mb-2">
					<div class="card border-0">
						<div class="row no-gutters">
							<div class="order-1<?php echo $img_loc ?> col-6<?php echo $img_cols ?>">
								<div class="mx-2 mx-sm-0 mb-2 mb-sm-0 img-hover-scale">
									<div class="img-wrap bg-light<?php echo $round;?>" style="padding-bottom:<?php echo $img_height ?>%;">
										<div class="img-item">
											<a href="<?php echo $list[$i]['href'] ?>"<?php echo $target ?>>
												<?php echo $wr_tack ?>
												<?php echo $wr_cap ?>
												<img src="<?php echo $thumb ?>" alt="<?php echo $wr_alt ?>" class="img-render<?php echo $round;?>">
											</a>
											<?php if($is_caption){ ?>
											<div class="img-caption font-weight-normal f-sm">
												<span><i class="fa fa-clock-o" aria-hidden="true"></i> <?php echo na_date($list[$i]['wr_datetime'], 'orangered', 'H:i', 'm.d', 'm.d'); ?></span>
												<span class="float-right"><?php echo na_name_photo($list[$i]['mb_id'], $list[$i]['name']) ?></span>
											</div>
											<?php } ?>
										</div>
									</div>
								</div>
							</div>
							<div class="col order-2">
								<div class="card-body pt-2 pb-0">
									<?php if($ca_name){ ?>
									<div class="entry-meta meta-0 mb-3">
										<a href="<?php echo $list[$i]['href_ca'];?>"><span class="post-cat <?php echo $bg_red[rand(0, 6)];?>"><?php echo $ca_name;?></span></a>
									</div>
									<?php } ?>
									<div class="post-title">
										<a href="<?php echo $list[$i]['href'] ?>"<?php echo $target ?>>
											<?php echo $wr_icon ?>
											<?php echo $list[$i]['subject'] ?>
										</a>
										<?php if($list[$i]['wr_comment']) { ?>
											<span class="sr-only">댓글</span>
											<span class="count-plus orangered">
												<?php echo $list[$i]['wr_comment'] ?>
											</span>
										<?php } ?>
									</div>
									<div class="entry-meta meta-1 mt-0">
										<span class="post-on"><i class="fa fa-clock-o"></i> <?php echo na_date($list[$i]['wr_datetime'], 'orangered', 'H:i', 'm.d', 'y.m.d'); ?></span>
										<span class="hit-count has-dot"><i class="fa fa-eye"></i> <?php echo $list[$i]['wr_hit'];?></span>
										<!--span class="float-right"><?php echo $list[$i]['name'];?></span-->
									</div>
									<?php if($is_content){ ?>
									<p class="d-none d-lg-block na-lh-3 pt-2"><?php echo na_cut_text($list[$i]['wr_content'], $cut_txt) ?></p>
									<?php } ?>
								</div>
							</div>
						</div>
					</div>
                </li>
				<?php } ?>

				<?php if(!$list_cnt) { ?>
				<li class="w-100 f-de text-muted text-center px-2 py-5">
					글이 없습니다.
				</li>
				<?php } ?>
			</ul>
		</div>
	</div>